static char rcsid[] = "@(#)$Id: lookup.c,v 2.6 1994/11/18 04:03:06 peter Exp $";
/*
 * lookup.c - routine to calculate lookup table.

 * Copyright 1994, 16th November.
 * By Peter Chang
 * peterc@v2.ph.man.ac.uk
  
 * See notice in misc.h for details of permissions and warranty of this
 * software.

 *
 * $Log: lookup.c,v $
 * Revision 2.6  1994/11/18  04:03:06  peter
 * xpgs-2.5-patch 01: Changes in header files for clean compile
 *
 * Revision 2.5.1.1  1994/11/17  03:34:23  peter
 * Import of actual public release of xpgs-2.5: lots of cosmetic changes to docs
 *
 * Revision 2.5  1994/11/16  09:19:21  peter
 * Putting xpgs-2.5 in trunk.
 *
 * Revision 2.0.1.1  1994/11/16  09:10:30  peter
 * Import of xpgs-2.5: archive of new release to alt.sources (11/94)
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include "pgs.h"
#include "lookup.h"

#if __GNUC__ == 2
USE(rcsid);
#endif

float *zplookup = NULL;

#ifdef LOOKUP_TEST
int width, height;
float pmm;

int main(int argc, char *argv[])
{
   int i, range;
   float vd, vdos, os;
   float *mylookup;
   float z, zt, zm;
   int rev;

   pmm = 3.742690;
   height = 476;
   rev = (argc > 1) ? -1 : 1;
   lookup(rev);

   vd = VD;
   os = OS;
   vdos = vd + rev*os;
   mylookup = zplookup;
   mylookup += (int) ((rev>0) ? ZMUL*height : ZMUL*os);
   if (rev == 1) {
      range = ZMUL*(os+height+0.5);
      zm = os;
      z=-height/2;
   } else {
      range = ZMUL*(vd+0.5);
      zm = vdos;
      z = rev*os;
   }
   for (; z<zm; z += 1.0) {
      zt = vd / (vdos - z);
      printf(" %.2f %f ", z, zt);
      zt = *(mylookup+(int)(ZMUL*z));
      printf("%f\n", zt);      
   }
}

#endif

/* 
 * a lookup table for calculating the transformed zp
 */
void lookup(int rev)
{
   int i, range;
   float *look;
   float os, vd, vdos;
   float z;

   os = OS;
   vd = VD;
   vdos = vd + rev*os;
   range = (int) ((rev == 1) ? ZMUL*(os+height+0.5) : ZMUL*(vd+0.5));

   if (os < OY) fprintf(stderr,
      "Width greater than offset, could imply pixel shift becomes inverted\n");
   if (rev == -1 && (vd-os) < OY)
      fprintf(stderr, "Object could be in your eyes\n");
   if (zplookup != NULL) free(zplookup);
   zplookup = (float *) malloc (range*sizeof(float));

   look = zplookup;
   z = (rev == 1) ? (float) -height : -os;
fprintf(stderr, "Lookup table for z' starts at %f and has %d entries\n",
	z, range);
   for (i=0; i<range; i++, look++) {
      *look = vd/(vdos-z);
      z += (1.0/ZMUL);
   }
}

