#ifndef MISC_H
#define MISC_H
/*
 * misc.h - miscellaneous header file.

 * Copyright 1994, 16th November.
 * Copyright 1994, 14th February.
 * By Peter Chang
 * peterc@v2.ph.man.ac.uk

 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the copyright holder
 * not be used in advertising or publicity pertaining to distribution of
 * the software without specific, written prior permission. The copyright
 * holder makes no representations about the suitability of this software
 * for any purpose. It is provided "as is" without express or implied
 * warranty.

 * The copyright holder disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and
 * fitness, in no event shall the copyright holder be liable for any
 * special, indirect or consequential damages or any damages whatsoever
 * resulting from loss of use, data or profits, whether in an action of
 * contract, negligence or other tortious action, arising out of or in
 * connection with the use or performance of this software.

 *
 * $Log: misc.h,v $
 * Revision 2.6  1994/11/18  04:03:07  peter
 * xpgs-2.5-patch 01: Changes in header files for clean compile
 *
 * Revision 2.5.1.1  1994/11/17  03:34:29  peter
 * Import of actual public release of xpgs-2.5: lots of cosmetic changes to docs
 *
 * Revision 2.5  1994/11/16  09:19:23  peter
 * Putting xpgs-2.5 in trunk.
 *
 * Revision 2.0.1.1  1994/11/16  09:10:31  peter
 * Import of xpgs-2.5: archive of new release to alt.sources (11/94)
 *
 *
 */

/* some cures for non-ANSI C header files and functions */
#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif
#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS 0
#endif

#ifndef RAND_MAX
#include <limits.h>
#define RAND_MAX INT_MAX
#endif

#if defined(__sun__)
#define srand(s) srandom(s)
#define rand() random()
#endif /* __sun__ */

#define NLEN 60
#define LLEN 120

#ifndef PI
#define PI  (3.14159265)
#endif
#ifndef TWO_PI
#define TWO_PI  (2*PI)
#endif

typedef unsigned char uschar;
typedef unsigned short int usshort;
typedef unsigned int usint;
typedef unsigned long int uslong;

/* use inline on certain functions, if possible */
#ifndef __GNUC__
#define __inline__
#endif

/* remove gcc version 2.x warning about unused variable */
#if __GNUC__ == 2
#define USE(var) static void * use_##var = (&use_##var, (void *) &var)
#endif

#define  DIE(B) {        \
            fprintf(stderr, B); \
            exit(EXIT_FAILURE); \
         }

#define  DIE3(B, C) {        \
            fprintf(stderr, B, C); \
            exit(EXIT_FAILURE); \
         }

#define  DIE4(B, C, D) {        \
            fprintf(stderr, B, C, D); \
            exit(EXIT_FAILURE); \
         }

#define  DIEIF(A,B) {        \
         if (A) {               \
            fprintf(stderr, B); \
            exit(EXIT_FAILURE); \
         }                      \
         }

#define  DIEIF3(A,B,C) {        \
         if (A) {                  \
            fprintf(stderr, B, C); \
            exit(EXIT_FAILURE);    \
         }                         \
         }

#define  DIEIF4(A,B,C,D) {        \
         if (A) {                  \
            fprintf(stderr, B, C, D); \
            exit(EXIT_FAILURE);    \
         }                         \
         }

#endif
