static char rcsid[] = "@(#)$Id: mkpolyh.c,v 2.6 1994/11/18 04:03:07 peter Exp $";
/*
 * mkpolyh - generates a polyh file from a mesh function z = f(x,y).

 * Copyright 1994, 16th November.
 * By Peter Chang. All rights reserved.
 * peterc@v2.ph.man.ac.uk

 * See notice in misc.h for details of permissions and warranty of this
 * software.

 *
 * $Log: mkpolyh.c,v $
 * Revision 2.6  1994/11/18  04:03:07  peter
 * xpgs-2.5-patch 01: Changes in header files for clean compile
 *
 * Revision 2.5.1.1  1994/11/17  03:34:26  peter
 * Import of actual public release of xpgs-2.5: lots of cosmetic changes to docs
 *
 * Revision 2.5  1994/11/16  09:19:24  peter
 * Putting xpgs-2.5 in trunk.
 *
 * Revision 2.0.1.1  1994/11/16  09:10:30  peter
 * Import of xpgs-2.5: archive of new release to alt.sources (11/94)
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "pgs.h"
#include "polyh.h"
#include "meshfn.h"

#if __GNUC__ == 2
USE(rcsid);
#endif

/* a value close to zero */
#define AZERO 0.01
Object *shapes = NULL;
usint nobj = 0;
float theta = 0.0, phi = 0.0;

int main(int argc, char *argv[])
{
   int i, fno;
   Object net;
   char name[NLEN];
   char *cptr;

   void mkpoint(Object *, float (*fun)(float , float , int ));
   int mkpolygon(Object *);
   int pcl(int , char **, char *);

   fno = pcl(argc, argv, name);
   if ((cptr = strstr(name, ".polyh")) != NULL) {
      *cptr = '\0';
   }
   sprintf(net.fname, "%s.polyh", name);
   mkpoint(&net, flist[fno]);
   i = mkpolygon(&net);
   savepolyh(&net, 1);
   printf("made and saved %s which has %d pts, %d polys with %d indices\n",
	  net.fname, net.ipts-1, i, net.nindex);
   free(net.ri);
   free(net.polygon);
   exit(EXIT_SUCCESS);
   return 0;
}


/*
 * calculate points
 */
void mkpoint(Object *pobj, float (*function)(float , float , int ))
{
   int i, j;
   float xi, yi, xs, ys;
   float x, y, z;
   Point *pptr;

   pobj->ipts = (xdiv+1)*(ydiv+1) + 1;
   DIEIF((pobj->ri = (Point *) calloc(pobj->ipts, sizeof(Point))) == NULL,
	 "Too many points, unable to allocate memory\n");

   z = (*function)(0.0, 0.0, 1); /* initialise function */
   xs = 2.0;
   xi = -1.0;
   ys = 2.0;
   yi = -1.0;
   xs /= xdiv;
   ys /= ydiv;
   y = yi;
   pptr = pobj->ri;
   pptr++;
   for (j=0; j<=ydiv; j++) {
      x = xi;
      for (i=0; i<=xdiv; i++) {
	 z = (*function)(x, y, 0);
	 if (z > 1.0) z = 1.0;
	 if (z < -1.0) z = -1.0;
	 pptr->x = bbx*x;
	 pptr->y = bby*y;
	 pptr->z = bbz*z;
	 x += xs;
	 pptr++;
      }
      y += ys;
   }
}


/*
 * make polygon
 */
int mkpolygon(Object *pobj)
{
   int i, j, k, l, m, n, p;
   Point *pptr, *qptr;
   usint *polygon;
   int a, d, f;
   float z[4];
   float zm, zl, zt;

   pobj->nindex = 5*xdiv*ydiv;
   DIEIF((pobj->polygon = (usint *) calloc(pobj->nindex,sizeof(int))) == NULL,
               "Unable to allocate memory for polygons\n");
   polygon = pobj->polygon;

   a = 1;
   d = xdiv+2;
   pptr = pobj->ri+1;
   qptr = pobj->ri+xdiv+2;
   k = 0;
   f = 0;

   for (j=0; j<ydiv; j++) {
      z[0] = (pptr++)->z;
      z[3] = (qptr++)->z;
      for (i=0; i<xdiv; i++) {
	 z[1] = (pptr++)->z;
	 z[2] = (qptr++)->z;
	 if (fabs(z[0]-z[1]+z[2]-z[3]) < AZERO) {
	    /* planar case, 4 vertices */
	    m = 1;
	 } else {
	    /* non-planar case -> two triangle */
	    /* find most and least */
	    l = m = 0;
	    zl = zm = z[0];
	    for (n=1; n<4; n++) {
	       zt = z[n];
	       if (zt > zm) {
		  zm = zt;
		  m = n;
	       } else if (zt < zl) {
		  zl = zt;
		  l = n;
	       }
	    }
	    /* check if there are common heights */
	    switch(l-m) {
	     case -3: case -1: /* min clockwise adjacent from max */
	       p = (m+1) & 3;
	       if ((zm-z[p]) < AZERO) m = l;
	       break;
	     case -2: case 2:  /* min opposite to max */
	       break;
	     case 1: case 3:   /* min clockwise adjacent from max */
	       p = (l+1) & 3;
	       if ((z[p]-zl) > AZERO) m = l;
	       break;
	     case 0: default:
	       break;
	    }
	 }
	 polygon[k++] = 4;
	 f++;
	 if ((m&1) == 1) { /* start at corner a */
	    polygon[k++] = a;
	 }
	 polygon[k++] = a+1;
	 polygon[k++] = d+1;
	 polygon[k++] = d;
	 if ((m&1) == 0) { /* end at corner a */
	    polygon[k++] = a;
	 }
	 a++;
	 d++;
	 z[0] = z[1];
	 z[3] = z[2];
      }
      a++;
      d++;
   }
   DIEIF(pobj->nindex != k, "Polygon index wrong\n");
   DIEIF(f != (xdiv*ydiv), "Polygon number wrong\n");
   return f;
}


/*
 * Parse the command line set the filename and the appropriate flags
 */
int pcl(int argc, char **argv, char *fname)
{
   static const char *options[] =  {
      "-help                             print this message",
      "-list                            list mesh functions",
      "-function <fno>                         set function (0)",
      "-size <XxYxZ>                              bbox size (1.0x1.0x1.0)",
      "-divisions <XxY>                   divisions in grid (30x30)",
      "-parameters '(<p1>,[<p2>,...])'       parameter list",
      NULL
   };
   static const char usage1[] = "usage: mkpolyh [options] <name>";
   static const char usage2[] = " try mkpolyh -help for a list of option";

   int i, optno, fvalid = 0, olen;
   const char **sptr;
   float (**fptr)(float , float , int );
   int fno = 0;
   int w;

   for (i = 1; i < argc; i++) {
      olen = strlen(argv[i]);
      for (sptr = options, optno = 0; *sptr != NULL; sptr++, optno++)
         if (strncmp(argv[i], *sptr, olen) == 0) break;
      
      switch(optno)  {
       case 0:
	 printf("%s\n", usage1);
	 printf("Options:\n");
	 for (sptr = options; *sptr != NULL; sptr++) printf(" %s\n", *sptr);
	 printf("\n");
	 exit(EXIT_SUCCESS);
	 break;
       case 1:
	 printf("The following functions are available\n");
	 for (w=0, fptr = flist; *fptr != NULL; w++, fptr++) {
	    (**fptr)(0.0, 0.0, 2);
	    printf("%d) %s\n", w, meshhelp);
	 }
	 exit(EXIT_SUCCESS);
	 break;
       case 2:
	 fno = atoi(argv[++i]);
	 for (w=0, fptr = flist; w<=fno; w++, fptr++)
	    if (*fptr == NULL) break;
	 DIEIF3(*fptr == NULL,
		"Function number too big, should be less than %d\n", w);
	 break;
       case 3:
	 sscanf(argv[++i], "%fx%fx%f", &bbx, &bby, &bbz);
	 break;
       case 4:
	 sscanf(argv[++i], "%dx%d", &xdiv, &ydiv);
	 break;
       case 5:
	 pparse(argv[++i], NULL);
	 break;
       default:
	 if (!fvalid && *argv[i] != '-')  {
	    strcpy(fname, argv[i]);
	    fvalid = 1;
	 } else  {
	    DIE4("%s\n%s\n", usage1, usage2);
	 }
	 break;
      }
   }
   
   DIEIF4(fvalid != 1, "%s\n%s\n", usage1, usage2);
   return fno;
}
