static char rcsid[] = "@(#)$Id: pcrle.c,v 2.6 1994/11/18 04:03:08 peter Exp $";
/*
 * pcrle.c - routine to read the mindimage rle format

 * Copyright 1994, 16th November.
 * Copyright 1994, 14th February.
 * By Peter Chang
 * peterc@v2.ph.man.ac.uk

 * See notice in misc.h for details of permissions and warranty of this
 * software.

 *
 * $Log: pcrle.c,v $
 * Revision 2.6  1994/11/18  04:03:08  peter
 * xpgs-2.5-patch 01: Changes in header files for clean compile
 *
 * Revision 2.5.1.1  1994/11/17  03:34:24  peter
 * Import of actual public release of xpgs-2.5: lots of cosmetic changes to docs
 *
 * Revision 2.5  1994/11/16  09:19:24  peter
 * Putting xpgs-2.5 in trunk.
 *
 * Revision 2.0.1.1  1994/11/16  09:10:30  peter
 * Import of xpgs-2.5: archive of new release to alt.sources (11/94)
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "pgs.h"
#include "pxmio.h"

#if __GNUC__ == 2
USE(rcsid);
#endif

/*
 * Read a significant line from a file.
 */
static int readline(FILE *fd, char *line, long *lineno, int flag)
{
   int length;
   char temp[LLEN+5];

   if (fgets(line, LLEN+4, fd) == NULL) {
      if (feof(fd)) return 0;
      else DIE3("fgets() failed on line %ld\n", *lineno);
   } else {
      (*lineno)++;
      if ((length=strlen(line)) > LLEN-1) {
         if (flag) fprintf(stderr,
               "Line too long on line %ld, line may be truncated.\n", *lineno);
         line[LLEN - 2] = '\n';
         line[LLEN - 1] = '\0';
         length=strlen(line);
         do {
            if (fgets(temp, LLEN+4, fd) == NULL) {
               if (feof(fd)) return length;
               else DIE3("fgets() failed on line %ld\n", *lineno);
            }
         } while(strlen(temp) > LLEN-1);
      }
   }

   return length;
}


/*
 * long and tortuous routine to read the MindImage rle format.
 * This is a non-standard format unrelated to anything else called
 * .rle
 */
int *pcrle(char name[NLEN], int verbose)
{
   char iname[NLEN], line[LLEN+10];
   int *atop, *aptr;
   char carray[30][2];
   int  i,j,k, check, lastpos, reqpos;
   int  len, xscale, yscale, cur, mul;
   long lineNo=0, tot, pos, roff, sum;

   char *rlet = NULL;
   FILE *fp;

   if (name[0] == '\0') {
      printf("\nPlease enter a filename for PC rle load:  ");
      scanf("%50s", iname);
      printf("\n\n");
      sprintf(name, "%s.rle", iname);
   }

   DIEIF3((fp = fopen(name, "r")) == NULL, "Error: Can't open %s\n", name);

   readline(fp, line, &lineNo,0); /* read copyright line */

   tot = 0;
   while((len = readline(fp, line, &lineNo,0))) tot += len;
   fclose(fp);
   tot -= lineNo+1;
   DIEIF((rlet = (char *) calloc(tot, sizeof(char))) == NULL,
      "Unable to allocate memory for rle table\n");
   tot--;

   lineNo = 0;
   if ((fp = fopen(name, "r")) == NULL) {
      fprintf(stderr,"Error: Can't open %s\n", name);
      return NULL;
   }

   sum = 0;
   len = readline(fp, line, &lineNo,1); /* read copyright line */
   for (i=0; i<len; i++) {
       if (line[i] > 32) sum += line[i]-'!';
   }

   len = readline(fp, line, &lineNo,1);
   xscale = line[0] - '!';
   yscale = line[1] - '!';
   sum += xscale+yscale;

   /* copy all data to rle table */
   roff = 0;
   i = 2;
   do {
      while (line[i] != '\n' && line[i] != '\0') {
         rlet[roff] = line[i] - '!';
         sum += rlet[roff];
         i++;
         roff++;
      }
      i = 0;
   } while ((len = readline(fp, line, &lineNo,1)));
   fclose(fp);

   roff--;
   check = rlet[roff];
   sum -= check;
   sum = sum % 64;
#ifdef MYDEBUG
printf("factors %d %d\n", xscale, yscale);
printf("totals %ld %ld\n", tot, roff);
printf("checksum = %d, found to be %ld\n", check, sum);
#endif
   DIEIF(tot != roff, "couldn't get all data\n");
   DIEIF(check != sum, "file corrupt? checksum wrong\n");
   tot = roff;

   /* set tile parameters */
   tw = 512/xscale;
   th = 512/yscale;
   zmax  = 63;
   coloured = 0;
   DIEIF((atop = (int *) calloc(tw*th,sizeof(int))) == NULL,
	 "Unable to allocate memory for depthmap\n");
   if (verbose) printf("size = %d %d\n", tw, th);
   i = 0;
   j = tw*th;
   lastpos = 0;
   aptr = atop;
   for (pos=0; pos<tot; pos++) {
      cur = rlet[pos];
      if (cur > 63) {    /* find old combo */
         reqpos = (lastpos - cur + 93) % 30;
         cur = carray[reqpos][0];
         mul = carray[reqpos][1];
      } else {
         mul = rlet[++pos]+1;
      }
      carray[lastpos][0] = cur;
      carray[lastpos][1] = mul;
      lastpos = (lastpos+1) % 30;
      for (k=0; k<mul; k++) {
	 *aptr++ = cur;
	 i++;
         DIEIF(i >= j && k<(mul-1), "error overflowing lattice\n");
      }
   }
   free(rlet);

   if (verbose) printf("All done, %s loaded\n", name);
   return atop;
}
