/*
 * pgs.h - common header file.

 * Copyright 1994, 16th November.
 * Copyright 1994, 14th February.
 * By Peter Chang and Gareth Richards
 * peterc@v2.ph.man.ac.uk
 * gareth@h1.ph.man.ac.uk

 * See notice in misc.h for details of permissions and warranty of this
 * software.

 *
 * $Log: pgs.h,v $
 * Revision 2.6  1994/11/18  04:03:08  peter
 * xpgs-2.5-patch 01: Changes in header files for clean compile
 *
 * Revision 2.5.1.1  1994/11/17  03:34:30  peter
 * Import of actual public release of xpgs-2.5: lots of cosmetic changes to docs
 *
 * Revision 2.5  1994/11/16  09:19:25  peter
 * Putting xpgs-2.5 in trunk.
 *
 * Revision 2.0.1.1  1994/11/16  09:10:31  peter
 * Import of xpgs-2.5: archive of new release to alt.sources (11/94)
 *
 *
 */

/*
 * Width and height in pixels of z buffer used by screen and
 * paper routines. The screen uses half these values and the paper output
 * has a resolution of 144dpi. (These values apply in xpgs only.)
 */
#ifdef EUROPPR
#define MW 1540
#define MH 952
#define MWHS "1540x952"
#else
#define MW 1440
#define MH 890
#define MWHS "1440x890"
#endif

#define MYLOW -32000
#define MYHIGH 32000

#define VD  (300.0*pmm) /* Viewing distance from screen (in pixels) */
#define ES  (65.0*pmm)  /* Eye separation */
#define OS  (150.0*pmm) /* Offset into screen */
#define OX  (width/2)
#define OY  (height/2)

#include "misc.h"

#ifdef SILLYRAND
#define MYRAND (rand()/7) /* dodgy random number generator */
#else
#define MYRAND (rand())
#endif

extern int   width, height;
extern float pmm;

#ifdef SIRDS_STUFF
typedef struct {
   int t;
   int f;
} Llist;
#endif
