static char rcsid[] = "@(#)$Id: psout.c,v 2.6 1994/11/18 04:03:10 peter Exp $";
/*
 * psout - routines to save SIRDS as a postscript file.

 * Copyright 1994, 16th November.
 * Copyright 1994, 14th February.
 * By Peter Chang and Gareth Richards
 * peterc@v2.ph.man.ac.uk
 * gareth@h1.ph.man.ac.uk

 * See notice in misc.h for details of permissions and warranty of this
 * software.

 *
 * $Log: psout.c,v $
 * Revision 2.6  1994/11/18  04:03:10  peter
 * xpgs-2.5-patch 01: Changes in header files for clean compile
 *
 * Revision 2.5.1.1  1994/11/17  03:34:22  peter
 * Import of actual public release of xpgs-2.5: lots of cosmetic changes to docs
 *
 * Revision 2.5  1994/11/16  09:19:26  peter
 * Putting xpgs-2.5 in trunk.
 *
 * Revision 2.0.1.1  1994/11/16  09:10:30  peter
 * Import of xpgs-2.5: archive of new release to alt.sources (11/94)
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include "pgs.h"
#include "psout.h"

#if __GNUC__ == 2
USE(rcsid);
#endif


/*
 * save in PS format:
 * the area used by the SIRDS is 770x476 (720x445)
 * centred on a landscape piece of A4 (letter or 8.5x11) paper

 * Notes: A4 is 595x842 and letter is 612x792
 * hence the offsets are +36+83 and +36+59 in landscape coords.

 * All quantities are in points (72pt per inch).
 */


/* write hex lines */
void psline(FILE *fo, uschar *pixels, int pperl, int pperb)
{
   int times, remain, mask;
   int tmp;
   int h, i, k, t;

   times = pperl / 36;
   remain = pperl % 36;
   mask = (1 << grey) - 1;

   for (t=0; t<times; t++) {
      for (i=0; i<36; i++) {
	 h = 0;
	 for (k=0; k<pperb; k++, pixels++) {
	    tmp = *pixels & mask;
	    h = (h << grey) | tmp;
	 }
	 fprintf(fo,"%02x", h);
      }
      fprintf(fo,"\n");
   }
   
   for (i=0; i<remain; i++) {
      h = 0;
      for (k=0; k<pperb; k++, pixels++) {
	 tmp = *pixels & mask;
	 h = (h << grey) | tmp;
      }
      fprintf(fo,"%02x", h);
   }
   fprintf(fo,"\n");
}


/* set up PS header info and some definitions */
void psprologue(FILE *fo, char *name, int bperl)
{   
   fprintf(fo,"%%!PS-Abode-2.0 EPSF-2.0\n");
   fprintf(fo,"%%%%Creator: XPGS - by Peter Chang\n");
   fprintf(fo,"%%%%CreationDate: 14/2/94\n");
   fprintf(fo,"%%%%Title: %s\n", name);
   fprintf(fo,"%%%%BoundingBox: 0 0");
#ifdef EUROPPR
   fprintf(fo," 595 842\n");
#else
   fprintf(fo," 612 792\n");
#endif
   fprintf(fo,"%%%%Pages: 1\n");
   fprintf(fo,"%%%%DocumentFonts: Helvetica-Bold\n");
   fprintf(fo,"%%%%EndComments\n");
   fprintf(fo,"%%%%EndProlog\n");
   fprintf(fo,"\n");
   fprintf(fo,"%%%%Page: 1 1\n");
   fprintf(fo,"\n");
   fprintf(fo,"/origstate save def\n");
   fprintf(fo,"\n");
   fprintf(fo,"20 dict begin\n");
   fprintf(fo,"\n");
   fprintf(fo,"/pix %d string def\n", bperl);
   fprintf(fo,"\n");
   fprintf(fo,"/imagebitmap\n");
   fprintf(fo,"  { %d %d %d [%d 0 0 -%d 0 %d]\n", width, height, grey,
           width, height, height);
   fprintf(fo,"         { currentfile pix readhexstring pop }\n");
   fprintf(fo,"         image\n");
   fprintf(fo,"  } def\n");
   fprintf(fo,"\n");
   fprintf(fo,"/triangle\n");
   fprintf(fo,"  { newpath\n");
   fprintf(fo,"    0 0 moveto\n");  
   fprintf(fo,"    5 5 rlineto\n");
   fprintf(fo,"    -10 0 rlineto\n");
   fprintf(fo,"    5 -5 rlineto\n");
   fprintf(fo,"    closepath\n");
   fprintf(fo,"    fill\n");
   fprintf(fo,"  } def\n");
   fprintf(fo,"\n");

   /* set in landscape mode */
#ifdef EUROPPR
   fprintf(fo,"90 rotate 0 -595 translate\n");
#else
   fprintf(fo,"90 rotate 0 -612 translate\n");
#endif
   fprintf(fo,"\n");
   fprintf(fo,"gsave\n");
   fprintf(fo,"\n");
#ifdef EUROPPR
   fprintf(fo,"36 59 translate\n");
   fprintf(fo,"770 476 scale\n");
#else
   fprintf(fo,"36 83 translate\n");
   fprintf(fo,"720 445 scale\n");
#endif
   fprintf(fo,"\n");
   fprintf(fo,"imagebitmap\n");
}


/* prints indicators and copyright and name stuff */
void psepilogue(FILE *fo, char *name, int sep)
{
   fprintf(fo,"\n");
   fprintf(fo,"grestore\n");
   fprintf(fo,"\n");

#ifdef EUROPPR
   fprintf(fo,"36 535 translate\n"); /* 476+59 */
#else
   fprintf(fo,"36 528 translate\n"); /* 445+83 */
#endif
   fprintf(fo,"\n");
   if (indicator) {
      fprintf(fo,"gsave\n");
      fprintf(fo,"\n");
#ifdef EUROPPR
      fprintf(fo,"385 %d 2 idiv sub\n", sep);
#else
      fprintf(fo,"360 %d 2 idiv sub\n", sep);
#endif
      fprintf(fo,"0 translate\n");
      fprintf(fo,"triangle\n");
      fprintf(fo,"\n");
      fprintf(fo,"%d 0 translate\n", sep);
      fprintf(fo,"triangle\n");
      fprintf(fo,"\n");
      fprintf(fo,"grestore\n");
   }

   fprintf(fo,"\n");
   fprintf(fo,"0 6 translate\n");
   fprintf(fo,"/Helvetica-Bold findfont 12 scalefont setfont\n");
   fprintf(fo,"0 0 moveto\n");
   fprintf(fo,"(%s - using xpgs ) show\n", name);
   fprintf(fo,"/Symbol findfont 12 scalefont setfont\n");
   fprintf(fo,"currentpoint moveto\n");
   fprintf(fo,"(\\343) show\n");
   fprintf(fo,"/Helvetica-Bold findfont 12 scalefont setfont\n");
   fprintf(fo,"currentpoint moveto\n");
   fprintf(fo,"(1994 by Peter Chang & Gareth Richards) show\n");
   fprintf(fo,"\n");
   fprintf(fo,"showpage\n");
   fprintf(fo,"\n");
   fprintf(fo,"end\n");
   fprintf(fo,"\n");
   fprintf(fo,"origstate restore\n");
   fprintf(fo,"\n");
   fprintf(fo,"%%%%Trailer\n");
}
