static char rcsid[] = "@(#)$Id: pxmio.c,v 2.6 1994/11/18 04:03:10 peter Exp $";
/*
 * pxmio.c - routines for p?m file input and output and tile creations.

 * Copyright 1994, 16th November.
 * By Peter Chang
 * peterc@v2.ph.man.ac.uk

 * See notice in misc.h for details of permissions and warranty of this
 * software.

 *
 * $Log: pxmio.c,v $
 * Revision 2.6  1994/11/18  04:03:10  peter
 * xpgs-2.5-patch 01: Changes in header files for clean compile
 *
 * Revision 2.5.1.1  1994/11/17  03:34:19  peter
 * Import of actual public release of xpgs-2.5: lots of cosmetic changes to docs
 *
 * Revision 2.5  1994/11/16  09:19:27  peter
 * Putting xpgs-2.5 in trunk.
 *
 * Revision 2.0.1.1  1994/11/16  09:10:30  peter
 * Import of xpgs-2.5: archive of new release to alt.sources (11/94)
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "pgs.h"
#include "pxmio.h"

#if __GNUC__ == 2
USE(rcsid);
#endif


/*
 * rescale and shift a depth map
 */
void rescaledmap(int *dmap, float ratio, int off)
{
   int *mapptr;
   int i, z;

   mapptr = dmap;
   for (i=th*tw; i>0; i--) {
      z = *mapptr;
      z = (int) (z * ratio);
      z -= off;
      *mapptr++ = z;
   }
}


/* 
 * gets a line cropping off the hashed comments 
 * and returns a pointer to the terminator of the string
 */
char *my_fgets(char *s, FILE *f)
{
   register int c, n = LLEN-1;
   register char *cs = s;

   while (--n>0 && (c=fgetc(f)) != EOF) {
      if (c == '#' || (*cs++ = (char) c) == '\n') break;
   }
   if (c == '#') {
      *cs++ = '\n';
      while ((c=fgetc(f)) != EOF) {
	 if (c == '\n') break;
      }
   }
   *cs = '\0';
   DIEIF(c == EOF && cs == s, "EOF reached before data read!\n");
   return cs;
}


/* 
 * gets an unsigned integer from a string
 * and returns a pointer to the next position on the string
 */
char *getusint(int *num, char *s, char *end)
{
   register int c;

   while (s < end && !isdigit(c = (int) *s++));

   if (s >= end) return NULL;
   for (*num=0; isdigit(c); c = (int) *s++) {
      *num *= 10;
      *num += (c - '0');
   }

   return s;
}


static char *my_lline;
static char *my_lpos, *my_lend;

#define GET_INT(A) \
   while ((my_lpos = getusint(A, my_lpos, my_lend)) == NULL) { \
      my_lend = my_fgets(my_lline, fi); \
      my_lpos = my_lline; \
   }

/*
 * load .p*m file for tile or depthmap - 0 or 1 
 * returning usshort * or int *
 */
void *loadpxm(char name[NLEN], int dmode)
{
   FILE *fi;
   char magic[NLEN];
   int rawbits;
   usshort *tile;
   int *dmap;
   int input = 1;

   void loadpgmtile(FILE *, usshort *, int );
   void loadppmtile(FILE *, usshort *, int );
   void loadpgmdmap(FILE *, int *, int );
   void loadppmdmap(FILE *, int *, int );

#ifndef VMS
   if (strcmp(name, "-") == 0) {
      fi = stdin;
      input = 0;
   } else if ((fi = fopen(name, "r")) == NULL) {
      fprintf(stderr, "Unable to open file: %s\n", name);
      return NULL;
   }
#else
   if ((fi = fopen(name, "r")) == NULL) {
      fprintf(stderr, "Unable to open file: %s\n", name);
      return NULL;
   }
#endif
   fscanf(fi, "%2s", magic);
   DIEIF(magic[0] != 'P', "File format is incorrect!!!\n\n");
   switch (magic[1]) {
    case '2':
      rawbits = 0;
      coloured = 0;
      break;
    case '3':
      rawbits = 0;
      coloured = 1;
      break;
    case '5':
      rawbits = 1;
      coloured = 0;
      break;
    case '6':
      rawbits = 1;
      coloured = 1;
      break;
    default:
      DIEIF(1, "File format is incorrect!!!\n\n");
      break;
   }

   DIEIF((my_lline = (char *) malloc(LLEN)) == NULL,
               "Unable to allocate memory for line\n");
   my_lend = my_fgets(my_lline, fi);
   my_lpos = my_lline;

   GET_INT(&tw);
   GET_INT(&th);
   GET_INT(&zmax);

   DIEIF(rawbits && zmax > 255, "Max value incompatible with rawbits\n");

   switch(dmode) {
    case LDPXMDMAP:
      DIEIF((dmap = (int *) calloc(tw*th,sizeof(int))) == NULL,
	    "Unable to allocate memory for depthmap\n");

      if (coloured) {
	 loadppmdmap(fi, dmap, rawbits);
      } else {
	 loadpgmdmap(fi, dmap, rawbits);
      }

      free(my_lline);
      if (input) fclose(fi);
      return (void *) dmap;
    case LDPXMTILE: default:
      DIEIF((tile = (usshort *) calloc(tw*th,sizeof(short))) == NULL,
	    "Unable to allocate memory for tile\n");

      if (coloured) {
	 loadppmtile(fi, tile, rawbits);
      } else {
	 loadpgmtile(fi, tile, rawbits);
      }

      free(my_lline);
      if (input) fclose(fi);
      return (void *) tile;
   }
}


/* load tile */
void loadpgmtile(FILE *fi, usshort *tile, int rawbits)
{
   int i, j, z;
   usshort *zline;

   for (j=0; j<th; j++) {
      zline = &tile[j*tw];
      for (i=0; i<tw; i++) {
	 if (rawbits) {      
	    z = fgetc(fi);
	 } else {
	    GET_INT(&z);
	 }
	 *zline++ = z;
      }
   }
}


void loadppmtile(FILE *fi, usshort *tile, int rawbits)
{
   int i, j, k, r, g, b;
   usshort *zline;

   nocols = 1;
   DIEIF((palette = (Myrgb *) calloc(10,sizeof(Myrgb))) == NULL,
               "Unable to allocate memory for colours\n");
   palette[0].r = 0; palette[0].g = 0; palette[0].b = 0;

   for (j=0; j<th; j++) {
      zline = &tile[j*tw];
      for (i=0; i<tw; i++)  {
	 if (rawbits) {
	    r = fgetc(fi);
	    g = fgetc(fi);
	    b = fgetc(fi);
	 } else {
	    GET_INT(&r);
	    GET_INT(&g);
	    GET_INT(&b);
	 }
	 for (k=nocols-1; k>=0; k--) {
	    if (r == palette[k].r && g == palette[k].g
		&& b == palette[k].b) break;
	 }
	 if (k>=0) {
	    *zline++ = k;
	 } else {
	    palette[nocols].r = r;
	    palette[nocols].g = g;
	    palette[nocols].b = b;
	    *zline++ = nocols;
	    nocols++;
	    if ((nocols % 10)==0) {
	       DIEIF((palette = (Myrgb *) realloc(palette,
		     (nocols+10)*sizeof(Myrgb))) == NULL,
		     "Unable to allocate memory for colours\n");
	    }
	 }
      }
   }
}


/* load depthmap */
void loadpgmdmap(FILE *fi, int *dmap, int rawbits)
{
   int i, j, z;
   int *zline;

   for (j=0; j<th; j++) {
      zline = &dmap[j*tw];
      for (i=0; i<tw; i++) {
	 if (rawbits) {      
	    z = fgetc(fi);
	 } else {
	    GET_INT(&z);
	 }
	 *zline++ = z;
      }
   }
}


void loadppmdmap(FILE *fi, int *dmap, int rawbits)
{
   int i, j, c, z, zm;
   int *zline;

   zm = zmax + 1;
   for (j=0; j<th; j++) {
      zline = &dmap[j*tw];
      for (i=0; i<tw; i++)  {
	 if (rawbits) {
	    c = fgetc(fi);
	    z = c;
	    z *= zm;
	    z += fgetc(fi);
	    z *= zm;
	    z += fgetc(fi);
	 } else {
	    GET_INT(&c);
	    z = c;
	    z *= zm;
	    GET_INT(&c);
	    z += c;
	    z *= zm;
	    GET_INT(&c);
	    z += c;
	 }
	 *zline++ = z;
      }
   }
}


/* generate random .pgm tile */
usshort *randpbm(int den)
{
   int   i, j;
   usshort *tile;
   usshort *zline;

   zmax = 255;
   DIEIF((tile = (usshort *) calloc(tw*th,sizeof(short))) == NULL,
               "Unable to allocate memory for tile\n");

   for (j=0; j<th; j++) {
      zline = &tile[j*tw];
      for (i=0; i<tw; i++) {
	 zline[i] = ((MYRAND & 0x00ff) > den) ? zmax : 0;
      }
   }
   return tile;
}


usshort *randpgm(void)
{
   int   i, j;
   usshort *zline;
   usshort *tile;

   zmax = 255;
   DIEIF((tile = (usshort *) calloc(tw*th,sizeof(short))) == NULL,
               "Unable to allocate memory for tile\n");

   for (j=0; j<th; j++) {
      zline = &tile[j*tw];
      for (i=0; i<tw; i++) {
	 zline[i] = MYRAND % zmax;
      }
   }
   return tile;
}


/* generate random .ppm tile */
usshort *randppm(void)
{
   int   i, j;
   usshort *zline;
   usshort *tile;

   rainbow();
   DIEIF((tile = (usshort *) calloc(tw*th,sizeof(short))) == NULL,
               "Unable to allocate memory for tile\n");

   for (j=0; j<th; j++) {
      zline = &tile[j*tw];
      for (i=0; i<tw; i++) {
	 zline[i] = MYRAND % nocols;
      }
   }
   return tile;
}


void rainbow(void)
{
   Myrgb *pa;

   zmax = 255;
   nocols = 25;
   DIEIF((palette = (Myrgb *) calloc(nocols,sizeof(Myrgb))) == NULL,
               "Unable to allocate memory for colours\n");
   pa = palette;
   pa->r = 0; pa->g = 0; pa->b = 0; pa++;
   pa->r = 255; pa->g = 0; pa->b = 0; pa++;
   pa->r = 255; pa->g = 63; pa->b = 0; pa++;
   pa->r = 255; pa->g = 127; pa->b = 0; pa++;
   pa->r = 255; pa->g = 191; pa->b = 0; pa++;

   pa->r = 255; pa->g = 255; pa->b = 0; pa++;
   pa->r = 191; pa->g = 255; pa->b = 0; pa++;
   pa->r = 127; pa->g = 255; pa->b = 0; pa++;
   pa->r = 63; pa->g = 255; pa->b = 0; pa++;

   pa->r = 0; pa->g = 255; pa->b = 0; pa++;
   pa->r = 0; pa->g = 255; pa->b = 63; pa++;
   pa->r = 0; pa->g = 255; pa->b = 127; pa++;
   pa->r = 0; pa->g = 255; pa->b = 191; pa++;

   pa->r = 0; pa->g = 255; pa->b = 255; pa++;
   pa->r = 0; pa->g = 191; pa->b = 255; pa++;
   pa->r = 0; pa->g = 127; pa->b = 255; pa++;
   pa->r = 0; pa->g = 63; pa->b = 255; pa++;

   pa->r = 0; pa->g = 0; pa->b = 255; pa++;
   pa->r = 63; pa->g = 0; pa->b = 255; pa++;
   pa->r = 127; pa->g = 0; pa->b = 255; pa++;
   pa->r = 191; pa->g = 0; pa->b = 255; pa++;

   pa->r = 255; pa->g = 0; pa->b = 255; pa++;
   pa->r = 255; pa->g = 0; pa->b = 191; pa++;
   pa->r = 255; pa->g = 0; pa->b = 127; pa++;
   pa->r = 255; pa->g = 0; pa->b = 63; pa++;
}


/* global function pointer for saving line, set by pxmstart() */
void (*pxmline) (FILE *, Myrgb *);

static char *my_pline;

/* starts the saving of a pixmap */
void pxmstart(FILE *fo)
{
   int magic;

   void pgmline(FILE *, Myrgb *);
   void ppmline(FILE *, Myrgb *);
   void rpgmline(FILE *, Myrgb *);
   void rppmline(FILE *, Myrgb *);

   if (zmax <= 255) {
      if (coloured) {
	 magic = 6;
	 pxmline = rppmline;
      } else {
	 magic = 5;
	 pxmline = rpgmline;
      }
   } else {
      DIEIF((my_pline = (char *) malloc(LLEN)) == NULL,
	    "Unable to allocate memory for my_pline\n");
      my_pline[0] = '\0';
      if (coloured) {
	 magic = 3;
	 pxmline = ppmline;
      } else {
	 magic = 2;
	 pxmline = pgmline;
      }
   }
   fprintf(fo, "P%d\n", magic);
}


/* save .pgm line */
void pgmline(FILE *fo, Myrgb *line)
{
   int   i;
   char pbit[LLEN];

   if (line != NULL) {
      for (i=0; i<width; i++, line++) {
         sprintf(pbit, " %d", line->r);
         if (strlen(my_pline) + strlen(pbit) >= 70) {
            fprintf(fo, "%s\n", my_pline);
            strcpy(my_pline, pbit);
         } else
            strcat(my_pline, pbit);
      }
   } else {
      fprintf(fo, "%s\n", my_pline);
      free(my_pline);
   }
}


/* save .ppm line */
void ppmline(FILE *fo, Myrgb *line)
{
   int   i;
   char pbit[LLEN];

   if (line != NULL) {
      for (i=0; i<width; i++, line++) {
	 sprintf(pbit, " %d %d %d", line->r, line->g, line->b);
         if (strlen(my_pline) + strlen(pbit) >= 70) {
            fprintf(fo, "%s\n", my_pline);
            strcpy(my_pline, pbit);
         } else
            strcat(my_pline, pbit);
      }
   } else {
      fprintf(fo, "%s\n", my_pline);
      free(my_pline);
   }
}


/* save raw .pgm line */
void rpgmline(FILE *fo, Myrgb *line)
{
   int   i;

   if (line != NULL) {
      for (i=0; i<width; i++, line++) {
	 fputc(line->r, fo);
      }
   }
}


/* save raw .ppm line */
void rppmline(FILE *fo, Myrgb *line)
{
   int   i;

   if (line != NULL) {
      for (i=0; i<width; i++, line++) {
	 fputc(line->r, fo);
	 fputc(line->g, fo);
	 fputc(line->b, fo);
      }
   }
}

