/*
 * pxmio.h - header for pxmio.c

 * Copyright 1994, 16th November.
 * By Peter Chang
 * peterc@v2.ph.man.ac.uk

 * See notice in misc.h for details of permissions and warranty of this
 * software.

 *
 * $Log: pxmio.h,v $
 * Revision 2.6  1994/11/18  04:03:11  peter
 * xpgs-2.5-patch 01: Changes in header files for clean compile
 *
 * Revision 2.5.1.1  1994/11/17  03:34:31  peter
 * Import of actual public release of xpgs-2.5: lots of cosmetic changes to docs
 *
 * Revision 2.5  1994/11/16  09:19:28  peter
 * Putting xpgs-2.5 in trunk.
 *
 * Revision 2.0.1.1  1994/11/16  09:10:32  peter
 * Import of xpgs-2.5: archive of new release to alt.sources (11/94)
 *
 *
 */

#include "misc.h"

typedef struct {
   usshort r;
   usshort g;
   usshort b;
} Myrgb;

extern Myrgb *palette;
extern int nocols, zmax, coloured;
extern int tw, th;

extern void (*pxmline) (FILE *fptr, Myrgb *pixelline);

#define LDPXMTILE 0
#define LDPXMDMAP 1

void rescaledmap(int *dmap, float ratio, int off);
void *loadpxm(char name[NLEN], int dmapmode);
usshort *randpbm(int density);
usshort *randpgm(void);
usshort *randppm(void);
void rainbow(void);
void pxmstart(FILE *fptr);
