static char rcsid[] = "@(#)$Id: vpgs.c,v 2.6.2.1 1995/01/26 04:44:16 peter Exp $";
/*
 *  vpgs - a program to view SIRDS generated from depth maps.

 * A SIRDS is created from depth map data in p?m format and
 * displayed in an X window. It can then be saved in either
 * XBitMap or PostScript format.

 * Copyright 1994 and 1995, 26th January.
 * By Peter Chang
 * peterc@a3.ph.man.ac.uk

 * See notice in misc.h for details of permissions and warranty of this
 * software.

 *
 * $Log: vpgs.c,v $
 * Revision 2.6.2.1  1995/01/26  04:44:16  peter
 * Fixed bug in PS output with grey != 1.
 *
 * Error in title setting rectified.
 *
 * New reload fn implemented.
 *
 * Revision 2.6  1994/11/18  04:03:13  peter
 * xpgs-2.5-patch 01: Changes in header files for clean compile
 *
 * Revision 2.5.1.1  1994/11/17  03:34:23  peter
 * Import of actual public release of xpgs-2.5: lots of cosmetic changes to docs
 *
 * Revision 2.5  1994/11/16  09:19:34  peter
 * Putting xpgs-2.5 in trunk.
 *
 * Revision 2.0.1.1  1994/11/16  09:10:30  peter
 * Import of xpgs-2.5: archive of new release to alt.sources (11/94)
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#ifdef VMS
#include <DecW$Include/Xlib.h>
/* #include <DecW$Include/Xos.h> */
#include <DecW$Include/Xutil.h>
#include <DecW$Include/keysym.h>
#else
#include <X11/Xlib.h>
/* #include <X11/Xos.h> */
#include <X11/Xutil.h>
#include <X11/keysym.h>
#endif

#include "icon.xbm"    /* icon bitmap */
#define SIRDS_STUFF
#include "pgs.h"
#include "pxmio.h"
#include "psout.h"
#include "zbuffer.h"
#include "lookup.h"
#include "xmisc.h"

#if __GNUC__ == 2
USE(rcsid);
#endif

static char *dispname = NULL, *fontname = NULL, *geometry = NULL;

Object *shapes = NULL;
usint nobj = 0;
float theta = 0.0, phi = 0.0;

Display *dpy;
Pixmap iconmap;
XFontStruct *font_info = NULL;
int depth;

Xss_w wmain = { None, None, 0, 0, 0, 0 },
      whp = { None, None, 300, 200, 0, 0 };

GC gcpx, gcpxr, gcpxor;
static GC gcpxt, gcpxs, gcpxsr;

static usint pw = MW, ph = MH;

int reverse = 1;
int fineness = 0;
float background = -1.0;
float pmm;
float enlarge = 1.0;

Myrgb *palette = NULL;
int nocols, zmax = 255, coloured = 1;
int tw, th;

int grey = 1, indicator = 1;
static int density = 127;
static int xstep = 1, ystep = 1;

int width, height; 
int buf_h = ZBLINES, buf_top, buf_bot;

int main(int argc, char **argv)
{
   int **ztopl = NULL, **ztopr = NULL; /* s-buffers */
   int dmax = 256;
   int *zmap = NULL;

   Window wtemp;
   XEvent report;
   KeySym keysym;
   char buf[3];

   int sep = 0;
   XPoint points[3];

   float spmm;

   int help, input, redraw;
   char name[NLEN], bname[NLEN], oname[NLEN];

   void pcl(int, char **, char *);
   void quitvpgs(void);
   void initall(int , char *[]);
   void stripname(char [NLEN], char [NLEN]);
   void writeintro(int , char *);
   int  drawsirds(int *, int **, int **, int );
   void saveps(int *, int **, int **, char [NLEN]);

   pcl(argc, argv, name);
   stripname(bname, name);

   printf("\nWelcome to vpgs\n");

   srand(time(NULL));

   input = 0;
   redraw = 1;
   help = 0;
   DIEIF((zmap = (int *)loadpxm(name, LDPXMDMAP)) == NULL,
	 "Crashing out\n");
   printf("input size %d %d\n", tw, th);
   width = tw;
   height = th;
   initall(argc, argv);
   spmm = pmm;
   printf("No of pixels per millimetre: %f\n", pmm);
   printf("\n ES: %f\n VD: %f\n OS: %f\n BG: %d\n OX: %d \t OY: %d \n",
	  ES, VD, OS, sep, OX, OY);
   dmax = zmax+1;
   if (coloured) dmax *= dmax*dmax;
   rescaledmap(zmap, (height / (float) dmax), height/2);
   writeintro(0, name);
   XFlush(dpy);
   redraw = 1;

   while (1) {
      XNextEvent(dpy, &report);
      switch (report.type) {
       case ConfigureNotify:
	 if (report.xconfigure.window == wmain.win) {
	    if (wmain.w != report.xconfigure.width ||
		wmain.h != report.xconfigure.height) {
	       redraw = 1;
	       rescaledmap(zmap, (dmax / (float) height), -dmax/2);
	       wmain.w = report.xconfigure.width;
	       wmain.h = report.xconfigure.height;
	       XFreePixmap(dpy, wmain.pix);
	       wmain.pix = XCreatePixmap(dpy, wmain.win,
					 wmain.w, wmain.h, 1);
	       DIEIF(wmain.pix == None, "Could not create main pixmap\n");
	       width = wmain.w;
	       height = wmain.h;
	       rescaledmap(zmap, (height / (float) dmax), height/2);
	    }
	 }
	 break;
       case Expose:
         wtemp = report.xexpose.window;
         while (XCheckTypedWindowEvent(dpy, wtemp, Expose, &report));
         handleexpose(wtemp);
         break;
       case ButtonPress:
	 break;
       case ButtonRelease:
	 if (report.xbutton.window == wmain.win ||
	     report.xbutton.window == whp.win) {
	    help = 1 - help;
	    if (help) XMapWindow(dpy, whp.win);
	    else XUnmapWindow(dpy, whp.win);
	 }
	 break;
        case KeyPress:
	 XLookupString(&report.xkey, buf, 3, &keysym, NULL);
	 switch (keysym) {
	  case XK_q: case XK_Q:
	    quitvpgs();
	    zmemf(ztopl);
	    zmemf(ztopr);
	    free(zmap);
	    exit(EXIT_SUCCESS);
	  case XK_h: case XK_H:
	    help = 1 - help;
	    if (help) XMapWindow(dpy, whp.win);
	    else XUnmapWindow(dpy, whp.win);
	    break;
	  case XK_l: case XK_L:
	    input = 1;
	    break;
	  case XK_o: case XK_O:
	    input = 2;
	    break;
	  case XK_s: case XK_S:
	    sprintf(dstring, "%s.ps", bname);
	    if (popupquery("Please enter PS file name") > 0) {
	       strncpy(oname, dstring, NLEN-1);
	       zmemf(ztopl);
	       zmemf(ztopr);
	       width = pw;
	       height = ph;
	       ztopl = zmema();
	       ztopr = zmema();
#ifdef EUROPAPER
	       pmm = (width/770.0)*72.0/25.4;
#else
	       pmm = (width/720.0)*72.0/25.4;
#endif
	       lookup(reverse);
	       saveps(zmap, ztopl, ztopr, oname);
	       pmm = spmm;
	       width = wmain.w;
	       height = wmain.h;
	       XBell(dpy, 100);
	       XFlush(dpy);
	       printf("Postscript saved: %s\n", oname);
	    }
	    break;
	  case XK_w: case XK_W:
	    sprintf(dstring, "%s.xbm", bname);
	    if (popupquery("Please enter XBM file name") > 0) {
	       strncpy(oname, dstring, NLEN-1);
	       XWriteBitmapFile(dpy, oname, wmain.pix, wmain.w, wmain.h,
				-1, -1);
	       XBell(dpy, 100);
	       XFlush(dpy);
	       printf("Bitmap saved: %s\n", oname);
	    }
	    break;
	  default:
	    break;
	 }
      } /* end of event loop */
      if (input) {
	 switch (input) {
	  case 1: default:
	    dstring[0] = '\0';
	    input = popupquery("Please enter P?M file name (w/ ext)");
	    if (input <= 0) break;
	    strncpy(name, dstring, NLEN-1);
	    stripname(bname, name);
	    writeintro(-1, name);
	    XFlush(dpy);
	  case 2:
	    free(zmap);
	    break;
	 }
	 if (input > 0) {
	    if ((zmap = (int *)loadpxm(name, LDPXMDMAP)) == NULL) {
	       quitvpgs();
	       zmemf(ztopl);
	       zmemf(ztopr);
	       exit(EXIT_FAILURE);
	    }	    
	    printf("input size %d %d\n", tw, th);
	    if (width <= 0 || height <= 0) {
	       width = tw;
	       height = th;
	    }
	    dmax = zmax+1;
	    if (coloured) dmax *= dmax*dmax;
	    input = 0;
	    rescaledmap(zmap, (height / (float) dmax), height/2);
	    writeintro(0, name);
	    XFlush(dpy);
	    redraw = 1;
	 }
      }
      if (redraw) {
	 redraw = 0;
	 zmemf(ztopl);
	 zmemf(ztopr);
	 width = wmain.w;
	 height = wmain.h;
	 ztopl = zmema();
	 ztopr = zmema();
	 lookup(reverse);
	 printf("\nProcessing frame:\n  ");
	 XFillRectangle(dpy, wmain.pix, gcpxsr, 0, 0, wmain.w, wmain.h);
	 sep = drawsirds(zmap, ztopl, ztopr, 0);
	 printf("Finished screen\n");
	 if (indicator) {
	    points[1].x = (width+sep)*0.5;
	    points[0].x = points[1].x+5;
	    points[2].x = points[1].x-5;
	    points[0].y = 0;
	    points[1].y = 10;
	    points[2].y = 0;
	    XFillPolygon(dpy, wmain.pix, gcpxs, points, 3,
			 Convex, CoordModeOrigin);
	    points[1].x = (width-sep)*0.5;
	    points[0].x = points[1].x+5;
	    points[2].x = points[1].x-5;
	    XFillPolygon(dpy, wmain.pix, gcpxs, points, 3,
			 Convex, CoordModeOrigin);
	 }
	 XCopyPlane(dpy, wmain.pix, wmain.win, gcpxt, 0, 0,
		    wmain.w, wmain.h, 0, 0, 1);
	 XFlush(dpy);
      }
   } /* while */
}


/* remove extension */
void stripname(char fname[NLEN], char gname[NLEN])
{
   char *tptr;
   strcpy(fname, gname);
   tptr = strstr(fname, ".pgm");
   if (tptr != NULL) {
      *tptr = '\0';
      return;
   }
   tptr = strstr(fname, ".ppm");
   if (tptr != NULL) {
      *tptr = '\0';
   }
   return;
}


/*
 * draw SIRDS
 */
int drawsirds(int *dmap, int **zbufl, int **zbufr, int mode)
{
   int *zll, *zlr;
   uschar *pixarray;
   Llist *same;

   int x, y, pixpos, sep = 0;
   uschar colour;

   void sirdsnew(int *, int *, Llist *);
   void drawline(uschar *, int );
   void drawpsline(uschar *);

   DIEIF((same = (Llist *) malloc(width*sizeof(Llist))) == NULL,
	 "Unable to allocate memory for array\n");
   DIEIF((pixarray = (uschar *) malloc(width*sizeof(char))) == NULL,
	 "Unable to allocate memory for array\n");


   buf_bot = 0;
   for (y=0;y<height;y++) {
      if (y == buf_bot) sep = zsfillall(y, dmap, zbufl, zbufr,
					tw, th, xstep, ystep);
      zll = zbufl[y%buf_h];
      zlr = zbufr[y%buf_h];
      for (x=0;x<width;x++) {
	 same[x].t = x;
	 same[x].f = x;
      }
      sirdsnew(zll, zlr, same);
      if (mode > 0) {
	 for (x=0; x<width; x++) {
	    pixpos = same[x].f;
	    if (pixpos != x) {
	       colour = pixarray[pixpos];
	    } else {
	       colour = (uschar) (MYRAND & 0xff);
	       colour = (uschar) ((colour > density) ? 0xff : (MYRAND & 0xff));
	    }
	    pixarray[x] = colour;
	 }
	 drawpsline(pixarray);
      } else {
	 for (x=0; x<width; x++) {
	    pixpos = same[x].f;
	    colour = (pixpos != x) ? pixarray[pixpos] :
	             (uschar) (((MYRAND & 0x00ff) > density) ? 1 : 0);
	    pixarray[x] = colour;
	 }
	 drawline(pixarray, y);
      }
   }
   free(pixarray);
   free(same);
   return sep;
}


void drawline(uschar *pixline, int y)
{
   int x;

   for (x=0; x<width; x++) {
      if (pixline[x]==1) XDrawPoint(dpy, wmain.pix, gcpxs, x, y);
   }
}


void initall(int argc, char *argv[])
{
   XSizeHints hint;
   XWMHints wmhint;
   Window root;
   uslong fg, bg;
   usint sw, sh;
   int screen;
   int gflags = 0;

   void writehelp(void);

   dpy = XOpenDisplay(dispname);
   if (!dpy) {
      fprintf(stderr, "Could't open display: ");
      if (dispname == NULL)
#ifdef VMS
         fprintf(stderr, "%s\n", getenv("DECW$DISPLAY"));
#else
         fprintf(stderr, "%s\n", getenv("DISPLAY"));
#endif
      else
         fprintf(stderr, "%s\n", dispname);
      exit(EXIT_FAILURE);
   }

   screen = DefaultScreen(dpy);
   root = RootWindow(dpy, screen);

   sw = width;
   sh = height;
   if (geometry != NULL)
      gflags = XParseGeometry(geometry, &hint.x, &hint.y, &sw, &sh);
   wmain.w = sw;
   wmain.h = sh;

   bg = BlackPixel(dpy, screen);
   fg = WhitePixel(dpy, screen);
   pmm = ((float) DisplayWidth(dpy, screen)) 
              / DisplayWidthMM(dpy, screen);
   depth = DefaultDepth(dpy, screen);

   width = wmain.w;
   height = wmain.h;
   printf("No of pixels per millimetre: %f\n", pmm);
   printf("\n VD: %f OS: %f\n OX: %d \t OY: %d \n", VD, OS, OX, OY);

   if (fontname != NULL) font_info = XLoadQueryFont(dpy, fontname);

   if (font_info == NULL) {
      fprintf(stderr, "Trying to use fixed font.\n");
      DIEIF((font_info = XLoadQueryFont(dpy, "fixed")) == NULL,
	    "Couldn't open any fonts\n");
   }
#ifdef MYDEBUG
   XSynchronize(dpy, 1); /* for debug X stuff */
#endif

   hint.width = wmain.w; hint.height = wmain.h;
   hint.flags = PSize;
   if (gflags & (WidthValue | HeightValue)) {
      hint.flags |= USSize;
   }
   if (gflags & XValue) {
      if (gflags & XNegative) {
	 hint.x += DisplayWidth(dpy, screen) - hint.width;
      }
      hint.flags |= USPosition;
   }
   if (gflags & YValue) {
      if (gflags & YNegative) {
	 hint.y += DisplayHeight(dpy, screen) - hint.height;
      }
      hint.flags |= USPosition;
   }
   wmain.x = hint.x; wmain.y = hint.y;
   wmain.win = XCreateSimpleWindow(dpy, root,
         wmain.x, wmain.y, wmain.w, wmain.h, 5, fg, bg);
   DIEIF(wmain.win == None, "Could not create main window\n");
   iconmap = XCreateBitmapFromData(dpy, wmain.win, (char *)pgs_bits,
                                   pgs_width, pgs_height);
   wmhint.input = True;
   wmhint.flags = InputHint;
   wmhint.icon_pixmap = iconmap;
   XSetStandardProperties (dpy, wmain.win, "Vpgs", "vpgs", iconmap, argv, argc,
			   &hint);
   XSetWMHints(dpy, wmain.win, &wmhint);
   XSelectInput(dpy, wmain.win, ButtonPressMask | ButtonReleaseMask |
		ExposureMask | OwnerGrabButtonMask | KeyPressMask |
		StructureNotifyMask);
   XMapWindow(dpy, wmain.win);

   /* To render, we will need graphics context of the proper depth. */
   gcpx = XCreateGC(dpy, wmain.win, 0, NULL);
   XSetForeground(dpy, gcpx, fg);
   XSetBackground(dpy, gcpx, bg);
   XSetFont(dpy, gcpx, font_info->fid);
   XSetClipMask(dpy, gcpx, None);
   XSetGraphicsExposures(dpy, gcpx, False);
   XSetLineAttributes(dpy, gcpx, 0, LineSolid, CapButt, JoinRound);
   XSetSubwindowMode(dpy, gcpx, ClipByChildren);

   gcpxt = XCreateGC(dpy, wmain.win, 0, NULL);
   XCopyGC(dpy, gcpx, ~0L, gcpxt);
   if (fg > bg) {
      XSetForeground(dpy, gcpxt, fg);
      XSetBackground(dpy, gcpxt, bg);
   } else {
      XSetForeground(dpy, gcpxt, bg);
      XSetBackground(dpy, gcpxt, fg);
   }

   gcpxr = XCreateGC(dpy, wmain.win, 0, NULL);
   XCopyGC(dpy, gcpx, ~0L, gcpxr);
   XSetForeground(dpy, gcpxr, bg);
   XSetBackground(dpy, gcpxr, fg);

   gcpxor = XCreateGC(dpy, wmain.win, 0, NULL);
   XCopyGC(dpy, gcpx, ~0L, gcpxor);
   XSetForeground(dpy, gcpxor, fg^bg);
   XSetFunction(dpy, gcpxor, GXxor);


   wmain.pix = XCreatePixmap(dpy, wmain.win, wmain.w, wmain.h, 1);
   gcpxs = XCreateGC(dpy, wmain.pix, 0, NULL);
   gcpxsr = XCreateGC(dpy, wmain.pix, 0, NULL);
   XSetForeground(dpy, gcpxs, fg);
   XSetBackground(dpy, gcpxs, bg);
   XSetClipMask(dpy, gcpxs, None);
   XSetGraphicsExposures(dpy, gcpxs, False);
   XSetLineAttributes(dpy, gcpxs, 0, LineSolid, CapButt, JoinRound);
   XCopyGC(dpy, gcpxs, ~0L, gcpxsr);
   XSetForeground(dpy, gcpxsr, bg);
   XSetBackground(dpy, gcpxsr, fg);
   XFillRectangle(dpy, wmain.pix, gcpxsr, 0, 0, wmain.w, wmain.h);


   whp.win = XCreateSimpleWindow(dpy, root, whp.x, whp.y, whp.w, whp.h,
				 5, fg, bg);
   DIEIF(whp.win == None, "Could not create help window\n");
   XSetStandardProperties (dpy, whp.win, "Vpgs help", "vpgs help", iconmap,
			   NULL, 0, NULL);
   XSetWMHints(dpy, whp.win, &wmhint);
   XSelectInput(dpy, whp.win, ButtonPressMask | ButtonReleaseMask |
		ExposureMask | OwnerGrabButtonMask | KeyPressMask);
   whp.pix = XCreatePixmap(dpy, whp.win, whp.w, whp.h, depth);
   DIEIF(whp.pix == None, "Could not create help pixmap\n");

   initpopup(root, fg, bg);
   writehelp();
}


void writehelp(void)
{
   int font_a, font_d, font_h, strl, strw;
   int linepos, colpos;
   int i;
   const char **sptr;
   static const char *strings[] = {
      "******* Keys in graphics window ******",
      " ",
      "q to Quit",
      "h to get Help",
      "l to Load new p?m depthmap file",
      "o to reload Old file",
      "s to Save frame as postscript",
      "w to Write frame as bitmap",
      NULL
   };
   font_a = font_info->ascent;
   font_d = font_info->descent;
   font_h = font_a + font_d;

   XFillRectangle(dpy, whp.pix, gcpxr, 0, 0, whp.w, whp.h);
   strw = 0;
   for (i=0, sptr=strings; *sptr != NULL; i++, sptr++) {
      strl = XTextWidth(font_info, *sptr, strlen(*sptr));
      if (strl > strw) strw = strl;
   }

   colpos = whp.w/2 - strw/2;
   linepos = whp.h/2 - (i*font_h)/2 - font_d;
   for (sptr=strings; *sptr != NULL; sptr++) {
      linepos += font_h;
      XDrawString(dpy, whp.pix, gcpx, colpos, linepos, *sptr, strlen(*sptr));
   }
   XFlush(dpy);
}


void writeintro(int load, char *name)
{
   int font_a, font_d, font_h, strl, strw;
   int linepos;
   int i, ox;
   const char *stra;
   char *strb;
   static const char *strings[] = {
      "Vpgs by Peter Chang",
      " ",
      "Copyright 1994",
      " ",
      " ",
      NULL
   };

   font_a = font_info->ascent;
   font_d = font_info->descent;
   font_h = font_a + font_d;

   XFillRectangle(dpy, wmain.win, gcpxr, 0, 0, wmain.w, wmain.h);

   linepos = wmain.h/3 + font_a - font_h;
   ox = 0;
   stra = strings[0];
   for (i=0; stra != NULL; i++, stra = strings[i]) {
      linepos += font_h;
      strl = strlen(stra);
      strw = XTextWidth(font_info, stra, strl);
      XDrawString(dpy, wmain.win, gcpx, ox+(wmain.w-strw)/2,
		  linepos, stra, strl);
   }

   DIEIF((strb = (char *) malloc(LLEN)) == NULL,
	 "Couldn't allocate memory for string\n");

   switch(load) {
    case 0:
      sprintf(strb, "%s loaded", name);
      break;
    case -1: default:
      sprintf(strb, "Loading %s...", name);
      break;
      
   }
   linepos += 2*font_h;
   strl = strlen(strb);
   strw = XTextWidth(font_info, strb, strl);
   XDrawString(dpy, wmain.win, gcpx, ox+(wmain.w-strw)/2,
	       linepos, strb, strl);

   sprintf(strb, "Press h or click on window for help");
   linepos += 3*font_h;
   strl = strlen(strb);
   strw = XTextWidth(font_info, strb, strl);
   XDrawString(dpy, wmain.win, gcpx, ox+(wmain.w-strw)/2,
	       linepos, strb, strl);

   free(strb);
}


int handleexpose(Window wev)
{
   if (wev == wmain.win) {
      XCopyPlane(dpy, wmain.pix, wmain.win, gcpxt, 0, 0,
		 wmain.w, wmain.h, 0, 0, 1);
   } else if (wev == whp.win) {
      XCopyArea(dpy, whp.pix, whp.win, gcpx, 0, 0, whp.w, whp.h, 0, 0);
   }

   return 0;
}


void quitvpgs(void)
{
   XFreePixmap(dpy, wmain.pix);
   XFreePixmap(dpy, whp.pix);
   XFreePixmap(dpy, iconmap);
   destroypopup();
   XFreeFont(dpy, font_info);
   XFreeGC(dpy, gcpxs);
   XFreeGC(dpy, gcpxsr);
   XFreeGC(dpy, gcpxt);
   XFreeGC(dpy, gcpx);
   XFreeGC(dpy, gcpxr);
   XFreeGC(dpy, gcpxor);
   XDestroyWindow(dpy, whp.win);
   XDestroyWindow(dpy, wmain.win);
   XCloseDisplay(dpy);
   free(zplookup);
   printf("\nFond farewell\n");
}


/* SIRDS algorithm */
void sirdsnew(int *zll, int *zlr, Llist *same)
{
   register int s;
   register short left, right;
   register short st, sl, sr;

   for (left=0; left<width; left++) {
      s = *zll++;
      right = left + s;
      if (right < width) {
	 s -= zlr[right];
	 if (s <= 1 && s >= -1) {
	    sl = left; sr = right;
	    for (st=same[sr].f; st!=sl && st!=sr; st=same[sr].f) {
	       if (st > sl) {
		  sr = st;
	       } else {
		  same[sl].t = sr;
		  same[sr].f = sl;
		  sr = sl;
		  sl = st;
	       }
	    }
	    same[sl].t = sr;
	    same[sr].f = sl;
	 }
      }
   }
}


/* postscript output */
static FILE *psfo;
static int pspixl, pspixb;

void saveps(int *dmap, int **zbufl, int **zbufr, char name[NLEN])
{
   int sep;
   int drawsirds(int *, int **, int **, int );

   switch(grey) {
    case 2:
      pspixb = 4;
      break;
    case 4:
      pspixb = 2;
      break;
    case 8:
      pspixb = 1;
      break;
    case 1: default:
      grey = 1;
      pspixb = 8;
      break;
   }
   pspixl = (width+pspixb-1)/pspixb;

printf("density %d grey %d pixb %d pixl %d\n", density, grey, pspixb, pspixl);

   if ((psfo = fopen(name, "w")) == NULL) {
      printf("Can't save %s\n", name);
      return;
   }

   psprologue(psfo, name, pspixl);
   sep = drawsirds(dmap, zbufl, zbufr, 1);
#ifdef EUROPPR
   sep = (sep*770)/width;
#else
   sep = (sep*720)/width;
#endif

   psepilogue(psfo, name, sep);
   fclose(psfo);
}

void drawpsline(uschar *pa)
{
   psline(psfo, pa, pspixl, pspixb);
}


/*
 * Parse the command line set the filename and the appropriate flags
 */
void pcl(int argc, char **argv, char *fname)
{
   static const char *options[] = {
      "-help                    print this message",
      "-display  <display>          X display name",
      "-geometry <geometry>             X geometry",
      "-background <b>          background plane (-1.0)",
      "-reverse              set crosseyed viewing",
      "-enlarge <ef>        enlarge depth of sirds (1.0)",
      "-step <XxY>              steps used in dmap (1x1)",
#ifdef vaxc
      "-paper <wxh>      size of array used for PS (?x?)",
#else
      "-paper <wxh>      size of array used for PS (" MWHS ")",
#endif
      "-indicoff     turn off indicators on window",
      "-zblines <zb> lines to use in each z buffer (256)",
      "-DENSITY <0-255>      density of black dots (127)",
      "-GREY <1,2,4,8>  set no. of grey scale bits (1)",
      NULL
   };
   static const char usage1[] = "usage: vpgs [options] <p?m file>";
   static const char usage2[] = " try vpgs -help for a list of options";

   int i, optno, fvalid = 0, olen;
   const char **sptr;

   for (i = 1; i < argc; i++) {
      olen = strlen(argv[i]);
      for (sptr = options, optno = 0; *sptr != NULL; sptr++, optno++)
         if (strncmp(argv[i], *sptr, olen) == 0) break;

      switch(optno) {
       case 0:
         printf("%s\n", usage1);
         printf("Options (defaults in parenthesis):\n");
 	 for (sptr = options; *sptr != NULL; sptr++) printf(" %s\n", *sptr);
	 printf("\n");
         exit(EXIT_SUCCESS);
         break;

       case 1:
         dispname = argv[++i];
         break;

       case 2:
         geometry = argv[++i];
         break;

       case 3:
         background = atof(argv[++i]);
         break;

       case 4:
         reverse = -1;
         break;

       case 5:
         enlarge = atof(argv[++i]);
	 break;

       case 6:
         sscanf(argv[++i], "%dx%d", &xstep, &ystep);
	 break;

       case 7:
         sscanf(argv[++i], "%dx%d", &pw, &ph);
         break;

       case 8:
         indicator = 0;
         break;

       case 9:
         buf_h = atoi(argv[++i]);
	 break;

       case 10:
         density = atoi(argv[++i]) & 0xff;
	 break;

       case 11:
         grey = atoi(argv[++i]) & 0x0f;
         break;

       default:
         if (!fvalid && *argv[i] != '-') {
            strcpy(fname, argv[i]);
            fvalid = 1;
         } else {
            DIE4("%s\n%s\n", usage1, usage2);
         }
         break; 
      }
   }

   DIEIF4(fvalid != 1, "%s\n%s\n", usage1, usage2);
}
