static char rcsid[] = "@(#)$Id: xdraw.c,v 2.6.2.1 1995/01/26 04:49:56 peter Exp $";
/*
 * xdraw.c - routines to draw things in xss

 * Copyright 1994 and 1995, 26th January.
 * By Peter Chang
 * peterc@a3.ph.man.ac.uk

 * See notice in misc.h for details of permissions and warranty of this
 * software.

 *
 * $Log: xdraw.c,v $
 * Revision 2.6.2.1  1995/01/26  04:49:56  peter
 * Fixed bugs in drawing perspective objects - both clipped and unclipped.
 *
 * Trimmed number of flops used in calculating positions of lines.
 *
 * Revision 2.6  1994/11/18  04:03:13  peter
 * xpgs-2.5-patch 01: Changes in header files for clean compile
 *
 * Revision 2.5.1.1  1994/11/17  03:34:20  peter
 * Import of actual public release of xpgs-2.5: lots of cosmetic changes to docs
 *
 * Revision 2.5  1994/11/16  09:19:35  peter
 * Putting xpgs-2.5 in trunk.
 *
 * Revision 2.0.1.1  1994/11/16  09:10:29  peter
 * Import of xpgs-2.5: archive of new release to alt.sources (11/94)
 *
 *
 */

#ifdef VMS
#include <DecW$Include/Xlib.h>
#else
#include <X11/Xlib.h>
#endif

#include "pgs.h"
#include "polyh.h"
#include "xmisc.h"
#include "lookup.h"

#if __GNUC__ == 2
USE(rcsid);
#endif

/* drawing stuff here */
/* need: views[], wmain, raxis, dpy, gcpx, VD OS , Segment * */
extern Xss_w wmain;
extern Xss_d views[4];
extern Point raxis;

void pdrawaxis(int clip, int dirn)
{
   float x, y, z;
   float ox, oy;
   XPoint points[2];

   ox = views[dirn].w/2.0;
   oy = views[dirn].h/2.0;

   switch(dirn) {
    case 1:
      x = -oy*raxis.z;
      y = oy*raxis.y;
      z = oy*raxis.x;
      break;
    case 2:
      x = oy*raxis.x;
      y = -oy*raxis.z;
      z = oy*raxis.y;
      break;
    case 3: default:
      x = oy*raxis.x;
      y = oy*raxis.y;
      z = oy*raxis.z;
      break;
   }
#ifndef XSSUSEPM
   ox += views[dirn].x;
   oy += views[dirn].y;
#endif
   points[1].x = ox;
   points[1].y = oy;
   if (!(clip && z < 0.0)) {
      points[0].x = ox + x;
      points[0].y = oy - y;
      XDrawLines(dpy, views[dirn].d, gcpx, points, 2, CoordModeOrigin);
   }
   if (!(clip && z > 0.0)) {
      points[0].x = ox - x;
      points[0].y = oy + y;
      XSetLineAttributes(dpy, gcpx, 0, LineOnOffDash, CapButt, JoinRound);
      XDrawLines(dpy, views[dirn].d, gcpx, points, 2, CoordModeOrigin);
      XSetLineAttributes(dpy, gcpx, 0, LineSolid, CapButt, JoinRound);
   }
}


void drawaxis(int clip)
{
   float x, y, z;
   float ox, oy, zf;
   XPoint points[2];

   ox = width/2.0;
   oy = height/2.0;
   x = oy*raxis.x;
   y = oy*raxis.y;
   z = oy*raxis.z;
   points[1].x = ox;
   points[1].y = oy;
   if (!(clip && z < 0.0)) {
      zf = VD / (VD+OS-z);
      points[0].x = ox + x*zf;
      points[0].y = oy - y*zf;
      XDrawLines(dpy, wmain.pix, gcpx, points, 2, CoordModeOrigin);
   }
   if (!(clip && z > 0.0)) {
      zf = VD / (VD+OS+z);
      points[0].x = ox - x*zf;
      points[0].y = oy + y*zf;
      XSetLineAttributes(dpy, gcpx, 0, LineOnOffDash, CapButt, JoinRound);
      XDrawLines(dpy, wmain.pix, gcpx, points, 2, CoordModeOrigin);
      XSetLineAttributes(dpy, gcpx, 0, LineSolid, CapButt, JoinRound);
   }
}


static const int bbox_seg[4][4] = {
   {0,1,2,3}, {4,2,1,7}, {6,1,3,7}, {5,2,7,3}
};

void pdrawbox(Object *pobj, int dirn)
{
   int i, j;
   int xa, ya, xb, yb;
   float x, y, z;
   float mm;
   float ox, oy;
   Affine taf;
   Point tpt;

   ox = views[dirn].w/2.0;
   oy = views[dirn].h/2.0;

   mm = oy;
   x = mm*pobj->wt.rsh.x;
   y = mm*pobj->wt.rsh.y;
   z = mm*pobj->wt.rsh.z;
   switch(dirn) {
    case 1:
      ox -= z;
      oy -= y;
      break;
    case 2:
      ox += x;
      oy += z;
      break;
    case 3: default:
      ox += x;
      oy -= y;
      break;
   }
#ifndef XSSUSEPM
   ox += views[dirn].x;
   oy += views[dirn].y;
#endif
   taf = pobj->wt;
   magsaffine(&taf, mm, mm, mm);

   for (i=0; i<4; i++) {
      applysaffine(&tpt, &pobj->rbb[bbox_seg[i][0]], &taf);
      switch(dirn) {
       case 1:
	 xa = (int) (ox - tpt.z);
	 ya = (int) (oy - tpt.y);
	 break;
       case 2:
	 xa = (int) (ox + tpt.x);
	 ya = (int) (oy + tpt.z);
	 break;
       case 3: default:
	 xa = (int) (ox + tpt.x);
	 ya = (int) (oy - tpt.y);
	 break;
      }
      for (j=1; j<4; j++) {
	 applysaffine(&tpt, &pobj->rbb[bbox_seg[i][j]], &taf);
	 switch(dirn) {
	  case 1:
	    xb = (int) (ox - tpt.z);
	    yb = (int) (oy - tpt.y);
	    break;
	  case 2:
	    xb = (int) (ox + tpt.x);
	    yb = (int) (oy + tpt.z);
	    break;
	  case 3: default:
	    xb = (int) (ox + tpt.x);
	    yb = (int) (oy - tpt.y);
	    break;
	 }
	 XDrawLine(dpy, views[dirn].d, gcpx, xa, ya, xb, yb);
      }
   }
}


void pdrawboxc(Object *pobj, int dirn, float clip)
{
   int i, j;
   int xa, ya, xb, yb;
   float x, y, z;
   float ax, ay, az, bx, by, bz;
   float zf, mm;
   float ox, oy;
   Affine taf;
   Point tpt;

   ox = views[dirn].w/2.0;
   oy = views[dirn].h/2.0;

   mm = oy;
   x = mm*pobj->wt.rsh.x;
   y = mm*pobj->wt.rsh.y;
   z = mm*pobj->wt.rsh.z;
   clip *= mm;
   switch(dirn) {
    case 1:
      ox -= z;
      oy -= y;
      clip -= x;
      break;
    case 2:
      ox += x;
      oy += z;
      clip -= y;
      break;
    case 3: default:
      ox += x;
      oy -= y;
      clip -= z;
      break;
   }
#ifndef XSSUSEPM
   ox += views[dirn].x;
   oy += views[dirn].y;
#endif
   taf = pobj->wt;
   magsaffine(&taf, mm, mm, mm);

   for (i=0; i<4; i++) {
      applysaffine(&tpt, &pobj->rbb[bbox_seg[i][0]], &taf);
      switch(dirn) {
       case 1:
	 ax = - tpt.z;
	 ay = tpt.y;
	 az = tpt.x;
	 break;
       case 2:
	 ax = tpt.x;
	 ay = - tpt.z;
	 az = tpt.y;
	 break;
       case 3: default:
	 ax = tpt.x;
	 ay = tpt.y;
	 az = tpt.z;
	 break;
      }
      for (j=1; j<4; j++) {
	 applysaffine(&tpt, &pobj->rbb[bbox_seg[i][j]], &taf);
	 switch(dirn) {
	  case 1:
	    bx = - tpt.z;
	    by = tpt.y;
	    bz = tpt.x;
	    break;
	  case 2:
	    bx = tpt.x;
	    by = - tpt.z;
	    bz = tpt.y;
	    break;
	  case 3: default:
	    bx = tpt.x;
	    by = tpt.y;
	    bz = tpt.z;
	    break;
	 }
	 if (az < clip) {
	    if (bz < clip) {
	       continue;
	    } else {
	       zf = 1.0/(bz - az);
	       az -= clip;
	       bz -= clip;
	       xa = (int) (ox + (bz*ax - az*bx)*zf);
	       ya = (int) (oy - (bz*ay - az*by)*zf);
	       xb = (int) (ox + bx);
	       yb = (int) (oy - by);
	       az += clip;
	    }
	 } else {
	    if (bz < clip) {
	       zf = 1.0/(bz - az);
	       az -= clip;
	       bz -= clip;
	       xb = (int) (ox + (bz*ax - az*bx)*zf);
	       yb = (int) (oy - (bz*ay - az*by)*zf);
	       xa = (int) (ox + ax);
	       ya = (int) (oy - ay);
	       az += clip;
	    } else {
	       xa = (int) (ox + ax);
	       ya = (int) (oy - ay);
	       xb = (int) (ox + bx);
	       yb = (int) (oy - by);
	    }
	 }
	 XDrawLine(dpy, views[dirn].d, gcpx, xa, ya, xb, yb);
      }
   }
}


void drawbox(Object *pobj)
{
   int i, j;
   int xa, ya, xb, yb;
   float x, y, z;
   float zf, mm;
   float hh, os, ox, oy;
   float *lkup;
   Affine taf;
   Point tpt;

   ox = width/2.0;
   oy = height/2.0;
   mm = oy;
   x = mm*pobj->wt.rsh.x;
   y = mm*pobj->wt.rsh.y;
   z = mm*pobj->wt.rsh.z;
   os = OS - z;
   hh = -height - z;
   lkup = zplookup;
   lkup += (int) (ZMUL*(height+z));
   taf = pobj->wt;
   magsaffine(&taf, mm, mm, mm);

   for (i=0; i<4; i++) {
      applysaffine(&tpt, &pobj->rbb[bbox_seg[i][0]], &taf);
      zf = tpt.z;
      if (zf > os || zf < hh) continue;
      zf = *(lkup+(int)(ZMUL*zf));
      xa = (int) (ox + (x + tpt.x)*zf);
      ya = (int) (oy - (y + tpt.y)*zf);
      for (j=1; j<4; j++) {
	 applysaffine(&tpt, &pobj->rbb[bbox_seg[i][j]], &taf);
	 zf = tpt.z;
	 if (zf > os || zf < hh) continue;
	 zf = *(lkup+(int)(ZMUL*zf));
	 xb = (int) (ox + (x + tpt.x)*zf);
	 yb = (int) (oy - (y + tpt.y)*zf);
	 XDrawLine(dpy, wmain.pix, gcpx, xa, ya, xb, yb);
      }
   }
}


void drawboxc(Object *pobj, float clip)
{
   int   i, j;
   int   xa, ya, xb, yb;
   float ax, ay, az, bx, by, bz;
   float zf, zff, mm;
   float x, y, z;
   float hh, os, ox, oy;
   float *lkup;
   Affine taf;
   Point tpt;

   ox = width/2.0;
   oy = height/2.0;
   mm = oy;
   x = mm*pobj->wt.rsh.x;
   y = mm*pobj->wt.rsh.y;
   z = mm*pobj->wt.rsh.z;
   lkup = zplookup;
   lkup += (int) (ZMUL*height);
   clip *= mm;

   os = OS - z;
   hh = -height - z;

   zff = *(lkup+(int)(ZMUL*clip));
   lkup += (int) (ZMUL*z);
   clip -= z;
   taf = pobj->wt;
   magsaffine(&taf, mm, mm, mm);

   for (i=0; i<4; i++) {
      applysaffine(&tpt, &pobj->rbb[bbox_seg[i][0]], &taf);
      ax = tpt.x;
      ay = tpt.y;
      az = tpt.z;
      for (j=1; j<4; j++) {
	 applysaffine(&tpt, &pobj->rbb[bbox_seg[i][j]], &taf);
	 bx = tpt.x;
	 by = tpt.y;
	 bz = tpt.z;
	 if (az < clip) {
	    if (bz < clip) {
	       continue;
	    } else {
	       az -= clip;
	       bz -= clip;
	       zf = 1.0/(bz - az);
	       xa = (int) (ox + (x + (bz*ax - az*bx)*zf)*zff);
	       ya = (int) (oy - (y + (bz*ay - az*by)*zf)*zff);
	       az += clip;
	       bz += clip;
	       if (bz > os || bz < hh) continue;
	       zf = *(lkup+(int)(ZMUL*bz));
	       xb = (int) (ox + (x + bx)*zf);
	       yb = (int) (oy - (y + by)*zf);
	    }
	 } else {
	    if (bz < clip) {
	       az -= clip;
	       bz -= clip;
	       zf = 1.0/(bz - az);
	       xb = (int) (ox + (x + (bz*ax - az*bx)*zf)*zff);
	       yb = (int) (oy - (y + (bz*ay - az*by)*zf)*zff);
	       az += clip;
	       if (az > os || az < hh) continue;
	       zf = *(lkup+(int)(ZMUL*az));
	       xa = (int) (ox + (x + ax)*zf);
	       ya = (int) (oy - (y + ay)*zf);
	    } else {
	       if (az > os || az < hh) continue;
	       zf = *(lkup+(int)(ZMUL*az));
	       xa = (int) (ox + (x + ax)*zf);
	       ya = (int) (oy - (y + ay)*zf);
	       if (bz > os || bz < hh) continue;
	       zf = *(lkup+(int)(ZMUL*bz));
	       xb = (int) (ox + (x + bx)*zf);
	       yb = (int) (oy - (y + by)*zf);
	    }
	 }
	 XDrawLine(dpy, wmain.pix, gcpx, xa, ya, xb, yb);
      }
   }
}


void pdrawobj(Object *pobj, int dirn)
{
   int i, nver;
   int xa, ya, xb, yb;
   float x, y, z;
   float mm;
   float ox, oy;
   Segment *tedge;
   Affine taf;
   Point tpt;

   void pdrawbox(Object *, int );

   if (pobj->bbox) {
      pdrawbox(pobj, dirn);
      return;
   }
   ox = views[dirn].w/2.0;
   oy = views[dirn].h/2.0;

   mm = oy;
   x = mm*pobj->wt.rsh.x;
   y = mm*pobj->wt.rsh.y;
   z = mm*pobj->wt.rsh.z;
   switch(dirn) {
    case 1:
      ox -= z;
      oy -= y;
      break;
    case 2:
      ox += x;
      oy += z;
      break;
    case 3: default:
      ox += x;
      oy -= y;
      break;
   }
#ifndef XSSUSEPM
   ox += views[dirn].x;
   oy += views[dirn].y;
#endif
   taf = pobj->wt;
   magsaffine(&taf, mm, mm, mm);

   nver = pobj->nlines;
   tedge = pobj->edge;
   for (i=0; i<nver; i++, tedge++) {
      switch(dirn) {
       case 1:
	 applysaffine(&tpt, &pobj->ri[tedge->f], &taf);
	 xa = (int) (ox - tpt.z);
	 ya = (int) (oy - tpt.y);
	 applysaffine(&tpt, &pobj->ri[tedge->t], &taf);
	 xb = (int) (ox - tpt.z);
	 yb = (int) (oy - tpt.y);
	 break;
       case 2:
	 applysaffine(&tpt, &pobj->ri[tedge->f], &taf);
	 xa = (int) (ox + tpt.x);
	 ya = (int) (oy + tpt.z);
	 applysaffine(&tpt, &pobj->ri[tedge->t], &taf);
	 xb = (int) (ox + tpt.x);
	 yb = (int) (oy + tpt.z);
	 break;
       case 3: default:
	 applysaffine(&tpt, &pobj->ri[tedge->f], &taf);
	 xa = (int) (ox + tpt.x);
	 ya = (int) (oy - tpt.y);
	 applysaffine(&tpt, &pobj->ri[tedge->t], &taf);
	 xb = (int) (ox + tpt.x);
	 yb = (int) (oy - tpt.y);
	 break;
      }
      XDrawLine(dpy, views[dirn].d, gcpx, xa, ya, xb, yb);
   }
}


void pdrawobjc(Object *pobj, int dirn, float clip)
{
   int i, nver;
   int xa, ya, xb, yb;
   float x, y, z;
   float ax, ay, az, bx, by, bz;
   float zf, mm;
   float ox, oy;
   Segment *tedge;
   Affine taf;
   Point tpt;

   void pdrawboxc(Object *, int , float );

   if (pobj->bbox) {
      pdrawboxc(pobj, dirn, clip);
      return;
   }

   ox = views[dirn].w/2.0;
   oy = views[dirn].h/2.0;

   mm = oy;
   x = mm*pobj->wt.rsh.x;
   y = mm*pobj->wt.rsh.y;
   z = mm*pobj->wt.rsh.z;
   clip *= mm;
   switch(dirn) {
    case 1:
      ox -= z;
      oy -= y;
      clip -= x;
      break;
    case 2:
      ox += x;
      oy += z;
      clip -= y;
      break;
    case 3: default:
      ox += x;
      oy -= y;
      clip -= z;
      break;
   }
#ifndef XSSUSEPM
   ox += views[dirn].x;
   oy += views[dirn].y;
#endif
   taf = pobj->wt;
   magsaffine(&taf, mm, mm, mm);

   nver = pobj->nlines;
   tedge = pobj->edge;
   for (i=0; i<nver; i++, tedge++) {
      switch(dirn) {
       case 1:
	 applysaffine(&tpt, &pobj->ri[tedge->f], &taf);
	 ax = - tpt.z;
	 ay = tpt.y;
	 az = tpt.x;
	 applysaffine(&tpt, &pobj->ri[tedge->t], &taf);
	 bx = - tpt.z;
	 by = tpt.y;
	 bz = tpt.x;
	 break;
       case 2:
	 applysaffine(&tpt, &pobj->ri[tedge->f], &taf);
	 ax = tpt.x;
	 ay = - tpt.z;
	 az = tpt.y;
	 applysaffine(&tpt, &pobj->ri[tedge->t], &taf);
	 bx = tpt.x;
	 by = - tpt.z;
	 bz = tpt.y;
	 break;
       case 3: default:
	 applysaffine(&tpt, &pobj->ri[tedge->f], &taf);
	 ax = tpt.x;
	 ay = tpt.y;
	 az = tpt.z;
	 applysaffine(&tpt, &pobj->ri[tedge->t], &taf);
	 bx = tpt.x;
	 by = tpt.y;
	 bz = tpt.z;
	 break;
      }
      if (az < clip) {
	 if (bz < clip) {
	    continue;
	 } else {
	    az -= clip;
	    bz -= clip;
	    zf = 1.0/(bz - az);
	    xa = (int) (ox + (bz*ax - az*bx)*zf);
	    ya = (int) (oy - (bz*ay - az*by)*zf);
	    xb = (int) (ox + bx);
	    yb = (int) (oy - by);
	 }
      } else {
	 if (bz < clip) {
	    az -= clip;
	    bz -= clip;
	    zf = 1.0/(bz - az);
	    xb = (int) (ox + (bz*ax - az*bx)*zf);
	    yb = (int) (oy - (bz*ay - az*by)*zf);
	    xa = (int) (ox + ax);
	    ya = (int) (oy - ay);
	 } else {
	    xa = (int) (ox + ax);
	    ya = (int) (oy - ay);
	    xb = (int) (ox + bx);
	    yb = (int) (oy - by);
	 }
      }
      XDrawLine(dpy, views[dirn].d, gcpx, xa, ya, xb, yb);
   }
}


void drawobj(Object *pobj)
{
   int i, nver;
   int xa, ya, xb, yb;
   float x, y, z;
   float zf, mm;
   float hh, os, ox, oy;
/*   XPoint points[20]; */
   Segment *tedge;
   float *lkup;
   Affine taf;
   Point tpt;

   /*
    * points are given in normalised coordinates,
    * we scale it all up relative to the centre of the window and
    * window height
    */

   void drawbox(Object *);

   if (pobj->bbox) {
      drawbox(pobj);
      return;
   }

   ox = width/2.0;
   oy = height/2.0;
   mm = oy;
   x = mm*pobj->wt.rsh.x;
   y = mm*pobj->wt.rsh.y;
   z = mm*pobj->wt.rsh.z;
   lkup = zplookup;
   lkup += (int) (ZMUL*(height+z));
   os = OS - z;
   hh = -height - z;

#if 1
   taf = pobj->wt;
   magsaffine(&taf, mm, mm, mm);

   nver = pobj->nlines;
   tedge = pobj->edge;
   for (i=0; i<nver; i++, tedge++) {
      applysaffine(&tpt, &pobj->ri[tedge->f], &taf);
      zf = tpt.z;
      if (zf > os || zf < hh) continue;
      zf = *(lkup+(int)(ZMUL*zf));
      xa = (int) (ox + (x + tpt.x)*zf);
      ya = (int) (oy - (y + tpt.y)*zf);
      applysaffine(&tpt, &pobj->ri[tedge->t], &taf);
      zf = tpt.z;
      if (zf > os || zf < hh) continue;
      zf = *(lkup+(int)(ZMUL*zf));
      xb = (int) (ox + (x + tpt.x)*zf);
      yb = (int) (oy - (y + tpt.y)*zf);
      XDrawLine(dpy, wmain.pix, gcpx, xa, ya, xb, yb);
   }
#else
   i=0;
   do {
      nver = pobj->polygon[i++];
      for(j=0; j<nver; j++) {
         pnb = pobj->polygon[i++];
	 zf = vd / (vdos - zm*pobj->rn[pnb].z);
         xb = ox + (x + xm*pobj->rn[pnb].x)*zf;
         yb = oy - (y + ym*pobj->rn[pnb].y)*zf;
	 points[j].x = xb;
	 points[j].y = yb;
      }
      points[j].x = points[0].x ;
      points[j].y = points[0].y ;
      j++;
      XDrawLines(dpy, wmain.pix, gcpx, points, j, CoordModeOrigin);
   } while (i<pobj->nindex);
#endif
}


void drawobjc(Object *pobj, float clip)
{
   int   i, nver;
   int   xa, ya, xb, yb;
   float ax, ay, az, bx, by, bz;
   float zf, zff, mm;
   float x, y, z;
   float hh, os, ox, oy;
   float *lkup;
   Segment *tedge;
   Affine taf;
   Point tpt;

   void drawboxc(Object *, float );

   if (pobj->bbox) {
      drawboxc(pobj, clip);
      return;
   }

   ox = width/2.0;
   oy = height/2.0;
   mm = oy;
   x = mm*pobj->wt.rsh.x;
   y = mm*pobj->wt.rsh.y;
   z = mm*pobj->wt.rsh.z;
   lkup = zplookup;
   lkup += (int) (ZMUL*height);
   clip *= mm;

   os = OS - z;
   hh = -height - z;

   zff = *(lkup+(int)(ZMUL*clip));
   lkup += (int) (ZMUL*z);
   clip -= z;
#if 1
   taf = pobj->wt;
   magsaffine(&taf, mm, mm, mm);

   nver = pobj->nlines;
   tedge = pobj->edge;
   for (i=0; i<nver; i++, tedge++) {
      applysaffine(&tpt, &pobj->ri[tedge->f], &taf);
      ax = tpt.x;
      ay = tpt.y;
      az = tpt.z;
      applysaffine(&tpt, &pobj->ri[tedge->t], &taf);
      bx = tpt.x;
      by = tpt.y;
      bz = tpt.z;
      if (az < clip) {
	 if (bz < clip) {
	    continue;
	 } else {
	    az -= clip;
	    bz -= clip;
	    zf = 1.0/(bz - az);
	    xa = (int) (ox + (x + (bz*ax - az*bx)*zf)*zff);
	    ya = (int) (oy - (y + (bz*ay - az*by)*zf)*zff);
	    bz += clip;
	    if (bz > os || bz < hh) continue;
	    zf = *(lkup+(int)(ZMUL*bz));
	    xb = (int) (ox + (x + bx)*zf);
	    yb = (int) (oy - (y + by)*zf);
	 }
      } else {
	 if (bz < clip) {
	    az -= clip;
	    bz -= clip;
	    zf = 1.0/(bz - az);
	    xb = (int) (ox + (x + (bz*ax - az*bx)*zf)*zff);
	    yb = (int) (oy - (y + (bz*ay - az*by)*zf)*zff);
	    az += clip;
	    if (az > os || az < hh) continue;
	    zf = *(lkup+(int)(ZMUL*az));
	    xa = (int) (ox + (x + ax)*zf);
	    ya = (int) (oy - (y + ay)*zf);
	 } else {
	    if (az > os || az < hh) continue;
	    zf = *(lkup+(int)(ZMUL*az));
	    xa = (int) (ox + (x + ax)*zf);
	    ya = (int) (oy - (y + ay)*zf);
	    if (bz > os || bz < hh) continue;
	    zf = *(lkup+(int)(ZMUL*bz));
	    xb = (int) (ox + (x + bx)*zf);
	    yb = (int) (oy - (y + by)*zf);
	 }
      }
      XDrawLine(dpy, wmain.pix, gcpx, xa, ya, xb, yb);
   }
#else
   i=0;
   do {
      nver = pobj->polygon[i++];
      pna = pobj->polygon[i+nver-1];
      ax = pobj->rn[pna].x;
      ay = pobj->rn[pna].y;
      az = pobj->rn[pna].z;
      for(j=0; j<nver; j++) {
         pnb = pobj->polygon[i++];
         bx = pobj->rn[pnb].x;
         by = pobj->rn[pnb].y;
         bz = pobj->rn[pnb].z;
         if (az < 0.0) {
            if (bz < 0.0) {
               ax = bx;
               ay = by;
               az = bz;
               continue;
            } else  {
               zf = 1.0/(bz - az);
               xa = ox + (x + xm*(bz*ax - az*bx)*zf)*zff;
               ya = oy - (y + ym*(bz*ay - az*by)*zf)*zff; 
	       zf = vd / (vdos - zm*bz);
               xb = ox + (x + xm*bx)*zf;
               yb = oy - (y + ym*by)*zf;
            }
         } else {
            if (bz < 0.0) {
               zf = 1.0/(az - bz);
               xb = ox + (x + xm*(az*bx - bz*ax)*zf)*zff; 
               yb = oy - (y + ym*(az*by - bz*ay)*zf)*zff; 
	       zf = vd / (vdos - zm*az);
               xa = ox + (x + xm*ax)*zf;
               ya = oy - (y + ym*ay)*zf;
            } else {
	       zf = vd / (vdos - zm*az);
               xa = ox + (x + xm*ax)*zf;
               ya = oy - (y + ym*ay)*zf;
	       zf = vd / (vdos - zm*bz);
               xb = ox + (x + xm*bx)*zf;
               yb = oy - (y + ym*by)*zf;
            }
         }
         XDrawLine(dpy, wmain.pix, gcpx, xa, ya, xb, yb);
         ax = bx;
         ay = by;
         az = bz;
      }
   } while (i<pobj->nindex);
#endif
}
