static char rcsid[] = "@(#)$Id: xmisc.c,v 2.6 1994/11/18 04:03:14 peter Exp $";
/*
 * xmisc.c - miscellaneous routines for a popup dialogue box.

 * Copyright 1994, 16th November.
 * By Peter Chang
 * peterc@v2.ph.man.ac.uk

 * See notice in misc.h for details of permissions and warranty of this
 * software.

 *
 * $Log: xmisc.c,v $
 * Revision 2.6  1994/11/18  04:03:14  peter
 * xpgs-2.5-patch 01: Changes in header files for clean compile
 *
 * Revision 2.5.1.1  1994/11/17  03:34:19  peter
 * Import of actual public release of xpgs-2.5: lots of cosmetic changes to docs
 *
 * Revision 2.5  1994/11/16  09:19:35  peter
 * Putting xpgs-2.5 in trunk.
 *
 * Revision 2.0.1.1  1994/11/16  09:10:28  peter
 * Import of xpgs-2.5: archive of new release to alt.sources (11/94)
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h> /* included by Xos.h, apparently */

#ifdef VMS
#include <DecW$Include/Xlib.h>
/* #include <DecW$Include/Xos.h> */
#include <DecW$Include/Xutil.h>
#include <DecW$Include/keysym.h>
#else
#include <X11/Xlib.h>
/* #include <X11/Xos.h> */
#include <X11/Xutil.h>
#include <X11/keysym.h>
#endif

#include "xmisc.h"

#if __GNUC__ == 2
USE(rcsid);
#endif

/* all to do with the popup dialog */
#define EF_LEN 50
char dstring[LLEN];
static char estring[LLEN];
static int dstring_len = 0, estring_len = 0;
static int char_w = 0,  win_pos = 0;

#ifdef DIALOG_TEST
Display *dpy;
XFontStruct *font_info = NULL;

GC gcpx, gcpxor;
#endif

Xss_w wpop = { None, None, 200, 50, 0, 0 };

Xss_d dlg[] = { { None, 0, 0, 0, 0 },  /* Label */
                { None, 0, 0, 0, 0 },  /* Entry 1 */
                { None, 0, 0, 0, 0 },  /* Ok */
                { None, 0, 0, 0, 0 },  /* Clear */
                { None, 0, 0, 0, 0 }   /* Cancel */
};

#ifdef DIALOG_TEST
int main(int argc, char *argv[])
{
   int j;

   initpopup(None, 0, 0);
   if (argc > 1) strncpy(dstring, argv[1], LLEN-1);
   j = popupquery("Hello world");
   if (j > 0) printf("received string |%s| %d\n", dstring, j);
   else printf("cancelled\n");

   j = popupquery("Hello again");
   if (j > 0) printf("received string |%s| %d\n", dstring, j);
   else printf("cancelled\n");

   return 1;
}
#endif

void initpopup(Window root, int fg, int bg)
{
   XSizeHints hint;
   XWMHints wmhint;

   int font_h;
   int j;

#ifdef DIALOG_TEST
   int screen;

   dpy = XOpenDisplay(NULL);

   screen = DefaultScreen(dpy);
   root = RootWindow(dpy, screen);

   bg = BlackPixel(dpy, screen);
   fg = WhitePixel(dpy, screen);

   DIEIF((font_info = XLoadQueryFont(dpy, "fixed")) == NULL,
	 "Couldn't open any fonts\n");
#endif
   font_h = font_info->ascent + font_info->descent;

   char_w = XTextWidth(font_info, " ", 1);

   dlg[0].w = char_w * EF_LEN;
   dlg[0].h = font_h;
   dlg[1].w = dlg[0].w + char_w + 4;
   dlg[1].h = font_h + 4;
   dlg[2].w = XTextWidth(font_info, "OK", 2) + 4;
   dlg[2].h = font_h + 4;
   dlg[3].w = XTextWidth(font_info, "Clear", 5) + 4;
   dlg[3].h = font_h + 4;
   dlg[4].w = XTextWidth(font_info, "Cancel", 6) + 4;
   dlg[4].h = font_h + 4;

   dlg[0].x = 5;
   dlg[0].y = 5;
   dlg[1].x = 5;
   dlg[1].y = dlg[0].h + dlg[0].y + 5;
   dlg[2].x = 5;
   dlg[2].y = dlg[1].h + dlg[1].y + 5;
   dlg[3].x = dlg[2].w + dlg[2].x + 15;
   dlg[3].y = dlg[2].y;
   dlg[4].x = dlg[3].w + dlg[3].x + 15;
   dlg[4].y = dlg[2].y;
   
   wpop.w = dlg[1].w + 10;
   wpop.h = dlg[0].h + dlg[1].h + dlg[2].h + 20;
   wpop.win = XCreateSimpleWindow(dpy, root, wpop.x, wpop.y,
				    wpop.w, wpop.h, 0, fg, bg);
   for (j=1; j<5; j++) {
      dlg[j].d = XCreateSimpleWindow(dpy, wpop.win, dlg[j].x, dlg[j].y,
				     dlg[j].w, dlg[j].h, 1, fg, bg);
      DIEIF(dlg[j].d == None, "Could not create control window\n");
      XSelectInput(dpy, dlg[j].d, NoEventMask);
   }

   /* tell the window manager */
   hint.flags = PSize | PPosition;
   hint.width = wpop.w;
   hint.height = wpop.h;
   wmhint.input = True;
   wmhint.flags = InputHint;
   XSetStandardProperties(dpy, wpop.win, "Xss Popup", "xss popup", None,
			   NULL, 0, &hint);
   XSetWMHints(dpy, wpop.win, &wmhint);

   XSelectInput(dpy, wpop.win, ButtonPressMask | ButtonReleaseMask |
		OwnerGrabButtonMask | ExposureMask |
		KeyPressMask | KeyReleaseMask);
   XMapSubwindows(dpy, wpop.win);

#ifdef DIALOG_TEST
   gcpx = XCreateGC(dpy, wpop.win, 0, NULL);
   XSetForeground(dpy, gcpx, fg);
   XSetBackground(dpy, gcpx, bg);
   XSetFont(dpy, gcpx, font_info->fid);
   XSetClipMask(dpy, gcpx, None);
   XSetGraphicsExposures(dpy, gcpx, False);
   XSetLineAttributes(dpy, gcpx, 0, LineSolid, CapButt, JoinRound);
   XSetSubwindowMode(dpy, gcpx, ClipByChildren);
   
   gcpxor = XCreateGC(dpy, wpop.win, 0, NULL);
   XCopyGC(dpy, gcpx, ~0L, gcpxor);
   XSetForeground(dpy, gcpxor, fg^bg);
   XSetFunction(dpy, gcpxor, GXxor);
   XSynchronize(dpy, 1); /* for debug X stuff */
#endif
}


void destroypopup(void)
{
   int j;

   for (j=1; j<5; j++) XDestroyWindow(dpy, dlg[j].d);
   XDestroyWindow(dpy, wpop.win);
}


static void drawpopef(void)
{
   int real_pos = 2;
   char *sptr;
   int slen;
   int blen;


   blen = dstring_len - EF_LEN;
   if (blen > win_pos) win_pos = blen;
   sptr = dstring + win_pos;
   slen = dstring_len - win_pos;

   /* draw the start of string */
   if (slen > 0) {
      XDrawImageString(dpy, dlg[1].d, gcpx, real_pos,
		       2 + font_info->ascent, sptr, slen);
      real_pos += XTextWidth(font_info, sptr, slen);
   }
   if (estring_len > 0) {
      slen += estring_len - EF_LEN;
      blen = (slen > 0) ? slen : 0;
      slen = estring_len - blen;
      /* draw the rest of string */
      if (slen > 0) {
	 XDrawImageString(dpy, dlg[1].d, gcpx, real_pos,
			  2 + font_info->ascent, estring, slen);
	 /* draw the cursor */
	 XFillRectangle(dpy, dlg[1].d, gcpxor, real_pos,
			2, char_w, dlg[1].h - 4);
	 real_pos += XTextWidth(font_info, estring, slen);
      }
   } else {
      /* draw the cursor */
      XFillRectangle(dpy, dlg[1].d, gcpx, real_pos, 2, char_w, dlg[1].h - 4);
      real_pos += char_w;
   }
   /* blank the rest of the window */
   XClearArea(dpy, dlg[1].d, real_pos, 2, dlg[1].w - real_pos,
	      dlg[1].h - 4, False);
}


static void drawpopup(char *label)
{
   /* paint label, ok, clear & cancel buttons */
   XDrawString(dpy, wpop.win, gcpx, dlg[0].x, dlg[0].y+font_info->ascent,
	       label, strlen(label));
   XDrawString(dpy, dlg[2].d, gcpx, 2, font_info->ascent + 2,
	       "OK", 2);
   XDrawString(dpy, dlg[3].d, gcpx, 2, font_info->ascent + 2,
	       "Clear", 5);
   XDrawString(dpy, dlg[4].d, gcpx, 2, font_info->ascent + 2,
	       "Cancel", 6);

   drawpopef();
}


/* move cursor to mouse position, similar structure to drawpopef() */
static void movecursor(int x)
{
   int real_pos = 2;
   char *sptr;
   int slen;
   int blen;
   int mouse;
   char tstring[LLEN];

   blen = dstring_len - EF_LEN;
   if (blen > win_pos) win_pos = blen;
   sptr = dstring + win_pos;
   strcpy(tstring, sptr);
   strcat(tstring, estring);
   slen = dstring_len - win_pos;
   sptr = tstring + slen;
   slen += estring_len - EF_LEN;
   blen = (slen > 0) ? slen : 0;
   slen = estring_len - blen;
   sptr += slen;
   *sptr = '\0';
   sptr = tstring;
   mouse = win_pos;
   while (*sptr != '\0') {
      real_pos += XTextWidth(font_info, sptr, 1);
      if (x < real_pos) break;
      mouse++;
      sptr++;
   }
   if (*sptr != '\0') {
      strcpy(tstring, dstring);
      strcat(tstring, estring);
      estring_len += dstring_len;
      dstring_len = mouse;
      estring_len -= mouse;
      strncpy(dstring, tstring, mouse);
      dstring[mouse] = '\0';
      strcpy(estring, tstring+mouse);
   } else {
      strcpy(tstring, dstring);
      strcat(tstring, estring);
      dstring_len += estring_len;
      estring_len = 0;
      strcpy(dstring, tstring);
      estring[0] = '\0';      
   }
   drawpopef();
}


/*
 * Process a keypress in the dialogue entry field.  Return a value of 1
 * if we're finished typing text, 0 otherwise.
 * There are several special keys defined:
 *     Left & Right cursor keys    moves cursor
 *     ^a ^b ^f ^e                 moves cursor, emacs style
 *     Backspace, Delete & Ctrl-h  deletes character
 *     Enter, Linefeed & KP_Enter  finishes input
 *     Escape                      cancels input
 *     ^d                          deletes character under cursor
 *     ^u                          deletes to beginning of line
 *     ^c                          clears input field
 */
int handlepopkey(XKeyEvent *kev)
{
   char buf[10];
   char tstring[LLEN];
   KeySym ks;
   int blen;

/*   buf[0] = '\0'; */
   blen = XLookupString(kev, buf, 9, &ks, NULL);
   if ((kev->state & ControlMask)) {
      switch (ks) {
       case XK_b: case XK_B:
	 ks = XK_Left;
	 break;
       case XK_f: case XK_F:
	 ks = XK_Right;
	 break;
       case XK_a: case XK_A:
	 ks = XK_Begin;
	 break;
       case XK_e: case XK_E:
	 ks = XK_End;
	 break;
       case XK_h: case XK_H:
	 ks = XK_Delete;
	 break;
       case XK_u: case XK_U:
	 dstring[0] = '\0';
	 dstring_len = 0;
	 win_pos = 0;
	 drawpopef();
/*	 XFlush(dpy); */
	 return 0;
       case XK_c: case XK_C:
	 dstring[0] = '\0';
	 estring[0] = '\0';
	 dstring_len = 0;
	 estring_len = 0;
	 win_pos = 0;
	 drawpopef();
/*	 XFlush(dpy); */
	 return 0;
       case XK_d: case XK_D:
	 if (estring_len > 0) {
	    strcpy(tstring, estring);
	    strcpy(estring, tstring+1);
	    estring_len--;
	    drawpopef();
/*	    XFlush(dpy); */
	 } else
	    XBell(dpy, 100);
	 return 0;
       default:
	 XBell(dpy, 100);
	 return 0;
      }
   }
   switch (ks) {
    case XK_Return: case XK_Linefeed: case XK_KP_Enter:
      strcat(dstring, estring);
      return 1;
    case XK_Escape:
      dstring[0] = '\0';
      estring[0] = '\0';
      dstring_len = 0;
      estring_len = 0;
      win_pos = 0;
      return 1;
    case XK_Left:
      if (estring_len < LLEN) {
	 if (dstring_len > 0) {
	    dstring_len--;
	    tstring[0] = dstring[dstring_len];
	    tstring[1] = '\0';
	    strcat(tstring, estring);
	    strcpy(estring, tstring);
	    estring_len++;
	    dstring[dstring_len] = '\0';
	    if (dstring_len < win_pos) win_pos--;
	 }
      }
      break;
    case XK_Right:
      if (estring_len > 0) {
	 if (dstring_len < LLEN) {
	    strcpy(tstring, estring);
	    dstring[dstring_len] = tstring[0];
	    dstring_len++;
	    strcpy(estring, tstring+1);
	    estring_len--;
	    dstring[dstring_len] = '\0';
	 }
      }
      break;
    case XK_Home: case XK_Begin:
      if (dstring_len > 0) {
	 strcpy(tstring, dstring);
	 strcat(tstring, estring);
	 strcpy(estring, tstring);
	 dstring[0] = '\0';
	 estring_len += dstring_len;
	 dstring_len = 0;
	 win_pos = 0;
      }
      break;
    case XK_End:
      if (estring_len > 0) {
	 strcpy(tstring, dstring);
	 strcat(tstring, estring);
	 strcpy(dstring, tstring);
	 estring[0] = '\0';
	 dstring_len += estring_len;
	 estring_len = 0;
	 win_pos = 0;
      }
      break;
    case XK_BackSpace: case XK_Delete:
      if (dstring_len > 0) {
	 dstring_len--;
	 dstring[dstring_len] = '\0';
	 if (dstring_len < win_pos) win_pos--;
      } else
      	 XBell(dpy, 100);
      break;
    default:
      if ((ks >= XK_KP_Multiply && ks <= XK_KP_9) ||
	  (ks >= XK_space && ks <= XK_asciitilde)) {
	 if ((dstring_len + estring_len + blen) < LLEN) {
	    strncat(dstring, buf, blen);
/* printf("typed |%s| (%d)\n", buf, blen); */
	    dstring_len += blen;
	 } else {
	    XBell(dpy, 100);
	 }
      }
      break;
   }

   drawpopef();
/*   XFlush(dpy); */

   return 0;
}


/* 
 * Pop up the dialog box, and process events until Return is pressed,
 * the OK or Cancel button is clicked.
 * Then pop down the dialog box and return the length of string.
 */

int popupquery(char *label)
{
   int finished = 0;
   XEvent xev;
   Window r_ret, w_ret, wtemp;
   int dx, dy, winx, winy;
   usint mask_ret;
   int j;
   int ob = 0;

   if (dstring[0] == '\0') {
      dstring_len = 0;
   } else {
      dstring_len = strlen(dstring);
   }
   win_pos = 0;
   estring[0] = '\0';
   estring_len = 0;

   /* erase the old label */
   XClearArea(dpy, wpop.win, dlg[0].x, dlg[0].y, dlg[0].w, dlg[0].h, False);

   /* move the dialog window to under the pointer */
   if (!XQueryPointer(dpy, wpop.win, &r_ret, &w_ret, &dx, &dy,
		      &winx, &winy, &mask_ret)) {
      dx = 0; dy = 0;
   } else {
      dx -= wpop.w / 2; dy -= wpop.h / 2;
   }
   if (dx < 0) dx = 0;
   if (dy < 0) dy = 0;
   XMoveWindow(dpy, wpop.win, dx, dy);
   
   XMapRaised(dpy, wpop.win);

   while (finished == 0) {
      XNextEvent(dpy, &xev);
      switch(xev.type) {
       case Expose:
	 wtemp = xev.xexpose.window;
	 while (XCheckTypedWindowEvent(dpy, wtemp, Expose, &xev));
	 if (wtemp == wpop.win) drawpopup(label);
#ifndef DIALOG_TEST
	 else handleexpose(wtemp);
#endif
	 break;
       case ButtonPress:
	 if (xev.xbutton.window == wpop.win) {
	    for (j=1; j<5; j++) {
	       if (dlg[j].d == xev.xbutton.subwindow) break;
	    }
	    if (j > 1 && j < 5) {
	       XFillRectangle(dpy, dlg[j].d, gcpxor, 0, 0,
			      dlg[j].w, dlg[j].h);
	       ob = j;
	    }
	    XFlush(dpy);
	 }
	 break;
       case ButtonRelease:
	 if (xev.xbutton.window == wpop.win) {
	    for (j=1; j<5; j++) {
	       if (dlg[j].d == xev.xbutton.subwindow) break;
	    }
	    if (j == 1) {
	       movecursor(xev.xbutton.x-dlg[1].x);
	    } else if (j < 5 && j == ob) {
	       switch(j) {
		case 2: /* ok */
		  strcat(dstring, estring);
		  finished = 1;
		  break;
		case 3: /* clear */
		  dstring[0] = '\0';
		  estring[0] = '\0';
		  dstring_len = 0;
		  estring_len = 0;
		  win_pos = 0;
		  drawpopef();
		  break;
		case 4: /* cancel */
		  dstring[0] = '\0';
		  estring[0] = '\0';
		  dstring_len = 0;
		  estring_len = 0;
		  win_pos = 0;
		  finished = -1;
		  break;
		default:
		  break;
	       }
	    }
	    if (ob > 0) {
	       XFillRectangle(dpy, dlg[ob].d, gcpxor, 0, 0,
			      dlg[ob].w, dlg[ob].h);
	    }
	    ob = 0;
	 }
	 break;
       case KeyPress:
	 if (xev.xkey.window == wpop.win) {
	    finished = handlepopkey(&xev.xkey);
	 }
	 break;
       default:	/* ignore any other events */
	 break;
					
      }
   }

   XUnmapWindow(dpy, wpop.win);
   XFlush(dpy); /* unpop immediately */

   if (finished > 0) {
      finished = dstring_len + estring_len;
/*      dstring[finished] = '\0'; */
      if (finished == 0) finished = -1;
   }
   return finished;
}
