static char rcsid[] = "@(#)$Id: xpgs.c,v 2.6.2.1 1995/01/26 04:43:36 peter Exp $";
/*
 * xpgs - a program to generate and output SIRDS of objects defined
 *        by convex polygon faces, the display is an X windows.

 * It animates the object rotating about a randomly-
 * chosen axis by making and storing frames of pixmaps.
 * Any frame can be saved in either XBitMap, PostScript
 * or our XSS format (as pure geometry data).

 * Copyright 1994 and 1995, 26th January.
 * By Peter Chang and Gareth Richards
 * peterc@a3.ph.man.ac.uk
 * gareth@h1.ph.man.ac.uk

 * See notice in misc.h for details of permissions and warranty of this
 * software.

 * 
 * $Log: xpgs.c,v $
 * Revision 2.6.2.1  1995/01/26  04:43:36  peter
 * Fixed bug in PS output with grey != 1.
 *
 * New reload fn implemented.
 *
 * Revision 2.6  1994/11/18  04:03:15  peter
 * xpgs-2.5-patch 01: Changes in header files for clean compile
 *
 * Revision 2.5.1.1  1994/11/17  03:34:20  peter
 * Import of actual public release of xpgs-2.5: lots of cosmetic changes to docs
 *
 * Revision 2.5  1994/11/16  09:19:37  peter
 * Putting xpgs-2.5 in trunk.
 *
 * Revision 2.0.1.1  1994/11/16  09:10:29  peter
 * Import of xpgs-2.5: archive of new release to alt.sources (11/94)
 *
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>

#ifdef VMS
#include <DecW$Include/Xlib.h>
/* #include <DecW$Include/Xos.h> */
#include <DecW$Include/Xutil.h>
#include <DecW$Include/keysym.h>
#include <lib$routines.h>
#else
#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
/* #include <sys/time.h> */
#endif

#include "icon.xbm"    /* icon bitmap */
#define SIRDS_STUFF
#include "pgs.h"
#include "polyh.h"
#include "psout.h"
#include "zbuffer.h"
#include "lookup.h"
#include "xmisc.h"

#if __GNUC__ == 2
USE(rcsid);
#endif

#define FNO 24      /* Frames */

static short fno = 1, shimmer = 0;
static long  delay = 300000L;
static float mag = 1.0; /* , zfactor = 1.0; */
static float alpha;

static char *dispname = NULL, *fontname = NULL, *geometry = NULL;

Object *shapes = NULL;
usint nobj = 0;
float theta = 0.0, phi = 0.0;

static Affine globalaf;

Display *dpy;
Pixmap iconmap;
XFontStruct *font_info = NULL;
int depth;

Xss_w wmain = { None, None, MW/2, MH/2, 0, 0 },
      whp = { None, None, 400, 400, 0, 0 };

GC gcpx, gcpxr, gcpxor;
static GC gcpxt, gcpxs, gcpxsr;

#ifdef XPGSUSEPM
static Pixmap pix[FNO];
#else
static Pixmap pix;
static XImage *image[FNO];
#endif

/*
 * these values give 144dpi;
 * for 300dpi use 3208x1983 = A4 (3000x1854 = letter) on command line
 */
static usint   pw = MW, ph = MH;

int   fineness = 0;
int   reverse = 1;
float background = -1.0;
float pmm;           /* pixel per mm */
float enlarge = 1.0;

int   density = 127, grey = 1, indicator = 1;
int   width, height;
int   buf_h = ZBLINES, buf_top, buf_bot;

static int frame;

int main(int argc, char **argv)
{
   int **ztopl = NULL, **ztopr = NULL; /* s-buffers */

   Window wtemp;
   XEvent report;
   KeySym keysym;
   char buf[3];

   int i, sep=0;
   XPoint points[3];

   float spmm;

   int pause, begin, help, input;
   int anim, fb, nxt;
   char name[NLEN], oname[NLEN];
   int sno = 1, load=0;

#ifndef VMS
   struct timeval wait;
#ifdef linux
   struct timeval twait;
#endif
#else
   float wait;
#endif

   void pcl(int, char **, char *);
   void quitxpgs(void);
   void initall(int , char *[]);
   void writeintro(int , char *);
   int drawsirds(int **, int **, int , int );
   void saveps(int **, int **, char [NLEN], int );

   pcl(argc, argv, name);

   printf("\nWelcome to xpgs\n");

   initall(argc, argv);
   spmm = pmm;

   srand(time(NULL));

   setbuf(stdout, NULL);

#ifndef XPGSUSEPM
   /* the array of pointers to images doesn't seem to be initialised
      on some machines */
   for (i=0; i<fno; i++) image[i] = NULL;
#endif
   pause = 1;
   frame = 0;
   fb = 1;
   begin = 1;
   help = 0;
   input = 1;
#ifndef VMS
   wait.tv_sec = delay / 1000000L;
   wait.tv_usec = delay % 1000000L;
   printf("wait interval %ld s %ld us\n", wait.tv_sec, wait.tv_usec);
#else
   wait = delay/1000000.0;
   printf("wait interval %f s\n", wait);
#endif

   while (1) {
      nxt = 1;
      do {
	 if (pause == 0) { /* if not paused then hold for a while */
#ifndef VMS
#ifdef linux
	    /* select on Linux modifies the timeout struct */
	    twait = wait;
	    select(0, NULL, NULL, NULL, &twait);
#else
	    select(0, 0, 0, 0, &wait);
#endif
#else
	    lib$wait(&wait);
#endif
	 }
         if (pause==1 || XEventsQueued(dpy, QueuedAfterReading)) {
	    XNextEvent(dpy, &report); /* only block if paused */
	    switch (report.type) {
	     case ButtonPress:
	       break;
	     case ButtonRelease:
	       if (report.xbutton.window == wmain.win ||
		   report.xbutton.window == whp.win) {
		  help = 1 - help;
		  if (help) XMapWindow(dpy, whp.win);
		  else XUnmapWindow(dpy, whp.win);
	       }
	       break;
	     case Expose:
	       wtemp = report.xexpose.window;
	       while (XCheckTypedWindowEvent(dpy, wtemp, Expose, &report));
	       handleexpose(wtemp);
	       break;
	     case KeyPress:
	       XLookupString(&report.xkey, buf, 3, &keysym, NULL);
	       switch (keysym) {
		case XK_a: case XK_A:
		  anim = 1;
		  phi   = (2.0*PI*rand())/RAND_MAX;
		  theta = (PI*rand())/RAND_MAX;
		  initaffine(&globalaf);
		  if (shimmer) {
		     rotaffine(&globalaf, theta, phi, alpha);
		  }
		  printf("axis changed\n");
		  break;
		case XK_h: case XK_H:
		  help = 1 - help;
		  if (help) XMapWindow(dpy, whp.win);
		  else XUnmapWindow(dpy, whp.win);
		  break;
		case XK_i: case XK_I:
		  anim = 1;
		  printf("initialised points\n");
		  break;
		case XK_p: case XK_P:
		  pause = 1 - pause;
		  (pause) ? printf("pause on\n") : printf("pause off\n");
		  break;
		case XK_q: case XK_Q:
		  quitxpgs();
		  zmemf(ztopl);
		  zmemf(ztopr);
		  exit(EXIT_SUCCESS);
		case XK_r: case XK_R:
		  fb *= -1;
		  (fb == -1) ? printf("backward\n") :
		  printf("forward\n");
		  break;
		default:
		  break;
	       }

	       if (pause) {
		  switch (keysym) {
		   case XK_l: case XK_L:
		     input = 1;
		     break;
		   case XK_o: case XK_O:
		     input = 2;
		     break;
		   case XK_n: case XK_N:
		     nxt = 0;
		     break;
		   case XK_s: case XK_S:
		     sprintf(dstring, "%s%d.ps", name, sno);
		     if (popupquery("Please enter PS file name") > 0) {
			strncpy(oname, dstring, NLEN-1);
			zmemf(ztopl);
			zmemf(ztopr);
			width = pw;
			height = ph;
			ztopl = zmema();
			ztopr = zmema();
			/* set pmm to that of 720pt or 770pt on paper */
#ifdef EUROPPR
			pmm = (width/770.0)*72.0/25.4;
#else
			pmm = (width/720.0)*72.0/25.4;
#endif
			lookup(reverse);
			saveps(ztopl, ztopr, oname, frame);
			pmm = spmm;     /* reset pmm to that of screen */
			width = wmain.w;
			height = wmain.h;
			XBell(dpy, 100);
			XFlush(dpy);
			printf("Postscript saved: %s\n", oname);
			sno++;
		     }
		     break;
		   case XK_c: case XK_C:
		     sprintf(dstring, "%s%d.xss", name, sno);
		     if (popupquery("Please enter XSS file name") > 0) {
			strncpy(oname, dstring, NLEN-1);
			dstring[0] = '\0';
			popupquery("Enter comment line");
			if (shimmer == 0) {
			   initaffine(&globalaf);
			   rotaffine(&globalaf, theta, phi, frame*alpha);
			   for (i=0; i<nobj; i++)
			      mulaffine(&shapes[i].wt, &globalaf);
			}
			savexss(oname, dstring);
			if (shimmer == 0) {
			   for (i=0; i<nobj; i++)
			      reinitobj(&shapes[i]);
			}
			XBell(dpy, 100);
			XFlush(dpy);
			printf("XSS saved: %s\n",oname);
			sno++;
		     }
		     break;
		   case XK_w: case XK_W:
		     sprintf(dstring, "%s%d.xbm", name, sno);
		     if (popupquery("Please enter XBM file name") > 0) {
			strncpy(oname, dstring, NLEN-1);
#ifdef XPGSUSEPM
			XWriteBitmapFile(dpy, oname, pix[frame],
					 wmain.w, wmain.h, -1, -1);
#else
			XWriteBitmapFile(dpy, oname, pix,
					 wmain.w, wmain.h, -1, -1);
#endif
			XBell(dpy, 100);
			XFlush(dpy);
			sno++;
			printf("Bitmap saved: %s\n",oname);
		     }
		     break;
		   default:
		     break;
		  }
	       }
	     default:
	       break;
	    } /* end of event loop */
	    if (input) {
	       if (begin == 0) {
		  switch (input) {
		   case 1: default:
		     dstring[0] = '\0';
input = popupquery("Please enter POLYH or XSS file name (w/o ext)");
		     if (input <= 0) break;
		     strncpy(name, dstring, NLEN-1);
		   case 2:
		     killallshapes();
		     writeintro(-1, name);
		     XFlush(dpy);
		     break;
		  }
	       }
	       if (input > 0) {
		  input = 0;
		  if ((load = loadshapes(name, 1)) < 0) {
		     fprintf(stderr, "ERROR: something wrong with %s\n", name);
		     quitxpgs();
		     zmemf(ztopl);
		     zmemf(ztopr);
		     exit(EXIT_FAILURE);
		  }
		  alpha = PI*2.0/fno;
		  initaffine(&globalaf);
		  if (shimmer) {
		     initaffine(&globalaf);
		     rotaffine(&globalaf, theta, phi, alpha);
		  }
		  begin = 0;
		  writeintro(load, name);
		  XFlush(dpy);
		  anim = 1;
	       }
	    }
	 }
	 if (anim) {
	    anim = 0;
	    zmemf(ztopl);
	    zmemf(ztopr);
	    width = wmain.w;
	    height = wmain.h;
	    ztopl = zmema();
	    ztopr = zmema();
	    lookup(reverse);
	    if (begin) {
	       begin = 0;
	       printf("No of pixels per millimetre: %f\n", pmm);
	       printf("\n ES: %f\n VD: %f\n OS: %f\n BG: %d\n OX: %d \t OY: %d \n",
		      ES, VD, OS, sep, OX, OY);
	    }
	    printf("\nProcessing frames:\n  ");
	    
	    for(i=0;i<fno;i++) {
	       printf(" %d", i);
#ifdef XPGSUSEPM
	       XFillRectangle(dpy, pix[i], gcpxsr, 0, 0, wmain.w, wmain.h);
#else
	       XFillRectangle(dpy, pix, gcpxsr, 0, 0, wmain.w, wmain.h);
#endif
	       sep = drawsirds(ztopl, ztopr, i, 0);
	       if (indicator) {
		  points[1].x = (width+sep)*0.5;
		  points[0].x = points[1].x+5;
		  points[2].x = points[1].x-5;
		  points[0].y = 0;
		  points[1].y = 10;
		  points[2].y = 0;
#ifdef XPGSUSEPM
		  XFillPolygon(dpy, pix[i], gcpxs, points, 3,
			       Convex, CoordModeOrigin);
#else
		  XFillPolygon(dpy, pix, gcpxs, points, 3,
			       Convex, CoordModeOrigin);
#endif
		  points[1].x = (width-sep)*0.5;
		  points[0].x = points[1].x+5;
		  points[2].x = points[1].x-5;
#ifdef XPGSUSEPM
		  XFillPolygon(dpy, pix[i], gcpxs, points, 3,
			       Convex, CoordModeOrigin);
#else
		  XFillPolygon(dpy, pix, gcpxs, points, 3,
			       Convex, CoordModeOrigin);
#endif
	       }
#ifdef XPGSUSEPM
	       XCopyPlane(dpy, pix[i], wmain.win, gcpxt, 0, 0,
			  wmain.w, wmain.h, 0, 0, 1);
#else
	       if (image[i] != NULL) XDestroyImage(image[i]);
	       image[i] = XGetImage(dpy, pix, 0, 0, wmain.w, wmain.h,
				    AllPlanes, XYPixmap);
	       XCopyPlane(dpy, pix, wmain.win, gcpxt, 0, 0,
			  wmain.w, wmain.h, 0, 0, 1);
#endif
	       XFlush(dpy);
	    }
	    printf("\nAll done, press p to start animation.\n");
	 }  /* end of anim */
      } while (pause && nxt);

      frame += fb;
      if (frame > fno-1) frame = 0;
      if (frame < 0) frame = fno-1;
#ifdef XPGSUSEPM
      XCopyPlane(dpy, pix[frame], wmain.win, gcpxt, 0, 0,
		 wmain.w, wmain.h, 0, 0, 1);
#else
      XPutImage(dpy, pix, gcpxs, image[frame], 0, 0, 0, 0, wmain.w, wmain.h);
      XCopyPlane(dpy, pix, wmain.win, gcpxt, 0, 0, wmain.w, wmain.h, 0, 0, 1);
#endif
      XFlush(dpy);
   }
}


/*
 * draw SIRDS
 */
int drawsirds(int **zbufl, int **zbufr, int f, int mode)
{
   int *zll, *zlr;
   uschar *pixarray;
   Llist *same;

   int x, y, pixpos, sep = 0;
   uschar colour;

   void sirdsnew(int *, int *, Llist *);
   void drawline(int , uschar *, int );
   void drawpsline(uschar *);

   DIEIF((same = (Llist *) malloc(width*sizeof(Llist))) == NULL,
	 "Unable to allocate memory for array\n");
   DIEIF((pixarray = (uschar *) malloc(width*sizeof(char))) == NULL,
	 "Unable to allocate memory for array\n");

   if (shimmer == 0) {
      if (mode > 0) {
	 initaffine(&globalaf);
	 rotaffine(&globalaf, theta, phi, f*alpha);
      } else {
	 rotaffine(&globalaf, theta, phi, alpha);
      }
   }

   buf_bot = 0;
   for (y=0;y<height;y++) {
      if (y == buf_bot) sep = sfillall(y, zbufl, zbufr, mag, &globalaf);

      zll = zbufl[y%buf_h];
      zlr = zbufr[y%buf_h];
      for (x=0;x<width;x++) {
	 same[x].t = x;
	 same[x].f = x;
      }
      sirdsnew(zll, zlr, same);
      if (mode > 0) {
	 for (x=0; x<width; x++) {
	    pixpos = same[x].f;
	    if (pixpos != x) {
	       colour = pixarray[pixpos];
	    } else {
	       colour = (uschar) (MYRAND & 0xff);
	       colour = (uschar) ((colour > density) ? 0xff : (MYRAND & 0xff));
	    }
	    pixarray[x] = colour;
	 }
	 drawpsline(pixarray);
      } else {
	 for (x=0; x<width; x++) {
	    pixpos = same[x].f;
	    colour = (pixpos != x) ? pixarray[pixpos] :
	             (uschar) (((MYRAND & 0xff) > density) ? 1 : 0);
	    pixarray[x] = colour;
	 }
	 drawline(f, pixarray, y);
      }
   }
   free(pixarray);
   free(same);
   return sep;
}


void drawline(int f, uschar *pixline, int y)
{
   int x;

   for (x=0; x<width; x++) {
#ifdef XPGSUSEPM
      if (pixline[x]==1) XDrawPoint(dpy, pix[f], gcpxs, x, y);
#else
      if (pixline[x]==1) XDrawPoint(dpy, pix, gcpxs, x, y);
#endif
   }
}


void initall(int argc, char *argv[])
{
   XSizeHints hint;
   XWMHints wmhint;
   Window root;
   uslong fg, bg;
   usint sw, sh;
   int screen;
   int i;
   int gflags = 0;

   void writehelp(void);

   dpy = XOpenDisplay(dispname);
   if (!dpy) {
      fprintf(stderr, "Could't open display: ");
      if (dispname == NULL)
#ifdef VMS
         fprintf(stderr, "%s\n", getenv("DECW$DISPLAY"));
#else
         fprintf(stderr, "%s\n", getenv("DISPLAY"));
#endif
      else
         fprintf(stderr, "%s\n", dispname);
      exit(EXIT_FAILURE);
   }

   screen = DefaultScreen(dpy);
   root = RootWindow(dpy, screen);

   sw = wmain.w;
   sh = wmain.h;
   if (geometry != NULL)
      gflags = XParseGeometry(geometry, &hint.x, &hint.y, &sw, &sh);
   wmain.w = sw;
   wmain.h = sh;

   bg = BlackPixel(dpy, screen);
   fg = WhitePixel(dpy, screen);
   pmm = ((float) DisplayWidth(dpy, screen)) 
              / DisplayWidthMM(dpy, screen);
   depth = DefaultDepth(dpy, screen);

   width = wmain.w;
   height = wmain.h;
   printf("No of pixels per millimetre: %f\n", pmm);
   printf("\n VD: %f OS: %f\n OX: %d \t OY: %d \n", VD, OS, OX, OY);

   if (fontname != NULL) font_info = XLoadQueryFont(dpy, fontname);

   if (font_info == NULL) {
      fprintf(stderr, "Trying to use fixed font.\n");
      DIEIF((font_info = XLoadQueryFont(dpy, "fixed")) == NULL,
	    "Couldn't open any fonts\n");
   }
#ifdef MYDEBUG
   XSynchronize(dpy, 1); /* for debug X stuff */
#endif

   hint.width = wmain.w; hint.height = wmain.h;
   hint.flags = PSize;
   if (gflags & (WidthValue | HeightValue)) {
      hint.flags |= USSize;
   }
   if (gflags & XValue) {
      if (gflags & XNegative) {
	 hint.x += DisplayWidth(dpy, screen) - hint.width;
      }
      hint.flags |= USPosition;
   }
   if (gflags & YValue) {
      if (gflags & YNegative) {
	 hint.y += DisplayHeight(dpy, screen) - hint.height;
      }
      hint.flags |= USPosition;
   }
   wmain.x = hint.x; wmain.y = hint.y;
   wmain.win = XCreateSimpleWindow(dpy, root,
         wmain.x, wmain.y, wmain.w, wmain.h, 5, fg, bg);
   DIEIF(wmain.win == None, "Could not create main window\n");
   iconmap = XCreateBitmapFromData(dpy, wmain.win, (char *)pgs_bits,
                                   pgs_width, pgs_height);
   wmhint.input = True;
   wmhint.flags = InputHint;
   wmhint.icon_pixmap = iconmap;
   XSetWMHints(dpy, wmain.win, &wmhint);
   XSetStandardProperties (dpy, wmain.win, "Xpgs", "xpgs", iconmap, argv, argc,
			   &hint);
   XSelectInput(dpy, wmain.win, ButtonPressMask | ButtonReleaseMask |
		ExposureMask | OwnerGrabButtonMask | KeyPressMask);
   XMapWindow(dpy, wmain.win);

   /* To render, we will need graphics context of the proper depth. */
   gcpx = XCreateGC(dpy, wmain.win, 0, NULL);
   XSetForeground(dpy, gcpx, fg);
   XSetBackground(dpy, gcpx, bg);
   XSetFont(dpy, gcpx, font_info->fid);
   XSetClipMask(dpy, gcpx, None);
   XSetGraphicsExposures(dpy, gcpx, False);
   XSetLineAttributes(dpy, gcpx, 0, LineSolid, CapButt, JoinRound);
   XSetSubwindowMode(dpy, gcpx, ClipByChildren);

   gcpxt = XCreateGC(dpy, wmain.win, 0, NULL);
   XCopyGC(dpy, gcpx, ~0L, gcpxt);
   if (fg > bg) {
      XSetForeground(dpy, gcpxt, fg);
      XSetBackground(dpy, gcpxt, bg);
   } else {
      XSetForeground(dpy, gcpxt, bg);
      XSetBackground(dpy, gcpxt, fg);
   }

   gcpxr = XCreateGC(dpy, wmain.win, 0, NULL);
   XCopyGC(dpy, gcpx, ~0L, gcpxr);
   XSetForeground(dpy, gcpxr, bg);
   XSetBackground(dpy, gcpxr, fg);

   gcpxor = XCreateGC(dpy, wmain.win, 0, NULL);
   XCopyGC(dpy, gcpx, ~0L, gcpxor);
   XSetForeground(dpy, gcpxor, fg^bg);
   XSetFunction(dpy, gcpxor, GXxor);


#ifdef XPGSUSEPM
   for (i=0; i<fno; i++) {
      pix[i] = XCreatePixmap(dpy, wmain.win, wmain.w, wmain.h, 1);
   }
   gcpxs = XCreateGC(dpy, pix[0], 0, NULL);
   gcpxsr = XCreateGC(dpy, pix[0], 0, NULL);
#else
   pix = XCreatePixmap(dpy, wmain.win, wmain.w, wmain.h, 1);
   gcpxs = XCreateGC(dpy, pix, 0, NULL);
   gcpxsr = XCreateGC(dpy, pix, 0, NULL);
#endif
   XSetForeground(dpy, gcpxs, fg);
   XSetBackground(dpy, gcpxs, bg);
   XSetClipMask(dpy, gcpxs, None);
   XSetGraphicsExposures(dpy, gcpxs, False);
   XSetLineAttributes(dpy, gcpxs, 0, LineSolid, CapButt, JoinRound);
   XCopyGC(dpy, gcpxs, ~0L, gcpxsr);
   XSetForeground(dpy, gcpxsr, bg);
   XSetBackground(dpy, gcpxsr, fg);
#ifdef XPGSUSEPM
   XFillRectangle(dpy, pix[0], gcpxsr, 0, 0, wmain.w, wmain.h);
#else
   XFillRectangle(dpy, pix, gcpxsr, 0, 0, wmain.w, wmain.h);
#endif


   whp.win = XCreateSimpleWindow(dpy, root, whp.x, whp.y, whp.w, whp.h,
				 5, fg, bg);
   DIEIF(whp.win == None, "Could not create help window\n");
   XSetStandardProperties (dpy, whp.win, "Xpgs help", "xpgs help", iconmap,
			   NULL, 0, NULL);
   XSetWMHints(dpy, whp.win, &wmhint);
   XSelectInput(dpy, whp.win, ButtonPressMask | ButtonReleaseMask |
		ExposureMask | OwnerGrabButtonMask | KeyPressMask);
#ifdef XPGSUSEPM
   whp.pix = XCreatePixmap(dpy, whp.win, whp.w, whp.h, depth);
   DIEIF(whp.pix == None, "Could not create help pixmap\n");
#else
   whp.pix = whp.win;
#endif

   initpopup(root, fg, bg);
   writehelp();
}


void writehelp(void)
{
   int font_a, font_d, font_h, strl, strw;
   int linepos, colpos;
   int i;
   const char **sptr;
   static const char *strings[] = {
      "******* Keys in graphics window ******",
      "***** after frames have been done ****",
      " ",
      "q to Quit",
      "h to get Help",
      "a to change Axis",
      "i to re-Initialise points",
      "p to toggle Pause",
      "r to Reverse direction of frames",
      "While paused:",
      " c to save frame as XSS file",
      " l to Load new POLYH or XSS file",
      " o to reload Old file",
      " n to Next frame",
      " s to Save frame as Postscript",
      " w to Write frame as bitmap",
      NULL
   };
   font_a = font_info->ascent;
   font_d = font_info->descent;
   font_h = font_a + font_d;

   XFillRectangle(dpy, whp.pix, gcpxr, 0, 0, whp.w, whp.h);
   strw = 0;
   for (i=0, sptr=strings; *sptr != NULL; i++, sptr++) {
      strl = XTextWidth(font_info, *sptr, strlen(*sptr));
      if (strl > strw) strw = strl;
   }

   colpos = whp.w/2 - strw/2;
   linepos = whp.h/2 - (i*font_h)/2 - font_d;
   for (sptr=strings; *sptr != NULL; sptr++) {
      linepos += font_h;
      XDrawString(dpy, whp.pix, gcpx, colpos, linepos, *sptr, strlen(*sptr));
   }
   XFlush(dpy);
}


void writeintro(int load, char *name)
{
   int font_a, font_d, font_h, strl, strw;
   int linepos;
   int i, ox;
   const char *stra;
   char *strb;
   static const char *strings[] = {
      "Xpgs by Peter Chang",
      " ",
      "Copyright 1994",
      " ",
      " ",
      NULL
   };

   font_a = font_info->ascent;
   font_d = font_info->descent;
   font_h = font_a + font_d;

   XFillRectangle(dpy, wmain.win, gcpxr, 0, 0, wmain.w, wmain.h);

   linepos = wmain.h/3 + font_a - font_h;
   ox = 0;
   stra = strings[0];
   for (i=0; stra != NULL; i++, stra = strings[i]) {
      linepos += font_h;
      strl = strlen(stra);
      strw = XTextWidth(font_info, stra, strl);
      XDrawString(dpy, wmain.win, gcpx, ox+(wmain.w-strw)/2,
		  linepos, stra, strl);
   }

   DIEIF((strb = (char *) malloc(LLEN)) == NULL,
	 "Couldn't allocate memory for string\n");

   switch(load) {
    case 0:
      sprintf(strb, "%s.polyh loaded", name);
      break;
    case 1:
      sprintf(strb, "%s.xss loaded", name);
      break;
    case -1: default:
      sprintf(strb, "Loading %s...", name);
      break;
      
   }
   linepos += 2*font_h;
   strl = strlen(strb);
   strw = XTextWidth(font_info, strb, strl);
   XDrawString(dpy, wmain.win, gcpx, ox+(wmain.w-strw)/2,
	       linepos, strb, strl);

   sprintf(strb, "Press h or click on window for help");
   linepos += 3*font_h;
   strl = strlen(strb);
   strw = XTextWidth(font_info, strb, strl);
   XDrawString(dpy, wmain.win, gcpx, ox+(wmain.w-strw)/2,
	       linepos, strb, strl);

   free(strb);
}


int handleexpose(Window wev)
{
   if (wev == wmain.win) {
#ifdef XPGSUSEPM
      XCopyPlane(dpy, pix[frame], wmain.win, gcpxt, 0, 0,
		 wmain.w, wmain.h, 0, 0, 1);
#else
      XCopyPlane(dpy, pix, wmain.win, gcpxt, 0, 0,
		 wmain.w, wmain.h, 0, 0, 1);
#endif
   } else if (wev == whp.win) {
#ifdef XPGSUSEPM
      XCopyArea(dpy, whp.pix, whp.win, gcpx, 0, 0, whp.w, whp.h, 0, 0);
#else
      void writehelp(void);
      
      writehelp();
#endif
   }

   return 0;
}


void quitxpgs(void)
{
   int i;

#ifdef XPGSUSEPM
   for (i=0; i<fno; i++) XFreePixmap(dpy, pix[i]);
   XFreePixmap(dpy, whp.pix);
#else
   for (i=0; i<fno; i++) if (image[i] != NULL) XDestroyImage(image[i]);
   XFreePixmap(dpy, pix);
#endif

   XFreePixmap(dpy, iconmap);
   destroypopup();
   XFreeFont(dpy, font_info);
   XFreeGC(dpy, gcpxs);
   XFreeGC(dpy, gcpxsr);
   XFreeGC(dpy, gcpxt);
   XFreeGC(dpy, gcpx);
   XFreeGC(dpy, gcpxr);
   XFreeGC(dpy, gcpxor);
   XDestroyWindow(dpy, whp.win);
   XDestroyWindow(dpy, wmain.win);
   XCloseDisplay(dpy);
   killallshapes();
   free(zplookup);
   printf("\nFond farewell\n");
}


/* SIRDS algorithm */
void sirdsnew(int *zll, int *zlr, Llist *same)
{
   register int s;
   register short left, right;
   register short st, sl, sr;

   for (left=0; left<width; left++) {
      s = *zll++;
      right = left + s;
      if (right < width) {
	 s -= zlr[right];
	 if (s <= 1 && s >= -1) {
	    sl = left; sr = right;
	    for (st=same[sr].f; st!=sl && st!=sr; st=same[sr].f) {
	       if (st > sl) {
		  sr = st;
	       } else {
		  same[sl].t = sr;
		  same[sr].f = sl;
		  sr = sl;
		  sl = st;
	       }
	    }
	    same[sl].t = sr;
	    same[sr].f = sl;
	 }
      }
   }
}


/* postscript output */
static FILE *psfo;
static int pspixl, pspixb;

void saveps(int **zbufl, int **zbufr, char name[NLEN], int f)
{
   int sep;
   int drawsirds(int **, int **, int , int );

   switch(grey) {
    case 2:
      pspixb = 4;
      break;
    case 4:
      pspixb = 2;
      break;
    case 8:
      pspixb = 1;
      break;
    case 1: default:
      grey = 1;
      pspixb = 8;
      break;
   }
   pspixl = (width+pspixb-1)/pspixb;

printf("density %d grey %d pixb %d pixl %d\n", density, grey, pspixb, pspixl);

   if ((psfo = fopen(name, "w")) == NULL) {
      printf("Can't save %s\n", name);
      return;
   }

   psprologue(psfo, name, pspixl);
   sep = drawsirds(zbufl, zbufr, f, 1);
#ifdef EUROPPR
   sep = (sep*770)/width;
#else
   sep = (sep*720)/width;
#endif

   psepilogue(psfo, name, sep);
   fclose(psfo);
}

void drawpsline(uschar *pa)
{
   psline(psfo, pa, pspixl, pspixb);
}


/*
 * Parse the command line set the filename and the appropriate flags
 */
void pcl(int argc, char **argv, char *fname)
{

   static const char *options[] = {
      "-help                     print this message",
      "-display <display>            X display name",
      "-geometry <geometry>              X geometry",
      "-wait <delay>          delay in milliseconds (300)",
      "-frames <1-24>              number of frames (1)",
      "-background <b>             background plane (-1.0)",
      "-reverse               set crosseyed viewing",
      "-enlarge <ef>           enlargement of depth (1.0)",
      "-mag <mf>             magnification of scene (1.0)",
#ifdef vaxc
      "-paper <wxh>       size of array used for PS (?x?)",
#else
      "-paper <wxh>       size of array used for PS (" MWHS ")",
#endif
      "-indicoff      turn off indicators on window",
      "-zblines <zb>  lines to use in each z buffer (256)",
      "-DENSITY <0-255>       density of black dots (127)",
      "-GREY <1,2,4,8>   set no. of grey scale bits (1)",
      "-SHIMMER         shimmer mode to aid newbies",
      NULL
   };

   static const char usage1[] = "usage: xpgs [options] <polyh or xss file>";
   static const char usage2[] = " try xpgs -help for a list of option";

   int i, optno, fvalid = 0, olen;
   const char **sptr;

   for (i = 1; i < argc; i++) {
      olen = strlen(argv[i]);
      for (sptr = options, optno = 0; *sptr != NULL; sptr++, optno++)
         if (strncmp(argv[i], *sptr, olen) == 0) break;
      
      switch(optno)  {
       case 0:
         printf("%s\n", usage1);
         printf("Options (defaults in parenthesis):\n");
 	 for (sptr = options; *sptr != NULL; sptr++) printf(" %s\n", *sptr);
	 printf("\n");
         exit(EXIT_SUCCESS);
         break;

       case 1:
         dispname = argv[++i];
         break;

       case 2:
         geometry = argv[++i];
         break;

       case 3:
         delay = atoi(argv[++i]) * 1000; /* convert to microseconds */
         break;

       case 4:
         fno = atoi(argv[++i]);
         DIEIF(fno > FNO, "too many frames requested\n");
         break;

       case 5:
         background = atof(argv[++i]);
         break;

       case 6:
         reverse = -1;
         break;

       case 7:
         enlarge = atof(argv[++i]);
         break;

       case 8:
         mag = atof(argv[++i]);
         break;

       case 9:
         sscanf(argv[++i], "%dx%d", &pw, &ph);
         break;

       case 10:
         indicator = 0;
         break;

       case 11:
         buf_h = atoi(argv[++i]);
	 break;

       case 12:
         density = atoi(argv[++i]) & 0xff;
         break;

       case 13:
         grey = atoi(argv[++i]) & 0x0f;
         break;

       case 14:
         shimmer = 1;
         fno = 7;
         delay = 50000;
         break;

       default:
         if (!fvalid && *argv[i] != '-') {
            strcpy(fname, argv[i]);
            fvalid = 1;
         } else {
            DIE4("%s\n%s\n", usage1, usage2);
         }
         break;
      }
   }

   DIEIF4(fvalid != 1, "%s\n%s\n", usage1, usage2);
}

