static char rcsid[] = "@(#)$Id: xss.c,v 2.6.2.1 1995/01/26 04:50:52 peter Exp $";
/*
 * xss - an X11 interactive scene setter.

 * It allows you compose a scene from objects interactively.
 * All the objects as displayed in wireframe and can be translated,
 * rotated and resized. A rotation axis can also be defined.
 * The resultant composition can be saved as a XSS file which
 * xpgs can read in.

 * Copyright 1994 and 1995, 26th January.
 * By Peter Chang
 * peterc@a3.ph.man.ac.uk

 * See notice in misc.h for details of permissions and warranty of this
 * software.

 *
 * $Log: xss.c,v $
 * Revision 2.6.2.1  1995/01/26  04:50:52  peter
 * Added clipping to parallel views for non-pixmap compilation.
 *
 * Revision 2.6  1994/11/18  04:03:16  peter
 * xpgs-2.5-patch 01: Changes in header files for clean compile
 *
 * Revision 2.5.1.1  1994/11/17  03:34:21  peter
 * Import of actual public release of xpgs-2.5: lots of cosmetic changes to docs
 *
 * Revision 2.5  1994/11/16  09:19:38  peter
 * Putting xpgs-2.5 in trunk.
 *
 * Revision 2.0.1.1  1994/11/16  09:10:28  peter
 * Import of xpgs-2.5: archive of new release to alt.sources (11/94)
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h> /* included by Xos.h, apparently */
#include <math.h>

#ifdef VMS
#include <DecW$Include/Xlib.h>
/* #include <DecW$Include/Xos.h> */
#include <DecW$Include/Xutil.h>
#include <DecW$Include/keysym.h>
#else
#include <X11/Xlib.h>
/* #include <X11/Xos.h> */
#include <X11/Xutil.h>
#include <X11/keysym.h>
#endif

#include "icon.xbm"
#include "tran.xbm"
#include "turn.xbm"
#include "pgs.h"
#include "polyh.h"
#include "xmisc.h"
#include "lookup.h"

#if __GNUC__ == 2
USE(rcsid);
#endif

/*
#define FNO     24
short fno = 1;
long  delay = 300000L;
*/

static char *dispname = NULL, *fontname = NULL, *geometry = NULL;

Object *shapes = NULL;
usint nobj = 0;

int   width, height;
float pmm;           /* pixel per mm */

Display *dpy;
Pixmap iconmap;
XFontStruct *font_info = NULL;
int depth;

Xss_w wmain = { None, None, MW/4 + MH/4, MH/2, 0, 0 },
      wcp = { None, None, 200, 375, 0, 0 },
      whp = { None, None, 400, 480, 0, 0 };

Xss_d cpb[] = { { None, 50, 35, 5, 5 },      /* quit */
                { None, 90, 175, 5, 75 },    /* change state */
                { None, 150, 100, 5, 265 },  /* cursor pad */
                { None, 90, 55, 105, 5 },     /* output */
                { None, 90, 138, 105, 75 },   /* object */
                { None, 90, 25, 105, 225 }   /* magnify */
};

static Xss_d curspad[] = { { None, tran_width, tran_height, 0, 0},
                    { None, turn_width, turn_height, 0, 0 } };

static Xss_b tran[] = { {90, 19}, {66, 74}, {32, 22},
                        {100, 57}, {64, 3}, {36, 63} };

static Xss_b turn[] = { {94, 17}, {25, 43}, {49, 29},
                        {60, 79}, {74, 56}, {40, 5} };

Xss_d views[4];

#define PADRAD 7

static int cpbno = 6;

GC gcpx, gcpxr, gcpxor;

float theta = 0.0, phi = 0.0;

Point raxis;

typedef struct {
   int redraw;
   int axis, clip, proj, turn;
   int inout; /* in = 1(load xss or polyh), 4(insert xss), 5(clone);
	       * out = 2(xbm), 3(xss) */
   float degree, inch, mag;
} Xss_state;

static Xss_state xss;

int main(int argc, char *argv[])
{
   Window wtemp;
   XEvent report;
   KeySym keysym;
   char buf[4];

   int i, j;

   int sno, cobj;
   int oldbx, oldby, oldbox;

   char name[NLEN], oname[NLEN], pname[NLEN];

   int load = 0;
   int verbose;
   int begin, help;

   void pcl(int, char **, char *);
   void quitxss(void);
   void initall(int , char *[]);
   void drawcontrol(void);
   void makeviews(int , int , int );
   void getangles(void);
   int  handlebuttonsp(int , XButtonEvent *);
   int  handlebuttonsr(int , XButtonEvent *, int , int , int ,
		       int , Object *, int );
   int  handlekeys(KeySym , int , Object *, int );
   void drawall(int , int , char *);
   void setsize(Object *, char *);

   pcl(argc, argv, name);

   printf("\nWelcome to xss\n");
 
   initall(argc, argv);

   begin = 1;
   verbose = 1;
   help = 0;
   sno = 1;
   cobj = 0;
   oldbx = 0;
   oldby = 0;
   oldbox = -1;

   xss.redraw = 1;
   xss.axis = 0;
   xss.clip = 0;
   xss.proj = 0;
   xss.turn = 1;
   xss.inout = 1;
   xss.degree = PI / 120.0;
   xss.inch = 0.01;
   xss.mag = 1.01;
   drawcontrol();

   while (1) {
      XNextEvent(dpy, &report);
      switch (report.type) {
       case ButtonPress:
	 if (report.xbutton.window == wcp.win) {
	    for (j=0; j<cpbno; j++) {
	       if (cpb[j].d == report.xbutton.subwindow) break;
	    }
	    if (j<cpbno) {
	       i = handlebuttonsp(j, &report.xbutton);
	       if (i >= 0) {
		  XFlush(dpy);
		  oldbx = report.xbutton.x;
		  oldby = report.xbutton.y;
		  oldbox = j;
	       }
	    }
	 }
	 break;
       case ButtonRelease:
	 if (report.xbutton.window == wmain.win ||
	     report.xbutton.window == whp.win) {
	    help = 1 - help;
	    if (help) XMapWindow(dpy, whp.win);
	    else XUnmapWindow(dpy, whp.win);
	 } else if (report.xbutton.window == wcp.win) {
	    for (j=0; j<cpbno; j++) {
	       if (cpb[j].d == report.xbutton.subwindow) break;
	    }
	    i = handlebuttonsr(j, &report.xbutton, oldbx, oldby,
			       oldbox, cobj, &shapes[cobj], verbose);
	    if (i >= 0) {
	       cobj = i;
	    } else {
	       xss.redraw = 0;
	    }
	    oldbox = -1;
	 }
	 break;
       case Expose:
	 wtemp = report.xexpose.window;
	 while (XCheckTypedWindowEvent(dpy, wtemp, Expose, &report));
	 xss.redraw = handleexpose(wtemp);
	 break;
       case ConfigureNotify:
	 if (report.xconfigure.window == wmain.win) {
	    if (wmain.w != report.xconfigure.width ||
		wmain.h != report.xconfigure.height) {
	       xss.redraw = 1;
	       wmain.w = report.xconfigure.width;
	       wmain.h = report.xconfigure.height;
	       if (xss.proj) {
#ifdef XSSUSEPM
		  XFreePixmap(dpy, wmain.pix);
		  wmain.pix = XCreatePixmap(dpy, wmain.win,
					    wmain.w, wmain.h, depth);
		  DIEIF(wmain.pix == None, "Could not create main pixmap\n");
#endif
		  width = wmain.w;
		  height = wmain.h;
		  lookup(1); /* set up lookup table */
	       } else {
#ifdef XSSUSEPM
		  for (j=0; j<4; j++) XFreePixmap(dpy, views[j].d);
#endif
		  makeviews(wmain.w, wmain.h, depth);
	       }
	    }
	 }
	 break;
       case KeyRelease:
	 XLookupString(&report.xkey, buf, 3, &keysym, NULL);
	 switch (keysym) {
	  case XK_Shift_L: case XK_Shift_R:
	    xss.degree = PI / 120.0;
	    xss.inch = 0.01;
	    xss.mag = 1.01;
	    if (verbose) printf("shift off\n");
	    break;
	  default:
	    break;
	 }
	 break;
       case KeyPress:
	 XLookupString(&report.xkey, buf, 3, &keysym, NULL);
	 switch (keysym) {
	  case XK_q: case XK_Q:
	    quitxss();
	    exit(EXIT_SUCCESS);
	  case XK_w: case XK_W:
	    xss.inout = 2;
	    break;
	  case XK_s: case XK_S:
	    xss.inout = 3;
	    break;
	  case XK_f: case XK_F:
	    xss.inout = 4;
	    break;
	  case XK_r: case XK_R:
	    xss.inout = 5;
	    break;
	  case XK_l: case XK_L:
	    xss.inout = 1;
	    break;
	  case XK_h: case XK_H:
	    help = 1 - help;
	    if (help) XMapWindow(dpy, whp.win);
	    else XUnmapWindow(dpy, whp.win);
	    break;
	  case XK_v: case XK_V:
	    verbose = 1 - verbose;
	    printf("toggled verbosity\n");
	    break;
	  case XK_Shift_L: case XK_Shift_R:
	    xss.degree = PI / 36.0;
	    xss.inch = 0.05;
	    xss.mag = 1.051;
	    if (verbose) printf("shift on\n");
	    break;
	  default:
	    cobj = handlekeys(keysym, cobj, &shapes[cobj], verbose);
	    break;
	 }
	 break;
       default:
	 break;
      } /* end of event switching */
      switch (xss.inout) {
       case 1: /* load file */
	 if (begin > 0) {
	    if ((load = loadshapes(name, verbose)) < 0) {
	       fprintf(stderr, "ERROR: something wrong with %s\n", name);
	       quitxss();
	       exit(EXIT_FAILURE);
	    }
	    for (i=0; i<nobj; i++) {
	       findedge(i, &shapes[i], verbose);
	       findbbox(i, &shapes[i], verbose);
	    }
	    begin = 0;
	    verbose = 0;
	    raxis.x = sin(theta) * cos(phi);
	    raxis.y = sin(theta) * sin(phi);
	    raxis.z = cos(theta);
	 } else {
	    strncpy(dstring, shapes[cobj].fname, NLEN-1);
	    if (popupquery("Please enter POLYH file name (w ext)") > 0) {
	       strncpy(pname, dstring, NLEN-1);
	       if ((i = addpolyh(pname, verbose)) < 0) {
		  fprintf(stderr, "ERROR: something wrong with %s\n", pname);
	       } else {
		  cobj = i;
		  findedge(cobj, &shapes[cobj], verbose);
		  initobj(&shapes[cobj]);
		  sprintf(dstring, "(1.0, 1.0, 1.0)");
		  if (popupquery("Please enter size") > 0)
		     setsize(&shapes[cobj], dstring);
		  findbbox(cobj, &shapes[cobj], verbose);
		  xss.redraw = 1;
	       }
	    }
	 }
	 xss.inout = 0;
	 break;
       case 2: /* save xbm */
	 sprintf(dstring, "%s%d.xbm", name, sno);
	 if (popupquery("Please enter XBM file name") > 0) {
	    strncpy(oname, dstring, NLEN-1);
	    XWriteBitmapFile(dpy, oname, wmain.win,
			     wmain.w, wmain.h, -1, -1);
	    XBell(dpy, 100);
	    XFlush(dpy);
	    sno++;
	    printf("Bitmap saved: %s\n",oname);
	 }
	 xss.inout = 0;
	 break;
       case 3: /* save xss */
	 if (xss.axis) getangles();
	 if (load == 0) {
	    dstring[0] = '\0';
	 } else {
	    sprintf(dstring, "%s", name);
	 }
	 if (popupquery("Please enter XSS file name (w/o ext)") > 0) {
	    strncpy(name, dstring, NLEN-1);
	    sprintf(oname, "%s.xss", name);
	    dstring[0] = '\0';
	    popupquery("Enter comment line");
	    savexss(oname, dstring);
	    load = 1;
	 }
	 xss.inout = 0;
	 break;
       case 4: /* insert xss */
	 if (load == 0) {
	    dstring[0] = '\0';
	 } else {
	    sprintf(dstring, "%s", name);
	 }
	 if (popupquery("Please enter XSS file name (w/o ext)") > 0) {
	    strncpy(oname, dstring, NLEN-1);
	    sprintf(pname, "%s.xss", oname);
	    if ((i = insertxss(pname, verbose)) <= 0) {
	       fprintf(stderr, "ERROR: something wrong with %s\n", pname);
	    } else {
	       for (cobj = nobj - i; cobj<nobj; cobj++) {
		  findedge(cobj, &shapes[cobj], verbose);
		  findbbox(cobj, &shapes[cobj], verbose);
	       }
	       cobj--;
	       if (load == 0) {
		  load = 1;
		  strcpy(name, oname);
	       }
	       xss.redraw = 1;
	    }
	 }
	 xss.inout = 0;
	 break;
       case 5: /* copy current */
	 if ((i = addpolyh(shapes[cobj].fname, verbose)) < 0) {
	    fprintf(stderr, "ERROR: something wrong with %s\n", pname);
	 } else {
	    findedge(i, &shapes[i], verbose);
	    shapes[i].ot = shapes[cobj].ot;
	    shapes[i].wt = shapes[cobj].wt;
	    findbbox(i, &shapes[i], verbose);
	    cobj = i;
	    xss.redraw = 1;
	 }
	 xss.inout = 0;
	 break;
       case 0: default:
	 break;	 
      }
      if (xss.redraw) {
         xss.redraw = 0;
	 drawall(cobj, load, name);
      }  /* end of redraw */
/*      XFlush(dpy); */
   } /* end of main loop */
}


int handleexpose(Window wev)
{
   void drawcontrol(void);

   if (wev == wmain.win) {
#ifdef XSSUSEPM
      if (xss.proj) {
	 XCopyArea(dpy, wmain.pix, wmain.win, gcpx, 0, 0,
		   wmain.w, wmain.h, 0, 0);
      } else {
	 int j;
	 for (j=0; j<4; j++) XCopyArea(dpy, views[j].d, wmain.win, gcpx, 0, 0,
				       views[j].w, views[j].h,
				       views[j].x, views[j].y);
      }
#else
      return 1;
#endif
   } else if (wev == whp.win) {
#ifdef XSSUSEPM
      XCopyArea(dpy, whp.pix, whp.win, gcpx, 0, 0, whp.w, whp.h, 0, 0);
#else
      void writehelp(void);
      
      writehelp();
#endif
   } else if (wev == wcp.win) {
      drawcontrol();
   }

   return 0;
}


void drawall(int cur, int load, char *name)
{
   int i, j;
#ifndef XSSUSEPM
   XRectangle rect;
#endif

   void pdrawobj(Object *, int );
   void pdrawobjc(Object *, int , float );
   void pdrawaxis(int , int );
   void drawobj(Object *);
   void drawobjc(Object *, float );
   void drawaxis(int );
   void writeinfo(int , int , char *);

#ifndef XSSUSEPM
   XClearWindow(dpy, wmain.win);
#endif
   if (xss.proj) {
#ifdef XSSUSEPM
      XFillRectangle(dpy, wmain.pix, gcpxr, 0, 0, wmain.w, wmain.h);
#endif
      if (xss.axis) drawaxis(xss.clip);
      for (i=0; i<nobj; i++) {
	 if (i != cur) XSetLineAttributes(dpy, gcpx, 0, LineOnOffDash,
					  CapButt, JoinRound);
	 if (shapes[i].hidden == 0) {
	    if (xss.clip) drawobjc(&shapes[i], 0.0);
	    else drawobj(&shapes[i]);
	 }
	 if (i != cur) XSetLineAttributes(dpy, gcpx, 0, LineSolid,
					  CapButt, JoinRound);
      }
#ifdef XSSUSEPM
      XCopyArea(dpy, wmain.pix, wmain.win, gcpx, 0, 0, wmain.w, wmain.h, 0, 0);
#endif
   } else {
#ifdef XSSUSEPM
      XFillRectangle(dpy, views[0].d, gcpxr, 0, 0, views[0].w, views[0].h);
      XDrawRectangle(dpy, views[0].d, gcpx, 0, 0, views[0].w, views[0].h);
      writeinfo(cur, load, name);
      XCopyArea(dpy, views[0].d, wmain.win, gcpx, 0, 0, views[0].w, views[0].h,
		views[0].x, views[0].y);
#else
      XClearArea(dpy, wmain.win, views[0].x, views[0].y,
		 views[0].w, views[0].h, False);
      writeinfo(cur, load, name);
#endif
      for (j=1; j<4; j++) {
#ifdef XSSUSEPM
	 XFillRectangle(dpy, views[j].d, gcpxr, 0, 0, views[j].w, views[j].h);
	 XDrawRectangle(dpy, views[j].d, gcpx, 0, 0, views[j].w, views[j].h);
#else
	 XClearArea(dpy, wmain.win, views[j].x, views[j].y,
		    views[j].w, views[j].h, False);
	 XDrawRectangle(dpy, wmain.win, gcpx, views[j].x, views[j].y,
			views[j].w, views[j].h);
#endif
	 if (xss.axis) pdrawaxis(xss.clip, j);
	 for (i=0; i<nobj; i++) {
	    if (shapes[i].hidden == 0) {
	       if (i != cur) XSetLineAttributes(dpy, gcpx, 0, LineOnOffDash,
						CapButt, JoinRound);
#ifndef XSSUSEPM
	       /* clipping for drawing method which does not use pixmaps */
	       rect.x = views[j].x;
	       rect.y = views[j].y;
	       rect.width = views[j].w;
	       rect.height = views[j].h;
	       XSetClipRectangles(dpy, gcpx, 0, 0, &rect, 1, Unsorted);
#endif
	       if (xss.clip) pdrawobjc(&shapes[i], j, 0.0);
	       else pdrawobj(&shapes[i], j);
#ifndef XSSUSEPM
	       rect.x = 0;
	       rect.y = 0;
	       rect.width = wmain.w;
	       rect.height = wmain.h;
	       XSetClipRectangles(dpy, gcpx, 0, 0, &rect, 1, Unsorted);
#endif
	       if (i != cur) XSetLineAttributes(dpy, gcpx, 0, LineSolid,
						CapButt, JoinRound);
	    }
	 }
#ifdef XSSUSEPM
	 XCopyArea(dpy, views[j].d, wmain.win, gcpx, 0, 0,
		   views[j].w, views[j].h, views[j].x, views[j].y);
#endif
      }
   }
}


void setsize(Object *pobj, char *sptr)
{
   char tstr[LLEN];
   float xmag, ymag, zmag;

   strcpy(tstr, sptr);
   pparse(tstr, NULL);

   xmag = 1.0;
   ymag = 1.0;
   zmag = 1.0;

   if (parno > 3) parno = 3;
   switch(parno) { /* deliberate fall through */
      /*@ -casebreak */
    case 3:
      zmag = parameter[2];
    case 2:
      ymag = parameter[1];
    case 1:
      xmag = parameter[0];
    default:
      break;
      /*@ =casebreak */
   }
   magaffine(&pobj->wt, xmag, ymag, zmag);
}


void initall(int argc, char *argv[])
{
   XSizeHints hint;
   XWMHints wmhint;
   Window root;
   uslong fg, bg;
   usint sw, sh;
   int screen;
   char doot[] = {5,5};
   int gflags = 0;

   void initcontrol(int , int );
   void makeviews(int , int , int );
   void writehelp(void);

   dpy = XOpenDisplay(dispname);
   if (!dpy) {
      fprintf(stderr, "Could't open display: ");
      if (dispname == NULL)
#ifdef VMS
         fprintf(stderr, "%s\n" ,getenv("DECW$DISPLAY"));
#else
         fprintf(stderr, "%s\n" ,getenv("DISPLAY"));
#endif
      else
         fprintf(stderr, "%s\n", dispname);
      exit(EXIT_FAILURE);
   }

   screen = DefaultScreen(dpy);
   root = RootWindow(dpy, screen);

   sw = wmain.w;
   sh = wmain.h;
   if (geometry != NULL)
      gflags = XParseGeometry(geometry, &hint.x, &hint.y, &sw, &sh);
   wmain.w = sw;
   wmain.h = sh;

   bg = BlackPixel(dpy, screen);
   fg = WhitePixel(dpy, screen);
   pmm = ((float) DisplayWidth(dpy, screen)) 
              / DisplayWidthMM(dpy, screen);
   depth = DefaultDepth(dpy, screen);

   width = wmain.w;
   height = wmain.h;
   printf("No of pixels per millimetre: %f\n", pmm);
   printf("\n VD: %f OS: %f\n OX: %d \t OY: %d \n", VD, OS, OX, OY);

   if (fontname != NULL) font_info = XLoadQueryFont(dpy, fontname);

   if (font_info == NULL) {
      fprintf(stderr, "Trying to use fixed font.\n");
      DIEIF((font_info = XLoadQueryFont(dpy, "fixed")) == NULL,
	    "Couldn't open any fonts\n");
   }
#ifdef MYDEBUG
   XSynchronize(dpy, 1); /* for debug X stuff */
#endif

   hint.width = wmain.w; hint.height = wmain.h;
   hint.flags = PSize;
   if (gflags & (WidthValue | HeightValue)) {
      hint.flags |= USSize;
   }
   if (gflags & XValue) {
      if (gflags & XNegative) {
	 hint.x += DisplayWidth(dpy, screen) - hint.width;
      }
      hint.flags |= USPosition;
   }
   if (gflags & YValue) {
      if (gflags & YNegative) {
	 hint.y += DisplayHeight(dpy, screen) - hint.height;
      }
      hint.flags |= USPosition;
   }
   wmain.x = hint.x; wmain.y = hint.y;
   wmain.win = XCreateSimpleWindow(dpy, root,
         wmain.x, wmain.y, wmain.w, wmain.h, 5, fg, bg);
   DIEIF(wmain.win == None, "Could not create main window\n");
   iconmap = XCreateBitmapFromData(dpy, wmain.win, (char *)pgs_bits,
                                   pgs_width, pgs_height);
   wmhint.input = True;
   wmhint.flags = InputHint;
   wmhint.icon_pixmap = iconmap;
   XSetWMHints(dpy, wmain.win, &wmhint);
   XSetStandardProperties(dpy, wmain.win, "Xss", "xss", iconmap, argv, argc,
			   &hint);
   XSelectInput(dpy, wmain.win, ButtonPressMask | ButtonReleaseMask |
		ExposureMask | OwnerGrabButtonMask |
		KeyPressMask | KeyReleaseMask | StructureNotifyMask);
   XMapWindow(dpy, wmain.win);

   /* To render, we will need graphics context of the proper depth. */
   gcpx = XCreateGC(dpy, wmain.win, 0, NULL);
   XSetForeground(dpy, gcpx, fg);
   XSetBackground(dpy, gcpx, bg);
   XSetFont(dpy, gcpx, font_info->fid);
   XSetDashes(dpy, gcpx, 0, doot, 2);
   XSetClipMask(dpy, gcpx, None);
   XSetGraphicsExposures(dpy, gcpx, False);
   /* zero line width! */
   XSetLineAttributes(dpy, gcpx, 0, LineSolid, CapButt, JoinRound);
/*   XSetSubwindowMode(dpy, gcpx, ClipByChildren); */

   gcpxr = XCreateGC(dpy, wmain.win, 0, NULL);
   XCopyGC(dpy, gcpx, ~0L, gcpxr);
   XSetForeground(dpy, gcpxr, bg);
   XSetBackground(dpy, gcpxr, fg);

   gcpxor = XCreateGC(dpy, wmain.win, 0, NULL);
   XCopyGC(dpy, gcpx, ~0L, gcpxor);
   XSetForeground(dpy, gcpxor, fg^bg);
   XSetFunction(dpy, gcpxor, GXxor);

   makeviews(wmain.w, wmain.h, depth);

   whp.win = XCreateSimpleWindow(dpy, root, whp.x, whp.y, whp.w, whp.h,
				 5, fg, bg);
   DIEIF(whp.win == None, "Could not create help window\n");
   XSetStandardProperties (dpy, whp.win, "Xss help", "xss help", iconmap,
			   NULL, 0, NULL);
   XSetWMHints(dpy, whp.win, &wmhint);
   XSelectInput(dpy, whp.win, ButtonPressMask | ButtonReleaseMask |
		ExposureMask | OwnerGrabButtonMask |
		KeyPressMask | KeyReleaseMask);
#ifdef XSSUSEPM
   whp.pix = XCreatePixmap(dpy, whp.win, whp.w, whp.h, depth);
   DIEIF(whp.pix == None, "Could not create help pixmap\n");
#else
   whp.pix = whp.win;
#endif

   wcp.win = XCreateSimpleWindow(dpy, root,
         wcp.x, wcp.y, wcp.w, wcp.h, 5, fg, bg);
   DIEIF(wcp.win == None, "Could not create control window\n");
   XSetWMHints(dpy, wcp.win, &wmhint);
   XSetStandardProperties (dpy, wcp.win, "Xss CP", "xss cp", iconmap,
			   NULL, 0, NULL);

   initcontrol(fg, bg);
   initpopup(root, fg, bg);

   writehelp();
#ifdef XSSUSEPM
   XCopyArea(dpy, whp.pix, whp.win, gcpx, 0, 0, whp.w, whp.h, 0, 0);
#endif
   XFlush(dpy);
}


void quitxss(void)
{
   int j;

#ifdef XSSUSEPM
   if (xss.proj) {
      XFreePixmap(dpy, wmain.pix);
   } else {
      for (j=0; j<4; j++) XFreePixmap(dpy, views[j].d);
   }
   XFreePixmap(dpy, whp.pix);
#endif
   XFreePixmap(dpy, iconmap);
   XDestroyWindow(dpy, whp.win);
   for (j=0; j<cpbno; j++) XDestroyWindow(dpy, cpb[j].d);
   XDestroyWindow(dpy, wcp.win);
   destroypopup();
   XFreeFont(dpy, font_info);
   XFreeGC(dpy, gcpx);
   XFreeGC(dpy, gcpxr);
   XFreeGC(dpy, gcpxor);
   XDestroyWindow(dpy, wmain.win);
   XCloseDisplay(dpy);
   killallshapes();
   if (zplookup != NULL) free(zplookup);
   printf("\nFond farewell\n");
}


void makeviews(int ww, int hh, int dd)
{
   int j;

   height = hh/2;
   width = ww - height;
   views[0].w = height; views[0].h = height;
   views[0].x = width; views[0].y = 0;
   views[1].w = height; views[1].h = height;
   views[1].x = width; views[1].y = height;
   views[2].w = width; views[2].h = height;
   views[2].x = 0; views[2].y = 0;
   views[3].w = width; views[3].h = height;
   views[3].x = 0; views[3].y = height;

   for (j=0; j<4; j++) {
#ifdef XSSUSEPM
      views[j].d = XCreatePixmap(dpy, wmain.win, views[j].w, views[j].h, dd);
      DIEIF(views[j].d == None, "Could not create view pixmap\n");
#else
      views[j].d = wmain.win;
#endif
   }
}


void initcontrol(int fg, int bg)
{
   int j;

   for (j=0; j<cpbno; j++) {
      cpb[j].d = XCreateSimpleWindow(dpy, wcp.win, cpb[j].x, cpb[j].y,
				     cpb[j].w, cpb[j].h, 1, fg, bg);
      DIEIF(cpb[j].d == None, "Could not create control window\n");
      XSelectInput(dpy, cpb[j].d, NoEventMask);
   }

   curspad[0].d = XCreatePixmapFromBitmapData(dpy, wcp.win, (char *) tran_bits,
					     curspad[0].w, curspad[0].h,
					     fg, bg, depth);
   DIEIF(curspad[0].d == None, "Could not create cursor pad pixmap\n");
   curspad[1].d = XCreatePixmapFromBitmapData(dpy, wcp.win, (char *) turn_bits,
					     curspad[1].w, curspad[1].h,
					     fg, bg, depth);
   DIEIF(curspad[1].d == None, "Could not create cursor pad pixmap\n");
   for (j = 0; j<6; j++) {
      XFillRectangle(dpy, curspad[0].d, gcpxr, tran[j].x, tran[j].y, 19, 19);
      XDrawRectangle(dpy, curspad[0].d, gcpx, tran[j].x, tran[j].y, 19, 19);
      XFillRectangle(dpy, curspad[1].d, gcpxr, turn[j].x, turn[j].y, 19, 19);
      XDrawRectangle(dpy, curspad[1].d, gcpx, turn[j].x, turn[j].y, 19, 19);
   }

   XSelectInput(dpy, wcp.win, ButtonPressMask | ButtonReleaseMask |
		ExposureMask | OwnerGrabButtonMask |
		KeyPressMask | KeyReleaseMask);
   XMapSubwindows(dpy, wcp.win);
   XMapWindow(dpy, wcp.win);
}


void drawcontrol(void)
{
   int font_a, font_d, font_h, strl, strw;
   int linepos, colpos;
   int j, delta;
   const char *stra;
   static const char *strings[] = {
      "Quit",
      "Translate",  /* 1: state 1-7*/
      "Turn",
      "Magnify",
      "Axis",
      "Clip",
      "Projection",
      "B Box",
      "Write Bitmap", /* 3: output 8-9 */
      "Save xss",
      "Merge",       /* 4: object 10-15 */
      "Load",
      "Clone",
      "Delete",
      "Other",
      "Initialise",
      "-",          /* 5: magnify 16-18 */
      "Mag",
      "+",
      NULL
   };

   void clickstate(int );

   font_a = font_info->ascent;
   font_d = font_info->descent;
   font_h = font_a + font_d;

   /* quit */
   XClearWindow(dpy, cpb[0].d);
   stra = strings[0];
   strl = strlen(stra);
   strw = XTextWidth(font_info, stra, strl);
   colpos = cpb[0].w/2 - strw/2;
   linepos = cpb[0].h/2 - font_h/2 - font_d;
   linepos += font_h;
   XDrawString(dpy, cpb[0].d, gcpx, colpos, linepos, stra, strl);

   /* state */
   XClearWindow(dpy, cpb[1].d);
   delta = cpb[1].h/7;
   linepos = 0;
   for (j=0; j<6; j++) {
      linepos += delta;
      XDrawLine(dpy, cpb[1].d, gcpx, 0, linepos, cpb[1].w, linepos);
   }
   linepos = -delta/2  + font_h/2 - font_d;
   for (j=1; j<8; j++) {
      stra = strings[j];
      strl = strlen(stra);
      strw = XTextWidth(font_info, stra, strl);
      colpos = cpb[1].w/2 - strw/2;
      linepos += delta;
      XDrawString(dpy, cpb[1].d, gcpx, colpos, linepos, stra, strl);
   }

   /* direction */
   clickstate(2);
   if (xss.clip) clickstate(1);
   if (xss.axis) clickstate(0);
   if (xss.proj) clickstate(3);


   /* output */
   XClearWindow(dpy, cpb[3].d);
   delta = cpb[3].h/2;
   linepos = 0;
   for (j=0; j<1; j++) {
      linepos += delta;
      XDrawLine(dpy, cpb[3].d, gcpx, 0, linepos, cpb[3].w, linepos);
   }
   linepos = -delta/2  + font_h/2 - font_d;
   for (j=8; j<10; j++) {
      stra = strings[j];
      strl = strlen(stra);
      strw = XTextWidth(font_info, stra, strl);
      colpos = cpb[3].w/2 - strw/2;
      linepos += delta;
      XDrawString(dpy, cpb[3].d, gcpx, colpos, linepos, stra, strl);
   }

   /* object */
   XClearWindow(dpy, cpb[4].d);
   delta = cpb[4].h/6;
   linepos = 0;
   for (j=0; j<5; j++) {
      linepos += delta;
      XDrawLine(dpy, cpb[4].d, gcpx, 0, linepos, cpb[4].w, linepos);
   }
   linepos = -delta/2  + font_h/2 - font_d;
   for (j=10; j<16; j++) {
      stra = strings[j];
      strl = strlen(stra);
      strw = XTextWidth(font_info, stra, strl);
      colpos = cpb[4].w/2 - strw/2;
      linepos += delta;
      XDrawString(dpy, cpb[4].d, gcpx, colpos, linepos, stra, strl);
   }

   /* magnify */
   XClearWindow(dpy, cpb[5].d);
   delta = cpb[5].w/3;
   linepos = 0;
   for (j=0; j<2; j++) {
      linepos += delta;
      XDrawLine(dpy, cpb[5].d, gcpx, linepos, 0, linepos, cpb[4].h);
   }
   linepos = cpb[5].h/2 + font_h/2 - font_d;
   colpos = delta/2;
   for (j=16; j<19; j++) {
      stra = strings[j];
      strl = strlen(stra);
      strw = XTextWidth(font_info, stra, strl);
      colpos -= strw/2;
      XDrawString(dpy, cpb[5].d, gcpx, colpos, linepos, stra, strl);
      colpos += delta + strw/2;
   }
}


/* respond to mouse clicks visually */
int clickbox(int box, int coord)
{
   int delta;

   switch(box) {
    case 0:
      XFillRectangle(dpy, cpb[0].d, gcpxor, 0, 0, cpb[0].w, cpb[0].h);
      break;
    case 1:
      delta = cpb[1].h/7;
      coord -= cpb[1].y;
      coord /= delta;
      if (coord < 7) {
	 XFillRectangle(dpy, cpb[1].d, gcpxor, 0, coord*delta,
			cpb[1].w, delta);
      }
      break;
    case 3:
      delta = cpb[3].h/2;
      coord -= cpb[3].y;
      coord /= delta;
      if (coord < 2) {
	 XFillRectangle(dpy, cpb[3].d, gcpxor, 0, coord*delta,
			cpb[3].w, delta);
      }
      break;
    case 4:
      delta = cpb[4].h/6;
      coord -= cpb[4].y;
      coord /= delta;
      if (coord < 6) {
	 XFillRectangle(dpy, cpb[4].d, gcpxor, 0, coord*delta,
			cpb[4].w, delta);
      }
      break;
    case 5:
      delta = cpb[5].w/3;
      coord -= cpb[5].x;
      coord /= delta;
      switch(coord) {
       case 0:
	 XFillRectangle(dpy, cpb[5].d, gcpxor, 0, 0, delta, cpb[5].h);
	 break;
       case 2:
	 XFillRectangle(dpy, cpb[5].d, gcpxor, 2*delta, 0, delta, cpb[5].h);
	 break;
       default:
	 return -1;
      }
      break;
    default:
      return -1;
   }
   return coord;
}


void clickstate(int subbox)
{
   int delta = cpb[1].h/7;

   switch(subbox) {
    case 0: /* axis stuff */
      XFillRectangle(dpy, cpb[1].d, gcpxor, 0, xss.turn*delta,
		     cpb[1].w, delta);
      XFillRectangle(dpy, cpb[1].d, gcpxor, 0, delta, cpb[1].w, delta);
      XFillRectangle(dpy, cpb[1].d, gcpxor, 0, 3*delta, cpb[1].w, delta);
      XClearWindow(dpy, cpb[2].d);
      XCopyArea(dpy, curspad[1].d, cpb[2].d, gcpx, 0, 0,
		cpb[2].w, cpb[2].h, 0, 0);
      break;
    case 1: /* clip */
      XFillRectangle(dpy, cpb[1].d, gcpxor, 0, 4*delta, cpb[1].w, delta);
      break;
    case 2: /* turn, have to use twice */
      XFillRectangle(dpy, cpb[1].d, gcpxor, 0, xss.turn*delta,
		     cpb[1].w, delta);
      XClearWindow(dpy, cpb[2].d);
      if (xss.turn == 1) {
	 XCopyArea(dpy, curspad[1].d, cpb[2].d, gcpx, 0, 0,
		   cpb[2].w, cpb[2].h, 0, 0);
      } else {
	 XCopyArea(dpy, curspad[0].d, cpb[2].d, gcpx, 0, 0,
		   cpb[2].w, cpb[2].h, 0, 0);
      }
      break;
    case 3: /* proj */
      XFillRectangle(dpy, cpb[1].d, gcpxor, 0, 5*delta, cpb[1].w, delta);
      break;
    default:
      break;
   }
}


int clickpad(int x, int y, int mode)
{
   int cx, cy, ri, rm, rr;
   Xss_b *button;

   Xss_b *curspadtoindex(int , int , int *);

   button = curspadtoindex(x-cpb[2].x, y-cpb[2].y, NULL);
   if (button == NULL) return -1;
   cx = button->x+10;
   cy = button->y+10;
   rm = cpb[2].w*2;
   ri = rm/((mode) ? 5*PADRAD : PADRAD);
/* printf("diameter is %d \n", ri); */
   for (rr = ri; rr<rm; rr += ri) {
      cx -= ri/2;
      cy -= ri/2;
      XDrawArc(dpy, cpb[2].d, gcpx, cx, cy, rr, rr, 0, 23040);
   }
   return 0;
}


void writehelp(void)
{
   int font_a, font_d, font_h, strl, strw;
   int linepos, colpos;
   int i;
   const char **sptr;
   static const char *strings[] = {
      "**** Keys for xss ****",
      " ",
      "(q) to Quit",
      "(h) to get Help",
      "(w) to Write frame as bitmap",
      "(s) to Save scene to xss file",
      "(f) to insert scene from another xss File",
      "(r) to clone cuRrent object",
      "(l) to Load new object",
      "(d) to Delete object",
      "(o) to switch to another Object",
      "(i) to Initialise object",
      "(b) to use Bounding box",
      "(c) to un/Clip scene",
      "(p) to change Projection scheme",
      "(m) to Magnify",
      "(n) to Shrink",
      "(t) to Turn/magnify/translate object",
      "(a) to toggle Axis definition mode",
      "(v) to toggle Verbosity",
      " ",
      "Rotation about",
      "  x axis: - (Up)   + (Down)",
      "  y axis: - (Left) + (Right)",
      "  z axis: + (,<)   - (.>)",
      "Translation along or magnification in",
      "  x axis: - (Left) + (Right)",
      "  y axis: + (Up)   - (Down)",
      "  z axis: + (,<)   - (.>)",
      " ",
      "When using the movement keys,",
      "holding down shift increases the",
      "effect fivefold.",
      NULL
   };
   font_a = font_info->ascent;
   font_d = font_info->descent;
   font_h = font_a + font_d;

   XFillRectangle(dpy, whp.pix, gcpxr, 0, 0, whp.w, whp.h);
   strw = 0;
   for (i=0, sptr=strings; *sptr != NULL; i++, sptr++) {
      strl = XTextWidth(font_info, *sptr, strlen(*sptr));
      if (strl > strw) strw = strl;
   }

   colpos = whp.w/2 - strw/2;
   linepos = whp.h/2 - (i*font_h)/2 - font_d;
   for (sptr=strings; *sptr != NULL; sptr++) {
      linepos += font_h;
      XDrawString(dpy, whp.pix, gcpx, colpos, linepos, *sptr, strlen(*sptr));
   }
}


void writeinfo(int cur, int load, char *name)
{
   int font_a, font_d, font_h, strl, strw;
   int linepos;
   int i, ox;
   const char *stra;
   char *strb;
   static const char *strings[] = {
      "Xss by Peter Chang",
      " ",
      "Copyright 1994",
      " ",
      " ",
      NULL
   };

   font_a = font_info->ascent;
   font_d = font_info->descent;
   font_h = font_a + font_d;

#ifdef XSSUSEPM
   linepos = views[0].h/8 + font_a - font_h;
   ox = 0;
#else
   linepos = views[0].y + views[0].h/8 + font_a - font_h;
   ox = views[0].x;
#endif
   stra = strings[0];
   for (i=0; stra != NULL; i++, stra = strings[i]) {
      linepos += font_h;
      strl = strlen(stra);
      strw = XTextWidth(font_info, stra, strl);
      XDrawString(dpy, views[0].d, gcpx, ox+(views[0].w-strw)/2,
		  linepos, stra, strl);
   }

   DIEIF((strb = (char *) malloc(LLEN)) == NULL,
	 "Couldn't allocate memory for string\n");
   sprintf(strb, "Current object is %s (%d)%s",
	   shapes[cur].fname, cur, shapes[cur].bbox ? "*" : "");
   linepos += font_h;
   strl = strlen(strb);
   strw = XTextWidth(font_info, strb, strl);
   XDrawString(dpy, views[0].d, gcpx, ox+(views[0].w-strw)/2,
	       linepos, strb, strl);

   if (load) sprintf(strb, "%s.xss loaded", name);
   else sprintf(strb, "No xss file loaded");
   linepos += 2*font_h;
   strl = strlen(strb);
   strw = XTextWidth(font_info, strb, strl);
   XDrawString(dpy, views[0].d, gcpx, ox+(views[0].w-strw)/2,
	       linepos, strb, strl);

   sprintf(strb, "Press h or click on window for help");
   linepos += 3*font_h;
   strl = strlen(strb);
   strw = XTextWidth(font_info, strb, strl);
   XDrawString(dpy, views[0].d, gcpx, ox+(views[0].w-strw)/2,
	       linepos, strb, strl);

   free(strb);
}


void getangles(void)
{
   phi = raxis.x*raxis.x + raxis.y*raxis.y + raxis.z*raxis.z;
   phi = 1.0/sqrt(phi);
   raxis.x *= phi;
   raxis.y *= phi;
   raxis.z *= phi;
   theta = acos(raxis.z);
   phi = atan2(raxis.y, raxis.x);
   printf("New rotation angles (in degrees): t=%7.2f p=%7.2f\n",
	  (theta*180.0/PI), (phi*180.0/PI));
}


/* button press */
int handlebuttonsp(int box, XButtonEvent *bev)
{
   int clickbox(int , int );
   int clickpad(int , int , int );

   switch(box) {
    case 0: case 1: case 3: case 4:
      return clickbox(box, bev->y);
    case 2:
      return clickpad(bev->x, bev->y,
		      (bev->button == Button3 || xss.inch > 0.02));
    case 5:
      return clickbox(box, bev->x);
    default:
      return -1;
   }
}


/* button release */
int handlebuttonsr(int box, XButtonEvent *bev, int ox, int oy, int obox,
		   int cur, Object *cshape, int verbose)
{
   int  i = cur, j, x, y;
   int  sbox = 0;
   int  dir;
   int  deltax, deltay;
   float degree, inch, mag;
   int  mode, num;

   void axisrot(float , float , float );
   void quitxss(void);
   void clickstate(int );
   float dirtotheta(int );
   float dirtophi(int );
   void magnifydir(int , float , Object *);
   void translatedir(int , float , Object *);
   Xss_b *curspadtoindex(int , int , int *);
   int curspadtodir(int , int );
   void changeproj(void);
   int clickbox(int , int );

   switch(obox) {
    case 0: case 1: case 3: case 4:
      sbox = clickbox(obox, oy);
      break;
    case 2:
      if (xss.turn==1 || xss.axis==1) {
	 XCopyArea(dpy, curspad[1].d, cpb[2].d, gcpx, 0, 0,
		   cpb[2].w, cpb[2].h, 0, 0);
      } else {
	 XCopyArea(dpy, curspad[0].d, cpb[2].d, gcpx, 0, 0,
		   cpb[2].w, cpb[2].h, 0, 0);
      }
      break;
    case 5:
      sbox = clickbox(obox, ox);
      break;
    default:
      return -1;
   }

   if (obox != box) return -1;

   mode = (bev->button == Button3 || xss.inch > 0.02);
   degree = PI / 180.0;
   inch = 0.01;
   mag = 1.01;

   x = bev->x;
   y = bev->y;
/* printf("Pressed button %d with key %d, coords %d,%d\n",
	  button, bno, x, y); */

   xss.redraw = 1;
   switch(box) {
    case 0: /* quit */
      quitxss();
      exit(EXIT_SUCCESS);
      break;
    case 1: /* state */
      deltay = cpb[1].h/7;
      y -= cpb[1].y;
      y /= deltay;
      if (y != sbox) return -1;
      switch(y) {
       case 0: case 1: case 2:
	 xss.redraw = 0;
	 if (xss.axis) {
	    xss.axis = 1 - xss.axis;
	    clickstate(0);
	 }
	 clickstate(2);
	 xss.turn = y;
	 clickstate(2);
	 break;
       case 3:
	 xss.axis = 1 - xss.axis;
	 clickstate(0);
	 break;
       case 4:
	 xss.clip = 1 - xss.clip;
	 clickstate(1);
	 break;
       case 5:
	 xss.proj = 1 - xss.proj;
	 changeproj();
	 clickstate(3);
	 break;
       case 6:
	 cshape->bbox = 1 - cshape->bbox;
	 break;
       default:
	 return -1;
      }
      break;
    case 2: /* cursor pad */
      x -= cpb[2].x;
      y -= cpb[2].y;
      ox -= cpb[2].x;
      oy -= cpb[2].y;

      {
	 Xss_b *button;

	 button = curspadtoindex(ox, oy, NULL);
	 if (button == NULL) return -1;
	 x -= button->x+10;
	 y -= button->y+10;
      }

      dir = curspadtodir(ox, oy);
      if (dir == 0) return -1;
      else {
	 int ss, si, st;
	 ss = x*x + y*y;
	 si = cpb[2].w/((mode) ? 5*PADRAD : PADRAD);
/* printf("radius is %d (%d)\n", si, ss); */
	 st = si;
	 num = 1;
	 while((st*st) < ss) {
	    st += si;
	    num++;
	 }
/* printf("number of increments %d \n", num); */
	 if (xss.axis==1 || xss.turn==1) {
	    degree *= (dir < 0) ? -num : num;
	    if (xss.axis==1) axisrot(dirtotheta(dir), dirtophi(dir), degree);
	    else rotate(cshape, 1, dirtotheta(dir), dirtophi(dir), degree);
	 } else {
	    switch(xss.turn) {
	     case 0:
	       translatedir(dir, num*inch, cshape);
	       break;
	     case 2:
	       inch = 1.0;
	       while (num-- > 0) inch *= mag;
	       magnifydir(dir, inch, cshape);
	       break;
	     default:
	       return -1;
	    }
	 }
      }
      break;
    case 3: /* output */
      deltay = cpb[3].h/2;
      y -= cpb[3].y;
      y /= deltay;
      if (y != sbox) return -1;
      switch(y) {
       case 0:
	 xss.inout = 2;
	 break;
       case 1:
	 xss.inout = 3;
	 break;
       default:
	 return -1;
      }
      break;
    case 4: /* object */
      deltay = cpb[4].h/6;
      y -= cpb[4].y;
      y /= deltay;
      if (y != sbox) return -1;
      switch(y) {
       case 0: /* merge xss */
	 xss.inout = 4;
	 break;
       case 1: /* load new polyh */
	 xss.inout = 1;
	 break;
       case 2: /* clone current polyh */
	 xss.inout = 5;
	 break;
       case 3: /* delete, note: this runs on to next case */
	 cshape->hidden = 1;
	 if (verbose) printf("deleted current object was %s (%d)\n",
			     shapes[i].fname, i);
       case 4: /* move to next object (cycle once through) */
	 for (j=0; j<nobj; j++) {
	    i = (i+1) % nobj;
	    if (shapes[i].hidden == 0) break;
	 }
	 if (verbose) printf("changed current object to %s (%d)\n",
			     shapes[i].fname, i);
	 break;
       case 5: /* reinitialise */
	 reinitobj(cshape);
	 break;
       default:
	 return -1;
      }
      break;
    case 5: /* magnify */
      deltax = cpb[5].w/3;
      x -= cpb[5].x;
      x /= deltax;
      inch = 1.0;
      num = (mode) ? 5 : 1;
      while (num-- > 0) inch *= mag;
      if (x != sbox) return -1;
      switch(x) {
       case 0:
	 magnify(cshape, 1, 0, 1.0/inch);
	 if (verbose) printf("shrank points\n");
	 break;
       case 1:
	 break;
       case 2:
	 magnify(cshape, 1, 0, inch);
	 if (verbose) printf("magnified points\n");
	 break;
       default:
	 return -1;
      }
      break;
    default:
      return -1;
   }
   return i;
}


/* translate pointer coordinates to an index */
Xss_b *curspadtoindex(int x, int y, int *ib)
{
   int tx, ty, j;
   Xss_b *button;

   button = (xss.axis==1 || xss.turn==1) ? turn : tran;

   for (j=0; j<6; j++, button++) {
      tx = x - button->x;
      ty = y - button->y;
      if ( tx >= 0 && tx < 20 && ty >=0 && ty < 20) break;
   }
   if (ib != NULL) *ib = j;
   return (j<6) ? button : NULL;
}


/* translate pointer coordinates to a direction */
int curspadtodir(int x, int y)
{
   int i;
   Xss_b *curspadtoindex(int , int , int *);

   curspadtoindex(x, y, &i);
   switch(i) {
    case 0:
      return -3;
    case 1:
      return -2;
    case 2:
      return -1;
    case 3:
      return 1;
    case 4:
      return 2;
    case 5:
      return 3;
    default:
      return 0;
   }
}


int handlekeys(KeySym key, int cur, Object *cshape, int verbose)
{
   int  i = cur;
   int j;
   int dir = 0;

   void axisrot(float , float , float );
   void dirprint(int );
   float dirtotheta(int );
   float dirtophi(int );
   void magnifydir(int , float , Object *);
   void translatedir(int , float , Object *);
   void changeproj(void);

   xss.redraw = 1;
   switch(key) {
    case XK_b: case XK_B:
      cshape->bbox = 1 - cshape->bbox;
/*      printf("toggled bounding box\n"); */
      break;
    case XK_c: case XK_C:
      xss.clip = 1 - xss.clip;
      clickstate(1);
      printf("toggled clip\n");
      break;
    case XK_p: case XK_P:
      xss.proj = 1 - xss.proj;
      changeproj();
      clickstate(3);
      printf("toggled projection\n");
      break;
    case XK_t: case XK_T:
      xss.redraw = 0;
      clickstate(2);
      xss.turn = (xss.turn+1) % 3;
      clickstate(2);
      printf("toggled turn\n");
      break;
    case XK_a: case XK_A:
      if (xss.axis) getangles();
      xss.axis = 1 - xss.axis;
      clickstate(0);
      printf("toggled axis\n");
      break;
    case XK_i: case XK_I:
      reinitobj(cshape);
      printf("initialised points\n");
      break;
    case XK_d: case XK_D: /* note: this runs on to next case */
      cshape->hidden = 1;
      if (verbose) printf("deleted current object was %s (%d)\n",
			  shapes[i].fname, i);
    case XK_o: case XK_O:
      for (j=0; j<nobj; j++) {
	 i = (i+1) % nobj;
	 if (shapes[i].hidden == 0) break;
      }
      if (verbose) printf("changed current object to %s (%d)\n",
			  shapes[i].fname, i);
      break;
    case XK_m: case XK_M:
      magnify(cshape, 1, 0, xss.mag);
      if (verbose) printf("magnified points\n");
      break;
    case XK_n: case XK_N:
      magnify(cshape, 1, 0, 1.0/xss.mag);
      if (verbose) printf("shrank points\n");
      break;
    case XK_Left: case XK_Right: case XK_Up: case XK_Down:
    case XK_greater: case XK_comma: case XK_period: case XK_less:
      if (xss.axis==1 || xss.turn==1) {
	 if (verbose) printf("rotated about ");
	 switch(key) {
	  case XK_Left:
	    dir = -2;
	    break;
	  case XK_Right:
	    dir = 2;
	    break;
	  case XK_Up:
	    dir = -1;
	    break;
	  case XK_Down:
	    dir = 1;
	    break;
	  case XK_less: case XK_comma:
	    dir = 3;
	    break;
	  case XK_greater: case XK_period:
	    dir = -3;
	    break;
	 }
	 if (xss.axis==1) axisrot(dirtotheta(dir), dirtophi(dir),
				  (dir > 0) ? xss.degree : -xss.degree);
	 else rotate(cshape, 1, dirtotheta(dir), dirtophi(dir),
		     (dir > 0) ? xss.degree : -xss.degree);
      } else {
	 switch(xss.turn) {
	  case 2: case 0:
	    if (verbose) {
	       if (xss.turn == 2) printf("magnified in ");
	       else printf("translated along ");
	    }
	    switch(key) {
	     case XK_Left:
	       dir = -1;
	       break;
	     case XK_Right:
	       dir = 1;
	       break;
	     case XK_Up:
	       dir = 2;
	       break;
	     case XK_Down:
	       dir = -2;
	       break;
	     case XK_less: case XK_comma:
	       dir = 3;
	       break;
	     case XK_greater: case XK_period:
	       dir = -3;
	       break;
	    }
	    if (xss.turn == 2) magnifydir(dir, xss.mag, cshape);
	    else translatedir(dir, xss.inch, cshape);
	    break;
	  default:
	    break;
	 } /* end of xss.turn */
      }
      if (verbose) dirprint(dir);
      break; /* end of case arrow keys */
    default:
      break;
   }
   return i;
}


void changeproj(void)
{
   void makeviews(int , int , int );

   if (xss.proj) {
#ifdef XSSUSEPM
      int j;
      for (j=0; j<4; j++) XFreePixmap(dpy, views[j].d);
      wmain.pix = XCreatePixmap(dpy, wmain.win, wmain.w, wmain.h, depth);
      DIEIF(wmain.pix == None, "Could not create main pixmap\n");
#else
      wmain.pix = wmain.win;
#endif
      width = wmain.w;
      height = wmain.h;
      lookup(1); /* set up lookup table */
   } else {
#ifdef XSSUSEPM
      XFreePixmap(dpy, wmain.pix);
#endif
      makeviews(wmain.w, wmain.h, depth);
   }
}


float dirtotheta(int dirn)
{
   switch(dirn) {
    case -1: case 1:
    case -2: case 2:
      return PI/2.0;
    case -3: case 3:
      return 0.0;
    default:
      break;
   }
   return 0.0;
}


float dirtophi(int dirn)
{
   switch(dirn) {
    case -1: case 1:
    case -3: case 3:
      return 0.0;
    case -2: case 2:
      return PI/2.0;
    default:
      break;
   }
   return 0.0;
}


void magnifydir(int dirn, float factor, Object *pobj)
{
   if (dirn < 0) {
      magnify(pobj, 1, -dirn, 1.0/factor);
   } else {
      magnify(pobj, 1, dirn, factor);
   }
}


void translatedir(int dirn, float inch, Object *pobj)
{
   if (dirn < 0) {
      translate(pobj, 1, -dirn, -inch);
   } else {
      translate(pobj, 1, dirn, inch);
   }
}


void dirprint(int dirn)
{
   switch(dirn) {
    case -1: case 1:
      printf("x");
      break;
    case -2: case 2:
      printf("y");
      break;
    case -3: case 3:
      printf("z");
      break;
    default:
      break;
   }

   if (dirn < 0) printf(" -\n");
   else printf(" +\n");
}


void axisrot(float ltheta, float lphi, float lalpha)
{
   float kl, km, kn, rac, rat, ras;
   float temp, xr, yr;

   kl = sin(ltheta) * cos(lphi);
   km = sin(ltheta) * sin(lphi);
   kn = cos(ltheta);
   rac = cos(lalpha);
   rat = 1.0-rac;
   ras = sin(lalpha);

   temp = kl*raxis.x + km*raxis.y + kn*raxis.z;
   xr = raxis.x*rac + rat*temp*kl + ras*(km*raxis.z-kn*raxis.y);
   yr = raxis.y*rac + rat*temp*km + ras*(kn*raxis.x-kl*raxis.z);
   raxis.z = raxis.z*rac + rat*temp*kn + ras*(kl*raxis.y-km*raxis.x);
   raxis.x = xr;
   raxis.y = yr;
}


/*
 * Parse the command line set the filename and the appropriate flags
 */
void pcl(int argc, char **argv, char *fname)
{
   static const char *options[] =  {
      "-help                     print this message",
      "-display <display>            X display name",
      "-font <name>                     X font name",
      "-geometry <geometry>              X geometry",
      NULL
   };
   static const char usage1[] = "usage: xss [options] <polyh or xss file>";
   static const char usage2[] = " try xss -help for a list of option";
   
   int i, optno, fvalid = 0, olen;
   const char **sptr;
   
   for (i = 1; i < argc; i++) {
      olen = strlen(argv[i]);
      for (sptr = options, optno = 0; *sptr != NULL; sptr++, optno++)
         if (strncmp(argv[i], *sptr, olen) == 0) break;
      
      switch(optno)  {
       case 0:
	 printf("%s\n", usage1);
	 printf("Options (defaults in parenthesis):\n");
	 for (sptr = options; *sptr != NULL; sptr++) printf(" %s\n", *sptr);
	 printf("\n");
	 exit(EXIT_SUCCESS);
	 break;
       case 1:
	 dispname = argv[++i];
	 break;
       case 2:
	 fontname = argv[++i];
	 break;
       case 3:
	 geometry = argv[++i];
	 break;
       default:
	 if (!fvalid && *argv[i] != '-')  {
	    strcpy(fname, argv[i]);
	    fvalid = 1;
	 } else  {
	    DIE4("%s\n%s\n", usage1, usage2);
	 }
	 break;
      }
   }
   
   DIEIF4(fvalid != 1, "%s\n%s\n", usage1, usage2);
}
