/*
 * zbuffer.h - header for zbuffer.c

 * Copyright 1994, 16th November.
 * By Peter Chang
 * peterc@v2.ph.man.ac.uk

 * See notice in misc.h for details of permissions and warranty of this
 * software.

 *
 * $Log: zbuffer.h,v $
 * Revision 2.6  1994/11/18  04:03:18  peter
 * xpgs-2.5-patch 01: Changes in header files for clean compile
 *
 * Revision 2.5.1.1  1994/11/17  03:34:32  peter
 * Import of actual public release of xpgs-2.5: lots of cosmetic changes to docs
 *
 * Revision 2.5  1994/11/16  09:19:39  peter
 * Putting xpgs-2.5 in trunk.
 *
 * Revision 2.0.1.1  1994/11/16  09:10:32  peter
 * Import of xpgs-2.5: archive of new release to alt.sources (11/94)
 *
 *
 */

#include "polyh.h"

#ifndef ZBLINES
/* default number of lines to use in each z-buffer */
#define ZBLINES 256
#endif
extern int buf_h, buf_top, buf_bot;

int sfillall(int yy, int **zbufa, int **zbufb, float mf, Affine *gt);
int zfillall(int yy, int **zbuf, float mf, Affine *gt);
int zsfillall(int yy, int *zmap, int **zbufa, int **zbufb, int x, int y,
	      int xs, int ys);
int **zmema(void);
void zmemf(int **zbuffer);


extern float background;
extern float enlarge;
extern int   fineness;
extern int   reverse;
