
#include "params.h"
#include "headers.h"
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>

#include <stdio.h>

#define BITMAPDEPTH 1
#define MAX_COLORS 3
#define CANNOT_OVERLAY 0
#define CAN_OVERLAY 1

/*
Display and screen_num are used as arguments to
nearly every Xlib routine, so it simplifies
routine calls to declare them global.  If there
were additional source files, these variables
would be declared extern in them.
*/

int	gold_X, gold_Y, gold_Z, gold[25];
Display *display;
int screen_num;
extern int get_colors();

/* pixel values */
unsigned long
	foreground,
	background_pixel,
	overlay_pixel_1,
	overlay_pixel_2;

/* passed back from get_color */
unsigned long overlay_plane_mask;

/* values for window_size in main, is window big enough to be useful? */
#define SMALL 1
#define OK 0

double sqrt();
typedef struct { double  real, imag; } complex;

#define ADD(A,B,C)      { C.real=A.real+B.real; C.imag=A.imag+B.imag; }

#define SUB(A,B,C)      { C.real=A.real-B.real; C.imag=A.imag-B.imag; }

#define MUL(A,B,C)      { C.real=A.real*B.real-A.imag*B.imag;\
C.imag=A.real*B.imag+A.imag*B.real; }

#define INV(A,C)        { double tmp = A.real*A.real+A.imag*A.imag;\
									      if(tmp<=0.001)tmp=0.001;C.real=A.real/tmp;\
	C.imag=-A.imag/tmp; }

#define ABS(A,R)        { R = A.real*A.real+A.imag*A.imag; }

#define EXP(A,C)        { double tmp = exp(A.real);\
																			  C.real = tmp*cos(A.imag);\
																			C.imag = tmp*sin(A.imag); }

#define	min(A,B)	((A)<(B)?(A):(B))
#define	max(A,B)	((A)>(B)?(A):(B))
