#include "image.h"
#include "params.h"

/* Remote variables */
extern Display *theDisplay;

/* function prototypes */
Window openWindow();
void main();
void drawRectangle();
void drawLine();
void getXInfo();

void main( argc, argv ) int argc; 
char * argv[];
{
	Window theWindow;
	GC theGC, whiteGC, the2GC;
	XGCValues theGCValues;


	int /* the functions currently available */
	(*func)(),
	nothing(),
	poly_root(),
	julia_set(),
	julia_expf(),
	julia_set_3(),
	cube_roots(),
	mandel();

	XEvent report;

	int await_user = 0;
	int window_width, window_height;

	/* This starts the tutorial demo */

	params( argc, argv );

	theGCValues.foreground = theWhitePixel;
	theGCValues.background = theBlackPixel;


	window_width = init_wide;
	window_height = init_tall;

	/* Connect to the XWindow server, get X information */
	initX();

	/* Open an X Window */
	theWindow = openWindow
	    (300,100,window_width,window_height,0,&theGC,&the2GC);

	whiteGC = XCreateGC
	    ( theDisplay, theWindow,
	    (GCForeground | GCBackground), &theGCValues);

	/* Select event types wanted */
	XSelectInput( theDisplay, theWindow, ExposureMask | KeyPressMask | 
			ButtonPressMask | ButtonReleaseMask | StructureNotifyMask);

	if(slow) XSynchronize(theDisplay, True);

	func = mandel;
	while( 1 ) {
		XNextEvent(theDisplay, &report);

		switch  (report.type) {

		case Expose:
			/* get all other Expose events on the queue */
			while (XCheckTypedEvent(theDisplay, Expose, &report));
			break;
#ifdef WHAT
		case ConfigureNotify:
			/* window has been resized, change width and
                               * height to send to place_text and place_graphics
                               * in next Expose */
			width = report.xconfigure.width;
			height = report.xconfigure.height;
			if ((width < size_hints.min_width) ||
			    (height < size_hints.min_height))
				window_size = SMALL;
			else
				window_size = OK;
			break;
#endif
		case ButtonPress:
			/*left_button(win,overlay_gc,width,height);*/
			plot( func, theWindow, theGC, whiteGC, window_width, window_height);
			break;
#ifdef RELEASE
            case ButtonRelease:
                      remove_overlay(win, clear_gc, width, height);
                      break;
#endif
		default:
			break;
		}
	}


	/* Clear out any commands that may not have been drawn yet */
	XFlush(theDisplay);

	/* Either wait for keystroke, or just terminate */

	if( await_user )
	{
		char dummy;
		scanf( "%c", &dummy );
		scanf( "%c", &dummy );
	}
	else sleep(10);

	/* Be nice and destroy the window for X */
	XDestroyWindow(theDisplay, theWindow);

	/* Disconnect from the X server */
	quitX();

}
