/*
 *
SURF: an X application to fine-tune, monitor, and control numerical simulations.
 *		Version 1.0
 * $Log:	draw.c,v $
 * Revision 1.3  94/05/26  22:28:23  22:28:23  wzhao (Weimin Zhao)
 * Release 1.02
 * Added two more axis systems, two more key commands, new meaning of "n".
 * 
 * Revision 1.2  94/05/11  01:07:59  01:07:59  wzhao (Weimin Zhao)
 * Fixed rcs header stuff
 * 
 *
 *    Copyright (C) 1994 Weimin Zhao
 *
*/
/*
    This program and upon which the library is built are free software;
    you can redistribute it and/or modify it under the terms of the GNU
    General Public License (GPL) and Library General Public License (LGPL)
    as published by the Free Software Foundation; either version 2 of the
    License, or any later version.

    This program and the library are distributed in the hope that it will
    be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*
 *	Bug reports to 		wzhao@mcs.kent.edu
 *		Weimin Zhao
 *		Liquid Crystal Institute, Kent State University, Kent, OH 44242, USA
*/
/*
#define		COLOR_V		75.0
#define		COLOR_V_min	30.0
#define		COLOR_V_max 85.0
#define		COLOR_C		40.0
#define		COLOR_H_min	180.0
#define		COLOR_H_max	0.0
*/

#include	"surf.h"
#include	"surf.bmp"
#ifdef	HPUX
#	include	<limits.h>
#elif	AIX
#	include	<time.h>
#elif	LINUX
#	include <time.h>
#endif
  
Display		*display;
Window		win;
int			screen_num;
unsigned	width, height; 
XFontStruct	*font;
GC			gc;
long		pxlBW[2], pxlBG[3]; 

/******************************************************************************
*    Local variables
******************************************************************************/
static long			*pixels;
static Colormap		cmap;
static XcmsColor	color;
static int			bar_h;
int					colorNow=-2;
static GC			gcThin;
/*****************************************************************************/

int	rndInt(double x) {
#ifdef HPUX
double flr, cel;
	flr = floor(x); cel = ceil(x);
	if (flr == cel) return (int)flr;
	if (fabs(x-flr) == 0.5) return (x>0)? (int)cel : (int)flr;
	else if(fabs(x-flr) > 0.5 ) return (int)cel;
	else return (int)flr;
#else
	return (int)rint(x);
#endif
}


void DrawArcs(Position3D point) {
XArc	arcs[2];
double	rho, delta_rho;

	delta_rho = (frame.x_max-frame.x_min)/frame.x_div;

	if(point.x == 0.0) {
		XFillArc(display, win, gc, width/2-(int)delta_rho,
			height/2-(int)delta_rho, 2*(int)delta_rho,
			2*(int)delta_rho, 0, 360*64);
		return;
	}
	rho = (frame.x_max-frame.x_min)*(point.x-minPnt.x)/
		(maxPnt.x-minPnt.x);
	arcs[1].x = width/2-(int)rho;
	arcs[1].y = height/2-(int)rho;
	arcs[1].width = arcs[1].height = (int)(2.0*rho);
	arcs[0].x = arcs[1].x - (int)delta_rho;
	arcs[0].y = arcs[1].y - (int)delta_rho;
	arcs[0].width = arcs[0].height = arcs[1].width + (int)(2.0*delta_rho);
	arcs[1].angle1 = arcs[0].angle1 = (int)(64.0*(point.y-minPnt.y));
	arcs[1].angle2 = arcs[0].angle2 = arcs[1].angle1 +
		(int)(64.0*(maxPnt.y-minPnt.y)/frame.y_div);
	XSetFunction(display, gc, GXxor);
	XFillArcs(display, win, gc, arcs, 2);
	XSetFunction(display, gc, GXcopy);
}

void DrawString(char *label, int x, int y, int space_w, char how) {
int	len_label, width_label, xPos;

	len_label = strlen(label);
	width_label = XTextWidth(font, label, len_label);
	switch(how) {
		case 'c': xPos = x+(space_w-width_label)/2; break;
		case 'l': xPos = x; break;
		case 'r': xPos = x-width_label; break;
		default:  break;
	}
	XDrawString(display, win, gc, xPos,
		y-font->descent, label, len_label);
}

void dblPlot(int nA, int nB, double *arrayA, double *arrayB) {
int		i, j, labelW;
XPoint	*pntsA, *pntsB;
double	minA, maxA, radius;
static double	factor1=0.15, factor2=0.85;
static double	factorA=0.15, factorB=0.85, diffAB=0.7, fctr;
char	label[60];

	if(!(pntsA = (XPoint*) malloc(sizeof(XPoint)*nA)))
		DIE("Cannot malloc pntsA in dblPlot!\n");
	if(!(pntsB = (XPoint*) malloc(sizeof(XPoint)*nB)))
		DIE("Cannot malloc pntsB in dblPlot!\n");
	popInfoWin();

	maxA = minA = arrayA[0];
	for(i=0; i<nA; i++) {
		pntsA[i].x = (int)(popWidth*(factor2-factor1)*i/nA
			+factor1*popWidth);
		maxA = maxA >= arrayA[i] ? maxA : arrayA[i];
		minA = minA <= arrayA[i] ? minA : arrayA[i];
	}
	for(i=0; i<nB; i++) {
		pntsB[i].x = (int)(popWidth*(factor2-factor1)*i/nB
			+factor1*popWidth);
		maxA = maxA >= arrayB[i] ? maxA : arrayB[i];
		minA = minA <= arrayB[i] ? minA : arrayB[i];
	}

	for(i=0; i<nA; i++) 
		pntsA[i].y = (int)(factorB*popHeight
				-diffAB*popHeight*(arrayA[i]-minA)/(maxA-minA));
	for(i=0; i<nB; i++) 
		pntsB[i].y = (int)(factorB*popHeight
				-diffAB*popHeight*(arrayB[i]-minA)/(maxA-minA));

	XDrawLine(display, infoWin, gc,
		(int)(factor1*popWidth), (int)(factorB*popHeight),
		(int)(factor1*popWidth), (int)(factorA*popHeight));
	XDrawLine(display, infoWin, gc,
		(int)(factor2*popWidth), (int)(factorB*popHeight),
		(int)(factor2*popWidth), (int)(factorA*popHeight));
	for(i=0; i<=4; i++) {
		sprintf(label, "%.3g", minA + i*(maxA-minA)*.25);
		labelW = XTextWidth(font, label, strlen(label));
		XDrawLine(display, infoWin, gc, (int)(factor1*popWidth),
			(int)(factorB*popHeight-diffAB*popHeight*i*0.25),
			(int)(factor1*popWidth)-10,
			(int)(factorB*popHeight-diffAB*popHeight*i*0.25));
		XDrawString(display, infoWin, gc, (int)(factor1*popWidth)-15-labelW,
			(int)(factorB*popHeight-diffAB*popHeight*i*0.25)+font->ascent/2,
			label, strlen(label));
		XDrawString(display, infoWin, gc, (int)(factor2*popWidth)+15,
			(int)(factorB*popHeight-diffAB*popHeight*i*0.25)+font->ascent/2,
			label, strlen(label));
		XDrawLine(display, infoWin, gc, (int)(factor2*popWidth),
			(int)(factorB*popHeight-diffAB*popHeight*i*0.25),
			(int)(factor2*popWidth)+10,
			(int)(factorB*popHeight-diffAB*popHeight*i*0.25));
	}
	radius = minPnt.x + (maxPnt.x-minPnt.x)*pntrX/(frame.x_max-frame.x_min);
	for(j=0; j<2; j++) {
	XSetForeground(display, gc, pxlBG[1+j]);
	fctr=(1-j)*factorB+j*factorA;
	XDrawLine(display, infoWin, gc, (int)(factor1*popWidth),
		(int)(fctr*popHeight), (int)(factor2*popWidth),
		(int)(fctr*popHeight));
	if(j==0) {
		if (frame.type == 0 || frame.type == 1)
			sprintf(label, "Along Phi=%.3g", pntrY);
		else if(frame.type == 10 || frame.type == 11)
			sprintf(label, "Along Y=%.3g", pntrY);
	}
	else {
		if (frame.type == 0 || frame.type == 1)
			sprintf(label, "Along R=%.3g", radius);
		else if(frame.type == 10 || frame.type == 11)
			sprintf(label, "Along X=%.3g", pntrX);
	}
	labelW=XTextWidth(font, label, strlen(label));
	XDrawString(display, infoWin, gc, (popWidth-labelW)/2,
		(int)(fctr*popHeight+(1-j)*(2*font->ascent+25)-j*(font->ascent+20)),
		label, strlen(label));
	for(i=0; i<=4; i++) {
		sprintf(label, "%.3g", (1-j)*minPnt.x+j*minPnt.y+0.25*i*
			((1-j)*(maxPnt.x-minPnt.x)+j*(maxPnt.y-minPnt.y)));
		labelW=XTextWidth(font, label, strlen(label));
		XDrawString(display, infoWin, gc,
			(int)(factor1*popWidth+0.25*i*(factor2-factor1)*popWidth-.5*labelW),
			(int)(fctr*popHeight)+(1-j)*(font->ascent+15)-j*15,
			label, strlen(label));
		XDrawLine(display, infoWin, gc,
			(int)(factor1*popWidth+0.25*i*(factor2-factor1)*popWidth),
			(int)(fctr*popHeight),
			(int)(factor1*popWidth+0.25*i*(factor2-factor1)*popWidth),
			(int)(fctr*popHeight)+(1-2*j)*10);
	}
	if(j==0) XDrawLines(display, infoWin, gc, pntsA, nA, CoordModeOrigin);
	else XDrawLines(display, infoWin, gc, pntsB, nB, CoordModeOrigin);
	}
	free(pntsA);	free(pntsB);
	XSetForeground(display, gc, pxlBW[0]);
}


void quadPlot(int nTot, int nFirst, double *Array, double *Array0) {
XPoint	*pntsMon, *pntsMon0;
int		i, j, k, nB, nBlk, widthLabel;
double	maxA, minA, *pnts, *pnts0;
char	label[20];
double	factorB=0.9;

	if(!(pntsMon = (XPoint *) malloc(sizeof(XPoint)* nTot)))
		DIE("Cannot malloc to pntsMon.\n");
	if(!(pntsMon0 = (XPoint *) malloc(sizeof(XPoint)* nTot)))
		DIE("Cannot malloc to pntsMon0.\n");
	if(!(pnts = (double *) malloc(sizeof(double)* nTot)))
		DIE("Cannot malloc to pnts\n");
	if(!(pnts0 = (double *) malloc(sizeof(double)* nTot)))
		DIE("Cannot malloc to pnts0.\n");
	nB= nTot - nFirst;
	for(j=0; j<2; j++) {
	double factor1=0.125, factor2=0.875;
		maxA = minA = Array[j* nFirst];
		nBlk = (1-j)* nFirst+j*nB;
		for(i=0; i< nBlk; i++) {
			pntsMon[i].x = (int)(popWidth*(factor2-factor1)*i/
				((1-j)* nFirst+j*nB-1)
				+factor1*popWidth);
			pnts[i] = Array[i+j* nFirst];
			maxA = maxA >= pnts[i] ? maxA : pnts[i];
			minA = minA <= pnts[i] ? minA : pnts[i];
		}
	
		for(i=0; i< nBlk; i++) {
			pntsMon0[i].x = (int)(popWidth*(factor2-factor1)*i
				/((1-j)* nFirst+j*nB-1)+factor1*popWidth);
			pnts0[i] = Array0[i+j* nFirst];
			maxA = maxA >= pnts0[i] ? maxA : pnts0[i];
			minA = minA <= pnts0[i] ? minA : pnts0[i];
		}
		for(i=0; i< nBlk; i++) {
			pntsMon[i].y=(int)(factorB*popHeight
				-0.8*popHeight*(pnts[i]-minA)/(maxA-minA));
			pntsMon0[i].y=(int)(factorB*popHeight
				-0.8*popHeight*(pnts0[i]-minA)/(maxA-minA));
		}
		if(j==0) {
			XDrawLine(display, infoWin, gc,
				(int)(0.15*popWidth), (int)(0.95*popHeight),
				(int)(0.25*popWidth), (int)(0.95*popHeight));
			sprintf(label, "At step %d", steps.now);
			XDrawString(display, infoWin, gc,
				(int)(0.25*popWidth)+10, (int)(0.95*popHeight)+font->ascent-8,
				label, strlen(label));
		XSetLineAttributes(display, gc, 2, LineOnOffDash, CapButt, JoinRound);
			XDrawLine(display, infoWin, gc,
			(int)(0.50*popWidth), (int)(0.95*popHeight),
			(int)(0.60*popWidth), (int)(0.95*popHeight));
			sprintf(label, "At step %d", steps.from);
			XDrawString(display, infoWin, gc,
				(int)(0.60*popWidth)+10, (int)(0.95*popHeight)+font->ascent-8,
				label, strlen(label));
		}
		XSetForeground(display, gc, pxlBG[2-j]);
		XSetLineAttributes(display, gc, 2, LineOnOffDash, CapButt, JoinRound);
		XDrawLines(display, infoWin, gc, pntsMon0, nBlk, CoordModeOrigin);
		XSetLineAttributes(display, gc, 2, LineSolid, CapButt, JoinRound);
		XDrawLines(display, infoWin, gc, pntsMon, nBlk, CoordModeOrigin);
		XDrawLine(display, infoWin, gc,
			(int)((j*factor2+(1-j)*factor1)*popWidth), (int)(0.1*popHeight),
			(int)((j*factor2+(1-j)*factor1)*popWidth), (int)(0.9*popHeight));
		sprintf(label, "Array%d", j+1);
		widthLabel=XTextWidth(font, label, strlen(label));
		XDrawString(display, infoWin, gc,
			(int)((j*factor2+(1-j)*factor1)*popWidth)-(2*j-1)*5-(1-j)*widthLabel,
			(int)(0.05*popHeight)+font->ascent-2, label, strlen(label));
		for(k=0; k<=4; k++) {
			sprintf(label, "%.3g", maxA-0.25*k*(maxA-minA));
			widthLabel=XTextWidth(font, label, strlen(label));
			XDrawLine(display, infoWin, gc,
				(int)((j*factor2+(1-j)*factor1)*popWidth),
				(int)(0.1*popHeight+0.2*k*popHeight),
				(int)((j*factor2+(1-j)*factor1)*popWidth)+(2*j-1)*5,
				(int)(0.1*popHeight+0.2*k*popHeight));
			XDrawString(display, infoWin, gc,
				(int)((j*factor2+(1-j)*factor1)*popWidth)
					+(2*j-1)*10-(1-j)*widthLabel,
				(int)(0.1*popHeight+0.2*k*popHeight)+font->ascent-8,
				label, strlen(label));
		}
		if(nB == 0) break;
	}
	XSetForeground(display, gc, pxlBW[0]);
	free(pntsMon);	free(pntsMon0);
	free(pnts);	free(pnts0);

}

XPoint	GetCorner(double delta_rho, double delta_phi, Position3D point) {
XPoint	corner;
double	factor;

		factor = M_PI/180.0;
		corner.x = width/2 +rndInt((frame.x_max-frame.x_min)
			*((point.x+delta_rho)*cos((point.y+delta_phi)*factor)-minPnt.x)
			/(maxPnt.x-minPnt.x));
		corner.y = height/2-rndInt((frame.x_max-frame.x_min)
			*((point.x+delta_rho)*sin((point.y+delta_phi)*factor)-minPnt.x)
			/(maxPnt.x-minPnt.x));
	return corner;
}

void DrawPoint(Position3D	point, int Connect) {
static int	oldX, oldY, evnX, evnY, oddX, oddY;
int			indx, n_corners ;
double		delta_rho, delta_phi, x, y, point_w, point_h, tmp;
XPoint		corners[4];
static Bool	isEven = True;

	tmp = (point.z-minPnt.z)/(maxPnt.z-minPnt.z);
	if ((tmp >= 0.0) && (tmp <=1)) {
		indx = rndInt(tmp*nColors);
		if(indx != colorNow) {
		XSetForeground(display, gc, pixels[indx]);
		XSetForeground(display, gcThin, pixels[indx]);
		}
	}
	else {
		indx = tmp > 0.0 ? -1 : -2;
		if(indx != colorNow) {
		XSetForeground(display, gc, pxlBW[2+indx]);
		XSetForeground(display, gcThin, pxlBW[2+indx]);
		}
	}
	colorNow = indx;
#ifdef DRAW_ARCS
	DrawArcs(point);
#else  /* DRAW_ARCS */

		delta_rho = (double)((maxPnt.x-minPnt.x)/frame.x_div);
		delta_phi = (double)((maxPnt.y-minPnt.y)/frame.y_div);
		point_w = (double)(frame.x_max-frame.x_min)/frame.x_div;
		point_h = (double)(frame.y_min-frame.y_max)/frame.y_div;

	if(frame.type == 0 || frame.type == 1) {
		corners[0] = GetCorner(0.0, 0.0, point);
		corners[1] = GetCorner(delta_rho, 0.0, point);
		corners[2] = GetCorner(delta_rho, delta_phi, point);
		corners[3] = GetCorner(0.0, delta_phi, point);
		if(point.x == 0) n_corners=3;
		else n_corners=4;
	XFillPolygon(display, win, gc, corners, n_corners, Convex, CoordModeOrigin);
	}
	else if(frame.type == 10 || frame.type == 11) {
		x = frame.x_min+(frame.x_max-frame.x_min)*(point.x-minPnt.x)
			/(maxPnt.x-minPnt.x)+point_w;
		y = frame.y_min+(frame.y_max-frame.y_min)*(point.y-minPnt.y)
			/(maxPnt.y-minPnt.y);
	XFillRectangle(display, win, gc, rndInt(x-point_w), rndInt(y-point_h),
		rndInt(point_w), rndInt(point_h));
	}
	else if(frame.type == 15 || frame.type == 16) {
		x = frame.x_min+rndInt((frame.x_max-frame.x_min)*(point.x-minPnt.x)
			/(maxPnt.x-minPnt.x));
		y = frame.y_min+rndInt((frame.y_max-frame.y_min)*(point.y-minPnt.y)
			/(maxPnt.y-minPnt.y));
		if(frame.type == 15 && Connect != 0 ) {
			XDrawLine(display, win, gc, oldX, oldY, rndInt(x), rndInt(y));
			oldX=rndInt(x); oldY=rndInt(y);
		}
		else if (frame.type == 15 && Connect == 0) {
			oldX=rndInt(x); oldY=rndInt(y);
		}
		else if (frame.type == 16 && Connect == 1) {
			XDrawLine(display, win, gc, oddX, oddY, rndInt(x), rndInt(y));
			oddX = rndInt(x); oddY = rndInt(y);
		}
		else if (frame.type == 16 && Connect == 2) {
			XDrawLine(display, win, gc, evnX, evnY, rndInt(x), rndInt(y));
			evnX = rndInt(x); evnY = rndInt(y);
		}
		else if(isEven) {
			evnX = rndInt(x); evnY = rndInt(y);
			isEven = False;
		}
		else {
			oddX = rndInt(x); oddY = rndInt(y);
			isEven = True;
		}

/*
	XDrawArc(display, win, gcThin, rndInt(x-3.), rndInt(y-3.), 5, 5, 0, 64*360);;
*/
	}
#endif /* DRAW_ARCS */
#ifdef DEBUG
printf("%d, %d;  %d, %d;  %.2f, %.2f;  %.2f, %.2f\n", (int)(x-point_w), (int)(y-point_h),
	(int)(point_w), (int)(point_h), x-point_w, y-point_h, point_w, point_h);
printf("%.3f, %.3f;  %.3f, %.3f;  %.3f, %.3f;  %d, %d\n", x, y, point.x, point.y,
point_w, point_h, frame.y_max, frame.y_min);
#endif
}

void PlaceFrame(void) {
int		i, j, x, y, x1, y1, y_old, frmW, delta=4, delta2=6, point_w, point_h;
char	label[10];
XPoint	edges[5];
double	factor;


	if(frame.type == 0 || frame.type == 1) {
		factor = sin(M_PI/3.0);
		frame.x_max = width < height ? (int)(0.9*width) :
			(int)(0.4*height)+width/2;
		frame.x_min = width/2;
		frmW = frame.x_max - frame.x_min;
	XSetLineAttributes(display, gc, 1, LineOnOffDash, CapButt, JoinRound);
		XDrawArc(display, win, gc, width/2-frmW-1,
			height/2-frmW-1, 2*(frmW+1),
			2*(frmW+1), 0, 360*64);
		XDrawLine(display, win, gc, frame.x_min,
			height/2-frmW-delta2, frame.x_min,
			height/2+frmW+delta2);
		XDrawLine(display, win, gc, frame.x_min-frmW-delta2, height/2,
			frame.x_min, height/2);
	XSetLineAttributes(display, gc, 1, LineSolid, CapButt, JoinRound);
		for(i=0; i<2; i++) {
			x=frame.x_min + (2*i-1)*(int)(factor*(frmW+delta2));
			x1=frame.x_min + (2*i-1)*(int)(factor*(frmW-delta));
			for (j=0; j<2; j++) {
				y=height/2 + (2*j-1)*(frmW+delta2)/2;
				y1=height/2 + (2*j-1)*(frmW-delta)/2;
				XDrawLine(display, win, gc, x, y, x1, y1);
			}
		}
		for(i=0; i<2; i++) {
			y=height/2 + (2*i-1)*(int)(factor*(frmW+delta2));
			y1=height/2 + (2*i-1)*(int)(factor*(frmW-delta));
			for (j=0; j<2; j++) {
				x=frame.x_min + (2*j-1)*(frmW+delta2)/2;
				x1=frame.x_min + (2*j-1)*(frmW-delta)/2;
				XDrawLine(display, win, gc, x, y, x1, y1);
			}
		}
	XSetLineAttributes(display, gc, 2, LineSolid, CapButt, JoinRound);
		XDrawLine(display, win, gc, width/2, height/2,
			(int)(0.95*width), height/2);
		DrawString("Cylindrical System", 0, 30, width, 'c');
		sprintf(label, "%.3g", maxPnt.x);
		DrawString(label, frame.x_max+5, height/2, 0, 'l');
	}
	else if(frame.type == 10 || frame.type == 11
			|| frame.type == 15 || frame.type == 16) {
		point_w = rndInt(0.8*width/frame.x_div);
		point_h = rndInt(0.8*height/frame.y_div);
		frame.x_min = (int)(0.1*width);
		frame.y_max = (int)(0.1*height);
		frame.x_max = frame.x_min + frame.x_div*point_w;
		frame.y_min = frame.y_max + frame.y_div*point_h;
		edges[0].x = edges[3].x = edges[4].x = frame.x_min;
		edges[0].y = edges[1].y = edges[4].y = frame.y_max;	
		edges[1].x = edges[2].x = frame.x_max;
		edges[2].y = edges[3].y = frame.y_min;
	XSetLineAttributes(display, gc, 1, LineOnOffDash, CapButt, JoinRound);
		XDrawLine(display, win, gc, frame.x_min, (frame.y_min+frame.y_max)/2,
			frame.x_max, (frame.y_min+frame.y_max)/2);
		XDrawLine(display, win, gc, (frame.x_min+frame.x_max)/2, frame.y_min,
			(frame.x_min+frame.x_max)/2, frame.y_max);
	XSetLineAttributes(display, gc, 2, LineSolid, CapButt, JoinRound);
		XDrawLines(display, win, gc, edges, 5, CoordModeOrigin);
		DrawString("Cartesian System", 0, 30, width, 'c');
		for(i=0; i<=4; i++) {
			sprintf(label, "%.3g", minPnt.x+0.25*i*(maxPnt.x-minPnt.x));
			DrawString(label,
				frame.x_min+rndInt(.25*i*(frame.x_max-frame.x_min))-6,
				frame.y_min+font->ascent+6, 0, 'l');
			XDrawLine(display, win, gc,
			frame.x_min+rndInt(.25*i*(frame.x_max-frame.x_min)), frame.y_min,
			frame.x_min+rndInt(.25*i*(frame.x_max-frame.x_min)), frame.y_min-8);
			XDrawLine(display, win, gc,
			frame.x_min+rndInt(.25*i*(frame.x_max-frame.x_min)), frame.y_max,
			frame.x_min+rndInt(.25*i*(frame.x_max-frame.x_min)), frame.y_max+8);
			sprintf(label, "%.4g", minPnt.y+0.25*i*(maxPnt.y-minPnt.y));
			DrawString(label, frame.x_max+4,
				frame.y_min+rndInt(.25*i*(frame.y_max-frame.y_min))+font->ascent/2,
				0, 'l');
			XDrawLine(display, win, gc,
			frame.x_max, frame.y_min+rndInt(.25*i*(frame.y_max-frame.y_min)),
			frame.x_max-8, frame.y_min+rndInt(.25*i*(frame.y_max-frame.y_min)));
			XDrawLine(display, win, gc,
			frame.x_min, frame.y_min+rndInt(.25*i*(frame.y_max-frame.y_min)),
			frame.x_min+8, frame.y_min+rndInt(.25*i*(frame.y_max-frame.y_min)));
		}
	}
	bar_h = rndInt(0.8*height/nColors);
	if(frame.type == 10 || frame.type == 11
		|| frame.type == 15 || frame.type == 16)
	XClearArea(display, win, (int)(48*bar_h/nColors), (int)(0.1*height)-8,
		frame.x_min-(int)(48*bar_h/nColors)-2, (int)(0.8*height)+24, False);
	else if(frame.type == 0 || frame.type == 1)
	XClearArea(display, win, (int)(48*bar_h/nColors), (int)(0.1*height)-8,
		2*frame.x_min-frame.x_max-(int)(48*bar_h/nColors)-2, 
		(int)(0.8*height)+24, False);

	for(i=0; i<=4; i++) {
		if(frame.type < 15)
		sprintf(label, "%.2f", i*(maxPnt.z-minPnt.z)*0.25+minPnt.z);
		else
		sprintf(label, "%g", i*(maxPnt.z-minPnt.z+1)*.25+minPnt.z);
		DrawString(label, (int)(48*bar_h/nColors),
			(int)((0.9-0.2*i)*height)+8, 0, 'l');
	}

	y_old = (int)(0.9*height);
	for(i=0; i<=nColors; i++) {
		XSetForeground(display, gc, pixels[i]);
		y =(int)((0.9-i*0.8/nColors)*height);
		XFillRectangle(display, win, gc, 0, y,
			(int)(nColors*bar_h/32), y_old-y);
		y_old = y;
	}
	XSetForeground(display, gc, pxlBW[1]);
	XFillRectangle(display, win, gc, 0, rndInt(0.1*height-bar_h*1.2),
		rndInt(nColors*bar_h/32), bar_h);
	XSetForeground(display, gc, pxlBW[0]);
	XFillRectangle(display, win, gc, 0, rndInt(0.9*height+bar_h*.2),
		rndInt(nColors*bar_h/32), bar_h);
}

void UpdateSteps(char todo) {
char	label[20];
static XPoint	FromBox[5] = { {80,10}, {20,10}, {10,20}, {20,30}, {80,30} };
static XPoint	NowBox[5] = { {80,10}, {80,30}, {140,30}, {140,10}, {80,10} };
static XPoint	ToBox[5] = { {140,10}, {200,10}, {210,20}, {200,30}, {140,30} };
static XPoint	HotBox[7], TimeBox[7], PntrBox[7];
int		i, fntHeight, hr, min;
double	sec, radius;

	fntHeight = font->ascent+font->descent;

	PntrBox[0].x = PntrBox[2].x = width - 20;
	PntrBox[0].y = PntrBox[5].y = 10;
	PntrBox[1].x = PntrBox[0].x + 5;
	PntrBox[3].x = PntrBox[5].x = PntrBox[0].x - 160;
	PntrBox[4].x = PntrBox[3].x - 5;
	PntrBox[1].y = PntrBox[4].y = PntrBox[0].y + 10;
	PntrBox[2].y = PntrBox[3].y = PntrBox[0].y + 20;
	PntrBox[6] = PntrBox[0];
	for (i=0; i<7; i++) {
		TimeBox[i].x = PntrBox[i].x - width + 200;
		TimeBox[i].y = PntrBox[i].y + height - 40;
		HotBox[i].x = PntrBox[i].x;
		HotBox[i].y = TimeBox[i].y;
	}

	radius = minPnt.x + (maxPnt.x-minPnt.x)*pntrX/(frame.x_max-frame.x_min);
	if(todo == 'n') {
		XClearArea(display, win, 82, 12, 56, 16, False);
		sprintf(label, "N%d",steps.now);
		DrawString(label, 80, 30-(20-fntHeight)/2, 60, 'c');
		XClearArea(display, win, HotBox[5].x+2, HotBox[0].y+2, 156, 16, False);
		sprintf(label, "HotV: %.4g", hotV);
		DrawString(label, HotBox[5].x, HotBox[2].y-(20-fntHeight)/2, 160, 'c');
		hr = floor(timeU/(CLK_TCK*3600));
		min = floor(timeU/(CLK_TCK*60));
		sec = 0.01*(timeU%(CLK_TCK*60));
		sprintf(label, "CPU: %d:%d:%.2f", hr, min, sec);
		XClearArea(display,win, TimeBox[5].x+2, TimeBox[0].y+2, 156, 16, False);
		DrawString(label, TimeBox[5].x, height-10-(20-fntHeight)/2, 160, 'c');
	}
	else if(todo == 'p') {
		if(frame.type == 0 || frame.type == 1)
			sprintf(label, "(%.3g, %.3g)", radius, pntrY);
		else if (frame.type == 10 || frame.type == 11 || frame.type == 15
			|| frame.type == 16 )
			sprintf(label, "(%.3g, %.3g)", pntrX, pntrY);
		XClearArea(display,win, PntrBox[5].x+2, PntrBox[0].y+2, 156, 16, False);
		DrawString(label, PntrBox[5].x, PntrBox[2].y-(20-fntHeight)/2, 160, 'c');
	}
	else {
		XClearArea(display, win, 5, 5, 210, 30, False);
		XClearArea(display, win, HotBox[4].x-5, HotBox[0].y-5, 130, 30, False);
		XClearArea(display, win, PntrBox[4].x-5, PntrBox[0].y-5, 130, 30, False);
		XDrawLines(display, win, gc, FromBox, 5, CoordModeOrigin);
		XDrawLines(display, win, gc, NowBox, 5, CoordModeOrigin);
		XDrawLines(display, win, gc, ToBox, 5, CoordModeOrigin);
		XDrawLines(display, win, gc, HotBox, 7, CoordModeOrigin);
		XDrawLines(display, win, gc, TimeBox, 7, CoordModeOrigin);
		XDrawLines(display, win, gc, PntrBox, 7, CoordModeOrigin);

		if(frame.type == 0 || frame.type == 1)
			sprintf(label, "(%.3g, %.3g)", radius, pntrY);
		else if (frame.type == 10 || frame.type == 11 || frame.type >= 15
			|| frame.type == 16 )
			sprintf(label, "(%.3g, %.3g)", pntrX, pntrY);
		DrawString(label, PntrBox[5].x, PntrBox[3].y-(20-fntHeight)/2, 160, 'c');

		hr = floor(timeU/(100*3600));
		min = floor(timeU/(100*60));
		sec = 0.01*(timeU%6000);
		sprintf(label, "CPU: %d:%d:%.2f", hr, min, sec);
		DrawString(label, TimeBox[5].x, height-10-(20-fntHeight)/2, 160, 'c');

		sprintf(label, "HotV: %.4g",hotV);
		DrawString(label, HotBox[5].x, HotBox[3].y-(20-fntHeight)/2, 160, 'c');

		sprintf(label, "F%d",steps.from);
		DrawString(label, 20, 30-(20-fntHeight)/2, 60, 'c'); 

		sprintf(label, "N%d",steps.now);
		DrawString(label, 80, 30-(20-fntHeight)/2, 60, 'c');

		sprintf(label, "T%d",steps.to);
		DrawString(label, 140, 30-(20-fntHeight)/2, 60, 'c');
	}
}

void ScreenSetup(int argc, char **argv) {
int		x=0, y=0, border_width=4, i;
char	*window_name="Surfing Along", *icon_name="SURF";
char	*fontname = "9x15";
Pixmap	icon_pixmap;
char	*display_name = NULL;
XTextProperty   windowName, iconName;
XWMHints    *wm_hints;
XClassHint  *class_hints;
XColor	clr1, clr2;
XSizeHints  *size_hints;
XGCValues	gcValues;
double		deltaH;



	if((display=XOpenDisplay(display_name)) == NULL) {
		fprintf(stderr,"%s: cannot connect to X server %s\n",
			progname, XDisplayName(display_name));
		exit(-1);
	}
	screen_num = DefaultScreen(display);
	pxlBW[0]=BlackPixel(display, screen_num);
	pxlBW[1]=WhitePixel(display, screen_num);

	cmap = DefaultColormap(display, screen_num);

	pixels = (long *) malloc( sizeof(long)* (nColors+1) );
	color.format = XcmsTekHVCFormat;
	color.spec.TekHVC.C = chromColor;
	color.spec.TekHVC.H = hueColor;
	color.spec.TekHVC.V = minColorV;
	deltaH = (maxColorV - minColorV)/nColors;

	for(i=0;i<=nColors; i++) {
		if(XcmsAllocColor(display,cmap,&color,XcmsTekHVCFormat) == XcmsFailure) {			fprintf(stderr, "%s: XcmsAllocColor failed, %d\n", progname, i);
			fprintf(stderr, "Error in allocating color at i=%d.\n", i);
			/*
			exit(-1);
			*/
		}
		color.spec.TekHVC.V += deltaH;
		pixels[i] = color.pixel;
	}
	if(!XAllocNamedColor(display, cmap, "snow2", &clr1, &clr2))
		printf("Cannot allocate bg color!\n");
	pxlBG[0] = clr2.pixel;
	if(!XAllocNamedColor(display, cmap, "deepskyblue", &clr1, &clr2))
		printf("Cannot allocate bg color!\n");
	pxlBG[1] = clr2.pixel;
	if(!XAllocNamedColor(display, cmap, "violetred", &clr1, &clr2))
		printf("Cannot allocate bg color!\n");
	pxlBG[2] = clr2.pixel;
	XFreeColormap(display, cmap);

	height = 0.8*DisplayHeight(display, screen_num);
	width = 0.8*DisplayWidth(display, screen_num);
	win = XCreateSimpleWindow(display, RootWindow(display,screen_num),x,y,
		width,height,border_width, pxlBW[0], pxlBG[0]);
	/*
	backup = XCreatePixmap(display, RootWindow(display,screen_num),
		width,height,8);
		*/
	icon_pixmap = XCreateBitmapFromData(display, win, surf_bits,
	surf_width, surf_height);

	if(!(size_hints=XAllocSizeHints())) {
		fprintf(stderr,"%s: failure allocating memory\n", progname);
		exit(0);
	}
	if(!(wm_hints=XAllocWMHints())) {
        fprintf(stderr,"%s: failure allocating memory\n", progname);
        exit(0);
	}
	if(!(class_hints=XAllocClassHint())) {
        fprintf(stderr,"%s: failure allocating memory\n", progname);
        exit(0);
	}
	size_hints->flags = PPosition | PSize | PMinSize;
	size_hints->min_width = 300;
	size_hints->min_height = 200;
	wm_hints->initial_state = NormalState;
	wm_hints->input = True;
	wm_hints->icon_pixmap = icon_pixmap;
	wm_hints->flags = StateHint | IconPixmapHint | InputHint;
	class_hints->res_name = progname;
	class_hints->res_class = "SurfClass";
	if(XStringListToTextProperty(&window_name, 1, &windowName)==0) {
		fprintf(stderr,"%s: structure allocation for windowName failed.\n",progname);
		exit(-1);
	}
	if(XStringListToTextProperty(&icon_name, 1, &iconName)==0) {
        fprintf(stderr,"%s: structure allocation for iconName failed.\n",progname);
        exit(-1);
	}
	XSetWMProperties(display,win,&windowName,&iconName,argv,argc,size_hints,
		wm_hints,class_hints);

	XSelectInput(display,win,ExposureMask|KeyPressMask
		|ButtonPressMask|StructureNotifyMask|ButtonMotionMask
		/*
		|PointerMotionHintMask
		*/
		);

	if((font = XLoadQueryFont(display, fontname)) == NULL ) {
		fprintf(stderr, "%s: Cannot open 9x15 font\n", progname);
		exit(-1);
	}
	gc = XCreateGC(display, win, 0, &gcValues);
	gcThin = XCreateGC(display, win, 0, &gcValues);
	XSetFont(display, gc, font->fid);
	XSetLineAttributes(display, gc, 2, LineSolid, CapButt, JoinRound);
	XSetLineAttributes(display, gcThin, 1, LineSolid, CapButt, JoinMiter);
	XSetForeground(display, gc, pxlBW[0]);
	XSetBackground(display, gc, pxlBG[0]);
	XSetBackground(display, gcThin, pxlBG[0]);
	XMapWindow(display,win);
}
