c*
c*
cSURF: an X application to fine-tune, monitor, and control numerical simulations.
c*		Version 1.02
c*    Copyright (C) 1994 Weimin Zhao
C*
C* $Id$
c*
c*/
c/*
c   This program and the library built upon it are free software;
c   you can redistribute it and/or modify it under the terms of the GNU
c   General Public License (GPL) and Library General Public License (LGPL)
c   as published by the Free Software Foundation; either version 2 of the
c   License, or any later version.
c
c   This program and the library are distributed in the hope that it will
c   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
c   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
c   GNU General Public License for more details.
c
c   You should have received a copy of the GNU General Public License
c   along with this program; if not, write to the Free Software
c   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
c*/
c/*
c*	Bug reports to 		wzhao@mcs.kent.edu
c*		Weimin Zhao
c*		Liquid Crystal Institute, Kent State University, Kent, OH 44240
c*/
c/******************************************************************************
c*  This is the template for the user-supplied fortransub subroutine for
c*  simulation.  For the purpose of demostration, this subroutine is written
c*  in Fortran, showing a trivial situation.
c*
c*  Fortran passes arguments by reference.
c*
c*  Use SAVE or COMMON in Fortran to save your intermediate data, like the
c*  "static" in C, as with the variable avg in the following subroutine.
c*
c*	The program would like less ugly if you set tab stops to be 4 ;-)  This
c*  can be done in vi with :set ts=4 
c*
c******************************************************************************/



	subroutine fortransub(ip, x, y, z, intP, dblP, hot, hotArray )
	integer	ip, intP(*)
	real*8	x(*), y(*), z(*), hot, hotArray(*), dblP(*)
	real*8	HALF, ONE, TWO, QUART, M_PI
	integer	i, j
	real*8	amp, avg
	save	avg
	parameter (ONE = 1.d0, TWO = 2.d0, HALF = .5d0, QUART = .25d0)
	M_PI = 4.d0*atan(ONE)

	avg = hot
	i = ip*intP(6)
	if( (intP(5) .eq. 15) .or. (intP(5) .eq. 16) ) then
		amp = aint(dble(i/intP(3)))*0.015d0 + ONE
	else
		amp = ip * 0.015d0 + ONE
	endif
	do j=0, intP(6)-1
		if(intP(5) .eq. 0) then
			x(j+1) = dblP(4)+aint(dble((i+j)/intP(4)))
     *			*(dblP(1)-dblP(4))/intP(3)
			y(j+1) = dblP(5)+dble(mod(i+j,intP(4))
     *			*(dblP(2)-dblP(5))/intP(4))
			z(j+1) = (dblP(3)+dblP(6))*HALF + HALF*(dblP(3)-dblP(6))
     *			*cos(x(j+1)*TWO*M_PI)
			avg = avg + z(j+1)/intP(6)
		else if(intP(5) .eq. 1) then
			x(j+1) = dblP(4)+dble(mod(i+j,intP(3))
     *			*(dblP(1)-dblP(4))/intP(3))
			y(j+1) = dblP(5)+aint(dble((i+j)/intP(3)))
     *			*(dblP(2)-dblP(5))/intP(4)
			z(j+1) = (dblP(3)+dblP(6))*HALF + HALF*(dblP(3)-dblP(6))
     *			*cos(x(j+1)*TWO*M_PI)
     *			*cos(M_PI*y(j+1)/180.0d0)
			avg = avg + z(j+1)/intP(6)
		else if(intP(5) .eq. 10) then
			x(j+1) = dblP(4) + aint(dble((i+j)/intP(4)))
     *			*(dblP(1)-dblP(4))/intP(3)
			y(j+1) = dblP(5) + dble(mod(i+j, intP(4))
     *			*(dblP(2)-dblP(5))/intP(4))
			z(j+1) = sqrt(abs(ONE - (x(j+1)*TWO/(dblP(1)-dblP(4)))**2
     *			- (y(j+1)*TWO/(dblP(2)-dblP(5)))**2))
			avg = avg + z(j+1)/intP(6)
		else if(intP(5) .eq. 11) then
			x(j+1) = dblP(4) + dble(mod(i+j,intP(3))
     *			*(dblP(1)-dblP(4))/intP(3))
			y(j+1) = dblP(5)+aint(dble((i+j)/intP(3)))
     *			*(dblP(2)-dblP(5))/intP(4)
			z(j+1) = sqrt(abs(ONE - (x(j+1)*TWO/(dblP(1)-dblP(4)))**2
     *			- (y(j+1)*TWO/(dblP(2)-dblP(5)))**2))
			avg = avg + z(j+1)/intP(6)
		else if(intP(5) .eq. 15) then
			x(j+1) = dblP(4) + dble(mod(i+j, intP(3))
     *			*(dblP(1)-dblP(4))/intP(3))
			y(j+1) = dblP(5) + HALF*amp*(dblP(2)-dblP(5))
     *			/cosh(x(j+1)*amp)**2
			avg = avg + y(j+1)/intP(6)
		endif
	enddo
	if(intP(5) .eq. 16) then
		do j=1, intP(6)/2
			x(2*j-1) = (dblP(1)+dblP(4))*HALF + HALF
     *			*dble(mod(i+2*j-2, intP(3))*(dblP(1)-dblP(4))/intP(3))
			x(2*j) = (dblP(1)+dblP(4))*HALF + 
     *			HALF*dble(mod(i+2*j-2, intP(3))*(dblP(4)-dblP(1))/intP(3))
			y(2*j-1) = dblP(5) + HALF*amp*(dblP(2)-dblP(5))
     *			/cosh(x(2*j-1)*amp)**2
			y(2*j) = dblP(5) + HALF*amp*(dblP(2)-dblP(5))
     *			/cosh(x(2*j)*amp)**2
			avg = avg + (y(2*j-1)+y(2*j))/intP(6)
		enddo
	endif
	hot = avg
	do j=0, intP(9)-1
		hotArray(j+1) = dblP(3)*amp
     *		*exp(-((j-HALF*intP(9))*6.d0/intP(8))**2*amp)
	enddo
	do j=intP(9), intP(8)
		hotArray(j+1) = dblP(3)*(amp*tanh((j-HALF*(intP(8)+intP(9)))
     *		*8.d0*amp/(intP(8)-intP(9))))**2
	enddo
	return
	end
c
