.TH surf l
.ds )H Weimin Zhao
.ds ]W May 1994
.SH NAME
surf \- an interactive monitor and control of numerical simulations
.SH SYNOPSIS
.C surf
.RC [
.IR file\| ]
.br
.SH DESCRIPTION
.C surf
is an Xlib based program to debug, monitor, and control large-
scale numerical simulations, written in either fortran or C.  3D results
are displayed on a 2D coordinate system while color shades are used to
display the third coordinate (z).  At present, only cylindrical and Cartesian
systems are supported.  Up to 22 integer and 22 double precision parameters
to be passed to and from your subroutine can be set via a file during startup
as well as being changed interactively as the simulation progresses.  One
scalar variable and upto two arrays of any sizes can be monitored during
the progress of simulation.
.PP
.C surf
is written using Xlib to run with minimum system resource demand
and thus should provide an effective means for large-scale simulation:
.RS
.TP 3
\(bu
3-dimensional real-time display of results;
.TP 3
\(bu
real-time interactive control up to 22 integer and 22 double
precision parameters;
.TP 3
\(bu
real-time display of one scalar variable (hot-value);
.TP 3
\(bu
real-time display of CPU time usage at each step of simulation.
.TP 3
\(bu
up to two arbitrary-size arrays of double precision variables
displayed at each simulation step and are compared with the initial
value;
.TP 3
\(bu
values of z along the two pointer-selected axes can be displayed
at any step of simulation.
.TP 3
\(bu
on-line help pop-up window;
.TP 3
\(bu
pop-up window display showing present set up of the parameters;
.TP 3
\(bu
customizable color.
.RE
.SH REQUIREMENTS FOR FORTRANSUB
The fortran subroutine
.C fortransub
should have the following format:
subroutine	
.C fortransub
(index, x, y, z, intp, dblp, hotv, hota)
.br
integer		index, intp()
.br
double		x(intp(6)), y(intp(6)), z(intp(6)), dblp(intp(2))
.br
double	hotv, hota(intp(9))
.RS
.TP 8
.C
index
the index of the current runing steps.  Negative values
of index is forced to -1 during plotting, which is useful
for initializing the fortran subroutined.  This index
can be controlled interactively using keyboard command,
'f', 'n', and 't', as explained below.  The default
starting point of index is index=0.
.TP
.C x,y,z
of dimension intp(6), are the coordinates the results.
Results with index < 0 are ignored.  This feature allows
one to initialize fortransub during a session.
.TP
.C intp
the integer parameter array of dimension at least 9.  The
first 9 integer parameters have to be the same as shown in
the above example.
.TP 
.C intp(1)
the number of integer parameters in array intp().
.TP
.C intp(2)
the number of real*8 parameters in array dblp().
.TP
.C intp(3)
the number of points along x-direction.  It is
assumed that x(1) = xMin. Whether x(intp(3)) = xMax or
x(intp(3)) = xMax-(xMax-xMin)/xPnts will not make a
significant difference in the display.  This program
assumes the latter case.
It must be an even number for axis type 16.
.TP
.C intp(4)
the number of points along y-direction. (see the
above discussion on intp(3).
.TP
.C intp(5)
cylindrical (0 to 9) or cartesian (10 to 19) system.
.RS
.TP 8
.IR 0,1:
cylindrical system which has uniform spacing among
adjacent points along both R- and Phi-axes.  The
points are drawn with Phi (axisType=0), or with R
(axisType=1) incremented first.
.TP 
.IR 10,11:
Cartesian system which has uniform spacing among
adjacent points along both X- and Y-axes. The points
are drawn with Y (axisType=10), or with X (axisType=11)
incremented first.
.TP
.IR 15,16:
Two-dimensional Cartesian system, (x,y).  If axisType
= 15, adjacent points are connected via a line, starting
from x(1).  If axisType = 16, two groups of points,
symmetric around the center of the x-axis, are connected
via lines.  For this axis type, number of points
along x-axis and size of chunk must be even values.
Each complete
scan from xMin to xMax is plotted using the color
indicated by the color bar on the left edge of the
screen.
.RE
.TP
.C intp(6)
dimension of arrays x(), y(), and z().  It must
an even number for axis type 16.
.TP
.C intp(7)
is each chunk of points (x,y,z) stackable (=1) or
not (=0).  When set to 1, only the results of the
last step is plotted.  When set to 0, the maximum
step cannot go beyond the one necessary for making
one complet coverage, i.e., stepsTo is not greater
than xPnts*yPnts/sizChunk + stepsFrom -1.  For the
case for which axisType 5, there is no limit on
stepsTo and intP(7) is always 0.
.TP
.C intp(8)
dimension of the hotarray.
.TP
.C intp(9)
dimension of hotarray1 within hotarray. If only
one hot array is desired, set intp(9) = intp(8).
In general, intp(9) <= intp(8).
.TP
.C dblp
the double precision parameter array of dimension >= 6.
The first and second three elements are, respectively,
the maxima and minima of x, y, and z.
.TP
.C hotv
the hot value to be shown at each step of simulation.
.TP
.C hota
the hot array(s) to be displayed by a pop-up window at
each step of simulation.  When intp(9) < intp(8), it
represents two arrays, having intp(9) and intp(8)-intp(9)
elements, called array1 and array2, respectively, in the
pop-up window.
.RE
.SH LINKING FORTRANSUB WITH SURF
.PP
Once the subroutine has been compiled with -c to obtain the object
file, it can be linked to the two object files, surf.o and draw.o using
the fortran complier. It is ready to run by typing "surf" or whatever
name you have chosen for the executable.
.PP
So far, the program has been tested on IBM RS6000 and HP9000/HP-UX9.
On i486/Linux machines, only an C subroutine can be used with this
program.
.SH ABOUT THE SETUP FILE
.PP
The setup file "fortsub.rc" should be typed as above, which gives a
minimum set .  The first line
is the total number of integer parameters.  The second is the total number
of double precision parameters to be passed to fortransub().
.PP
The following lines are the name and value, separated by white spaces,
of the parameters to used.  The name, as shown in the first column, can be
chosen as a string of no more than 12 letters, while the number always
indicates a fixed meaning.  For instance, the third line can have a name
rhoPnts, or rPnts.  But it always means how many divisions are given along the
first axis of the coordinate system.  Only the integer and double parameters
are pass to the fortran subroutine.  The configuration parameters are used for
customizing colors.
.PP
The number of lines for each category should exactly match the ones
defined on the first line.
.PP
Each group of parameters must be separated by a comment line starting
with a pound sign (#).
.SH ONCE START SURFING
.PP
The upper-left corner indicates the steps of calculation, from, now
and to.  The left-side is the color shade for z-coordinate.  The lower-right
corner displays the present value of the hot value.  The lower-left corner
displays the CPU usage as the simulation progresses.
.PP
The program directly responds to the following keypress:
.RS
.TP 8
.C f
set the "from" point of the steps.
.TP
.C t
set the "to" point of the steps.
.TP
.C g
start the simulation steps.
.TP
.C n
go to the "next" steps.  A stepwise operation.
.TP
.C x
stop the simulation while it is progressing.
.TP
.C c
clear the screen.
.TP
.C d
draw the results again.
.TP
.C r
read a parameter a named file.  Reading an rc file
also re-initialize the program.
.TP
.C s
save the current parameters to a named file.
.TP
.C Y
maximum value of y, for axisType 15 and 16 only.
.TP
.C y
minimum value of y, for axisType 15 and 16 only.
.TP
.C Z
set the maximum value of z.  For axisType 15 or
16, this indicates the last step of calculation.
.TP
.C z
set the minimum value of z.  For axisType 15 or
16, this indicates the first step of calculation.
.TP
.C q
quit the surf program.
.RE
.PP
Note that the above commands only affect the display.
For instance, changing maxZ with "Z" affects only the
display of the results, not the values passed
to the subroutine fortransub.  Parameters can only be
changed via the following function keys.
.RS
.TP 8
.C F1
pop up help window.
.TP
.C F2
pop up status window.
.TP
.C Shft-F1
pop up window displaying the pointer-selected values.
.TP
.C Shft-F2
pop up window displaying the hot array(s).
.TP
.C Ctrl-F[1-12]
reset integer parameters, intp(1-12).
.TP
.C Alt-F[1-12]
reset real*8 (double) parameters, dblp(1-12).
.TP
.C F[3-12]
reset integer parameters, intp(13-22).
.TP
.C Shft-F[3-12]
reset real*8 (double) parameters, dblp(13-22).
.TP
.C Escape
get rid of any pop-up windows. It may require
the pointer to be inside the pop-up window to
removed.
.RE
.SH IN CASE OF DIFFICULTY
.PP
The lines in the originally provided fortsub.rc file are the minimal
set of parameters required for the simulation.  They must be in the same
order as given above.
.PP
Some X window manager, e.g., Motif window manager (mwm), uses function
keys for certain window operation.  For instance, Alt-F4 could be defined
by default to close an application.  If this is the case, you have to modify
your .fmwmrc by remove the key bindings under DefaultWindowMenu category.
If you do not have the file .mwmrc, you can copy it from, say,
/usr/lib/X11/system.mwmrc, and then make your modification within the copy.
Remember to restart your window manager to activate the your new settings.
.SH BUGS
.PP
Please send your bug report to wzhao@mcs.kent.edu.  Comments are also
welcome.


