/*
 * Copyright (C) 1995 by Tom Pfau (pfau@cnj.digex.net)
 *
 * This file may be distributed under the terms of the GPL.
 */
#include "hlsrgb.h"

static float value (float n1,float n2,float hue)
{
    float val;

    while (hue >= 360.0) hue -= 360.0;
    while (hue < 0.0  ) hue += 360.0;

    if (hue < 60.0)
        val = n1 + (n2 - n1) * hue / 60.0;
    else if (hue < 180.0)
        val = n2;
    else if (hue < 240.0)
        val = n1 + (n2 - n1) * (240.0 - hue) / 60.0;
    else
        val = n1;
    return(val);
}

void hls_to_rgb(float h,float l,float s,float *r,float *g,float *b)
{
    float m1,m2;

    m2 = (l < 0.5) ? l * (1 + s) : l + s - (l * s);
    m1 = 2 * (l) - m2;
    if (s == 0)
    {
	(*r) = (*g) = (*b) = l;
    }
    else
    {
	*r = value(m1,m2,h+0.0);
	*g = value(m1,m2,h-120.0);
	*b = value(m1,m2,h+120.0);
    }
    return;
}

static float max3(float a,float b,float c)
{   float t;
    t = a;
    if (b > t)
	t = b;
    if (c > t)
	t = c;
    return(t);
}

static float min3(float a,float b,float c)
{   float t;
    t = a;
    if (b < t)
	t = b;
    if (c < t)
	t = c;
    return(t);
}

void rgb_to_hls(float r,float g,float b,float *h,float *l,float *s)
{
    float max_v,min_v,rc,gc,bc;

    max_v = max3(r,g,b);
    min_v = min3(r,g,b);

    *l = (max_v + min_v) / 2.0;
    if (max_v == min_v)
    {
    	*s = 0;
    	*h = 0;
    }
    else
    {
    	*s = (*l <= 0.5) ? ((max_v - min_v) / (max_v + min_v))
			 : ((max_v - min_v) / (2 - max_v - min_v));
    	rc = (max_v - r) / (max_v - min_v);
    	gc = (max_v - g) / (max_v - min_v);
    	bc = (max_v - b) / (max_v - min_v);

    	if (r == max_v)
	    *h = 2 + bc - gc;
    	else if (g == max_v) *h = 4 + rc - bc;
    	else if (b == max_v) *h = gc - rc;

    	*h = (*h) * 60.0;
    	if (*h < 0.0) *h += 360.0;
    }
}
