/*
 * Copyright (C) 1995 by Tom Pfau (pfau@cnj.digex.net)
 *
 * This file may be distributed under the terms of the GPL.
 */
#include "mandelbrot.h"

/*
This routine cycles through the color wheel.  The first time through, it
uses each color for successive counts.  The second time through, it uses
each color twice.  The third time, each color is used three times.
Background (color 1) is used if the count is 0 or if the count reaches
the iteration limit.  To double the number of times a color is used each
time through the loop, change 'for (i=1;;i++)' to 'for (i=1;;i*=2)'.
*/
void set_color(short int *ibuf,unsigned char *obuf,int itr,int clrs)
{
    int i,j,k;
    for (k=0;k<SCREEN_WIDTH;k++)
    {
	if ((ibuf[k] == itr) || (ibuf[k] == 0))
        {
	    obuf[k] = 1;
            continue;
        }
        for (i=1;;i++)
        {
	    j = i * (clrs - 2);
	    if (ibuf[k] <= j)
                break;
	    ibuf[k] -= j;
        }
	obuf[k] = ((ibuf[k]-1) / i) + 2;
    }
}
