#include <stdio.h>
#include "barcode.h"
#include "fileio.h"
#include "help.h"
#include "german.h"

void HelpSubframe(text)
char *text;
{
fprintf(stderr,text);
}

void help()
{
fprintf(stderr,"\n---> %s <--- \n",ButtonLabelHelp);
fprintf(stderr,
"%s
%s:   -EAN13 -EAN12 -EAN8 -UPC -CODE39 -CODE25 -CODE25I -CODE25M -CODE128A -CODE128B
%s:   -PPM   -PCX   -GIF  -PS  -LATEX  -PGM 
%s:   -X.... -Y....   (.... = 1...9999) (-X.... LATEX / PS )

%s:   -HELP_EAN -HELP_UPC -HELP_CODE39 -HELP_CODE25 -HELP_CODE128 -CODABAR           
%s:   -COPYRIGHT
%s 
       bar -EAN13 -GIF >outputfile.gif <inputstring.txt \n",MOptionen,MTypen,MAusgabeTypn,MBig,Copyright,Hilfen,Bsp);
 exit(0); 
}

main (argc,argv)
int argc;
char *argv[];
{ int i,ok1,z;
  char Wert[1024];
  char Output[1024];
  char File[1024];
  char Ausgabedatei[1024];
  long ywert,xwert;
  int typ = 0;
  int ausgabe = 6;
  ywert=100;
  xwert=100;
  strcpy(Wert,"");
  if (strcmp(argv[1],"-HELP")==0)
    {
     help();
     }                                                         
                                                          
  if ((strcmp(argv[1],"-HELP_EAN")!=0)     && (strcmp(argv[1],"-HELP_UPC")!=0) &&  
     (strcmp(argv[1],"-HELP_CODE39")!=0)  && (strcmp(argv[1],"-HELP_CODE25")!=0) &&
     (strcmp(argv[1],"-HELP_CODE128")!=0) && (strcmp(argv[1],"-HELP_CODABAR")!=0) &&
     (strcmp(argv[1],"-COPYRIGHT")!=0) &&
     (argc<=2)) { fprintf(stderr,"%s",ErrText4); exit(-1); }

  for (i=1; i < argc ; i++)
   {

/* */

if (strcmp(argv[i],"-HELP_EAN")==0) { HelpEan(); exit(0); }
if (strcmp(argv[i],"-HELP_UPC")==0) { HelpUpc(); exit(0); }
if (strcmp(argv[i],"-HELP_CODE128")==0) { HelpCode128(); exit(0); }
if (strcmp(argv[i],"-HELP_CODE25")==0) { Help2of5(); exit(0); }
if (strcmp(argv[i],"-HELP_CODE39")==0) { Help3of9(); exit(0); }
if (strcmp(argv[i],"-HELP_CODABAR")==0) { HelpCodabar(); exit(0); }
if (strcmp(argv[i],"-COPYRIGHT")==0) { HelpCopyright(); exit(0); }

if (strncmp(argv[i],"-X",2)==0) { char *ptr; 
                                  xwert=0; 
                                  ptr=argv[i]+2;
                                  if (0==sscanf(ptr,"%ld",&xwert )) { fprintf(stderr,"%s",ErrText5); exit(-1); }; 
                                 }
                                 
if (strncmp(argv[i],"-Y",2)==0) { char *ptr; 
                                  ywert=0; 
                                  ptr=argv[i]+2;
                                  if (0==sscanf(ptr,"%ld",&ywert )) { fprintf(stderr,"%s",ErrText6); exit(-1); }; 
                                 }


      if (strcmp(argv[i],"-HELP")==0)
            {
             help(); 
              }
                                 
                                  

      if (strcmp(argv[i],"-EAN13")==0)
      {
        /* aha EAN 13 ausgewaehlt */
        typ=0;
      }
   
/* */
      if (strcmp(argv[i],"-EAN12")==0)
        {
         /* aha EAN 12 ausgewaehlt */
         typ=1;
         }
                                  
/* */
      if (strcmp(argv[i],"-EAN8")==0)
      {
        /* aha EAN 8 ausgewaehlt */
      typ=2;
      }
   
/* */
      if (strcmp(argv[i],"-UPC")==0)
        {
         /* aha UPC ausgewaehlt */
         typ=8;
         }
/* */
      if (strcmp(argv[i],"-CODE39")==0)
        {
         /* aha code 39 ausgewaehlt */
         typ=4;
         }
                                  
/* */
      if (strcmp(argv[i],"-CODE25")==0)
      {
        /* aha Code 25 ausgewaehlt */
       typ=5;
      }
   
/* */
      if (strcmp(argv[i],"-CODE25I")==0)
        {
         /* aha Code 2 of 5 interl. ausgewaehlt */
        typ=6;
         }
/* */
      if (strcmp(argv[i],"-CODE25M")==0)
        {
         /* aha Code 2 of 5 Matrix ausgewaehlt */
         typ=7;
         }
                                  
/* */
      if (strcmp(argv[i],"-CODEABAR")==0)
      {
        /* aha CODEABAR ausgewaehlt */
      typ=3;
      }
   
/* */
      if (strcmp(argv[i],"-CODE128A")==0)
        {
         /* aha CODE128A ausgewaehlt */
       typ=9;
         }
/* */
      if (strcmp(argv[i],"-CODE128B")==0)
        {
         /* aha Code 128 B ausgewaehlt */
        typ=10;
         }
                                  
/* */
      if (strcmp(argv[i],"-PPM")==0)
              {                         
                /* aha PPM Biild ausgewaehlt */
              ausgabe=6;
              }                        
/* */
      if (strcmp(argv[i],"-GIF")==0)
              {                         
                /* aha GIF Bild ausgewaehlt */
              ausgabe=2;
              }                        
/* */
      if (strcmp(argv[i],"-PCX")==0)
              {                        
                /* aha PCX Biild ausgewaehlt */
              ausgabe=1;
              }                        
/* */
      if (strcmp(argv[i],"-PGM")==0)
              {                        
                /* aha PGM Biild ausgewaehlt */
              ausgabe=3;
              }                        
    
    
/* */
      if (strcmp(argv[i],"-LATEX")==0)
              {                         
                /* aha PPM Biild ausgewaehlt */
              ausgabe=4;
              }                        
                            
/* */
      if (strcmp(argv[i],"-PS")==0)
              {                        
                /* aha PCX Biild ausgewaehlt */
              ausgabe=5;
              }                        
     
  
   }

gets(Wert);
if (Wert==NULL) { fprintf(stderr,"%s",ErrText7); exit(-1); }
if (typ==0) { z=EAN13(Wert,Output); }
if (typ==1) { z=EAN12(Wert,Output); }
if (typ==2) { z=EAN8(Wert,Output); }
if (typ==3) { z=CODEA(Wert,Output); }
if (typ==4) { z=CODE39(Wert,Output); }
if (typ==5) { z=CODE25(Wert,Output); }
if (typ==6) { z=CODE25I(Wert,Output); }
if (typ==7) { z=CODE25M(Wert,Output); }
if (typ==8) { z=UPC(Wert,Output); }
if (typ==9)  { z=QCODE128(1,Wert,Output); }
if (typ==10) { z=QCODE128(2,Wert,Output); }
if (z==0) {fprintf(stderr,"%s",ErrText8); exit(-1); }
strcpy(Ausgabedatei,"");
if ((z!=0) && (ausgabe==6)){ ok1=create_ppm(NULL ,Output,ywert);        exit(0); }
if ((z!=0) && (ausgabe==4)){ ok1=create_tex(NULL, Output, xwert,ywert); exit(0); }
if ((z!=0) && (ausgabe==5)){ ok1=create_ps (NULL, Output, xwert,ywert); exit(0); }
{ ok1=create_ppm("barcode.tmp",Output,ywert); }
if ((ok1!=-1) && (ausgabe==2)) { char maches[200];
  strcpy(maches,"ppmtogif < barcode.tmp > ");
  strcat(maches,Ausgabedatei);
  strcat(maches," 2>/dev/null"); ok1=system(maches); }
if ((ok1!=-1) && (ausgabe==1)) {  char maches[200];
  strcpy(maches,"ppmtopcx  < barcode.tmp > ");
  strcat(maches,Ausgabedatei);
  strcat(maches," 2>/dev/null"); ok1=system(maches); }
if ((ok1!=-1) && (ausgabe==3)) {  char maches[200];
  strcpy(maches,"ppmtopgm < barcode.tmp > ");
  strcat(maches,Ausgabedatei);
  strcat(maches," 2>/dev/null"); ok1=system(maches); }

exit(0);
}
