/* code to manage the stuff on the "database" menu.
 */

#include <stdio.h>
#include <ctype.h>
#include <math.h>

#if defined(__STDC__)
#include <stdlib.h>
#endif

#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include "astro.h"
#include "circum.h"

#if defined(__STDC__) || defined(__cplusplus)
#define P_(s) s
#else
#define P_(s) ()
#endif

extern FILE *fopenh P_((char *name, char *how));
extern void db_scaninit P_((DBScan *sp, HowScan how));
extern Obj *db_scan P_((DBScan *sp));
extern char *syserrstr P_((void));
extern int db_n P_((void));
extern int db_n_cp P_((void));
extern int db_read P_((FILE *fp));
extern void db_del_all P_((void));
extern void db_set_cp P_((void));
extern void db_del_cp P_((void));
extern void all_newdb P_((int appended));
extern void get_xmstring P_((Widget w, char *resource, char **txtp));
extern void hlp_dialog P_((char *tag, char *deflt[], int ndeflt));
extern void prompt_map_cb P_((Widget w, XtPointer client, XtPointer call));
extern void set_xmstring P_((Widget w, char *resource, char *txt));
extern void watch_cursor P_((int want));
extern void xe_msg P_((char *msg, int app_modal));

void db_manage P_((void));
void db_newdb P_((int appended));
void db_cursor P_((Cursor c));
static void db_create_form P_((void));
static void db_set_title P_((void));
static FILE *fileopen P_((char *name));
static void db_cb P_((Widget w, XtPointer client, XtPointer data));
static void db_del_cp_cb P_((Widget w, XtPointer client, XtPointer data));
static void db_set_cp_cb P_((Widget w, XtPointer client, XtPointer data));
static void db_help_cb P_((Widget w, XtPointer client, XtPointer data));

#undef P_

extern Widget	toplevel_w;
extern char *myclass;
#define	XtD	XtDisplay(toplevel_w)

static Widget dbform_w;

static char dbfdef[] = "ephem.db";      /* default database file name */

void
db_manage()
{
	if (!dbform_w)
	    db_create_form();

	if (XtIsManaged(dbform_w))
	    XtUnmanageChild (dbform_w);
	else {
	    db_set_title();	/* get a fresh count */
	    XtManageChild (dbform_w);
	}
}

/* called when the database might have been updated.
 * as odd as this seems since *this* menu controls the db contents, this was
 *   added when the db fifo input path was added.
 * all we do is update our tally, if we are up at all.
 */
/* ARGSUSED */
void
db_newdb (appended)
int appended;
{
	if (dbform_w && XtIsManaged (dbform_w))
	    db_set_title();
}

/* called to put up or remove the watch cursor.  */
void
db_cursor (c)
Cursor c;
{
	Window win;

	if (dbform_w && (win = XtWindow(dbform_w))) {
	    Display *dsp = XtDisplay(dbform_w);
	    if (c)
		XDefineCursor (dsp, win, c);
	    else
		XUndefineCursor (dsp, win);
	}
}

/* create a prompt dialog to allow user to enter a db file name. */
static void
db_create_form ()
{
	Widget w;
	XmString title;
	Widget sep_w, f_w;
	Arg args[20];
	char *deffn;
	int n;
	
	title = XmStringCreateLtoR ("xephem Data Base",
						    XmSTRING_DEFAULT_CHARSET);
	n = 0;
	XtSetArg(args[n], XmNdefaultPosition, False);  n++;
	XtSetArg(args[n], XmNdialogTitle, title);  n++;
	XtSetArg(args[n], XmNautoUnmanage, False);  n++;
	dbform_w = XmCreatePromptDialog(toplevel_w, "DBPromptD", args, n);
	XtAddCallback (dbform_w, XmNmapCallback, prompt_map_cb, NULL);
	XtAddCallback (dbform_w, XmNhelpCallback, db_help_cb, 0);
	XmStringFree (title);

	/* create the form for the two buttons at the top */

	n = 0;
	XtSetArg (args[n], XmNfractionBase, 7); n++;
	XtSetArg (args[n], XmNverticalSpacing, 5); n++;
	f_w = XmCreateForm (dbform_w, "CpF", args, n);
	XtManageChild (f_w);

	    n = 0;
	    XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
	    XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
	    XtSetArg (args[n], XmNorientation, XmHORIZONTAL); n++;
	    sep_w = XmCreateSeparator (f_w, "Sep", args, n);
	    XtManageChild (sep_w);

	    n = 0;
	    XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	    XtSetArg (args[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
	    XtSetArg (args[n], XmNbottomWidget, sep_w); n++;
	    XtSetArg (args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
	    XtSetArg (args[n], XmNleftPosition, 1); n++;
	    XtSetArg (args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
	    XtSetArg (args[n], XmNrightPosition, 3); n++;
	    w = XmCreatePushButton (f_w, "SetCPPB", args, n);
	    XtManageChild (w);
	    XtAddCallback (w, XmNactivateCallback, db_set_cp_cb, 0);
	    set_xmstring (w, XmNlabelString, "Set\nCheckpoint");

	    n = 0;
	    XtSetArg (args[n], XmNtopAttachment, XmATTACH_FORM); n++;
	    XtSetArg (args[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
	    XtSetArg (args[n], XmNbottomWidget, sep_w); n++;
	    XtSetArg (args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
	    XtSetArg (args[n], XmNleftPosition, 4); n++;
	    XtSetArg (args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
	    XtSetArg (args[n], XmNrightPosition, 6); n++;
	    w = XmCreatePushButton (f_w, "DelCPPB", args, n);
	    XtManageChild (w);
	    XtAddCallback (w, XmNactivateCallback, db_del_cp_cb, 0);
	    set_xmstring (w, XmNlabelString, "Delete to\nCheckpoint");

	get_xmstring (dbform_w, XmNtextString, &deffn);
	if (strlen (deffn) == 0)
	    set_xmstring (dbform_w, XmNtextString, dbfdef);
	XtFree (deffn);

	/* use the Ok button to mean Append */
	XtAddCallback (dbform_w, XmNokCallback, db_cb, NULL);
	set_xmstring (dbform_w, XmNokLabelString, "Append");

	/* use the Apply button to mean Delete */
	XtAddCallback (dbform_w, XmNapplyCallback, db_cb, NULL);
	XtManageChild (XmSelectionBoxGetChild(dbform_w, XmDIALOG_APPLY_BUTTON));
	set_xmstring (dbform_w, XmNapplyLabelString, "Delete\nAll");

	/* allow cancel to unmanage and call it Close */
	XtAddCallback (dbform_w, XmNcancelCallback, db_cb, NULL);
	set_xmstring (dbform_w, XmNcancelLabelString, "Close");

#if XmVersion >= 1001
	w = XmSelectionBoxGetChild (dbform_w, XmDIALOG_TEXT);
	XmProcessTraversal (w, XmTRAVERSE_CURRENT);
	XmProcessTraversal (w, XmTRAVERSE_CURRENT); /* yes, twice!! */
#endif
}

/* set up the title to the dialog.
 * this is a cheap way to indicate the number of objects in the db.
 */
static void
db_set_title()
{
	DBScan dbs;
	char title[1024];
	Obj *op;
	int nes=0, ne=0, np=0, nh=0;
	int nc=0, ng=0, nn=0, npn=0, nq=0, ns=0, no=0;
	int npl=0;
	int t=0;

	for (db_scaninit(&dbs, SCAN_ALLBUT_PLANET); op = db_scan(&dbs); ) {
	    switch (op->type) {
	    case FIXED:
		switch (op->f_class) {
		case 'C': case 'U': case 'O': nc++; t++; break;
		case 'G': case 'H': case 'A': ng++; t++; break;
		case 'N': case 'F': case 'K': nn++; t++; break;
		case 'P': npn++; t++; break;
		case 'Q': nq++; t++; break;
		case 'T': case 'B': case 'D': case 'M': case 'S': case 'V': 
		    ns++; t++; break;
		default: no++; t++; break;
		}
		break;
	    case ELLIPTICAL: ne++; t++; break;
	    case HYPERBOLIC: nh++; t++; break;
	    case PARABOLIC: np++; t++; break;
	    case EARTHSAT: nes++; t++; break;
	    case PLANET: npl++; t++; break;
	    case UNDEFOBJ: break;
	    default:
		printf ("Unknown object type: %d\n", op->type);
		exit (1);
	    }
	}

	/* do a sanity check on the total.
	 * also, there shouldn't be any planets in the db!
	 */
	if (db_n() - NOBJ != t) {
	    printf ("Objects unaccounted for: t=%d n=%d\n", t, db_n());
	    exit(1);
	}
	if (npl > 0) {
	    printf ("%d planets in database!\n", npl);
	    exit (1);
	}

	(void) sprintf (title, "\
%6d Solar -- elliptical\n\
%6d Solar -- hyperbolic\n\
%6d Solar -- parabolic\n\
%6d Earth satellites\n\
%6d Clusters (C,U,O)\n\
%6d Galaxies (G,H,A)\n\
%6d Planetary Nebulae (P)\n\
%6d Nebulae (N,F,K)\n\
%6d Quasars (Q)\n\
%6d Stars (S,V,D,B,M,T)\n\
%6d Undefined\n\
------\n\
%6d Total objects in memory\n\
%6d Objects at time of checkpoint\n\
\n\
Enter name of database file to read:",
	    ne, nh, np, nes, nc, ng, npn, nn, nq, ns, no, t, db_n_cp()-NOBJ);
	set_xmstring (dbform_w, XmNselectionLabelString, title);
}

/* try to open name for read access.
 * if successful, return FILE *, else print a message and return NULL.
 */
static FILE *
fileopen (name)
char *name;
{
	FILE *fp;
	
	fp = fopenh (name, "r");
	if (!fp) {
	    char msg[128];
	    (void) sprintf (msg, "Can not open %.75s: %.25s", name,
							syserrstr());
	    xe_msg (msg, 1);
	}
	return (fp);
}

/* callback from any of the buttons along the bottom */
/* ARGSUSED */
static void
db_cb (w, client, data)
Widget w;
XtPointer client;
XtPointer data;
{
	static char me[] = "db_cb()";
	XmSelectionBoxCallbackStruct *s = (XmSelectionBoxCallbackStruct *)data;
	char *sp;
	FILE *fp;

	watch_cursor(1);

	switch (s->reason) {
	case XmCR_OK: /* append */
	    XmStringGetLtoR (s->value, XmSTRING_DEFAULT_CHARSET, &sp);
	    fp = fileopen (sp);
	    if (fp) {
		if (db_read (fp) < 0) {
		    char msg[128];
		    (void) sprintf (msg, "Error reading `%.100s'", sp);
		    xe_msg (msg, 1);
		}
		all_newdb(1);	/* includes us! */
		(void) fclose (fp);
	    }
	    XtFree (sp);
	    break;
	case XmCR_APPLY:	/* delete to checkpoint */
	    db_del_all();
	    all_newdb(0);	/* includes us! */
	    break;
	case XmCR_CANCEL:
	    XtUnmanageChild (w);
	    break;
	default:
	    printf ("%s: Unknown reason = 0x%x\n", me, s->reason);
	    exit(1);
	}

	watch_cursor(0);
}

/* callback from the Delete to Checkpoint button */
/* ARGSUSED */
static void
db_del_cp_cb (w, client, data)
Widget w;
XtPointer client;
XtPointer data;
{
	db_del_cp();
	all_newdb(0);
}

/* callback from the Set Checkpoint button */
/* ARGSUSED */
static void
db_set_cp_cb (w, client, data)
Widget w;
XtPointer client;
XtPointer data;
{
	db_set_cp();
	db_set_title();
}

/* ARGSUSED */
static void
db_help_cb (w, client, data)
Widget w;
XtPointer client;
XtPointer data;
{
	static char *msg[] = {
"This displays a count of the various types of objects currently in memory.",
"Database files may be read in to add to this list or the list may be deleted."
};

	hlp_dialog ("DataBase menu", msg, XtNumber(msg));
}
