.TH xephem 1X
.SH Name
xephem \- an interactive astronomical ephemeris for X
.SH Syntax
\fBxephem\fP
.SH Description
.na
.nh
.PP
.B Xephem
is an interactive astronomical ephemeris program for X Windows
systems.  It computes heliocentric, geocentric and topocentric information
for celestial objects. Xephem has built-in support for all planets; the moons of
Jupiter, Saturn and Earth; and Mars' central meridian longitude. Xephem also
supports any objects in heliocentric or Earth orbit given the appropriate
elements. A sample database of some 16000+ objects is included in the release
kit. Xephem generates data in configurable tabular forms and in graphical
schematic views.  Xephem can plot and list all data fields and can be
programmed to search for arbitrary circumstances.
.SH Getting Started
.PP
Xephem contains extensive context-sensitive on-line help. Virtually none of
that help is duplicated here so go ahead and run xephem to learn more. In
order for xephem to find this help text the resource `XEphem.HELPFILE' must
be set to the path name of the xephem.hlp file.

When you first run xephem you may hear a beep and see a message box.
Xephem occasionally adds auxiliary information to the message box and may
beep when it does so to draw your attention to it.
Whether the message box is displayed may be toggled using the 
.I Messages
entry in the File pulldown menu off the Main menu.
Whether xephem beeps when it adds a message may be toggled using the
.I Message Bell
option in the Preferences pulldown menu.
.SH Quick Menu Tour
.PP
The
.I Help
pulldown at the top right of the main menu provides access to several
categories of assistance applicable to the overall
operation of
.B xephem.
Those unfamiliar with
.B xephem
might begin by reading the 
.I Introduction
help section first and reading the additional help information in the
order in which it is listed in the pulldown.

The
.I Main menu
of
.B xephem
provides control and display of three basic services: observing circumstances,
looping, and access to additional displays.

Observing circumstances includes location, time and atmospheric conditions
(used for the refraction model). Looping refers to the ability to set up
.B xephem
so that it automatically increments time at a desired step size and rate.

Additional displays provide all of the tabular and graphical information
available, and always refer to the circumstances defined in the main menu.
These additional displays are activated from the 
.I Views
pulldown.

.B Xephem
has information about the Solar system planets and several moons
built in. These can be accessed without the need to access an external
database. Nevertheless, if a database of objects is available then
.B xephem
can read this information into memory and use it as well. Database files
are read in using the
.I Data Base
button in the
.I Objects
pulldown or via the DBFIFO fifo (see the Help for the Data Base menu for more
details). All of the information about each object in
memory may be inspected and manipulated in detail and assigned to so-called
`user defined objects' X and Y using the
.I ObjX/Y
button in the same pulldown.

All of the data that 
.B xephem
presents in numeric form may be written to a file and later plotted; written
to a file in as a tabular listing; or used to formulate an arbitrary
mathematical expression that may be solved for a maximum, minimum or zero.
These facilities are accessed from the
.I Control
pulldown.

Several display and accuracy formatting options may be controlled from the
.I Preferences
pulldown.

The
.I Files
pulldown in the main menu allows one to reset the main menu from the initial
resource settings; toggle whether the general messages menu is displayed; and
quit the program.
.SH Resources
.PP
Xephem has many resources, many of which you will soon want to tune to your
taste and circumstances; many others may be left unchanged. Look through the
XEphem.ad distribution for full details. If no resources are available
xephem contains internal fallback resources that are suitable for a
black-and-white X terminal.

Of course, in addition to all the custom resources, xephem supports
the usual Xt command line arguments such as -display, -xrm, -synchronous, -fg
and -bg.

The application class of xephem is XEphem.

A list of widgets in xephem would be enormous. If you really want such
a list, build xephem for X11R5 and use the editres feature. The necessary
code is in xephem.c surrounded by #ifdef WANT_EDITRES.
.SH Time zones
.PP
As of v2.5, if when xephem was compiled __STDC__ was defined and at runtime the
gmtime() function returns non-NULL, then xephem will attempt to set the
timezone name and offset from the operating system whenever the "Now" option is
used from the various Main menu time fields or resources. Otherwise, xephem
never attempts to automatically change the timezone name or offset. In any
case, these may be set manually at any time from the Main menu, or they may
be initialized from the XEphem.TZName and XEphem.TZone resources, respectively.
.SH Files and Fifos
.PP
Xephem can use and create several files and communicate via several fifos. The
following table lists the name of the resource that defines each, the default
name and a short description of each. Many of the names may be changed at
runtime. Full details of each may be found in the appropriate tune-time Help
available from within xephem. The initial default settings define everything to
be in the current directory. All file names may begin with tilde (~) to refer
to the user's HOME directory.
.na
.nf

X Resource Name                 Default         Usage
---------------                 -------         -----

XEphem.DBFIFO                   xephem_db_fifo  auto database input
XEphem.SKYLOCFIFO               xephem_loc_fifo Sky View Button2 report
XEphem.SKYOUTFIFO               xephem_out_fifo Sky View center report
XEphem.SKYINFIFO                xephem_in_fifo  Sky View center input
XEphem.HELPFILE                 xephem.hlp      Help text
XEphem.SITESFILE                xephem_sites    Earth view sites
XEphem*DBPromptD.textString     ephem.db        Object database
XEphem*Plot*Filename.value      ephem.plt       Plot file
XEphem*List*Filename.value      ephem.lst       Listing file
.SH Author
.PP
Elwood Downey, ecdowney@noao.edu. Though they graciously provide me with email
and other services, neither I nor xephem are associated in any way with the
National Optical Astronomical Observatory.
.SH References
.PP
.B Ephem
is the ancestor of xephem. It is suitable for "dumb" 24x80 character displays,
including VMS and DOS as well as UNIX.
v4.28 may be found on export.lcs.mit.edu (also known as ftp.x.org and
198.112.44.100) in contrib/ephem_4.28.tar.Z.
.PP
.B Xephem
updates may be found on ftp.x.org. Look in contrib/xephem for the latest
release. Xephem source, the SAO cataloge and several sample executables are
also maintained on iraf.noao.edu (140.252.1.1) in contrib/xephem.
.PP
The online Help entry
.I on Credits
lists some of the texts, individuals and
organizations that have contributed to xephem. Space and memory limitations
prevent me me from listing everyone.
.PP
The xephem distribution kit includes an awk script to convert from NASA
"2-line" earth satellite format to the form required by the xephem database.
This script is called
.I nasa2xdb.awk
and should be available wherever you find xephem.
