/* > xchart.c */
/* Daniel F. Smith, 1994 */
/* Draw charts of the command line files (unsigned char data) */

#include <stdio.h>
#include <stdlib.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>

#include "Chart.h"

extern void exit(int);

static int xscale=16;
static String resources[]={
	"*quit.label: Quit",
	"*xin.label: Zoom in",
	"*xout.label: Zoom out",
	"*viewport.fromVert: buttonbox",
	"*viewport.charts*resizable: True",
	"*viewport.allowHoriz: True",
	"*viewport.allowVert: True",
	"*viewport.width: 800",
	"*Chart.gridSize: 100",
	"*Chart.scaleY: 3",
	"*buttonbox.width: 800",
	"*buttonbox.left: ChainLeft",
	"*buttonbox.right: ChainLeft",
	"*buttonbox.top: ChainTop",
	"*buttonbox.bottom: ChainTop",
	NULL};

static long fileext(FILE *f) {
	long cur,ret;
	if ((cur=ftell(f))<0 ||
	    fseek(f,0,SEEK_END)!=0 ||
	    (ret=ftell(f))<0 ||
	    fseek(f,cur,SEEK_SET)!=0)
		return -1;
       	return ret;
	}

static char *databuf(char *fname,long *len) {
	static unsigned char *d;
	long i;
	FILE *f;

	f=fopen(fname,"rb");
	if (f==NULL) return NULL;
	if ((*len=fileext(f))<0) return NULL;
	if ((d=(unsigned char *)malloc(*len))==NULL) {
		fclose(f);
		return NULL;
		}
	for(i=0;i<*len;i++)
		d[i]=fgetc(f);
	fclose(f);
	return d;
	}

static void Xmagin(Widget button,XtPointer clientd,XtPointer calld) {
	Widget *chart=(Widget *)clientd;
	xscale/=2;
	if (xscale<1) xscale=1;
	while(*chart) {
		XtVaSetValues(*chart,XtNscaleX,xscale,NULL);
		chart++;
		}
	}

static void Xmagout(Widget button,XtPointer clientd,XtPointer calld) {
	Widget *chart=(Widget *)clientd;
	xscale*=2;
	while(*chart) {
		XtVaSetValues(*chart,XtNscaleX,xscale,NULL);
		chart++;
		}
	}

int main(int argc,char *argv[]) {
	XtAppContext app_context;
	Widget topLevel,form,bbox,quit,vprt,xmagin,xmagout,charts,*chart;
	long len;
	unsigned char *d;
	int i;
	char wname[10];
	
	topLevel=XtVaAppInitialize(&app_context,
				   "XChart",
				   NULL,0,
				   &argc,argv,
				   resources,NULL);
	/* There should be some filenames left in argc/argv */
	if (argc<=1) {
		fprintf(stderr,"Syntax: %s <filename> [<filename>...]\n"
			"Where <filename> is a file to be displayed.\n",
			argv[0]);
		exit(1);
		}

	form=XtVaCreateManagedWidget("form",formWidgetClass,topLevel,NULL);
	bbox=XtVaCreateManagedWidget("buttonbox",boxWidgetClass,form,NULL);

	/* Create command buttons, add callbacks below */
	quit   =XtVaCreateManagedWidget("quit",commandWidgetClass,bbox,NULL);
	xmagin =XtVaCreateManagedWidget("xin", commandWidgetClass,bbox,NULL);
	xmagout=XtVaCreateManagedWidget("xout",commandWidgetClass,bbox,NULL);

	vprt=XtVaCreateManagedWidget("viewport",viewportWidgetClass,form,NULL);
	charts=XtVaCreateManagedWidget("charts",formWidgetClass,vprt,NULL);
	
	chart=(Widget *)malloc(sizeof(Widget)*argc);
	chart[argc-1]=NULL;
	/* Bring up main charts */
	for(i=1;i<argc;i++) {
		sprintf(wname,"chart%d",i);
		d=databuf(argv[i],&len);
		if (!d) {
			fprintf(stderr,"%s: warning: cannot load file %s\n",
				argv[0],argv[i]);
			continue;
			}
		chart[i-1]=XtVaCreateManagedWidget(wname,
						   chartWidgetClass,charts,
						   XtNdatap,d,
						   XtNndata,len,
						   XtNscaleX,xscale,
						   NULL);
		if (i>1)
			XtVaSetValues(chart[i-1],XtNfromVert,chart[i-2],NULL);
		}

	/* command callbacks */
	XtAddCallback(quit,XtNcallback,(XtCallbackProc)exit,NULL);
	XtAddCallback(xmagout,XtNcallback,Xmagout,(XtPointer)chart);
	XtAddCallback(xmagin,XtNcallback,Xmagin,(XtPointer)chart);

	XtRealizeWidget(topLevel);
	XtAppMainLoop(app_context);
	return 0;
	}
