############################################################
#                     Sourceing funktion files
############################################################
foreach file {parse types menus help functions util save setup inout} {
  source [lindex $argv 0]/$file.tcl
}

############################################################
#                    General initializion
############################################################
if {![info exists setup(dotfile)]} {
  set setup(dotfile) "output.dot"
}
if {![info exists setup(exportFile)]} {
  set setup(exportFile) "dotfile.dot"
}
if {![info exists setup(file)]} {
  set setup(file) 1
}
if {![info exists setup(print)]} {
  set setup(print) 1
}
if {![info exists setup(commentchar)]} {
  set commentChar ""
}
if {![info exists setup(onePage)]} {
  set setup(onePage) 1
}
if {![info exists setup(saveDefault)]} {
  set setup(saveDefault) 0
}
if {![info exists setup(exportOnSave)]} {
  set setup(exportOnSave) 0
}
if {![info exists setup(commentchar)]} {
  set setup(commentchar) ""
}
if {$argv0 == "wish"} {
  puts "To start this program, type wish <template file> <dotfile path> <module path>"
  exit -1
}
set widget2Help(.menu) "Menus"
set widget2Help(.setup) "Setup"
set widget2Help(.buttons.f1.setup) "Setup"
set widget2Help(.buttons.f2.import) "Export/Import"
set widget2Help(.buttons.f2.export) "Export/Import"
set widget2Help(.buttons.f2.reset) "Reset Page"
set widget2Help(.setup) "Setup"
set widget2Help(.buttons.f3.save) "Save"
set changed 0

set editInfo(name) ""   ;# just to avoid testing for it.
parseFile

############################################################
#                      Menu WINDOW
############################################################

frame .menu
pack .menu -expand 1 -fill both
subType "" .

frame .buttons
pack .buttons -side bottom -expand 1 -fill both
pack [frame .buttons.f1] [frame .buttons.f2] [frame .buttons.f3] \
    -expand 1 -fill x
button .buttons.f1.quit -text "QUIT" -command quit -width 9
button .buttons.f1.about -text "About" -command about -width 9
button .buttons.f1.setup -text "Setup" -command setup -width 9
button .buttons.f2.export -text "Export" -command exportFile -width 9
button .buttons.f2.import -text "Import" -command importFile -width 9
button .buttons.f2.reset -text "reset page" -command resetToDefult -width 9
button .buttons.f3.save -text "SAVE" -command save_template

pack .buttons.f1.about .buttons.f1.setup .buttons.f1.quit  -side left -expand 1 -fill both
pack  .buttons.f2.export .buttons.f2.import .buttons.f2.reset -expand 1 -fill both -side left
pack .buttons.f3.save -expand 1 -fill both -side left

############################################################
#               global bindings for entry's
############################################################
bind Entry <Double-ButtonPress-3> {%W delete sel.first sel.last}
bind all <ButtonPress-3> "help %W"
bind all <Control-s> save_template

wm withdraw .
wm geometry . +0+0
wm deiconify .
wm title . "Dotfile Genrator"

############################################################
#                 sourceing .dotfilerc
############################################################
if {[file exists ~/.dotfilerc]} {
  source ~/.dotfilerc
}

############################################################
#                checking for an export file
############################################################
if {[file exists $setup(exportFile)]} {
  set answer [tk_dialog .dialog "Load data" "An export file exists load it" questhead 0 Yes No]
  if {$answer == 0} {
    importFile
  }
}


