############################################################
#   funktion to insert information about the actual info
#   into the info list.
############################################################
proc print {args} {
  global answers editInfo
  append answers [join $args] "\n"
}

############################################################
#                    set the description
############################################################
proc desc {args} {
  global editInfo texts children 
  if {![winfo exists .edit]} {
    makeEdit
  } else {
    destroy .edit.options
  }
  catch {unset texts}
  catch {unset help}
  frame .edit.options -borderwidth 1 -relief sunken
  pack .edit.options -after .edit.name -expand 1 -fill both -expand 1 
  set editInfo(name) [info level -1]
  set editInfo(desc) [join $args]
  set editInfo(curDesc) [join $args]
  proc makeChange {name {menuCreate 0}} "global changed changeElm; if {!\$menuCreate} {set changed 1}"

  foreach elm [array names children] {
    if {[string match $editInfo(name)* $elm]} {
      unset children($elm)
    }
  }
}

############################################################
#               set the short description
############################################################
proc shortDesc {args} {
  global shortDesc setup
  set shortDesc([info level -1]) "\n$setup(commentchar) [join $args]"
}

############################################################
#             function to create save functions
############################################################
proc save {funk} {
  global editInfo saveInfo answers ok setup loaded pathProgsNames
  set function [info level -1]
  set ok($function) $funk
  set editInfo(name) $function
  .edit.name.2 configure -text $pathProgsNames($function)
  if {$setup(onePage)} {
    set state disabled
  } else {
    set state normal
  }
  if {$saveInfo($function) == 0} {
    .edit.save.but configure -text "Will not be saved"
  } else {
    .edit.save.but configure -text "Will be saved"
  }
  .edit.save.but configure -command "changeSave $function" -state $state
  packAll .edit.options $function [expr ![info exists loaded($function)]]
  set loaded($function) 1
  makeChange all 1
  wm deiconify .edit
}

############################################################
#      create function to be called whenever changes
#      are made to the scheme
############################################################
proc change {funk} {
  global editInfo
  proc makeChange {name {menuCreate 0}} "global changed changeElm;useVars;;set changeElm \$name; uplevel #0 {$funk};saveVars;if {!\$menuCreate} {set changed 1}"
}

############################################################
#        Just an alias for source...
#        used when importing template files
############################################################
proc import {file} {
  global argv
  source [lindex $argv 1]/$file
}

############################################################
#                        Edit WINDOW
############################################################
proc makeEdit {} {
  toplevel .edit
  pack [frame .edit.name]
  pack [frame .edit.save] -side bottom -fill x -expand yes
  pack [frame .edit.description] -side bottom

  label .edit.name.1 -text "name: "
  label .edit.name.2 
  pack .edit.name.1 .edit.name.2 -side left
  
  message .edit.description.desc -textvariable editInfo(desc) -aspect 200
  pack .edit.description.desc

  button .edit.save.but -text "OK" -command "wm withdraw .edit"
  pack .edit.save.but -fill x -expand 1
  
  wm withdraw .edit
  wm geometry .edit +300+0
  wm deiconify .edit
}

############################################################
#   This function reset a page to it's default values
############################################################
proc resetToDefult {} {
  global editInfo loaded scrollValue
  set function $editInfo(name)
  if {$function == ""} return
  destroy .edit
  uplevel \#0 "eval unset \[info vars ${function}_*\]"
  unset loaded($function)
  if {[info exists scrollValue]} {
    foreach elm [array names scrollValue] {
      if {[string match ${function}_* $elm]} {
	unset scrollValue($elm)
      }
    }
  }
  $function
}

############################################################
#               Quit
############################################################
proc quit {} {
  global changed
  if {$changed} {
    set answer [tk_dialog .dialog "Unsaved Information" \
		    "There's information, which haven't been exported what do you want to do" questhead 1 Quit Export]
    if {$answer == 1} exportFile
  }
  exit
}
