############################################################
#          general help page, called from the menu.
############################################################
proc generalHelp {{text ""}} {
  global generalHelpIndex textIndexes argv
  set defaultFont "-*-helvetica-medium-r-*-*-12-*"
  set italicFont "-*-helvetica-medium-o-*-*-12-*"
  set boldFont  "-*-helvetica-bold-r-*-*-12-*"
  set largeFont "-*-helvetica-medium-r-*-*-18-*"

  if {[winfo exists .help]} {
    wm deiconify .help
    raise .help
  } else {
    toplevel .help
    button .help.quit -text "Quit Help" -command {
      destroy .help
    }
    pack .help.quit -side bottom -expand 1 -fill x -padx 5 -pady 5
    for {set i 0} {$i < 2} {incr i} {
      frame .help.f$i
      pack .help.f$i -side left -anchor n -expand 1 -fill both
    }
    
    # making the widgets
    text .help.text -wrap word -font $defaultFont \
	-yscrollcommand ".help.textscroll set" -width 50
    scrollbar .help.textscroll -command ".help.text yview"
    pack .help.text .help.textscroll -in .help.f1 -side left -fill y 
    
    listbox .help.lbox 	-relief raised -borderwidth 2 -width 30 
    pack .help.lbox  -in .help.f0 -fill y -expand 1
    bind .help.lbox <ButtonRelease-1> {
      .help.text yview $generalHelpIndex([.help.lbox curselection])
      .help.lbox selection clear 0 end
    }
    catch {unset textIndexes}
    source [lindex $argv 0]/generatedHelp
  }

  if {$text == ""} {
    .help.text yview 1.0
    return
  }
  
  if {[lsearch -exact $textIndexes $text] != -1} {
    .help.text yview $generalHelpIndex([lsearch -exact $textIndexes $text])
  } elseif {[lsearch -glob $textIndexes $text*] != -1} {
    .help.text yview $generalHelpIndex([lsearch -glob $textIndexes $text*])
  }
}

############################################################
#                   show the about box
############################################################
proc about {} {
  global module
  set index [tk_dialog .about "About the Dotfile Generator" \
		 "This is the Dotfile Generator made by\nJesper Pedersen\nOdense University\nDenmark\nVersion 1.0\n\nModule name: $module(name)\nCreator: $module(creator)\nVersion: $module(version)" {} 0 OK "Show the help pages"]
  if {$index == 1} {generalHelp}
}

############################################################
#               this program is called every time
#               a right button is pressed
############################################################
proc help {widget} {
  global help editInfo texts widget2Help path2Help
  set function $editInfo(name)
  set length 0
  foreach path [array names path2Help] {
    if {[string match $path* $widget]} {
      if {[string length $path] > $length} {
	set length [string length $path]
	set w $path2Help($path)
      }
    }
  }
  if {$length > 0} {
    set editInfo(desc) "$texts(${function}__$w)\n\n$help($w)"
  } elseif {[string match ".edit*" $widget]} {
    set editInfo(desc) "$editInfo(curDesc)"
  } elseif {[info exists widget2Help]} {
    # checks if the widget is registreted for help in the help index
    set index ""
    foreach entry [array names widget2Help] {
      if {[string match $entry* $widget]} {
	set index $widget2Help($entry)
	break
      }
    }
    generalHelp $index
  } else {
    set index [tk_dialog .nohelp "NO help" "No help for that topic sorry." warning 0 OK "See Help Pages"]
    if {$index == 1} {
      generalHelp
    }
  }
}

