proc exportFile {} {
  global setup progList changed saveInfo children widgetArgs ok
  set saved {}
  set hash {############################################################}

  set FILE [open $setup(exportFile) w]
  foreach menu $progList {
    set changed 0
    set any 0
    foreach var [uplevel \#0 info vars $menu*] {
      if {!$any} {puts $FILE "$hash\n\# $menu\n$hash"}
      
      if {[catch "uplevel \#0 set $var"]} {
	foreach subvar [uplevel \#0 array names $var] {
	  puts $FILE "set ${var}($subvar) {[uplevel set ${var}($subvar)]}"
	}
      } else {
	puts $FILE "set $var \{[uplevel \#0 set $var]\}"
      }
      set any 1
    }
    if {$any} {
      lappend saved $menu
    }
  }
  puts $FILE "foreach menu {$saved} {set loaded(\$menu) 1}"

  puts $FILE "$hash\n\# setup\n$hash"
  foreach elm [array names setup] {
    puts $FILE "set setup($elm) \{$setup($elm)\}"
  }

  puts $FILE "$hash\n\# saveInfo\n$hash"
  foreach elm [array names saveInfo] {
    puts $FILE "set saveInfo($elm) $saveInfo($elm)"
  }
  puts $FILE "$hash\n\# Children Info\n$hash"
  foreach child [array names children] {
    puts $FILE "set children($child) {$children($child)}"
  }
  puts $FILE "$hash\n\# Widget Args\n$hash"
  foreach elm [array names widgetArgs] {
    puts $FILE "set widgetArgs($elm) {$widgetArgs($elm)}"
  }
  puts $FILE "$hash\n\#Save Funktions\n$hash"
  foreach elm [array names ok] {
    puts $FILE "set ok($elm) {$ok($elm)}"
  }
   
  close $FILE
}

proc importFile {} {
  global setup editInfo
  
  if {![file exists $setup(exportFile)]} {
    error "no importfile:\n \"$setup(exportFile)\" doesn't exists"
  }
  uplevel \#0 source $setup(exportFile)
  if {$editInfo(name) != ""} {
    packAll .edit.options $editInfo(name) 0 0
  }
}
