proc writeText {} {
  upvar text text
  if {$text != ""} {
    puts ".help.text insert insert \"$text\""
    set text ""
  }
}

############################################################
#         reading and parsing the help file
#         and writing it to a script
############################################################
set IN [open help.data]

set i 0; set header 0; set slash 0; set quotation 0; set newLine 0
set text ""

while {[gets $IN line] != -1} {
  if {[regexp {^\[(.*)\]$} $line all title]} {
    writeText
    puts "set index \[.help.text index insert\]"
    puts ".help.text insert insert \"$title\\n\""
    puts {.help.text tag add header $index insert}
    puts ".help.lbox insert end \"$title\""
    puts "set generalHelpIndex($header) \$index"
    puts "lappend textIndexes {$title}"
    incr header
  } else {
    set length [string length $line]
    if {$length == 0} {
      append text {\n\n}
    }
    for {set j 0} {$j<$length} {incr j} {
      set char [string range $line $j $j]
      if {$char == "\\"} {
	if {$slash} {
	  append text {\\}
	}
	set slash [expr ($slash+1)%2]

      } elseif {$char == "\""} {
	if {$slash} {
	  append text {\"}
	  set slash 0
	} else {
	  if {$quotation} {
	    # end of quotation
	    writeText
	    puts {.help.text tag add italic $index insert}
	  } else {
	    # beginning of quotation
	    writeText
	    puts {set index [.help.text index insert]}
	  }
	  set quotation [expr ($quotation+1)%2]
	}

      } elseif {$char == "<"} {
	if {$slash} {
	  append text "<"
	  set slash 0
	} else {
	  # start of boldface
	  writeText
	  puts {set index [.help.text index insert]}
	}

      } elseif {$char == ">"} {
	if {$slash} {
	  append text ">"
	  set slash 0
	} else {
	  # end of boldface
	  writeText
	  puts {.help.text tag add bold $index insert}
	}
      } else {
	if {$slash} {
	  append text "\\$char"
	  set newLine 1
	  set slash 0
	} else {
	  append text $char
	  set newLine 0
	}
      }
    }
    if {$length != 0 && !$newLine} {
      append text " "
    }
  }
}
close $IN
writeText
puts {.help.text tag configure header -font $largeFont}
puts {.help.text tag configure italic -font $italicFont}
puts {.help.text tag configure bold -font $boldFont}
puts {.help.text configure -state disabled}

