proc changeSave {name} {
  global saveInfo changed
  if {$saveInfo($name) == 0} {
    .edit.save.but configure -text "Will be saved" \
	-command "changeSave $name"
  } else {
    .edit.save.but configure -text "Will not be saved" \
	-command "changeSave $name"
  }
  set saveInfo($name) [expr !$saveInfo($name)]
  set changed 1
}

proc subType {prevTypes type} {
  global subPath pathProgs widget2Help pathProgsNames
  destroy .menu
  frame .menu
  pack .menu -expand 1 -fill both
  if {[info exists subPath($type)]} {
    foreach but $subPath($type) {
      if {$prevTypes == ""} {
	set newType $type
      } else {
	set newType $prevTypes/$type
      }
      button .menu._$but -text "$but-->" \
	  -command "subType {$newType} {$but}" -anchor w
      pack .menu._$but -fill both -expand 1
    }
  }
  if {[info exists pathProgs($type)]} {
    foreach but $pathProgs($type) {
      button .menu._$but -text $pathProgsNames($but) -command $but -anchor w
      pack .menu._$but -fill both -expand 1
    }
  }

  if {$prevTypes == ""} {
    return
  } elseif {$prevTypes == "."} {
    button .menu.back -text "<---Back" -command "subType {} ." -anchor w
  } else {
    regexp {^(.+)/([^/]+)$} $prevTypes all pptype lastType
    button .menu.back -text "<---Back" \
	-command "subType {$pptype} {$lastType}" -anchor w
  }
  pack .menu.back -fill both -expand 1
}   
