#
# funktion to parse input file.
#
proc parseFile {} {
  global subPath progList pathProgs saveInfo argv argv0 pathProgsNames files

  lappend files [file tail $argv0]
  foreach fileName $files {
    set IN [open [lindex $argv 1]/$fileName]
    set funktion 0
    
    while {![eof $IN]} {
      gets $IN line
      if {$funktion} {
	# read the info line
	if {![regexp {^ *\#(.*)$} $line all line]} {
	  puts "Error in template file \"$fileName\", near funktion $funkName"
	  puts "Type path must be the first line in the funktion"
	  exit -1
	}
	set lastPath "."
	while {[regexp {^([^/]*)/(.*)$} $line all elm line]} {
	  set elm [string trim $elm]
	  uniqAppend subPath($lastPath) $elm
	  set lastPath $elm
	}
	set line [string trim $line]
	if {$line == ""} {
	  set line $funkName
	}
	set pathProgsNames($funkName) $line
	lappend pathProgs($lastPath) $funkName
	set funktion 0
      } elseif {[regexp {^proc ([^\{]+) \{} $line all funk]} {
	set funkName $funk
	lappend progList $funk
	set saveInfo($funk) 0
	set funktion 1
      }
    }
    close $IN
  }
}
