############################################################
#           This funktion, save the templates.             
############################################################
proc save_template {} {
  global progList saveInfo answers shortDesc ok editInfo setup
  set noSave 0
  set initProg $editInfo(name)

  #
  # Making the window for print.
  #
  if {$setup(print)} {
    set w .output
    if {[winfo exists $w]} {
      $w.text delete 1.0 end
    } else {
      toplevel $w
      wm withdraw $w

      button $w.ok -text OK -command "destroy $w"
      pack $w.ok -padx 3m -pady 3m -ipadx 2m -ipady 1m -side bottom

      text $w.text -relief raised -bd 2 -yscrollcommand "$w.scroll set" \
	  -setgrid true
      scrollbar $w.scroll -relief flat -command "$w.text yview"
      pack $w.scroll -side right -fill y
      pack $w.text -side left -expand yes -fill both
      wm geometry $w 50x15-0+0
    }
  }

  #
  # opening the file for output
  #
  if {$setup(file)} {
    set OUTPUT [open $setup(dotfile) w]
  }

  #
  # decide how much to save
  #
  if {$setup(onePage)} {
    set plist $editInfo(name)
  } else {
    set plist $progList
  }

  #
  # runs through all the files, which have to be saved
  #
  foreach prog $plist {
    if {(!$setup(onePage) && $saveInfo($prog) == 0)} continue
    set editInfo(name) $prog

    linkVars $prog top
    set answers {}
    set err [catch {uplevel \#0 $ok($prog)} errmsg]


    #
    # saveing the menu gave an error
    #
    if {$err} {
      global errorInfo pathProgsNames
      set info $errorInfo
      set what [tk_dialog .dialog "Error while saving" "an error occurred in module: \"$pathProgsNames($prog)\", with the following error message: \"$errmsg\". What do you want to do?" error -1 "Continue without saving this module" "Goto errornous module" "see stack trace"]
      if {$what == 1} {
	eval $prog
	return
      }
      if {$what == 2} {
	set w .tkerrorTrace
	catch {destroy $w}
	toplevel $w -class ErrorTrace
	wm minsize $w 1 1
	wm title $w "Stack Trace for Error"
	wm iconname $w "Stack Trace"
	button $w.ok -text OK -command "destroy $w;eval $prog"
	text $w.text -relief raised -bd 2 -yscrollcommand "$w.scroll set" \
	    -setgrid true -width 40 -height 10
	scrollbar $w.scroll -relief flat -command "$w.text yview"
	pack $w.ok -side bottom -padx 3m -pady 3m -ipadx 2m -ipady 1m
	pack $w.scroll -side right -fill y
	pack $w.text -side left -expand yes -fill both
	$w.text insert 0.0 $info
	$w.text mark set insert 0.0
	
	# Center the window on the screen.
	
	wm withdraw $w
	update idletasks
	set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
		   - [winfo vrootx [winfo parent $w]]]
	set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
		   - [winfo vrooty [winfo parent $w]]]
	wm geom $w +$x+$y
	wm deiconify $w
	eval $prog
	return
      }
    } else {
      #
      # no error occured, printing and/or saving
      #
      if {[info exists shortDesc($prog)] && $answers != ""} {
	if {$setup(print)} {
	  .output.text insert end "$shortDesc($prog)\n"
	}
	if {$setup(file)} {
	  puts $OUTPUT $shortDesc($prog)
	}
      }
      if {$setup(print)} {
	.output.text insert end $answers
      }
      if {$setup(file)} {
	puts $OUTPUT $answers
      }
    }
  }
  #
  # openng the window, and closing the files.
  #
  if {$setup(print)} {
    wm deiconify .output
  }
  if {$setup(file)} {
    close $OUTPUT
  }

  # exporting
  if {$setup(exportOnSave) == 1} {
    exportFile
  }
  
  # creating the original window
  if {$prog != $initProg} {
    eval $initProg
  }
}

############################################################
#    This procedure link variables to their basic names.
############################################################
proc linkVars {prefix parrent {save 0}} {
  global children widgetArgs editInfo saveDefault setup
  set function $editInfo(name)
  set count 0
  
  foreach child $children(${function}__$parrent) {
    global  ${prefix}_$child
    uplevel "catch {unset $child}"
    set type $widgetArgs(${function}__${child}_type)

    switch -exact -- $type {
      checkbox -
      int   -
      float -
      entry {
	if {$save} {
	  uplevel \#0 "set ${prefix}_$child \[set $child\]"
	} else {
	  if {[info exist ${prefix}_$child]} {
	    incr count
	    uplevel \#0 "set $child {[set ${prefix}_$child]}"
	  } else {
	    uplevel \#0 "set $child {}"
	  }
	}
      }
      menu {
	set entries $widgetArgs(${function}__${child}_entries)
	if {$save} {
	  upvar \#0 ${prefix}_$child old $child new
	  if {$old != $new(name)} {
	    set old $new(name)
	  } else {
	    set entry [lindex $entries $new(index)]
	    if {$old != $new(index)} {
	      set old $entry
	    }
	  }
	} else {
	  if {[info exists ${prefix}_$child]} {
	    incr count
	    uplevel \#0 "set ${child}(name) {[set ${prefix}_$child]}"
	    uplevel \#0 "set ${child}(index) {[lsearch -exact $entries [set ${prefix}_$child]]}"
	  } else {
	    uplevel \#0 "set ${child}(name) {}"
	    uplevel \#0 "set ${child}(index) -1"
	  }
	}
      }
      textbox {
	if {$save} {
	  upvar \#0 ${prefix}_$child x $child y
	  if {$x != $y} {
	    set x $y
	  }
	} else {
	  if {[info exist ${prefix}_$child]} {
	    incr count
	    uplevel \#0 "set $child {[set ${prefix}_$child]}"
	  } else {
	    uplevel \#0 "set $child {}"
	  }
	}
      }
      listbox {
	set entries $widgetArgs(${function}__${child}_entries)
	if {$save} {
	  upvar \#0 ${prefix}_$child old $child new
	  set indexes {}
	  foreach entry $new(name) {
	    set index [lsearch -exact $entries $entry]
	    if {$index != -1} {
	    lappend indexes $index
	    }
	  }
	  if {[lsort $old] != [lsort $indexes]} {
	    set old $indexes
	  } elseif {[lsort $old] != [lsort $new(index)]} {
	    set old $new(index)
	  }
	} else {
	  if {[info exist ${prefix}_$child]} {
	    incr count
	    uplevel \#0 "set ${child}(index) {[set ${prefix}_$child]}"
	    uplevel \#0 "set ${child}(name) {}"
	    foreach index [set ${prefix}_$child] {
	      uplevel \#0 "lappend ${child}(name) {[lindex $entries $index]}"
	    }
	  } else {
	    uplevel \#0 "set ${child}(index) {}"
	    uplevel "set ${child}(name) {}"
	  }
	}
      }
      extentry {
	# Nothing shall be done for extentry, they will be serve by forevery
      }
      line   -
      header {
	# Nothing It just have to be here.
      }
      default {
	error "Unknow type $type"
      }
    }
  }

  # linking the variable saveDefault
  set saveDefault $setup(saveDefault)

  return $count
}

############################################################
#    This procedure is used to run through an extentry
############################################################
proc forevery {extentry proc} {
  global children editInfo recursiveForevery
  set function $editInfo(name)

  # checking that the extentry realy is an extentry
  if {![info exists children(${function}__$extentry)]} {
    error "$extentry isn't an extented entry, so you can not use forevery"
  }

  # finding the parent to the extentry
  foreach child [array names children] {
    if {![string match $function* $child]} continue
    if {[lsearch -exact $children($child) $extentry] != -1} {
      set parent $child
      break
    }
  }

  if {$parent == "${function}__top"} {
    set prefix "${function}_$extentry"
  } else {
    
    if {![info exists recursiveForevery($parent)]} {
      regexp "^${function}__(.*)\$" $parent all par
      error "You can not make a forevery on $extentry, without a forevery on its parent, which is $par."
    }
    set prefix $recursiveForevery($parent)_$extentry
  }
  
  set row 0
  while {1} {
    if {![linkVars $prefix$row $extentry]} {
      break
    }
    set recursiveForevery(${function}__$extentry) $prefix$row
    set result [catch {uplevel \#0 $proc} err]
    linkVars $prefix$row $extentry 1
    switch  $result {
      1 {error $err}
      3 break
    }
    incr row
  }
  catch {unset recursiveForevery(${function}__$extentry)}
}

############################################################
#    This procedure enables or disables widgets
############################################################
proc Enable {args} {
  global state editInfo children
  set function $editInfo(name)

  foreach widget $args {
    enable_disable normal $widget
  }
  packAll .edit.options $function 0 0
}

proc Disable {args} {
  global state editInfo children
  set function $editInfo(name)

  foreach widget $args {
    enable_disable disabled $widget
  }
  packAll .edit.options $function 0 0
}

proc enable_disable {mode name} {
  global state editInfo children widgetArgs recursiveForevery
  set function $editInfo(name)
  if {![info exists widgetArgs(${function}__${name}_type)]} {
    error "Enable/Disable called with an unknow widget: \"$name\""
  }
  set type $widgetArgs(${function}__${name}_type)

  # finding the parent to the element
  foreach child [array names children] {
    if {![string match ${function}* $child]} continue
    if {[lsearch -exact $children($child) $name] != -1} {
      set parent $child
      break
    }
  }

  # finding the variable prefix
  if {$parent == "${function}__top"} {
    set prefix $function
  } else {
    if {![info exists recursiveForevery($parent)]} {
      regexp "^${function}__(.*)\$" $parent all par
	error "You can not Disable/Enable \"$name\", without a forevery on its parent, which is \"$par\"."
    }
    set prefix $recursiveForevery($parent)
  }

  set state(${prefix}_$name) $mode
  if {$type == "extentry"} {
    forevery $name "foreach child {[set children(${function}__$name)]} {enable_disable $mode \$child}"
  }
}

proc useVars {} {
  global editInfo
  linkVars $editInfo(name) top
}

proc saveVars {} {
  global editInfo
  linkVars $editInfo(name) top 1
}
