proc setup {} {
  global setup temp widget2Help
  if {[winfo exists .setup]} {
    raise .setup
    wm deiconify .setup
    return
  }
  toplevel .setup

  foreach var {dotfile exportFile file print commentchar
    onePage saveDefault exportOnSave} {
    set temp($var) $setup($var)
  }
  
  label .setup.label -text "Setup"
  pack .setup.label

  frame .setup.filename
  pack .setup.filename -expand 1 -fill both
  label .setup.filename.label -text "dotfile :"
  entry .setup.filename.entry -textvariable temp(dotfile) -bd 2 -relief sunken
  pack .setup.filename.label .setup.filename.entry -side left

  frame .setup.export
  pack .setup.export -expand 1 -fill both
  label .setup.export.label -text "Export file:"
  entry .setup.export.entry -textvariable temp(exportFile) -bd 2 -relief sunken
  pack .setup.export.label .setup.export.entry -side left

  frame .setup.commentChar
  pack .setup.commentChar -anchor w
  label .setup.commentChar.label -text "Comment character: " 
  entry .setup.commentChar.entry -textvariable temp(commentchar) \
      -width 10 -relief sunken -bd 2
  pack .setup.commentChar.label .setup.commentChar.entry -side left
  bind .setup.commentChar.entry <BackSpace> {
    %W delete [expr [%W index insert] -1] [expr [%W index insert] -1];
  }

  frame .setup.save
  pack .setup.save -expand 1 -fill x
  checkbutton .setup.save.1 -text "save to file" \
      -variable temp(file) -anchor w 
  checkbutton .setup.save.2 -text "print" \
      -variable temp(print) -anchor w 
  pack .setup.save.1 .setup.save.2 -fill x -side left -fill x -expand 1
  
  checkbutton .setup.whatTosave -text "Save defaults too" \
      -variable temp(saveDefault) -anchor w
  checkbutton .setup.onePage -text "Just save one page at a time"\
      -variable temp(onePage) -anchor w
  checkbutton .setup.exportOnSave -text "export when saving" \
      -variable temp(exportOnSave) -anchor w
  pack .setup.whatTosave .setup.onePage .setup.exportOnSave -fill both -expand 1

  frame .setup.buttons
  pack .setup.buttons -expand 1 -fill x
  button .setup.buttons.ok -text "OK" -command {
    foreach var {dotfile exportFile file print commentchar
      onePage saveDefault exportOnSave} {
      set setup($var) $temp($var)
    }
    if {[winfo exists .edit.save.but]} {
      if {$setup(onePage)} {
	.edit.save.but configure -state disabled
      } else {
	.edit.save.but configure -state normal
      }
    }
    destroy .setup
  }
  button .setup.buttons.cancel -text "CANCEl" -command {
    destroy .setup
  }
 
  pack .setup.buttons.ok .setup.buttons.cancel -side left -fill x -expand 1
}
