############################################################
#                          Basic Objects
############################################################
proc CheckBox {name args} {
  global widgetArgs editInfo
  set function $editInfo(name)
  set widgetArgs(${function}__${name}_default) 0
  widget $name checkbox $args
}
proc Int {name args} {
  global widgetArgs editInfo
  set function $editInfo(name)
  set widgetArgs(${function}__${name}_default) {}
  set widgetArgs(${function}__${name}_textafter) {}
  widget $name int $args
}
proc Float {name args} {
  global widgetArgs editInfo
  set function $editInfo(name)
  set widgetArgs(${function}__${name}_default) {}
  set widgetArgs(${function}__${name}_textafter) {}
  widget $name float $args
}
proc Entry {name args} {
  global widgetArgs editInfo
  set function $editInfo(name)
  set widgetArgs(${function}__${name}_default) {}
  set widgetArgs(${function}__${name}_textafter) {}
  widget $name entry $args
}
proc TextBox {name args} {
  global widgetArgs editInfo
  set function $editInfo(name)
  set widgetArgs(${function}__${name}_default) {}
  widget $name textbox $args
}
proc Menu {name args} {
  global widgetArgs editInfo
  set function $editInfo(name)
  set widgetArgs(${function}__${name}_default) 0
  set widgetArgs(${function}__${name}_textafter) {}
  set widgetArgs(${function}__${name}_entries) {}
  widget $name menu $args
}
proc ListBox {name args} {
  global widgetArgs editInfo
  set function $editInfo(name)
  set widgetArgs(${function}__${name}_selectmode) extended
  set widgetArgs(${function}__${name}_default) {}
  set widgetArgs(${function}__${name}_entries) {}
  widget $name listbox $args
}
proc Line {name args} {
  global widgetArgs editInfo
  set function $editInfo(name)
  set widgetArgs(${function}__${name}_default) ""
  widget $name line $args
}
proc Header {name args} {
  global widgetArgs editInfo
  set function $editInfo(name)
  set widgetArgs(${function}__${name}_default) ""
  widget $name header $args
}

############################################################
#                         ExtEntry
############################################################
proc ExtEntry {name args} {
  global children editInfo widgetArgs
  set function $editInfo(name)
  set widgetArgs(${function}__${name}_orient) left
  set widgetArgs(${function}__${name}_count) 3
  set widgetArgs(${function}__${name}_entries) {}
  set widgetArgs(${function}__${name}_default) {}
  
  widget $name extentry $args
  
  set children(${function}__$name) $widgetArgs(${function}__${name}_entries)
  foreach var $children(${function}__$name) {
    set children(${function}__top) [lremove $children(${function}__top) $var]
  }
}

############################################################
#                     Object constructor
############################################################
proc widget {name type rest} {
  global help children widgetArgs editInfo texts

  set function $editInfo(name)

  set option ""
  foreach var $rest {
    if {[string index $var 0] == "-" && [string index $var 1] != "-"} {
      set option [string range $var 1 end]
      set first 1
    } else {
      if {$option == ""} {
	error "no option for $name in $function, input string: \"$var\""
      }
      if {[string index $var 0] == "-"} {
	set var [string range $var 1 end]
      }
      if {[info exists widgetArgs(${function}__${name}_$option)] & !$first} {
	append widgetArgs(${function}__${name}_$option) " $var"
      } else {
	set widgetArgs(${function}__${name}_$option) $var
      }
      set first 0
    }
  }

  if {![info exist widgetArgs(${function}__${name}_help)]} {
    set widgetArgs(${function}__${name}_help) "No Help"
  }
  set help($name) $widgetArgs(${function}__${name}_help)
  lappend children(${function}__top) $name
  set widgetArgs(${function}__${name}_type) $type
  if {![info exist widgetArgs(${function}__${name}_text)]} {
    set widgetArgs(${function}__${name}_text) ""
  }
  set texts(${function}__$name) $widgetArgs(${function}__${name}_text)
}

############################################################
#     This procedure is the general packing procedure.
############################################################
proc packAll {path function new {pack 1}} {
  global children widgetArgs editInfo
  set function $editInfo(name)
  foreach child $children(${function}__top) {
    set default $widgetArgs(${function}__${child}_default)
    set type $widgetArgs(${function}__${child}_type)
    Pack $path $function $child $pack
    if {$new} {
      setVariable $child $path $function $default
    }
  }
}
      
############################################################
#     This is the genal procedure for packing objects
############################################################
proc Pack {path prefix name pack {orient top}} {
  global widgetArgs editInfo path2Help state

  set function $editInfo(name)
  set default $widgetArgs(${function}__${name}_default)

  set type $widgetArgs(${function}__${name}_type)
  set path2Help($path._$name) $name
  eval pack_$type \"$path\" \"$prefix\" \"$name\" \"$pack\" \"$orient\"

  if {![info exists state(${prefix}_$name)]} {
    set state(${prefix}_$name) "normal"
  }

  #
  # setting the state.
  #
  switch $type {
    checkbox {
      $path._$name configure -state $state(${prefix}_$name)
    }
    entry -
    int -
    float {
      $path._$name.2 configure -state $state(${prefix}_$name)
    }
    textbox {
      $path._$name.text configure -state $state(${prefix}_$name)
      set w $path._$name
      if {$state(${prefix}_$name) == "normal"} {
	$w.scroll configure -command "$w.text yview"
      } else {
	$w.scroll configure -command ""
      }
    }
    menu {
      $path._$name.bar configure -state $state(${prefix}_$name)
    }
    listbox {
      set w $path._$name
      if {$state(${prefix}_$name) == "normal"} {
	# nothing to be done...things done in Pack
	$w.scroll configure -command "$w.box yview"
	bindtags $w.box "Listbox $w.box .edit all"
      } else {
	bind $w.box <Enter> ""
	bind $w.box <ButtonRelease-1> break
	bind $w.box <ButtonPress-1> break
	bindtags $w.box {$w.box}
	$w.scroll configure -command ""
      }
    }
    extentry {
      set w $path._$name
      if {$state(${prefix}_$name) == "normal"} {
	$w.scroll configure -command "scroll $w $prefix $name"
      } else {
	$w.scroll configure -command ""
      }
    }
    line {}
    header {}
    default {
      error "unknow type $type"
    }
  }
}

############################################################
#          pack procedure for checkbox
############################################################
proc pack_checkbox {path prefix name pack orient} {
  if {$pack} {
    global widgetArgs editInfo
    set function $editInfo(name)

    set args [makeArgsList $name]
    set text $widgetArgs(${function}__${name}_text)
    eval checkbutton $path._$name -text \{$text\} -variable ${prefix}_$name \
	-relief flat -command \"makeChange $name\" $args
    pack $path._$name -anchor w -expand 1 -side $orient
  } else {
    $path._$name configure -variable ${prefix}_$name
  }
}

############################################################
#          pack procedure for entry
############################################################
proc pack_entry {path prefix name pack orient} {
  set w $path._$name
  if {$pack} {
    global widgetArgs editInfo
    set function $editInfo(name)
    set args [makeArgsList $name textafter]

    set textBefore $widgetArgs(${function}__${name}_text)
    set textAfter $widgetArgs(${function}__${name}_textafter)

    frame $w
    pack $w  -anchor w -expand 1 -fill x -side $orient
    label $w.1 -text $textBefore
    eval entry $w.2 -textvariable ${prefix}_$name -relief sunken $args
    label $w.3 -text $textAfter
    pack $w.1 -side left -anchor w
    pack $w.3 $w.2 -side right -padx 2
    bind $path._$name.2 <KeyPress> "makeChange $name"
  } else {
    global ${prefix}_$name
    if {![info exists ${prefix}_$name]} {
      set ${prefix}_$name ""
    }
    $w.2 configure -textvariable ${prefix}_$name
  }
}

############################################################
#          pack procedure for int
############################################################
proc pack_int {path prefix name pack orient} {
  pack_entry "$path" "$prefix" "$name" "$pack" "$orient"
  if {$pack} {
    eval $path._$name.2 configure -width 5
    bind $path._$name.2 <KeyPress> "checkInt %W"
  }
}

############################################################
#          pack procedure for float
############################################################
proc pack_float {path prefix name pack orient} {
  pack_entry "$path" "$prefix" "$name" "$pack" "$orient"
  if {$pack} {
    eval $path._$name.2 configure -width 5
    bind $path._$name.2 <KeyPress> "checkFloat %W"
  }
}
############################################################
#          pack procedure for textbox
############################################################
proc pack_textbox {path prefix name pack orient} {
  global ${prefix}_$name
  
  global traceTable editInfo
  set w $path._$name
  set function $editInfo(name)
  if {[info exists traceTable(${function}_$w)]} {
    uplevel \#0 \
	"trace vdelete $traceTable(${function}_$w) w {trace_textbox $w.text}"
    unset traceTable(${function}_$w)
  }
  
  if {$pack} {
    global widgetArgs editInfo
    set function $editInfo(name)
    set args [makeArgsList $name]
    
    set text $widgetArgs(${function}__${name}_text)
    pack [frame $w] -anchor w -expand 1 -fill x -side $orient
    pack [label $w.label -text $text] -expand 1 -fill x
    eval text $w.text -relief raised  -yscrollcommand \"$w.scroll set\" \
	-wrap word -width 40 -height 5 $args
    scrollbar $w.scroll -command "$w.text yview"
    pack $w.text $w.scroll -side left -fill y
  } else {
    ${path}._$name.text delete 1.0 end
  }
  # I have to enable it, to insert element into it.
  ${path}._$name.text configure -state normal
  global ${prefix}_$name ${prefix}_${name}_scroll
  if {[info exists ${prefix}_$name]} {
    $w.text insert 1.0 [set ${prefix}_$name]
    if {[info exists ${prefix}_${name}_scroll]} {
      $w.text mark set insert [lindex [set ${prefix}_${name}_scroll] 1]
      $w.text yview [lindex [set ${prefix}_${name}_scroll] 0]
    }
  } else {
    set ${prefix}_$name ""
  }
  trace variable ${prefix}_$name w "trace_textbox $w.text"
  set traceTable(${function}_$w) ${prefix}_$name
  bind $w.text <KeyPress> "set copyingTextBoxFlag 1;set ${prefix}_$name \[$w.text get 1.0 end-1c\];set ${prefix}_${name}_scroll \[list \[$w.text index @1,0\] \[$w.text index insert\]\];set copyingTextBoxFlag 0;makeChange $name"
}

############################################################
#          pack procedure for menu
############################################################
proc pack_menu {path prefix name pack orient} {
  global ${prefix}_$name widgetArgs editInfo
  set function $editInfo(name)
  
  set entries $widgetArgs(${function}__${name}_entries)
  set w $path._$name
  if {$pack} {
    set tleft $widgetArgs(${function}__${name}_text)
    set tright $widgetArgs(${function}__${name}_textafter)
    set args [makeArgsList $name entries textafter]
    pack [frame $w] -anchor w -expand 1 -fill x -side $orient
    label $w.tleft -text $tleft
    label $w.tright -text $tright
    eval menubutton $w.bar -textvariable ${prefix}_$name -indicatoron 1 \
	-menu $w.bar.menu \
	-relief raised -bd 2 -padx 4p -pady 4p -highlightthickness 2 \
	-anchor c $args
    pack  $w.tleft $w.bar $w.tright -side left
    menu $w.bar.menu -tearoff 0
    foreach entry $entries {
      $path._$name.bar.menu add command -label $entry \
	  -command "[list set ${prefix}_$name $entry];makeChange $name"
    }
    if {![info exists ${prefix}_$name]} {
      set ${prefix}_$name [lindex $entries 0]
    }
  } else {
    $w.bar configure -textvariable ${prefix}_$name
    set i 0
    foreach entry $entries {
      $path._$name.bar.menu entryconfigure $i \
	  -command "[list set ${prefix}_$name $entry];makeChange $name"
      incr i
    }
  }
}

############################################################
#          pack procedure for listbox
############################################################
proc pack_listbox {path prefix name pack orient} {
  global widgetArgs editInfo traceTable ${prefix}_$name
  set function $editInfo(name)
  set text $widgetArgs(${function}__${name}_text)
  set entries $widgetArgs(${function}__${name}_entries)
  set selectmode $widgetArgs(${function}__${name}_selectmode)
  set w $path._$name

  if {[info exists traceTable(${function}_$w)]} {
    uplevel \#0 \
	"trace vdelete $traceTable(${function}_$w) w {trace_listbox $w.box}"
    unset traceTable(${function}_$w)
  }

  if {$pack} {
    set args [makeArgsList $name entries]
    pack [frame $w] -anchor w -expand 1 -fill x -side $orient
    pack [label $w.label -text $text] -fill x -expand 1
    eval listbox $w.box -yscrollcommand \"$w.scroll set\" -relief raised \
	-borderwidth 2 -height 5 -exportselection off $args
    scrollbar $w.scroll -command "$w.box yview"
    pack $w.box $w.scroll -side left -fill y
    foreach entry $entries {
      $w.box insert end $entry
    }
  } else {
    $w.box selection clear 0 end
  }
  if {[info exists ${prefix}_$name]} {
    foreach sel [set ${prefix}_$name] {
      $w.box selection set $sel
    }
  } else {
    set ${prefix}_$name ""
  }
  uplevel \#0 "trace variable ${prefix}_$name w {trace_listbox $w.box}"
  bind $w.box <ButtonRelease-1> "set copyingListBoxFlag 1;set ${prefix}_$name \[$w.box curselection\];set copyingListBoxFlag 0;makeChange $name"
}

############################################################
#          pack procedure for extEntry
############################################################
proc pack_extentry {path prefix name pack orient} {
  global widgetArgs children editInfo scrollValue
  set function $editInfo(name)
  
  set w $path._$name
  set count $widgetArgs(${function}__${name}_count)
  if {$pack} {
    set text $widgetArgs(${function}__${name}_text)
    set subOrient $widgetArgs(${function}__${name}_orient)
    set args [makeArgsList $name entries count orient]
    
    pack [eval frame $w $args] -side $orient 
    pack [label $w.header -text $text] -expand 1 -fill x
    
    scrollbar $w.scroll -command "scroll $w $prefix $name"
    pack $w.scroll -side right -fill y -anchor w -expand 1
    if {![info exists scrollValue(${prefix}_$name)]} {
      set scrollValue(${prefix}_$name) "$count $count 0 [expr $count-1]"
    }
    eval $w.scroll set $scrollValue(${prefix}_$name)
    set widgetArgs(scrollbar) scrollbar
   
    for {set row 0} {$row < $count} {incr row} {
      pack [frame $w.row$row]
      foreach child $children(${function}__$name) {
	Pack $w.row$row ${prefix}_$name$row $child 1 $subOrient
      }
    }
  } else {
    if {![info exists scrollValue(${prefix}_$name)]} {
      set scrollValue(${prefix}_$name) "$count $count 0 [expr $count-1]"
    }
    eval $w.scroll set $scrollValue(${prefix}_$name)
    $w.scroll configure -command "scroll $w $prefix $name"
    set offset [lindex $scrollValue(${prefix}_$name) 2]
    for {set row 0} {$row < $count} {incr row} {
      foreach child $children(${function}__$name) {
	Pack $w.row$row ${prefix}_$name[expr $row + $offset] $child 0
      }
    }
  }
}

############################################################
#          pack procedure for line
############################################################
proc pack_line {path prefix name pack new} {
  if {$pack} {
    set args [makeArgsList $name]
    eval frame $path.$name -height 0.05c -relief sunken -bd 1 $args
    pack $path.$name -fill x -expand 1 -pady 3
  }
}

############################################################
#          pack procedure for header
############################################################
proc pack_header {path prefix name pack new} {
  if {$pack} {
    global widgetArgs editInfo
    set function $editInfo(name)
    set text $widgetArgs(${function}__${name}_text)
    set w $path._$name
    set args [makeArgsList $name]
    pack [frame $w -bd 3 -relief groove] -expand 1 -fill x
    pack [eval label $w.label -text \{$text\} $args] -expand 1 -fill x
  }
}

############################################################
#   This function sets the default variables recursive
############################################################
proc setVariable {name path prefix default} {
  global widgetArgs children editInfo
  set function $editInfo(name)
  
  set type $widgetArgs(${function}__${name}_type)
  switch -exact $type {
    checkbox -
    int      -
    float    -
    entry {
      global ${prefix}_$name
      set ${prefix}_$name $default
    }
    textbox {
      if {[info commands ${path}._$name.text] != ""} {
	${path}._$name.text insert 1.0 $default
      }
      global ${prefix}_$name
      set ${prefix}_$name $default
    }
    menu {
      set entries $widgetArgs(${function}__${name}_entries)
      if {[isIndex $default [llength $entries]]} {
	set index $default
      } else {	
	set index [lsearch -exact $entries $default]
	if {$index == -1} {
	  error "\"$defualt\" isn't an index or element in Menu $name, should be one of: \"$entries\""
	}
      }
      global ${prefix}_$name
      set ${prefix}_$name [lindex $entries $index]
    }
    listbox {
      set entries $widgetArgs(${function}__${name}_entries)
      global ${prefix}_$name
      set ${prefix}_$name {}
      foreach entry $default {
	if {[isIndex $entry [llength $entries]]} {
	  set index $entry
	} else {
	  set index [lsearch -exact $entries $entry]
	  if {$index == -1} {
	    error "\"$entry\" isn't a index or element in ListBox \"$name\", should be one of: \"$entries\""
	  }
	}
	lappend ${prefix}_$name $index
	$path._$name.box selection set $index
      }
    }
    
    extentry {
      set count $widgetArgs(${function}__${name}_count)
      set row 0
      set w $path._$name
      foreach value $default {
	set i 0
	foreach child $children(${function}__$name) {
	  setVariable $child $w.row$row \
	      ${prefix}_$name$row [lindex $value $i]
	  
	  # if the child is an extentry, then set its scrollbar
	  if {$widgetArgs(${function}__${child}_type) == "extentry"} {
	    set subCount $widgetArgs(${function}__${child}_count)
	    set bar "[llength [lindex $value $i]] $subCount 0 [expr $subCount-1]"
	    if {$row < $count} {
	      eval $w.row${row}._$child.scroll set $bar
	    }
	  }
	  incr i
	}
	incr row
      }
    }
  }
}

############################################################
#                      scroll bars
############################################################
proc scroll {path prefix name newTop} {
  global widgetArgs scrollValue children editInfo
  set function $editInfo(name)
  
  if {$newTop < 0} {set newTop 0}
  set count $widgetArgs(${function}__${name}_count)

  # reading the scrollbar
  set scrollbar ${path}.scroll
  set totalUnit [lindex [$scrollbar get] 0]
  set windowUnits [lindex [$scrollbar get] 1]
  set oldTop [lindex [$scrollbar get] 2]
  set oldBot [lindex [$scrollbar get] 3]
  set scrollCount [expr $newTop - $oldTop]


  # setting the scrollbar
  if {[expr $newTop+$windowUnits] > $totalUnit} {
    set totalUnit [expr $newTop+$windowUnits]
  }
  set bar "$totalUnit $windowUnits $newTop [expr $newTop+$windowUnits-1]"
  eval $scrollbar set $bar
  set scrollValue(${prefix}_$name) $bar

  for {set row 0} {$row < $count} {incr row} {
    foreach child $children(${function}__$name) {
      Pack $path.row$row ${prefix}_$name[expr $row+$newTop] $child 0
    }
  }
}

proc makeArgsList {name args} {
  global editInfo widgetArgs
  set result ""
  
  set function $editInfo(name)
  foreach var [array names widgetArgs] {
    if {![regexp "^${function}__${name}_(.*)\$" $var all option]} continue
    set found 0
    foreach elm [eval lappend temp $args text default help type] {
      if {$elm == $option} {
	set found 1
	continue
      }
    }
    if {!$found} {
      append result " -$option {$widgetArgs($var)}"
    }
  }
  return $result
}

############################################################
#              trace funktion for the textbox.
############################################################
proc trace_textbox {path variable subvar operation} {
  global copyingTextBoxFlag
  if {[info exists copyingTextBoxFlag] && $copyingTextBoxFlag == 1} return
  upvar $variable x
  set insert [$path index insert]
  $path delete 1.0 end
  $path insert 1.0 $x
  $path mark set insert $insert
}

############################################################
#              trace funktion for the listbox.
############################################################
proc trace_listbox {path variable subvar operation} {
  global copyingListBoxFlag
  if {[info exists copyingListBoxFlag] && $copyingListBoxFlag == 1} return
  upvar $variable x
  $path selection clear 0 end
  foreach index $x {
    $path selection set $index
  }
}

############################################################
# This function checks wheter element can be a index in
# a widget with noOfElm number of elements.
############################################################
proc isIndex {element noOfElm} {
  if {![regexp {^[0-9]+$} $element]} {
    return 0
  }
  if {[expr $element+1] > $noOfElm} {
    return 0
  }
  return 1
}
