#
# funktion to chose between two element. just like "? : " operator
#
proc pick {truth true false} {
  if {[uplevel \#0 expr \{$truth\}]} {
    return $true
  } else {
    return $false
  }
}
  

proc _tospace {str} {
  return [join [split $str "_"] " "]
}

proc spaceto_ {str} {
  return [join [split $str " "] "_"]
}

proc checkInt {widget} {
  if {![regexp {^-?[0-9]*$} [$widget get]]} {
    $widget delete [expr [$widget index insert] -1] [$widget index insert]
    error "This entry is only for integers"
  }
}

proc checkFloat {widget} {
  if {![regexp {^-?[0-9]*\.?[0-9]*$} [$widget get]]} {
    $widget delete [expr [$widget index insert] -1] [$widget index insert]
    error "This entry is only for floating points"
  }
}

#
# append to a list, if it the element doesn't exist.
#
proc uniqAppend {list value} {
  upvar $list l
  if {![info exists l]} {
    uplevel set $list [list \"$value\"]
  } elseif {[lsearch -exact $l $value] == -1} {
    uplevel lappend $list \"$value\"
  }
}

proc lremove {list value} {
  set index [lsearch -exact $list $value]
  return [lreplace $list $index $index]
}

proc min {x y} {
  if {$x < $y} {return $x}
  return $y
}
