/*********************************************************
 Copyright (C) 1994 Patrick Voigt
*********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <X11/xpm.h>
#include <Xm/Xm.h>
#include <Xm/AtomMgr.h>
#include <Xm/List.h>
#include <Xm/DragDrop.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/Frame.h>
#include <Xm/PushBG.h>
#include <Xm/SeparatoG.h>
#include <Xm/RowColumn.h>

#include "dd.h"
#include "fm.h"
#include "pixmaps.h"

extern Widget pb1, icon_row[2];
extern struct dir *v_head, *v_actual;
extern int list_nr;
extern char **table;
extern char f_name[2048];

Widget drag_source;
int drop_target;
Pixmap pixmaps[10];
Widget i_popup = NULL;
Boolean is_my_drag = False;
Atom COMPOUND_TEXT, ICON_INFO;
struct drag_icon *i_head = NULL;

void HandleDrop (Widget w, XtPointer client_data, XtPointer call_data);
void tools_HandleDrop (Widget w, XtPointer client_data, XtPointer call_data);

/********************************************************************************
 loescht ein Icon
********************************************************************************/
void delete_icon (struct drag_icon *help)
{
  int num;

  delete []help->path;
  num = help->num_files;
  while (num)
    delete []help->files[--num];
  if (help->num_files)
    delete []help->files;
  XtDestroyWidget (help->symbol);
  delete help;
}

/********************************************************************************
  Callback-Routine der Icons, wird bei Betaetigung der linken Maustaste gerufen 
  falls Icon fuer directory steht, wird diese Verzeichnis erzeugt
  und das alte geloescht 
********************************************************************************/
void icon_cb (Widget w, XtPointer client_data, XmPushButtonCallbackStruct *cbs)
{
  struct drag_icon *help = i_head;
  struct dir *temp = v_head;

  while (help->symbol != w)
    help = help->next;

  if (!help->files)
  {
    v_head = NULL;
    delete_list (temp);
    v_head = v_actual = create_list (help->path, NULL, ++list_nr, True);
    sensitiv_check();
    list_info();
  }
}

/********************************************************************************
  erzeugt Standard Icons und registriert alle Dropsites
  wird aus main gerufen
********************************************************************************/
void dragdrop_init (void)
{
  Widget lb[5], fr[5];
  Pixmap shapemask_return;
  Display *disp = XtDisplay (icon_row[0]);
  int n;
  Arg args[10];
  Atom importList;
  char *pixmap_data[] = {
                           (char*) tree,
                           (char*) house,
                           (char*) directory,
			   (char*) files,
                           (char*) editor,
                           (char*) eye,
                           (char*) la_print,
                           (char*) info,
                           (char*) recycle,
                           (char*) folders
                         };
  int i;

  COMPOUND_TEXT = XmInternAtom (disp, "COMPOUND_TEXT", False);
  ICON_INFO = XmInternAtom (disp, "ICON_INFO", False);

  importList = COMPOUND_TEXT;
  n = 0;
  XtSetArg (args[n], XmNimportTargets, &importList); n++;
  XtSetArg (args[n], XmNnumImportTargets, 1); n++;
  XtSetArg (args[n], XmNdropSiteOperations, XmDROP_COPY); n++;
  XtSetArg (args[n], XmNdropProc, HandleDrop); n++;

  XtVaSetValues (icon_row[0], XmNuserData, 5, NULL);
  XmDropSiteRegister (icon_row[0], args, n);

  for (i = 0; i < 10; i++)
    XpmCreatePixmapFromData (disp, RootWindow (disp, DefaultScreen (disp)), 
                             (char**) pixmap_data[i], &pixmaps[i], &shapemask_return, NULL);
  for (i = 0; i < 3; i++)
    if (table[i + 1])
    {
      fr[i] = XtVaCreateManagedWidget ("frame", xmFrameWidgetClass, icon_row[1],
                                                XmNmarginHeight, 2,
                                                XmNspacing, 40, NULL);
      lb[i] = XtVaCreateManagedWidget ("label", xmLabelWidgetClass, fr[i],
				                XmNlabelType, XmPIXMAP,
                                                XmNlabelPixmap, pixmaps[i + 4], NULL);
      XtUninstallTranslations (lb[i]);

      XtVaSetValues (lb[i], XmNuserData, i, NULL);
      XmDropSiteRegister (lb[i], args, n);
    }

  for (i = 3; i < 5; i++)
  {
    fr[i] = XtVaCreateManagedWidget ("frame", xmFrameWidgetClass, icon_row[1],
                                              XmNmarginHeight, 2,
                                              XmNspacing, 40, NULL);
    lb[i] = XtVaCreateManagedWidget ("label", xmLabelWidgetClass, fr[i],
				              XmNlabelType, XmPIXMAP,
                                              XmNlabelPixmap, pixmaps[i + 4], NULL);
    XtUninstallTranslations (lb[i]);

    XtVaSetValues (lb[i], XmNuserData, i, NULL);
    XmDropSiteRegister (lb[i], args, n);
  }

  i_head = new drag_icon; 
  i_head->symbol = XtVaCreateManagedWidget ("/", xmPushButtonWidgetClass, icon_row[0],
	  					 XmNlabelType, XmPIXMAP,
                                        	 XmNlabelPixmap, pixmaps[0], NULL);

  XtAddCallback (i_head->symbol, XmNactivateCallback, icon_cb, NULL);
  XtOverrideTranslations (i_head->symbol, XtParseTranslationTable ("<Btn3Down>: info()"));
  XtOverrideTranslations (i_head->symbol, XtParseTranslationTable ("<Btn2Down>: dummy()"));
  i_head->path = "/";
  i_head->files = NULL;
  i_head->num_files = 0;
  i_head->next = new drag_icon;

  i_head->next->symbol = XtVaCreateManagedWidget ("h", xmPushButtonWidgetClass, icon_row[0],
						        XmNlabelType, XmPIXMAP,
                                                        XmNlabelPixmap, pixmaps[1], NULL);
  XtAddCallback (i_head->next->symbol, XmNactivateCallback, icon_cb, NULL);
  XtOverrideTranslations (i_head->next->symbol,
                          XtParseTranslationTable ("<Btn3Down>: info()"));
  XtOverrideTranslations (i_head->next->symbol,
                          XtParseTranslationTable ("<Btn2Down>: dummy()"));
  i_head->next->path = new char[strlen(getenv ("HOME"))+2];
  strcpy (i_head->next->path, getenv ("HOME"));
  strcat (i_head->next->path, "/");
  i_head->next->files = NULL;
  i_head->next->num_files = 0;
  i_head->next->next = NULL;
}

Boolean DragConvertProc (Widget w, Atom *selection, Atom *target, Atom *typeRtn, 
                       XtPointer *valueRtn, unsigned long *lengthRtn, int *formatRtn,
                       unsigned long max_lengthRtn, XtPointer client_data,
                       XtRequestId *request_id)
{
  if (*target != ICON_INFO)
    return (False);

  *typeRtn = ICON_INFO;
  *valueRtn = NULL;
  *lengthRtn = 0;
  *formatRtn = 7;

  return (True);
}

/********************************************************************************
  Action-Routine, die mit ListWidgets verbunden ist und auf Druck 
  der mittleren Maustaste eine Drag-Operation beginnt
********************************************************************************/
void mk_drag (Widget w, XEvent *event, String *params, Cardinal *num_params)
{
  struct drag_icon *help = i_head;
  Arg args[4];
  Atom exportList[1];
  int n;

  drag_source = w;
  is_my_drag = True;

  while (help && help->symbol != w)
    help = help->next;

  if (help == NULL)
    XtCallActionProc (w, "ListProcessDrag", event, params, *num_params); 
  else
  {
    n = 0;
    exportList[0] = ICON_INFO;

    XtSetArg (args[n], XmNexportTargets, exportList); n++;
    XtSetArg (args[n], XmNnumExportTargets, 1); n++;
    XtSetArg (args[n], XmNdragOperations, XmDROP_COPY); n++;
    XtSetArg (args[n], XmNconvertProc, DragConvertProc); n++;

    XmDragStart (w, event, args, n);
  }
}

/********************************************************************************
  Action-Routine, die mit Pushbuttons (Icons) verbunden ist;
  wenn recht Maustaste ueber Icon betaetigt wird,
  werden Infos als Popup angezeigt 
********************************************************************************/
void mk_info (Widget w, XEvent *event, String *params, Cardinal *num_params)
{
  static Widget *items;
  struct drag_icon *help = i_head;
  int i;

  if (i_popup)
  {
    XtDestroyWidget (i_popup);
    delete []items;
  }

  while (help->symbol != w)
    help = help->next;
 
  i_popup = XmCreatePopupMenu (pb1, "i_popup", NULL, 0);

  if (help->files)
  {
    items = new Widget[help->num_files + 2];
    items[0] = XtVaCreateManagedWidget (help->path, xmPushButtonGadgetClass, i_popup, NULL);
    items[1] = XtVaCreateManagedWidget ("", xmSeparatorGadgetClass, i_popup, NULL);
    for (i = 0; i < help->num_files; i++)
      items[i + 2] = XtVaCreateManagedWidget (help->files[i], xmPushButtonGadgetClass,
                                              i_popup, NULL);
  }
  else
  {
    items = new Widget[1];
    items[0] = XtVaCreateManagedWidget (help->path, xmPushButtonGadgetClass, i_popup, NULL);
  }

  XmMenuPosition (i_popup, (XButtonPressedEvent*) event);
  XtManageChild (i_popup);
}


/********************************************************************************
  macht aus name eine Liste der darin enthaltenen Strings und gibt diese
  ueber cont zurueck, path enthaelt den Pfad in dem die Files aus cont
  zu finden sind,
  die Funktion gibt die Anzahl Strings in cont zurueck
********************************************************************************/
int mk_ddfiles (char *name, char **path, char ***cont)
{ 
  struct dir *temp = v_head;
  int i = 0, len, help_len, offset = 0, num_files;
  char **files, *string;

  string = name;
  while (temp->list != drag_source)
    temp = temp->next;

  if (v_actual == temp)
    offset = 29;

  while (name[i] != '\n')
    i++;

  help_len = len = strlen(name) - 1;
  if (len > i)                    // mehrere Eintraege
  {
    int k = 0;

    i = 0;
    while (name[i] != '\0')
    {
      while (name[i] != '\n' && name[i] != '\0')
        i++;
      if (name[i] == '\n')
        name[i++] = '\0';
      k++;
    }
   
    if (!strcmp (&name[offset], "."))
    {
      name = &name[offset + 2];
      len = len - offset - 2;
      k--;
      if (k == 1)
        goto label1;
    }

    *path = new char[strlen (temp->p.get_path()) + 1];
    strcpy (*path, temp->p.get_path());
    *cont = new char*[k + 1];
    files = *cont;
    num_files = k;
    files[0] = new char [strlen(&name[offset])+1];
    strcpy (files[0], &name[offset]);
    i = 0;
    k = 1;
    while (len > i)
    {
      while (name[i] != '\0' && len > i)
        i++;
      if (len > i)
      {
        files[k] = (char*) new char [strlen (&name[++i + offset]) + 1];
        strcpy (files[k++], &name[i + offset]);
      }
    }
    files[k] = NULL; 
  }
  else                            // nur ein Eintrag 
  {
label1:
    XmString str;
    int *list, cnt;

    i = 0;
    while (name[i] != '\0' && name[i] != '\n')
      i++;
    name[i] = '\0';

    str = XmStringCreate (name, "charset1"); 
    if (XmListGetMatchPos (drag_source, str, &list, &cnt))       // directory
    {
      *path = new char[strlen(temp->p.get_path()) + strlen(&name[offset]) + 2];
      strcpy (*path, temp->p.get_path());
      if (strlen(&name[offset]) > 1 || name[offset] != '.') 
      { 
        strcat (*path, &name[offset]);
        strcat (*path, "/");
      }
      *cont = NULL;
      num_files = 0;
      delete []list;
    } 
    else                                                         // anderes file 
    {
      *path = new char[strlen(temp->p.get_path()) + 1];
      strcpy (*path, temp->p.get_path());
      *cont = new char* [2];
      files = *cont;
      files[0] = new char[strlen(&name[offset]) + 1];
      strcpy (files[0], &name[offset]);
      num_files = 1;
      files[1] = NULL;
    }
    XmStringFree (str);
  }

  for (i = 0; i <= help_len; i++)
    if (!string[i])
      string[i] = '\n';
  return num_files;
}


/********************************************************************************
  Konvertierug von Parametern bei einem Drop  
  und moegliche Erzeugung eines neuen Icons
********************************************************************************/
void TransferProc (Widget w, XtPointer closure, Atom *seltype, 
                   Atom *type, XtPointer value, unsigned long *length,
                   int format)
{
  extern void dd_info (Widget w, char *file);  
  extern void dd_delete (char *path, char **files, int count);  
  extern void dd_transfer (char *path, char **files, int count,
                            int target, Boolean icon);
  
  struct drag_icon *help = i_head, *pre_help;
  char **files;
  char *path;
  char *argv[50];
  char name[512];
  int i, num;
  Boolean is_icon;

  if (drop_target < 0)
  {
    if (*type == ICON_INFO)
    {
      while (help->symbol != drag_source)
        help = help->next;
      path = help->path;
      files = help->files;
      i = num = help->num_files;
      is_icon = True;
    }
    else
    {
      num = mk_ddfiles ((char*) value, &path, &files);
      XtFree ((char*) value);
      is_icon = False;
    }

    dd_transfer (path, files, num, drop_target, is_icon);
    return;
  }
  
  if (*type == COMPOUND_TEXT)
  {
    if (drop_target >= 3)
    {
      switch (drop_target)
      {
        case 3:  i = num = mk_ddfiles ((char*) value, &path, &files);
                 if (num == 1)
                   dd_info (drag_source, files[0]);
                 else
                   if (num == 0)
                       dd_info (drag_source, path);

                 delete []path;
                 while (num)
                   delete []files[--num];
                 if (i)
                   delete []files;

                 break;

        case 4:  num = mk_ddfiles ((char*) value, &path, &files);
                 if (num > 0)
                   dd_delete (path, files, num);
                 else
                   dd_delete (path, NULL, 0);

                 break;

        case 5:  num = mk_ddfiles ((char*) value, &path, &files);
                 while (help)
	         {
                   if (!strcmp (help->path, path) && num == help->num_files)
		   {
                     for (i = 0; i < num; i++)
                       if (strcmp (help->files[i], files[i]))
                         break;
                     if (i == num)
		     {
                       delete []path;
                       i = num;
                       while (i)
                         delete []files[--i];
                       if (num)
                         delete []files;
                       return;
                     }      
                   }
                   pre_help = help;
                   help = help->next;
                 }
                 help = pre_help;

                 help->next = new drag_icon;
                 help = help->next;
                 help->next = NULL;

                 help->num_files = num;
                 help->path = path;
                 help->files = files;

                 help->symbol = XtVaCreateManagedWidget ("pb", xmPushButtonWidgetClass, 
                                                               icon_row[0], NULL);
                 XtAddCallback (help->symbol, XmNactivateCallback, icon_cb, NULL);
                 XtOverrideTranslations (help->symbol,
                                         XtParseTranslationTable ("<Btn2Down>: drag()"));
                 XtOverrideTranslations (help->symbol,
                                         XtParseTranslationTable ("<Btn3Down>: info()"));


                 if (help->num_files)
                   XtVaSetValues (help->symbol, XmNlabelType, XmPIXMAP,
                                                XmNlabelPixmap, pixmaps[3], NULL);
                 else
                   XtVaSetValues (help->symbol, XmNlabelType, XmPIXMAP,
                                                XmNlabelPixmap, pixmaps[2], NULL);
                 break;
      }
      XtFree ((char*) value);
      return;
    }

    num = mk_ddfiles ((char*) value, &path, &files);
    if ( num == 1)
    {
      if (!fork())
      {
        strcpy (name, table[drop_target + 1]);
        mk_argv (name, argv);
     
        i = 0;
        while (argv[i] != NULL)
          i++;

        strcpy (f_name, path);
        strcat (f_name, files[0]);
        argv[i] = f_name;
        argv[i + 1] = NULL;

        execv (name, &argv[0]); 
        exit (1);
      }
    }

    delete []path;
    i = num;
    while (i)
      delete []files[--i];
    if (num)
      delete []files;
  }


  if (*type == ICON_INFO)
  {
    help = i_head;
    while (help && help->symbol != drag_source)
    {
      pre_help = help;
      help = help->next;
    }

    if (drop_target == 4)
    {
      pre_help->next = help->next;
      delete_icon (help);
    }
  }
  XtFree ((char*) value);
}

/********************************************************************************
  wird gerufen, wenn ein Drop auftritt  
********************************************************************************/
void HandleDrop (Widget w, XtPointer client_data, XtPointer call_data)
{
  XmDropProcCallback      DropData;
  XmDropTransferEntryRec  transferEntries;
  XmDropTransferEntry     transferList;
  Arg args[10];
  Atom *export_targets;
  int n = 0;
  Boolean abort = False;
  struct dir *help = v_head;
  struct drag_icon *help1 = i_head;

  DropData = (XmDropProcCallback) call_data; 

  if (!is_my_drag)
  {
    n = 0;
    XtSetArg (args[n], XmNtransferStatus, XmTRANSFER_FAILURE); n++;
    XmDropTransferStart (DropData->dragContext, args, n);
    return;
  }

  XtVaGetValues (w, XmNuserData, &drop_target, NULL);
  XtVaGetValues (DropData->dragContext, XmNexportTargets, &export_targets, NULL);

  if (XtParent(drag_source) == icon_row[0])
  {
    if (drop_target != 4 && drop_target > 0)
      abort = True;
    else
      if (drop_target < 0)
      {
        n = -1;
        while (help && n > drop_target)
	{
          help = help->next;
          n--;
        }
        while (help1->symbol != drag_source)
          help1 = help1->next;
        strcpy (f_name, help1->path);
        if (!help1->files)
	{
          n = strlen (f_name);
          n -= 2;
          while (f_name[n] != '/')
            n--;
          f_name[n + 1] = '\0';
        }
        if (!strcmp (help->p.get_path(), f_name))
          abort = True;
      } 
  }

  XtVaGetValues (drag_source, XmNuserData, &n, NULL);

  if ((DropData->dropAction != XmDROP) ||
      (DropData->operation != XmDROP_COPY) ||
      (n == drop_target) ||
      (abort))
  {
    n = 0;
    XtSetArg (args[n], XmNtransferStatus, XmTRANSFER_FAILURE); n++;
  }
  else
  {
    transferEntries.target = export_targets[0];
    transferEntries.client_data = (XtPointer) w;
    transferList = &transferEntries;

    n = 0;
    XtSetArg (args[n], XmNdropTransfers, transferList); n++;
    XtSetArg (args[n], XmNnumDropTransfers, 1); n++;
    XtSetArg( args[n], XmNdropSiteOperations, XmDROP_COPY); n++;
    XtSetArg (args[n], XmNtransferProc, TransferProc); n++;
  }

  is_my_drag = False;
  XmDropTransferStart (DropData->dragContext, args, n);
}
