/*********************************************************
 Copyright (C) 1994 Patrick Voigt
*********************************************************/

#include <sys/wait.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/List.h>
#include <Xm/Label.h>
#include <Xm/MessageB.h>
#include <Xm/ScrolledW.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/SeparatoG.h>
#include <Xm/CascadeBG.h>
#include <Xm/RowColumn.h>
#include <Xm/SelectioB.h>
#include <Xm/TextF.h>
#include <Xm/Text.h>
 
#include "fm.h"
#include "dd.h"
#include "file.h"
#include "bitmaps.h"


extern void destroy_dialog (Widget dialog, XtPointer o, XtPointer p);
extern void position_dialog (Widget dialog, XtPointer o, XtPointer p);
extern void busy_cursor (Widget w, Boolean busy);
extern struct dir *v_head, *v_actual;
extern int list_nr;
extern char f_name[2048];
extern struct drag_icon *i_head;
extern Pixmap pixmaps[10];

Widget mainw, form, pb1, pb2, frame, textf, label, popup, pop_widget, icon_row[2],
       items[6], casc1, casc2, pulld1_items[3], pulld2_items[2];
int timer_id;

void mk_popup (Widget w, XEvent *event, String *params, Cardinal *num_params);
void popup_cb (Widget menu_item, XtPointer client_data, XmRowColumnCallbackStruct *cbs);
void pulld1_cb (Widget menu_item, XtPointer client_data, XmRowColumnCallbackStruct *cbs);
void pulld2_cb (Widget menu_item, XtPointer client_data, XmRowColumnCallbackStruct *cbs);
void about_cb (Widget w, XtPointer client_data, XtPointer call_data);

/********************************************************************************
  Signalbehandlungsroutine fuer SIGCLD - Tod eines Sohnes
  killt den Zombie
********************************************************************************/
void kill_zombie (int dummy)
{
  wait (NULL);
  signal (SIGCLD, kill_zombie);
};

/********************************************************************************
  Callback-Funktion des Pfadeingabefeldes
  wird bei Druecken von Enter gerufen
********************************************************************************/
void textf_cb (Widget menu_item, XtPointer client_data, XtPointer call_data)
{
  char *entry;
  XtVaGetValues (textf, XmNvalue, &entry, 0);

  if (access (entry, F_OK))
  {
    XmString deny;
    deny = XmStringCreateSimple ("Directory does not exist!");
    XtRemoveTimeOut (timer_id);
    time_check (0, 0);
    XtVaSetValues (label, XmNlabelString, deny,
                          XmNuserData, -1, NULL);
    XmStringFree (deny);
    return;
  }

  if (access (entry, R_OK))
  {
    XmString deny;
    deny = XmStringCreateSimple ("Cannot access this directory, permission denied!");
    XtRemoveTimeOut (timer_id);
    time_check (0, 0);
    XtVaSetValues (label, XmNlabelString, deny,
                          XmNuserData, -1, NULL);
    XmStringFree (deny);
    return;
  }

  if (entry[strlen (entry)-1] != '/')
  {
    strcpy (f_name, entry);
    strcat (f_name, "/");
  }
  else
    strcpy (f_name, entry);

  delete_list (v_head);
  list_nr = 1;
  v_head = v_actual = create_list (f_name, NULL, 1, True);
  list_info();
  sensitiv_check();
}

/********************************************************************************
  Timerroutine, wird alle 5 Sekunden gerufen; testet, ob geoeffnete
  Verzeichnisse veraendert wurden, wenn ja: updaten
********************************************************************************/
void time_check (void *data, XtIntervalId *id)
{
  struct dir *help, *pre_help, *pre_pre_help;
  struct drag_icon *i_help, *pre_i_help;
  int old_time;
  char name[2048];
  struct stat x;
  int top;
 
  XtVaGetValues (label, XmNuserData, &top, NULL);
  if (top == -1)
  {
    list_info();
    XtVaSetValues (label, XmNuserData, 0, NULL);
  }

  help = pre_pre_help = pre_help = v_head;
  while (help)
  {
    if (access (help->p.get_path(), R_OK) == -1)
    {
      if (help == v_head || help == v_head->next)
      {
        int i;
        strcpy (name, help->p.get_path());
        i = strlen (name);
        if (i == 1)
        {
          fprintf (stderr, "Hmm, cannot access the root directory !?! ... exiting ..\n");
          exit (-1);
        }
        i--;
        while (name[--i] != '/');
        name[i + 1] = '\0';

        delete_list (v_head);
        v_head = v_actual = create_list (name, form, ++list_nr, True);
        break;
      }

      XtVaGetValues (pre_help->list, XmNtopItemPosition, &top, NULL);
      strcpy (name, pre_help->p.get_path());
      delete_list (pre_help);
      v_actual = pre_pre_help->next = create_list (name, pre_pre_help->scroll,
                                                   ++list_nr, True);
      XmListSetPos (v_actual->list, top);
      break;
    }
    pre_pre_help = pre_help;
    pre_help = help;
    help = help->next;
  }

  if (!help)
  {
    help = pre_pre_help = pre_help = v_head;
    while (help)
    {
      old_time = help->p.get_st_mtime (0);
      strcpy (name, help->p.get_path());
      lstat (name, &x);
      if (x.st_mtime > old_time)
        if (help == v_actual)
          if (v_actual == v_head)
          {
            delete_list (help);
            v_head = v_actual = create_list (name, form, ++list_nr, True);
            break;
          }
          else
          {
            delete_list (help);
            v_actual = pre_help->next = create_list (name, pre_help->scroll,
                                                     ++list_nr, True);
            break;
          }
        else
        {
          XtVaGetValues (help->list, XmNtopItemPosition, &top, NULL);
          help->p.readmdir (name);
          light_list (help);
          XmListSetPos (help->list, top);
        }
      pre_pre_help = pre_help;
      pre_help = help;
      help = help->next;
    }
  }

  i_help = i_head->next->next;
  pre_i_help = i_head->next;

  while (i_help)
  {
    if (access (i_help->path, R_OK) == -1)
    {
      pre_i_help = i_help->next;
      delete_icon (i_help);
      if (!pre_i_help)
        break;
      i_help = pre_i_help;
    }
    pre_i_help = i_help;
    i_help = i_help->next;
  }

  timer_id = XtAppAddTimeOut (XtWidgetToApplicationContext (mainw),
                              5000, time_check, 0);
}

/********************************************************************************
  Funktion prueft, ob Sensitivitaet der Button veraendert werden muss
  und tut dies, wenn notwendig
********************************************************************************/
void sensitiv_check (void)
{
  if (list_nr == 1)
    XtSetSensitive (pb1, False);
  else
    XtSetSensitive (pb1, True);
  if (strlen(v_head->p.get_path()) == 1)
    XtSetSensitive (pb2, False);
  else 
    XtSetSensitive (pb2, True);
}

/********************************************************************************
  Hauptprogramm
  erzeugt Oberflaeche
********************************************************************************/
int main (int argc, char **argv)
{
  Widget toplevel, menu_form, frame1, frame2, pullright1, pullright2, about;
  XtAppContext app;
  Pixmap pixmap1, pixmap2;
  Pixel fg, bg;
  XtActionsRec my_actions[] = {
                                {"popup", &mk_popup},
                                {"drag", &mk_drag},
                                {"info", &mk_info},
                                {"dummy", NULL}
                              };

  signal (SIGCLD, &kill_zombie);
 
  read_fmex ();

  toplevel = XtVaAppInitialize (&app, "Pfm", (XrmOptionDescList) NULL,
                                0, &argc, argv, (String *) NULL, NULL);

  mainw = XtVaCreateManagedWidget ("mainw", xmMainWindowWidgetClass, toplevel,
					    XmNwidth, 600,
					    XmNheight, 450, NULL, 0);

  menu_form = XtVaCreateManagedWidget ("menu_form", xmFormWidgetClass, mainw, NULL, 0);

  frame2 = XtVaCreateManagedWidget ("frame", xmFrameWidgetClass, menu_form,
					     XmNtopAttachment, XmATTACH_FORM,
                                       	     XmNrightAttachment, XmATTACH_FORM, NULL);

  frame1 = XtVaCreateManagedWidget ("frame", xmFrameWidgetClass, menu_form,
					     XmNtopAttachment, XmATTACH_FORM,
                                       	     XmNrightAttachment, XmATTACH_WIDGET,
                                       	     XmNrightWidget, frame2,
                                       	     XmNleftAttachment, XmATTACH_FORM, NULL);

  icon_row[0] = XtVaCreateManagedWidget ("icon_row", xmRowColumnWidgetClass, frame1,
                                                     XmNpacking, XmPACK_COLUMN,
                                                     XmNnumColumns, 1,
                                                     XmNorientation, XmHORIZONTAL, 0);

  icon_row[1] = XtVaCreateManagedWidget ("icon_row", xmRowColumnWidgetClass, frame2,
                                                     XmNpacking, XmPACK_COLUMN,
                                                     XmNnumColumns, 1,
                                                     XmNorientation, XmHORIZONTAL, 0);

  XtVaGetValues (menu_form, XmNforeground, &fg,
			    XmNbackground, &bg, NULL);

  pixmap1 = XCreatePixmapFromBitmapData (XtDisplay (mainw),
                                         RootWindowOfScreen (XtScreen (mainw)),
                                         hammer_bits,hammer_width, hammer_height, fg, bg,
                                         DefaultDepth (XtDisplay (mainw),
                                         DefaultScreen (XtDisplay (mainw))));
                                         
  pixmap2 = XCreatePixmapFromBitmapData (XtDisplay (mainw),
                                         RootWindowOfScreen (XtScreen (mainw)),
                                         hammer_bits,hammer_width, hammer_height, bg, fg,
                                         DefaultDepth (XtDisplay (mainw),
                                         DefaultScreen (XtDisplay (mainw))));

  pb1 = XtVaCreateManagedWidget ("pb1", xmPushButtonWidgetClass, menu_form,
					 XmNtopAttachment, XmATTACH_WIDGET,
					 XmNtopWidget, frame1,
					 XmNleftAttachment, XmATTACH_FORM,
					 XmNlabelType, XmPIXMAP,
					 XmNlabelInsensitivePixmap, pixmap2,
					 XmNlabelPixmap, pixmap1, NULL);

  XtAddCallback (pb1, XmNactivateCallback, kill_first, NULL);
  XtOverrideTranslations (pb1, XtParseTranslationTable ("<Btn2Down>: dummy()"));

  pixmap1 = XCreatePixmapFromBitmapData (XtDisplay (mainw),
                                         RootWindowOfScreen (XtScreen (mainw)),
                                         pfeil_bits, pfeil_width, pfeil_height, fg, bg,
                                         DefaultDepth (XtDisplay (mainw),
                                         DefaultScreen (XtDisplay (mainw))));

                                         
  pixmap2 = XCreatePixmapFromBitmapData (XtDisplay (mainw),
                                         RootWindowOfScreen (XtScreen (mainw)),
                                         pfeil_bits, pfeil_width, pfeil_height, bg, fg,
                                         DefaultDepth (XtDisplay (mainw),
                                         DefaultScreen (XtDisplay (mainw))));

  pb2 = XtVaCreateManagedWidget ("pb2", xmPushButtonWidgetClass, menu_form,
					 XmNtopAttachment, XmATTACH_WIDGET,
					 XmNtopWidget, frame1,
					 XmNleftAttachment, XmATTACH_WIDGET,
					 XmNleftWidget, pb1,
					 XmNlabelType, XmPIXMAP,
					 XmNlabelInsensitivePixmap, pixmap2,
					 XmNlabelPixmap, pixmap1, NULL);

  XtAddCallback (pb2, XmNactivateCallback, up_press, NULL);
  XtOverrideTranslations (pb2, XtParseTranslationTable ("<Btn2Down>: dummy()"));

  about = XtVaCreateManagedWidget ("About", xmPushButtonWidgetClass, menu_form,
					 XmNtopAttachment, XmATTACH_WIDGET,
					 XmNtopWidget, frame1,
					 XmNtopOffset, 1,
					 XmNrightAttachment, XmATTACH_FORM, NULL);

  XtAddCallback (about, XmNactivateCallback, about_cb, NULL);
  XtOverrideTranslations (about, XtParseTranslationTable ("<Btn2Down>: dummy()"));

  textf = XtVaCreateManagedWidget ("textf", xmTextFieldWidgetClass, menu_form,
					    XmNtopAttachment, XmATTACH_WIDGET,
					    XmNtopWidget, frame1,
				 	    XmNleftOffset, 50,
					    XmNrightAttachment, XmATTACH_WIDGET,
					    XmNrightWidget, about,
					    XmNleftAttachment, XmATTACH_WIDGET,
					    XmNleftWidget, pb2, NULL);

  XtAddCallback (textf, XmNactivateCallback, textf_cb, NULL);
  XtOverrideTranslations (textf, XtParseTranslationTable ("<Btn2Down>: dummy()"));

  form = XtVaCreateManagedWidget ("form", xmFormWidgetClass, mainw, NULL, 0);

  frame = XtVaCreateManagedWidget ("frame", xmFrameWidgetClass, form,
                                            XmNleftAttachment, XmATTACH_FORM,
                                            XmNrightAttachment, XmATTACH_FORM,
					    XmNbottomAttachment, XmATTACH_FORM, NULL);

  label = XtVaCreateManagedWidget ("label", xmLabelWidgetClass, frame, NULL);
  XtUninstallTranslations (label);

  popup = XmCreatePopupMenu (pb1, "popup", NULL, 0);
  XtAddCallback (popup, XmNentryCallback, popup_cb, NULL);

  items[0] = XtVaCreateManagedWidget ("xterm", xmPushButtonGadgetClass, popup, NULL);
  items[1] = XtVaCreateManagedWidget ("separa", xmSeparatorGadgetClass, popup, NULL);
  items[2] = XtVaCreateManagedWidget ("mkdir", xmPushButtonGadgetClass, popup, NULL);

  pullright1 = XmCreatePulldownMenu (pb1, "pullright1", NULL, 0);
  XtAddCallback (pullright1, XmNentryCallback, pulld1_cb, NULL);
  casc1 = XtVaCreateManagedWidget ("Sort", xmCascadeButtonGadgetClass, popup,
					   XmNsubMenuId, pullright1, NULL);
  pulld1_items[0] = XtVaCreateManagedWidget ("Name", xmPushButtonGadgetClass,
                                              pullright1, NULL);
  pulld1_items[1] = XtVaCreateManagedWidget ("Size", xmPushButtonGadgetClass,
                                              pullright1, NULL);
  pulld1_items[2] = XtVaCreateManagedWidget ("Time", xmPushButtonGadgetClass,
                                                     pullright1, NULL);

  pullright2 = XmCreatePulldownMenu (pb1, "pullright2", NULL, 0);
  XtAddCallback (pullright2, XmNentryCallback, pulld2_cb, NULL);
  casc2 = XtVaCreateManagedWidget ("Select", xmCascadeButtonGadgetClass, popup,
					     XmNsubMenuId, pullright2, NULL);
  pulld2_items[0] = XtVaCreateManagedWidget ("all", xmPushButtonGadgetClass,
                                                    pullright2, NULL);
  pulld2_items[1] = XtVaCreateManagedWidget ("some", xmPushButtonGadgetClass,
                                                       pullright2, NULL);
  
  XtAppAddActions (app, my_actions, XtNumber (my_actions));

  dragdrop_init();

  XtVaSetValues (toplevel, XmNtitle, "pfm v1.0",
                           XmNiconName, "pfm v1.0",
                           XmNiconPixmap, pixmaps[9], NULL);


  XtRealizeWidget (toplevel);
  XmMainWindowSetAreas (mainw, menu_form, NULL, NULL, NULL, form);

  getcwd (f_name, 2048);
  if (strlen(f_name) > 1)
    strcat (f_name, "/");

  v_head = v_actual = create_list (f_name, NULL, 1, True);
  list_info();
  sensitiv_check();

  timer_id = XtAppAddTimeOut (app, 5000, time_check, 0);

  XtAppMainLoop (app);
}

/********************************************************************************
  Action-Routine, die mit ListWidgets verbunden ist und auf Druck 
  der rechten Maustaste zur Ausfuehrung kommt 
********************************************************************************/
void mk_popup (Widget w, XEvent *event, String *params, Cardinal *num_params)
{
  struct dir *help = v_head;

  pop_widget = w;

  while (help->list != pop_widget)
    help = help->next;
  strcpy (f_name, help->p.get_path());

  if (!access (f_name, W_OK))
    XtSetSensitive (items[2], True);
  else
    XtSetSensitive (items[2], False);

  XmMenuPosition (popup, (XButtonPressedEvent *) event);
  XtManageChild (popup);
};


/********************************************************************************
  Callback-Routine des Ok-Buttons des Selectdialog
  selektiert Eintraege in Listwidget
********************************************************************************/
void select_files (Widget dialog, XtPointer client_data, XtPointer call_data)
{
  struct dir *help = (struct dir*) client_data;
  char *text;
  XmString str;
  int i, anz;

  busy_cursor (mainw, True);

  XtVaGetValues (dialog, XmNtextString, &str, NULL); 
  XmStringGetLtoR (str, XmSTRING_DEFAULT_CHARSET, &text);

  anz = help->p.get_anz();

  XmListDeselectAllItems (help->list);
  XtVaSetValues (help->list, XmNselectionPolicy, XmMULTIPLE_SELECT, 0);

  for (i = 2; i < anz; i++)
    if (fname_match (help->p.get_name(i), text))
      XmListSelectPos (help->list, i, False);

  XtVaSetValues (help->list, XmNselectionPolicy, XmEXTENDED_SELECT, 0);
    
  XtFree (text);
  XtDestroyWidget (dialog);
  busy_cursor (mainw, False);
}


/********************************************************************************
  Callback-Routine des Ok-Buttons des Mkdirdialogs
  erzeugt neues Verzeichnis
********************************************************************************/
void mk_directory (Widget dialog, XtPointer o, XtPointer p)
{
  Widget err_dialog;
  XmString msg, str, str1;
  char *text, *err_msg[] = { "pathname already exists!",
                              "pathname is too long!",
                              "insufficient kernel memory was available!",
                              "pathname contains a reference\nto a circular symbolic link!",
                              "no space left on device!",
                              "unknown error!"
                            };
  int i;

  XtVaGetValues (dialog, XmNtextString, &str, NULL); 
  XmStringGetLtoR (str, XmSTRING_DEFAULT_CHARSET, &text);

  i = strlen (f_name);
  if (!strlen (text))
    return;

  strcat (f_name, text);
  XtFree (text);

  if (!mkdir (f_name, 511))
  {
    XtDestroyWidget (dialog);
    XtRemoveTimeOut (timer_id);
    time_check (0, 0);
  }
  else
  {
    f_name[i] = '\0';
    switch (errno)
    {
      case EEXIST:        i = 0;
                          break;
      case ENAMETOOLONG:  i = 1;
                          break;
      case ENOMEM:        i = 2;
                          break;
      case ELOOP:         i = 3;
                          break;
      case ENOSPC:        i = 4;
                          break;
      default:            i = 5;
    }

    err_dialog = XmCreateInformationDialog (dialog, "err_dialog", NULL, 0);
    str = XmStringCreateLtoR ("Cannot create directory, because\n",
                              XmSTRING_DEFAULT_CHARSET);
    str1 = XmStringCreateLtoR (err_msg[i], XmSTRING_DEFAULT_CHARSET);
    msg = XmStringConcat (str, str1);

    XtUnmanageChild (XmMessageBoxGetChild (err_dialog, XmDIALOG_HELP_BUTTON));
    XtVaSetValues (XtParent(err_dialog), XmNtitle, "Error occured", 0);
    XtVaSetValues (err_dialog, XmNmessageString, msg,
                               XmNnoResize, True,
                               XmNdefaultPosition, False,
                               XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL, 0);
    XmStringFree (str);
    XmStringFree (str1);
    XmStringFree (msg);

    XtAddCallback (err_dialog, XmNokCallback, destroy_dialog, NULL);
    XtAddCallback (err_dialog, XmNcancelCallback, destroy_dialog, NULL);
    XtAddCallback (err_dialog, XmNmapCallback, position_dialog, NULL);

    XtManageChild (err_dialog);
    XtPopup (XtParent(err_dialog), XtGrabNone);
  }
}


/********************************************************************************
  Popup-Callback-Routine, die bei Selektion eines eines Popup-Eintrags  
  gerufen wird
********************************************************************************/
void popup_cb (Widget menu_item, XtPointer client_data, XmRowColumnCallbackStruct *cbs)
{
  extern void mk_argv (char*, char**);
  Widget dialog;
  XmString message;
  extern char **table;
  char *argv[50];
  int i = 0;

  while (items[i] != cbs->widget)
    i++;
 
  if (i == 0)
  {
    if (!fork())
    {
      chdir (f_name);
      strcpy (f_name, table[0]);
      mk_argv (f_name, argv);
      execv (f_name, &argv[0]); 
      exit (-1);
    }
  }
  else
  {
    dialog = XmCreatePromptDialog (pb2, "mkdir", NULL, 0);
    message = XmStringCreateSimple ("Name:                           ");
    XtVaSetValues (XtParent(dialog), XmNtitle, "Create new directory", 0);
    XtVaSetValues (dialog, XmNselectionLabelString, message,
                           XmNnoResize, True,
                           XmNdefaultPosition, False,
                           XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL, 0);
    XmStringFree (message);
    XtUnmanageChild (XmSelectionBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
    XtAddCallback (dialog, XmNokCallback, mk_directory, NULL);
    XtAddCallback (dialog, XmNcancelCallback, destroy_dialog, NULL);
    XtAddCallback (dialog, XmNmapCallback, position_dialog, NULL);

    XtManageChild (dialog);
    XtPopup (XtParent(dialog), XtGrabNone);
  }
};

/********************************************************************************
  Pulldown1-Callback-Routine, die bei Selektion eines "Sort"-Eintrags  
  gerufen wird
********************************************************************************/
void pulld1_cb (Widget menu_item, XtPointer client_data, XmRowColumnCallbackStruct *cbs)
{
  int i = 0;
  struct dir *help = v_head;

  while (pulld1_items[i] != cbs->widget) 
    i++;
 
  while (help->list != pop_widget)
    help = help->next;

  help->p.change_sort (i + 1);

  if (help->next)
    light_list (help);
  else
  {
    int anz = help->p.get_anz();
    char csize[10];                                // Zugriffsrechte 
    char f[80];                                    // Infostring 
    XmStringTable str_table1;

    str_table1 = (XmStringTable) new XmString[anz];

    for (i = 0; i < anz ; i++)
    {
      strcpy (f, permissions (help->p.get_st_mode(i), help->p.get_st_type(i)));
      sprintf (csize, "%9d", help->p.get_st_size(i));
      strcat (f, csize);
      strcat (f, mtime(help->p.get_st_mtime(i)));
      strcat (f, "  ");
      strncat (f, help->p.get_name(i), 30);
      if (strlen (help->p.get_name(i)) > 30)
        strcat (f, "..");

      if (help->p.get_st_type (i) == IS_DIR || help->p.get_st_type (i) == IS_LNKD)
        str_table1[i] = XmStringCreateLtoR (f, "charset1");
      else 
        str_table1[i] = XmStringCreateLtoR (f, "charset2");
    }

    XtVaSetValues (help->list, XmNitems, str_table1,
                               XmNitemCount, anz ,
                               XmNvisibleItemCount, anz, 0);
    XmListDeletePos (help->list, 2);

    for (i = 0; i < anz; i++)
      XmStringFree (str_table1[i]);
    delete []str_table1;
  }
};

/********************************************************************************
  Pulldown2-Callback-Routine, die bei Selektion eines "Select"-Eintrags  
  gerufen wird
********************************************************************************/
void pulld2_cb (Widget menu_item, XtPointer client_data, XmRowColumnCallbackStruct *cbs)
{
  Widget dialog;
  XmString message;
  int i = 0, anz;
  struct dir *help = v_head;

  while (pulld2_items[i] != cbs->widget) 
    i++;

  while (help->list != pop_widget)
    help = help->next;

  if (!i)
  {
    busy_cursor (mainw, True);
    XmListDeselectAllItems (help->list);
    anz = help->p.get_anz();
    
    XtVaSetValues (help->list, XmNselectionPolicy, XmMULTIPLE_SELECT, 0);
    for (i = 2; i < anz; i++)
      XmListSelectPos (help->list, i, False);
    XtVaSetValues (help->list, XmNselectionPolicy, XmEXTENDED_SELECT, 0);
    
    busy_cursor (mainw, False);
  }
  else
  {
    dialog = XmCreatePromptDialog (pb2, "select", NULL, 0);
    message = XmStringCreateSimple ("Filter:                       ");
    XtVaSetValues (XtParent(dialog), XmNtitle, "Select files", 0);
    XtVaSetValues (dialog, XmNselectionLabelString, message,
                           XmNnoResize, True,
                           XmNdefaultPosition, False,
                           XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL, 0);
    XmStringFree (message);
    XtUnmanageChild (XmSelectionBoxGetChild(dialog, XmDIALOG_HELP_BUTTON));
    XtAddCallback (dialog, XmNokCallback, select_files, help);
    XtAddCallback (dialog, XmNcancelCallback, destroy_dialog, NULL);
    XtAddCallback (dialog, XmNmapCallback, position_dialog, NULL);

    XtManageChild (dialog);
    XtPopup (XtParent(dialog), XtGrabNone);
  }
};

/********************************************************************************
  About-Callback-Routine  
  erzeugt Copyright-Dialog
********************************************************************************/
void about_cb (Widget w, XtPointer client_data, XtPointer call_data)
{
  char contents[] = "  This software is provided 'as-is', without any express or implied
warranty. In no event will the author be held liable for any
damages arising from the use of this software.

  pfm is shareware. You may use pfm for your own amusement, and if
find it useful or of some value to you, your donation would be
greatly appreciated. $10 is the suggested donation (shareware fee),
though, of course, larger donations are quite welcome.

  Commercial users MUST pay the shareware fee.

  Once you have payed the shareware fee, you may use it on any
machine at no additional charge. The price also includes
future updates.


Please send me cash (bank-notes only) via snail mail.
My address:

            Patrick Voigt
            Hauptstr. 50
            07429 Sitzendorf
            Germany

  Please send bug reports, suggestions and comments to: 

  patrick.voigt@informatik.tu-chemnitz.de


Modification and redistribution
-------------------------------

  The software may be modified for your own purposes, but it's not
allowed to (re)distribute modified versions of the software.

  Each (re)distribution of pfm must include all sources plus all
other related files (README, LICENSE, etc.).

  You may charge a fee for the medium used to (re)distribute pfm
and a fee for the physical act of copying it, but for nothing else.";

  Widget dialog, text;
  XmString str;
  int i;
  Arg args[10];

  str = XmStringCreateLtoR ("pfm v1.0 is Copyright 1994 by Patrick Voigt                      ", XmSTRING_DEFAULT_CHARSET);

  i = 0;
  XtSetArg (args[i], XmNmessageString, str); i++;
  XtSetArg (args[i], XmNdefaultPosition, False); i++;
  XtSetArg (args[i], XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL); i++;
  XtSetArg (args[i], XmNnoResize, True); i++;
  XtSetArg (args[i], XmNsymbolPixmap, pixmaps[9]); i++;

  dialog = XmCreateInformationDialog (pb2, "about_dialog", args, i);

  XtUnmanageChild (XmMessageBoxGetChild (dialog, XmDIALOG_HELP_BUTTON));
  XtVaSetValues (XtParent(dialog), XmNtitle, "About pfm v1.0", 0);

  XmStringFree (str);

  XtAddCallback (dialog, XmNokCallback, destroy_dialog, NULL);
  XtAddCallback (dialog, XmNcancelCallback, destroy_dialog, NULL);
  XtAddCallback (dialog, XmNmapCallback, position_dialog, NULL);

  i = 0;
  XtSetArg (args[i], XmNscrollVertical, True); i++;
  XtSetArg (args[i], XmNscrollHorizontal, False); i++;
  XtSetArg (args[i], XmNeditMode, XmMULTI_LINE_EDIT), i++;
  XtSetArg (args[i], XmNeditable, False); i++;
  XtSetArg (args[i], XmNcursorPositionVisible, False); i++;
  XtSetArg (args[i], XmNwordWrap, True); i++;
  XtSetArg (args[i], XmNvalue, contents); i++;
  XtSetArg (args[i], XmNrows, 10); i++;

  text = XmCreateScrolledText (dialog, "text", args, i);
  XtManageChild (text); 
  XtManageChild (dialog);
  XtPopup (XtParent(dialog), XtGrabNone);
}
