/*
   
   Permission hereby granted to use and change this software, and make
   derivative works based on this code, as long as it mentions initial
   author - Roman Mitnitski, mitnits@shani.net.

   ROMAN MITNITSKI MAKES NO WARRANTY OF ANY KIND WITH REGARD
   TO THIS SOFWARE, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
   WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE.  Roman Mitnitski shall not be liable for errors
   contained herein or direct, indirect, special, incidental or
   consequential damages in connection with the furnishing,
   performance, or use of this program.               

*/

/* 
 * WiconShP.h - Private definitions for VendorShell derived widget
 */

/***********************************************************************
 *
 * WiconSh Shell Widget Private Data
 *
 ***********************************************************************/

#ifndef _XtWiconPrivate_h
#define _XtWiconPrivate_h

#include <X11/ShellP.h>
#include <time.h>
#include "wiconsh.h"

/* New fields for the VendorShell widget class record */

typedef struct {
    int HappyC;
} WiconShellClassPart;

typedef struct _WiconShellClassRec {
  	CoreClassPart      core_class;
	CompositeClassPart composite_class;
	ShellClassPart  shell_class;
	WMShellClassPart   wm_shell_class;
	VendorShellClassPart vendor_shell_class;
        TransientShellClassPart transient_shell_class;
        WiconShellClassPart    wicon_shell_class;
} WiconShellClassRec;

externalref WiconShellClassRec wiconShellClassRec;

/* New fields for the wicon shell widget. */

typedef struct {
        String *   pixmapData; /* The icon */
        String     tagLabel;   /* The label */
        Widget     labelsh;    /* Shell supporting the label */
        Widget     label;      /* label widget */
	String     tagFg;      /* Colors */
	String     tagBg;
	String     tagAFg;
	String     tagABg;
	Boolean    freezed;
	Dimension  LabelBorder;
	Pixel      Fg,Bg,ABg,AFg,middlec,topsh,botsh;
	XtCallbackList dropcallback;
	XtCallbackList clickcallback;     
	XtCallbackList doubleclickcallback;
	time_t     etime;
	Dimension  label_w;
	Dimension  label_h;
} WiconShellPart;

typedef  struct {
	CorePart        	core;
	CompositePart        	composite;
	ShellPart 	        shell;
	WMShellPart	        wm;
	VendorShellPart	        vendor;
	TransientShellPart	transient;
        WiconShellPart          wicon;  
} WiconShellRec, *WiconShellWidget;

#endif  /* */







