.TH XDROP 1 "14 December 1990
.SH NAME
xdrop
- drag/drop or select/paste application launcher
.SH SYNOPSIS
.B xdrop
[ 
.I standard Xview command line arguments 
]
[
.B -i
<icon file>
]
[
.B -x
<xbm file>
]
[
.B -l
<icon label>
]
<command>
.SH DESCRIPTION

.LP
.B xdrop
is an Open Look utility that allows users invoke normal UNIX
applications by pasting text or by using the Open Look drag and drop
mechanism.

When xdrop is running it displays an icon in a window.  The
user can drag and drop files or text onto the icon and xdrop will run
.B <command>
which may use the files or text in its arguments.

Additionally, the user may click the middle mouse button over the icon
and xdrop will execute the command using the current primary selection
as text.

While the command is being executed, xdrop inverts the icon. The command
that is executed can be edited while xdrop is running by selecting the
icon (usually by clicking the left mouse button).

The command is passed to the system shell (usually /bin/sh) to be
executed. The two environment variables
.B FILE
and
.B TEXT
are available to the command and their values depend on the user action
that initiated the command.

.IP -
When a file is dragged from another Open Look application (for example,
filemgr)
.B $FILE
is set to the full path and filename of the file and
.B $TEXT
is set to the contents of the file.

.IP -
When text is dragged from another Open Look application (for example,
cmdtool)
.B $FILE
is not defined and
.B $TEXT
is set to the text.

.IP -
When text is pasted from another X application (for example, xterm)
.B $FILE
is not defined and
.B $TEXT
is set to the text.

.SH OPTIONS
.IP \fB-i\fR
specifies a Sun icon file to use for the icon, perhaps created by
iconedit.

.IP \fB-x\fR
specifies an X11 bitmap file to use for the icon, perhaps created by
bitmap or xpaint.

.IP \fB-l\fR
specifies a label that will be displayed below the icon.

.SH NOTES
When invoking xdrop, it is important to enclose the
.B <command>
argument in single quotes to prevent references to $FILE and $TEXT being
expanded by the shell on the command line. Also, if you want to be able
to invoke several independent applications from xdrop, remember to add a
trailing
.B &
to the command to execute it in the background.

If no icon is specified, xdrop uses a default xdrop icon.

When the xdrop application is closed you can still drag and drop files
and text onto its icon, but you cannot paste text using the middle mouse
button. Note that the closed xdrop icon may take up more room on the
screen than the open application.

The command executed by xdrop has the same working directory as the xdrop
program itself. Sometimes you may wish to change directory in the command
line you give to xdrop. See the
.B xtermdrop
example below for an example.

I prefer xdrop windows to have no titlebar. You have to tell your window
manager to do this. For olwm and olvwm you add this line to .Xdefaults,

.B OpenWindows.MinimalDecor: xdrop

For twm you add this line to .twmrc

.B NoTitle{"xdrop"}

.SH EXAMPLES
The supplied examples are shell scripts and they assume that the icons are
in a directory ~/xdrop.

.B xdrop -x man32.xbm 'xterm -e man $TEXT &'

This simple example looks up one or more man pages when command or
function names are dropped or pasted into it. This is included as the
script
.B mandrop
in the xdrop distribution.

.B xdrop -i edit.icon 'cd ; xterm -e vi ${FILE:-$TEXT} &'

This simple example edits one or more files that are dropped onto it. If
text is pasted into it then
.B FILE
is undefined, so it uses
.B $TEXT
as filenames. Dropped filenames are always absolute but pasted text
will be a relative filename unless it starts with a slash. In this case
the filename is relative to the working driectory of the xdrop program
itself, so this example changes to the home directory first.
This is included as the script
.B editdrop
in the xdrop distribution.

.B xdrop -x xterm.xbm -l 'xterm' 'cd ; xterm -sb &'

This example shows how xdrop can be used just to launch applications.
Clicking the middle mouse button on the icon creates new xterm windows.
Note that it changes to the home directory first.  This is included as
the script
.B xtermdrop
in the xdrop distribution.

.B xdrop -x spell32.xbm 'echo "$TEXT" | ispell -l > /tmp/spell ; xterm -e less /tmp/spell ; rm /tmp/spell'

This example displays spelling errors in some text or a file that is
dropped onto it.  This is included as the script
.B spelldrop
in the xdrop distribution.

.SH REQUIREMENTS

Xdrop requires the xview toolkit version 3.0 or later and an ANSI C
compiler to compile.

Drag and drop should work with OpenWindows 3 applications, but not
OpenWindows 2 applications.

I have no idea about OpenWindows 4 or Solaris or X11R6. This
functionality is the least tested.

Pasting text should work from most X11 applications (Xt or Xview based).

Xdrop does not require OpenWindows or an Open Look window manager to
run. You can just use it with xterm and twm if you like.

.SH HOW IT WORKS
Whether you drag and drop or select and paste, xdrop ends up getting the
value of the current primary selection. The selection is usually
available as several different target types. You ask for the type you
want and the owner of the selection provides it.

The targets can be different representations of the selection itself or
information about the selection. For example, with a dropped file you
can get the filename, the contents of the file or the length of the
file. You can see the available targets by running xdrop with the
.B -debug
option. Xdrop uses the STRING and FILE_NAME targets.

Once xdrop has the selection it constructs a command line to pass to the
shell. This has up to three components - a filename, some text and the
command to execute. If there is a filename then the command line
contains
.B FILE="filename" ; export FILE ;
to set up the
.B FILE
variable. There is a similar construct to set up the
.B TEXT
variable. The last part of the command line is the command to execute,
which can refer to
.B $FILE
and
.B $TEXT
in its arguments.

There are some considerations about quoting. The value of
.B TEXT
needs to be quoted to allow white space within it. Single quotes are no
good because there is no way to get a single quote (ie an apostrophe)
within them. With double quotes, the shell expands expressions containing
the special characters backquote, dollar and backslash.

Xdrop assumes that the selection will be literal text, so it escapes
each of the special characters and any double quotes with a backslash.
You can see the results of this processing by running xdrop with the
.B -debug
option.

Newlines are also special and appear differently depending on how you
refer to a variable. For example
.B echo $TEXT
and
.B echo """$TEXT"""
work differently.

.SH BUGS
If there is no selection when you paste, it sometimes takes a while for
the selection mechanism to realise there is nothing selected. It gets
there after a few seconds. I think this is happening in the xview
toolkit rather than in the X server.

Xdrop uses
.B system()
to execute the command. This seems to work alright but the book says its
bad.

If you find xdrop does not work as expected with drag and drop from a
particular application, try the
.B -debug
option. This will display the types of selection available from the source
application. xdrop uses the STRING and FILE_NAME targets.

It can be very difficult to think about xterms running shells expanding
command lines with several levels of quoting involved.

.SH HISTORY
Xdrop was originally written in 1990, back when drag and drop was new to
the xview toolkit. It was released to the net but it didn't change the
world :) It wasn't long before Sun released xview 3.0 and OpenWindows 3.0
which meant that xdrop didn't work any more...

After a long while and some enquiries from poeple I ported it to xview
3.0 so that it would work with the new drag and drop mechanism. I also
added the pasting mechanism since this allowed it to work easily with Xt
apps too. This is how I use xdrop at the moment (no OpenWindows at
home).

There was another pause in development as I watched the future of xview
hanging in the balance. It's still hanging, so I decided to release
version 2 anyway. I wonder how long it will last...

.SH AUTHOR
The author of xdrop is Mark Dobie (mrd@ecs.soton.ac.uk). Please mail me
if you have any problems or if you have any ideas about useful additions
to xdrop.

.SH ACKNOWLEDGEMENTS

Thanks to William R White III for some testing.

I would like to thank Joan Cragun for kindly telling me how to read an
icon into the program.

Xdrop version 2 was developed using freely available software.

Thanks to Linus Torvalds, Peter Macdonald, all the other contributors to
Linux, The XFree86 Project and the X Consortium, Steve Kirkendall, Jef
Poskanzer, the Free Software Foundation and Sun Microsystems.




