/*
 * Anyone remember the way the ancient Atari 2600 prevented screen burn-in on
 * televisions?  We simulate that.  It's probably not worth the effort, but
 * what the hey....  (Of course, to simulate it properly I'd have to turn off
 * every other scan line :-)
 */

#include <stdlib.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "xmss-module.h"
#include "colormap.h"

#define LINEAR		0
#define EXPONENTIAL	1

static XrmOptionDescRec a2600_options[] =
{
    "-2600changetime",	".changeTime",	 XrmoptionSepArg, (caddr_t) 0,
    "-2ct",		".changeTime",	 XrmoptionSepArg, (caddr_t) 0,
    "-2600percent",	".percent",	 XrmoptionSepArg, (caddr_t) 0,
    "-2p",		".percent",	 XrmoptionSepArg, (caddr_t) 0,
    "-percent",		".Percent",	 XrmoptionSepArg, (caddr_t) 0,
    "-2600linear",	".scale",	 XrmoptionNoArg,(caddr_t)"linear",
    "-2600exponential",	".scale",	 XrmoptionNoArg,(caddr_t)"exponential",
    "-2l",		".scale",	 XrmoptionNoArg,(caddr_t)"linear",
    "-2ex",		".scale",	 XrmoptionNoArg,(caddr_t)"exponential",
    "-linear",		".Scale",	 XrmoptionNoArg,(caddr_t)"linear",
    "-exponential",	".Scale",	 XrmoptionNoArg,(caddr_t)"exponential",
};

static int changetime, fraction, doic, blocked, scale;
static double mscale, ln65536;
static _Xconst Module *blank;

static int
#if NeedFunctionPrototypes
a2600_init(int reinit)
#else
a2600_init(reinit)
    int reinit;
#endif
{
    _Xconst char *cp;

    if (!reinit)
	ln65536 = log(65536.0);
    if (!(changetime = getNumRes("2600.changeTime", SCLASS, ".Time")))
	changetime = 16;
    if (!(fraction = getNumRes("2600.percent", SCLASS, ".Percent")))
	fraction = 40;
    mscale = (100.0 - fraction) / 100.0;
    if (!(cp = getRes("2600.scale", SCLASS, ".Scale")))
	scale = LINEAR;
    else if (strcasecmp(cp, "linear") == 0)
	scale = LINEAR;
    else if (strcasecmp(cp, "exponential") == 0)
	scale = EXPONENTIAL;
    else
    {
	warning("2600: unrecognized scale", cp);
	scale = LINEAR;
    }
    changetime *= 1000000;
    if (reinit)
	return True;
    if (!colormap_init())
	return False;
    return True;
}

static int
#if NeedFunctionPrototypes
a2600_finit(int reinit)
#else
a2600_finit(reinit)
    int reinit;
#endif
{
    return (blank = module_select("blank")) != 0;
}

static long
#if NeedFunctionPrototypes
a2600_on(void)
#else
a2600_on()
#endif
{
    Colormap *CMs;
    int z;

    CMs = XListInstalledColormaps(dpy, root, &z);
    if ((blocked = (z != 1)))
	return (*blank->startup)();
    doic = 1;
    return 0;
}

static long
#if NeedFunctionPrototypes
a2600_off(void)
#else
a2600_off()
#endif
{
    if (blocked)
	return (*blank->shutdown)();
    XUninstallColormap(dpy, blankCM);
    return -1;
}

static unsigned short
#if NeedFunctionPrototypes
random_color(void)
#else
random_color()
#endif
{
    switch (scale)
    {
    case LINEAR:
	return (random() & 0xFFFF) * mscale;
    case EXPONENTIAL:
	return (exp(fmod(random() + 1.0, ln65536)) - 1) * mscale;
    default:
	fatal("2600: internal scale corrupted", 0);
	return 0;
    }
}

static long
#if NeedFunctionPrototypes
a2600_work(int blanked)
#else
a2600_work(blanked)
    int blanked;
#endif
{
    int z;

    if (blocked)
	return (*blank->work)(blanked);
    for (z = vis->colormap_size; z--; )
    {
	Colors[z].red = random_color();
	Colors[z].green = random_color();
	Colors[z].blue = random_color();
    }
    XStoreColors(dpy, blankCM, Colors, vis->colormap_size);
    if (doic)
    {
	XInstallColormap(dpy, blankCM);
	doic = 0;
    }
    return changetime;
}

Module a2600_module =
{
    "2600",			/* module name */
    a2600_options,		/* options */
    sizeof a2600_options / sizeof a2600_options[0],	/* number of options */
    a2600_init,			/* initialization */
    a2600_finit,		/* post-initialization */
    a2600_on,			/* transition to "on" state */
    a2600_off,			/* transition to "off" state */
    a2600_work,			/* called on every pass */
};
