/*
 * The trivial saver:  blank the screen.  This module is required, since it
 * is the fallback when the others can't run (insufficient processes or bad
 * command for xlock, bad visual for dim and 2600).  However, the require-
 * ment is enforced by the modules that need it, by their post-initialization
 * procedures; if other modules exist that don't require it, xmss can continue.
 */

#include <X11/Xlib.h>
#include "xmss-module.h"

static Window blankW;

static int
#if NeedFunctionPrototypes
blank_init(int reinit)
#else
blank_init(reinit)
    int reinit;
#endif
{
    XSetWindowAttributes sw;
    XColor bk, b2;
    Pixmap pm;

    if (reinit)
	return True;
    if (!(XAllocNamedColor(dpy, DefaultColormap(dpy, scr), "black", &bk, &b2)))
	return False;
    if (!(pm = XCreatePixmapFromBitmapData(dpy, root, "", 1, 1, 0, 0, 1)))
	return False;
    sw.cursor = XCreatePixmapCursor(dpy, pm, pm, &bk, &bk, 0, 0);
    XFreePixmap(dpy, pm);
    if (!sw.cursor)
	return False;
    sw.background_pixel = bk.pixel;
    sw.override_redirect = True;
    if (!(blankW = XCreateWindow(dpy, root, 0, 0, DisplayWidth(dpy, scr),
				 DisplayHeight(dpy, scr), 0, CopyFromParent,
				 CopyFromParent, CopyFromParent,
				 CWBackPixel|CWOverrideRedirect|CWCursor,
				 &sw)))
    {
	XFreeCursor(dpy, sw.cursor);
	return False;
    }
    return True;
}

static int
#if NeedFunctionPrototypes
blank_finit(int reinit)
#else
blank_finit(reinit)
    int reinit;
#endif
{
    return True;
}

static long
#if NeedFunctionPrototypes
blank_on(void)
#else
blank_on()
#endif
{
    XMapRaised(dpy, blankW);
    return -1;
}

static long
#if NeedFunctionPrototypes
blank_off(void)
#else
blank_off()
#endif
{
    XUnmapWindow(dpy, blankW);
    return -1;
}

static long
#if NeedFunctionPrototypes
blank_work(int blanked)
#else
blank_work(blanked)
    int blanked;
#endif
{
    return -1;
}

Module blank_module =
{
    "blank",			/* module name */
    0,				/* module options */
    0,				/* # of options */
    blank_init,			/* initialization */
    blank_finit,		/* post-initialization */
    blank_on,			/* transition to "on" state */
    blank_off,			/* transition to "off" state */
    blank_work,			/* called on every pass */
};
