/*
 * xmss globally visible definitions.
 */

#include <X11/Xresource.h>
#include "xmss-module.h"

#define CLASS		"XMss"

#ifdef SIGNALRETURNSINT
#define sigreturn_t int
#else
#define sigreturn_t void
#endif

typedef struct hotgeom
{
    struct hotgeom *next;
    int x, y, w, h;
} HotGeometry;

typedef struct hotwin
{
    struct hotwin *next;
    _Xconst HotGeometry *hot;
    Window win;
    int setp;
} HotWindow;

typedef struct hotkey
{
    unsigned int require;
    unsigned int avoid;
    unsigned int key;
} HotKey;

extern unsigned long hotspot, coldspot;
extern _Xconst HotGeometry *on, *off;
extern _Xconst HotKey *hotkey;
extern Atom XA_XMSS;
extern time_t now;

extern void xmss_init _((int));
extern _Xconst HotGeometry *getHotRes _((_Xconst char *, _Xconst char *, _Xconst char *));
extern _Xconst HotKey *getKeyRes _((_Xconst char *, _Xconst char *, _Xconst char *));
extern void addOptions _((_Xconst XrmOptionDescRec *, int, _Xconst char *));
extern void getResources _((int *, char **));
extern void update_resources _((void));
extern void registerEvents _((Window, int));
extern void queueWindow _((Window));
extern void runQueue _((void));
extern int checkActive _((void));
extern int checkPointer _((void));
extern _Xconst HotGeometry *ck_hot _((int, int, _Xconst HotGeometry *));
extern void show_hot _((_Xconst HotGeometry *, unsigned long));
extern void add_hot _((_Xconst HotGeometry *, unsigned long));
extern void hide_hot _((void));
extern void del_hot _((_Xconst HotGeometry *));
extern int is_hot _((Window));
extern void module_options _((void));
extern int module_init _((int));

#ifndef NOPTION
#define NOPTION		256
#endif
