.TH xmss 1 "X Version 11"
.SH NAME
xmss \- modular automatic screen saver
.SH SYNOPSIS
.B xmss 
[
.I options
]
.SH DESCRIPTION
.I XMss
is a screen saver for the X Window System which uses user-selectable modules
to protect the workstation screen from image burn-in.  The modules currently
provided are:
.TP 15
.B dim
Dim the workstation screen to a specified intensity by deforming the colormap.
.TP 15
.B 2600
Randomly alter the colormap periodically, after the fashion of the old Atari
2600's television screen saver.
.TP 15
.B blank
Simply blanks the screen.
.TP 15
.B xlock
Run a specified program (default ``xlock -nolock'').
.TP 15
.B random
Randomly select any known saver module each time the saver is activated.
.P
Other modules may be available in the installed version of
.IR xmss .
.P
Only the screen specified by
.P \-display
is controlled, since individual modules (e.g.
.BR dim )
may only work properly on a single screen due to the use of colormap
manipulation.
.SH OPTIONS
.I XMss
has both global options and module-specific options.  The global options are:
.TP 15
.BI \-display " display"
.TP 15
.BI \-name " name"
.TP 15
.BI \-xrm " resource"
Standard X toolkit options.  Note that these are the
.I only
toolkit options supported, because
.I xmss
does not have a window of its own.
.TP 15
.BI \-blanktime " seconds"
.TP 15
.BI \-bt " seconds"
Activate the specified saver module after
.I seconds
of inactivity.  The default is 300 seconds.
.TP 15
.BI \-initial " seconds"
Allow the X server to settle for
.I seconds
after
.I xmss
is started.  This is intended for use during the X11 startup sequence, when
many windows are created all at once; since
.I xmss
tracks window creation in order to detect keyboard events in windows, it is
faster to let
.I xmss
attach all the windows at once than to process many window-creation events
during server startup.  The default is 60 seconds.
.TP 15
.BI \-hotspots " geometry-list"
.TP 15
.BI \-hs " geometry-list"
The regions of the screen indicated by the comma- and/or space-separated
geometry specifications in
.I geometry-list
are designated as ``hot spots''; if the pointer enters any of these regions,
the selected saver module is immediately activated.  If a ``hot color'' is
defined, the current ``hot spot'' will be displayed in that color.  There is
no default.
.TP 15
.BI \-hotcolor " color"
.TP 15
.BI \-hc " color"
If specified, when the pointer moves into a ``hot spot'' or the ``hot key'' is
pressed, the ``hot spot'' will be highlighted with the specified
.IR color .  The default is not to highlight.
.TP 15
.BI \-coldspots " geometry-list"
.TP 15
.BI \-cs " geometry-list"
The regions of the screen indicated by the comma- and/or space-separated
geometry specifications in
.I geometry-list
are designated as ``cold spots''; screen saving is disabled while the pointer
is in any of these regions.  If a ``coldspot color'' is specified, the current
``cold spot'' will be displayed in that color.  There is no default.
.TP 15
.BI \-coldcolor " color"
.TP 15
.BI \-cc " color"
If specified, when the pointer moves into a ``cold spot'' or the ``hot key'' is
pressed, the ``cold spot'' will be highlighted with the specified
.IR color .  The default is not to highlight.
.TP 15
.BI \-hotkey " key"
.TP 15
.BI \-hk " key"
The specified
.IR key ,
which is described using a subset of X toolkit key event specifiers, causes
all ``hot'' and ``cold'' spots to be displayed using their respective colors.
The default is no ``hot key''.
.TP 15
.BI \-module " module"
The specified
.I module
will be used as a screen saver.  The default is
.BR random .
.TP 15
.B \-unlock
Remove the lock on the specified screen.  This may be useful if
.B xmss
exits unexpectedly; it is more likely to be useful in terminating a running
copy of
.BR xmss ,
as the running copy will detect the removal of its lock and exit.
.SS "dim Module Options"
.TP 15
.BI \-dimsteps " number"
.TP 15
.BI \-ds " number"
Dim the screen in
.I number
equal-sized steps.
.TP 15
.BI \-dimpercent " number"
.TP 15
.BI \-dp " number"
Reduce the screen's brightness by
.I number
percent.
.TP 15
.B \-dimgrabs
.TP 15
.B \-dg
Grab the server during the animated dim/undim sequence.  This may help make
the animation less jerky, but will block access to other clients and slow them
down.
.SS "2600 Module Options"
.TP 15
.BI \-2600changetime " seconds"
.TP 15
.BI \-2ct " seconds"
Alter the colormap every
.I seconds
seconds.
.TP 15
.BI \-2600percent " number"
.TP 15
.BI \-2p " number"
Reduce the brightness of the selected colors by
.I number
percent.
.TP 15
.B \-2600linear
.TP 15
.B \-2l
Select the brightness of the random colors linearly.
.TP 15
.B \-2600exponential
.TP 15
.B \-2ex
Select the brightness of the random colors according to an exponential scale.
Dim colors are much more likely than bright colors with this option.
.SS "xlock Module Options"
.TP 15
.BI \-locker " program"
The specified
.IR program ,
which can be any
.BR sh (1)
command line, will be run as the screen saver.
.SH RESOURCES
All resources are also available as options, and vice versa.
.I XMss
uses the name under which it was invoked as its instance name if the
.B \-name
option was not specified; its class name is
.B XMss.
.P
Each module can have its own resources.  The instance name for each module is
its name; the class name is
.BR Saver .
.P
The full class name for each resource is shown in parentheses after the full
instance name.
.TP 15
.BI xmss.display: " display " (XMss.Display)
The display to connect to.
.TP 15
.BI xmss.initialDelay: " seconds " (XMss.Delay)
The initial delay during program startup.  See the description of the
.B \-initial
option above.
.TP 15
.BI xmss.blankTime: " seconds " (XMss.Time)
Activate the selected saver module after
.I seconds
of inactivity.
.TP 15
.BI xmss.name: " name " (XMss.Name)
It is meaningful, although perhaps not sensible, to specify the instance name
of
.I xmss
in the resource file based on the name under which it was invoked.
.TP 15
.BI xmss.hotSpots: " geometry-list " (XMss.HotGeometry)
A space- or comma-separated list of X11 geometry specifications indicating the
``hot spots'' on the screen.
.TP 15
.BI xmss.coldSpots: " geometry-list " (XMss.HotGeometry)
A space- or comma-separated list of X11 geometry specifications indicating the
``cold spots'' on the screen.
.TP 15
.BI xmss.hotColor: " color " (XMss.Color)
The color to use when highlighting ``hot spots''.
.TP 15
.BI xmss.coldColor: " color " (XMss.Color)
The color to use when highlighting ``cold spots''.
.TP 15
.BI xmss.hotKey: " key " (XMss.Key)
The ``hot key'' to immediately highlight all ``hot'' and ``cold'' spots.
This key is specified using a subset of X toolkit key event specifiers:
the event type (e.g. ``<Key>'') must not be specified, and the ``:'' modifier
cannot be used.  An example ``hot key'' is
.BR "!Alt Shift Control_R" ;
note that a modifier key is permitted to appear as a normal key, if it is
specified as a keysym.  Weird effects may ensue if a modifier key is specified
both as a modifier and as a keysym.
.TP 15
.BI xmss.module: " module " (XMss.Module)
The saver module to run.
.SS "dim Module Resources"
.TP 15
.BI xmss.dim.steps: " number " (XMss.Saver.Steps)
The number of equally-sized steps to use in dimming the screen.
.TP 15
.BI xmss.dim.percent: " number " (XMss.Saver.Percent)
The screen's brightness will be reduced by
.I number
percent.
.TP 15
.B "xmss.dim.serverGrabs: true|false (XMss.Saver.ServerGrabs)"
If set to
.BR True ,
the
.B dim
module will grab the server while animating its dimming/undimming sequence.
This can make the animation much smoother, but locks out other X clients.
.SS "2600 module Resources"
.TP 15
.BI xmss.2600.changeTime: " seconds " (XMss.Saver.Time)
Randomly change colors every
.I seconds
seconds while active.
.BI xmss.2600.percent: " number " (XMss.Saver.Percent)
Reduce the brightness of all colors by
.I number
percent.
.TP 15
.B "xmss.2600.scale: linear|exponential (XMss.Saver.Scale)"
Specify the scale by which to select color brightness:  all brightness levels
are equally probable with the
.B linear
scale, whereas with the
.B exponential
scale dim colors are much more common.
.SS "xlock Module Resources"
.BI xmss.xlock.locker: " program " (XMss.Saver.Program)
Run the specified
.I program
as a command line to
.B /bin/sh
when active.
.SH ERRORS
Various things can go wrong during
.IR xmss 's
initialization, or occasionally when a module is activated.  These result in
messages to standard error, preceded by the class name
.RB ( XMss ).
The possible messages are:
.TP 15
.RI "can't open display: " display
The X server specified by
.I display
is not running or does not possess the specified screen.
.RI "unrecognized argument: " string
An unknown option or a non-option argument was specified.
.TP 15
no modules could be initialized
The initialization routines for all modules returned False, indicating that
they were unable to run in the default visual or could not allocate sufficient
server resources.
.TP 15
.RI "no such saver module: " string
The module specified by the
.B \-module
option or the
.B xmss.module
resource does not exist.
.TP 15
.BI "already running from host:pid: " host:pid
.B XMss
uses a locking protocol to avoid multiple copies running on the same screen,
which may otherwise interact with each other in strange ways.  If a lock is
discovered on the screen, the host and process ID for the other copy of
.B xmss
will be displayed.  If the lock is for a nonexistent copy of
.B xmss
(this should never happen), use
.B "xmss -unlock"
to release the lock.
.TP 15
.B lock on root window broken
The lock placed on the root window of the screen managed by
.B xmss
was removed, probably by an
.B "xmss \-unlock"
command.
.TP
.BI "can't dup resource: " value
.TP 15
.B "can't allocate HotGeometry"
.TP 15
.BI "can't dup keysym: " keysym
.TP 15
.B "can't allocate modifier translation"
.TP 15
.B "can't allocate key event"
The resource manager ran out of memory while parsing resources.
.TP 15
.B "addOptions: out of memory"
The resource manager ran out of slots in the master option directory while
adding module-specific options.  This requires
.B xmss
to be rebuilt with a larger value for
.BR NOPTION .
.B "can't allocate queue entry"
.B XMss
ran out of memory while adding a newly-created window to the queue of delayed
window attachments.
.B "2600: internal scale corrupted"
.TP 15
.B "random: lost the module list"
.BR XMss 's
memory is corrupted.  This should never happen.
.B "can't allocate hotwindow"
.B XMss
ranout of memory while adding a ``hotspot'' or ``coldspot'' window to the list
of currently displayed hot and cold spots.
.B "can't read XA_RESOURCE_MANAGER property on root window"
The attempt to reread
.BR xmss 's
resources after a resource manager database change is detected failed.
.TP 15
.B "ridiculously long XA_RESOURCE_MANAGER property"
.BR XMss 's
resource manager database buffer overflowed.  Since
.B xmss
is extremely generous with the memory it allocates to the database, this is
likely to indicate a problem with either the X server or the resource
database.  (If the resource database really is large enough to trigger this
message, perhaps other means of maintaining it are indicated.)
.SH WARNINGS
Some warning messages can be produced by
.B xmss
or its modules.  These will not cause
.B xmss
to exit but may disable modules or reduce its functionality.
.TP 15
.BI "only one non-modifier allowed in key event: " keysym
.B "can't combine ~ and !"
.BI "unknown keysym: " keysym
.BI "keysym not mapped to keycode: " keysym
.BI "keysym can't be ~'ed: " keysym
.B "modifier ~None is illegal"
.B "can't combine None with modifiers"
.B "a non-modifier must be included in the key event"
The hotkey specification was invalid, and has been ignored.  Correct the
definition and use
.B xrdb
to reinstall the resource database;
.B xmss
will reread the key definition.
.TP 15
waitpid failed
The
.B xlock
module lost track of the locker program.  It will be considered to have
exited.
.SH NOTES
Resource classes for saver modules was a bad idea, although future modules may
profit by sharing some resources.  The module resource class mechanism needs
to be redesigned.
.P
Occasionally the screen may blank when the
.B xlock
module is deactivated, because the
.B locker
program is notified of the deactivating event before
.B xmss
is.
.P
The
.B dim
module works best on a lightly-loaded local server.  Over a network or on a
heavily-loaded server, the dimming animation may appear to be jerky or
discontinuous.
.P
The
.B xmss.dim.steps
and
.B xmss.dim.percent
settings interact to some extent, and tend to be server-dependent.  They will
probably need to be tuned for each server.
.P
The
.B xlock
module uses the
.B blank
module as a fallback screen saver if the
.B locker
program terminates unexpectedly.  The
.B dim
and
.B 2600
modules also fall back to
.B blank
if they cannot determine the current colormap or its contents when activated.
.P
.B xlock
without the
.B \-nolock
option should only be used if the
.B xlock
module is explicitly invoked.  Doing otherwise is not an error, but the screen
will only be locked if the
.B random
module happens to select
.B xlock
at save time.
.P
.B XMss
should unblank when a new window pops up, since it might be important (e.g. an
alert); unfortunately, since
.B xlock
usually results in a window being opened and the
.B blank
module always does, there is a conflict.
.P
This utility will probably be obsoleted to some extent by X11R6.
.SH "SEE ALSO"
X11(1), xlock(1), xprop(1), xmss-module(7).
