.TH XScreenSaver 1 "22-mar-93" "X Version 11"
.SH NAME
attraction - interactions of opposing forces
.SH SYNOPSIS
.B attraction
[\-display \fIhost:display.screen\fP] [\-foreground \fIcolor\fP] [\-background \fIcolor\fP] [\-window] [\-root] [\-mono] [\-install] [\-visual \fIvisual\fP] [\-points \fIint\fP] [\-threshold \fIint\fP] [\-mode balls | lines | polygons | splines | filled-splines | tails ] [\-color-mode cycle | random] [\-size \fIint\fP] [\-segments \fIint\fP] [\-delay \fIusecs\fP] [\-color-shift \fIdegrees\fP] [\-radius \fIint\fP] [\-vx \fIint\fP] [\-vy \fIint\fP] [\-glow] [\-noglow] [\-orbit]
.SH DESCRIPTION
The \fIattraction\fP program has several visually different modes of 
operation, all of which are based on the interactions of a set of control
points which attract each other up to a certain distance, and then begin
to repel each other.  The attraction/repulsion is proportional to the 
distance between any two particles.
.SH OPTIONS
.I attraction
accepts the following options:
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-mono 
If on a color display, pretend we're on a monochrome display.
.TP 8
.B \-install
Install a private colormap for the window.
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-points integer
How many control points should be used, or 0 to select the number randomly.
Default 0.  Between 3 and 15 works best.
.TP 8
.B \-threshold integer
The distance (in pixels) from each particle at which the attractive force
becomes repulsive.  Default 100.
.TP 8
.B \-mode "balls | lines | polygons | tails | splines | filled-splines"
In \fIballs\fP mode (the default) the control points are drawn as filled
circles.  The larger the circle, the more massive the particle.

In \fIlines\fP mode, the control points are connected by straight lines;
the effect is something like \fIqix\fP.

In \fIpolygons\fP mode, the control points are connected by straight
lines, and filled in.  This is most interesting in color.

In \fIsplines\fP mode, a closed spline is interpolated from the control 
points.

In \fIfilled-splines\fP mode, the splines are filled in instead of being
outlines.  This is most interesting in color.

In \fItails\fP mode, the path which each particle follows is indicated
by a worm-like trail, whose length is controlled by the \fIsegments\fP
parameter.
.TP 8
.B \-color-mode cycle | random
Whether colors should cycle through the spectrum, or be picked randomly.
.TP 8
.B \-size integer
The size of the balls in pixels, or 0, meaning to select the sizes 
randomly (the default.)  If this is specified, then all balls will be 
the same size.  This option has an effect in all modes, since the ``size''
of the balls controls their mass.
.TP 8
.B \-segments integer
If in \fIlines\fP or \fIpolygons\fP mode, how many sets of line segments
or polygons should be drawn. Default 100.  This has no effect in \fIballs\fP
mode.  If \fIsegments\fP is 0, then no segments will ever be erased (this
is only useful in color.)
.TP 8
.B \-delay microseconds
How much of a delay should be introduced between steps of the animation.
Default 10000, or about 0.01 seconds.
.TP 8
.B \-color-shift degrees
If on a color display, the color of the line segments or polygons will 
cycle through the spectrum.  This specifies how far the hue of each segment
should be from the next, in degrees on the HSV wheel.  Default 3.
This has no effect in \fIballs\fP mode.
.TP 8
.B \-radius
The size in pixels of the circle on which the points are initially positioned.
The default is slightly smaller than the size of the window.
.TP 8
.B \-glow
This is consulted only in \fIballs\fP mode.  If this is specified, then 
the saturation of the colors of the points will vary according to their
current acceleration.  This has the effect that the balls flare brighter
when they are reacting to each other most strongly.

In \fIglow\fP mode, all of the balls will be drawn the same (random)
color, modulo the saturation shifts.  In non-glow mode, the balls will
each be drawn in a random color that doesn't change.
.TP 8
.B \-noglow
Don't do ``glowing.''  This is the default.
.TP 8
.B \-vx pixels
.TP 8
.B \-vy pixels
Initial velocity of the balls.  This has no effect in \fB\-orbit\fP mode.
.TP 8
.B \-orbit
Make the initial force on each ball be tangential to the circle on which
they are initially placed, with the right velocity to hold them in orbit
about each other.  After a while, roundoff errors will cause the orbit
to decay.
.TP 8
.B \-vmult float
In orbit mode, the initial velocity of the balls is multiplied by this;
a number less than 1 will make the balls pull closer together, and a larger
number will make them move apart.  The default is 1, meaning stability.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 1992, 1993 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski <jwz@mcom.com>, 13-aug-92.
