//  
//  Copyright (c) 1994 by Mike Romberg (  romberg@md.fsl.noaa.gov )
//
// dummy device ignore code by : David Cuka (dcuka@intgp1.ih.att.com)
//
//  This file may be distributed under terms of the GPL
//

#include "netmeter.h"
#include <fstream.h>
#include <string.h>

static const int FIELDS         = 11;
static const int INFIELD        = 0;
static const int OUTFIELD       = 5;
static const char NETFILENAME[] = "/proc/net/dev";


float NetMeter::incoming_[2];
float NetMeter::outgoing_[2];
Timer NetMeter::timer_( 1 );
int NetMeter::index_ = 0;
float NetMeter::lastinterval_;


NetMeter::NetMeter( void ){
  checkevent();
  checkevent();
}

NetMeter::~NetMeter( void ){
}

void NetMeter::checkevent( void ){
  static int pass = 0;

  pass = (pass + 1)%2;
  if ( !pass )
    return;
  
  static char buf[256];
  static float totals[FIELDS];
  float tmp;
  ifstream stats( NETFILENAME );

  if ( !stats ){
    cerr <<"Can not open file : " <<NETFILENAME <<endl;
    exit( 1 );
  }

  stats.getline( buf, 256 );
  stats.getline( buf, 256 );

  for ( int i = 0 ; i < FIELDS ; i++ )
    totals[i] = 0;

  while ( !stats.eof() ){
    stats.getline( buf, 256, ':' );

    // discard the dummy line so it does not screw things up.
    if (strcmp(buf, " dummy") == 0) {
      stats.ignore(256, '\n');
      continue;
    }

    if ( !stats.eof() ){
      for ( i = 0 ; i < FIELDS ; i++ ){
	stats >>tmp;
	totals[i] += tmp;
      }

      stats.ignore(256, '\n');
    }
  }

  timer_.stop();
  lastinterval_ = timer_.report();
  timer_.start();
  incoming_[index_] = totals[INFIELD];
  outgoing_[index_] = totals[OUTFIELD];
  index_ = (index_ + 1) % 2;
}


