
/*************************************************************************
* Program......: vex
* Author.......: Dan R. Gowin
* Date.........: Mar 17 1995
* Notice.......: Copyright (c), Dan R. Gowin, All Rights Reserved.
* Note.........: This X software was designed to allow remote execution
* .............: of a remote file manager with X Window redirection.
* .............: Vector Software
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation; either version 2, or (at your option) any
* later version.

* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
* 
*
*************************************************************************/

#include <stdio.h>
#include <xview/xview.h>
#include <xview/panel.h>
/* #include <xview/tty.h> */
#include <xview/termsw.h>
#include <xview/seln.h>

Seln_rank seln_type = SELN_PRIMARY;

#define FIRST_BUFFER            0
#define NOT_FIRST_BUFFER        !FIRST_BUFFER

char *seln_bufs[6];

Textsw          textsw;  /* select from this textsw */
Xv_Server       server;
char *get_selection();
Seln_result read_proc(); /* supplied to selection_query() as reader */
char *get_selection();

char master_username[20];
char master_hostname[100];

Termsw          term;
Panel_item      username_id;
Panel_item      server_id;

Frame frame;     /* top level application base-frame */
Frame subframe;  /* subframe (FRAME_CMD) is a child of frame */

int connect_flag = FALSE;

main(argc,argv)
int     argc;
char    *argv[];
{
    Panel       panel, subpanel;
    int         connect_proc();
    int         disconnect_proc();
    int         manage_proc();
    int show_cmd_frame(), pushed(), cancel(), televideo();
    Menu	menu;
    extern void exit();

#define VERSION "Vector Ver 0.8, Copyright (c), D. Gowin 1995, All Rights Reserved."
    printf("\nVEX: %s\n", VERSION);

    strcpy(master_username, (char *)getenv("LOGNAME"));
    strcpy(master_hostname, (char *)getenv("HOSTNAME"));

    xv_init(XV_INIT_ARGS, argc, argv, NULL);

    frame = (Frame)xv_create(NULL, FRAME,
		FRAME_LABEL, "Vector Executive", NULL);

    panel = (Panel)xv_create(frame, PANEL, NULL); 

    (void) xv_create(panel, PANEL_BUTTON,
        PANEL_LABEL_STRING,     "Connect",
        PANEL_NOTIFY_PROC,      connect_proc,
        NULL);
    (void) xv_create(panel, PANEL_BUTTON,
        PANEL_LABEL_STRING,     "Disconnect",
        PANEL_NOTIFY_PROC,      disconnect_proc,
        NULL);
    (void) xv_create(panel, PANEL_BUTTON,
        PANEL_LABEL_STRING,     "Manage",
        PANEL_NOTIFY_PROC,      manage_proc,
        NULL);
    (void) xv_create(panel, PANEL_BUTTON,
        PANEL_LABEL_STRING, "Directory",
        PANEL_NOTIFY_PROC,  show_cmd_frame,
        NULL);
    (void) xv_create(panel, PANEL_BUTTON,
        PANEL_LABEL_STRING, "Televideo",
        PANEL_NOTIFY_PROC,  televideo,
        NULL);

    (void) xv_create(panel, PANEL_BUTTON,
        PANEL_LABEL_STRING,     "Quit",
        PANEL_NOTIFY_PROC,      exit,
        NULL);


    /* Enter username - default is LOGNAME - button is for anonymous. */
    username_id = (Panel_item)xv_create(panel, PANEL_TEXT,
        PANEL_LABEL_STRING,         "Username:",
	PANEL_VALUE, "vector",
	PANEL_VALUE_DISPLAY_LENGTH, 56,
        PANEL_NOTIFY_PROC,          connect_proc,
        NULL);

    server_id = (Panel_item)xv_create(panel, PANEL_TEXT,
        PANEL_LABEL_STRING,         "Server:",
	PANEL_VALUE, master_hostname,
	PANEL_VALUE_DISPLAY_LENGTH, 56,
        PANEL_NOTIFY_PROC,          connect_proc,
        NULL);


    window_fit_height(panel);

    term = (Termsw)xv_create(frame, TERMSW, NULL);

    /* Create the command frame -- not displayed until XV_SHOW is set */
    subframe = (Frame)xv_create(frame, FRAME_CMD,
        FRAME_LABEL,         "Server Directory",
        NULL);

    /* Command frames have panels already created by default -- get it */
    subpanel = (Panel)xv_get(subframe, FRAME_CMD_PANEL);
    (void) xv_create(subpanel, PANEL_BUTTON,
        PANEL_LABEL_STRING,     "Get Selection",
        PANEL_NOTIFY_PROC,      pushed,
        NULL);
    (void) xv_create(subpanel, PANEL_BUTTON,
        PANEL_LABEL_STRING,     "Cancel",
        PANEL_NOTIFY_PROC,      cancel,
        NULL);

    window_fit(subpanel);

    textsw = (Textsw)xv_create(subframe, TEXTSW,
        WIN_X,                  0,
        WIN_BELOW,              subpanel,
        WIN_ROWS,               10,
        WIN_COLUMNS,            80,
        TEXTSW_FILE_CONTENTS,   ".vector_hosts",
        NULL);

    window_fit(subframe);
    server = (Xv_Server)xv_get(xv_get(subframe, XV_SCREEN), SCREEN_SERVER);

/*    window_fit(frame); */
    xv_main_loop(frame);
}


/* Called when base frame's button is pushed -- show/raise subframe */
show_cmd_frame(item, event)
Frame item;
Event *event;
{
    xv_set(subframe, XV_SHOW, TRUE, NULL);
}

/* This option has not been implemented at this time. */
televideo(item, event)
Frame item;
Event *event;
{
    printf("\nTelevideo has not been implemented at this time.\n");
}


/* Called when command frame's button is pushed */
pushed(item,event)
Panel_item  item;
Event  *event;
{
    /*char *text = get_selection(); */

    strcpy(master_hostname, get_selection());
    xv_set(server_id, PANEL_VALUE, master_hostname, NULL);


    /* Check to see if the pushpin is in -- if not, close frame */
/*    if ((int)xv_get(subframe, FRAME_CMD_PUSHPIN_IN) == FALSE) */
    if ((int)xv_get(subframe, FRAME_CMD_PIN_STATE) == FRAME_CMD_PIN_OUT)
        xv_set(subframe, XV_SHOW, FALSE, NULL);
}
cancel(item,event)
Panel_item  item;
Event  *event;
{

    if ((int)xv_get(subframe, FRAME_CMD_PIN_STATE) == FRAME_CMD_PIN_OUT)
        xv_set(subframe, XV_SHOW, FALSE, NULL);
}





/*
 * This procedure is called when the user this return on the
 * panel text item or clicking on the <apply> button.
 * Use ttysw_input() to feed the string to the termal window.
 */

int
connect_proc(item,event)
Panel_item      item;
Event   *event;
{
    char        str[81];
    
	sprintf(str, "xhost + %s \n", (char *)xv_get(server_id, PANEL_VALUE));
	ttysw_input(term, str, strlen(str));

	sprintf(str, "rsh -l %s %s\n", (char *)xv_get(username_id, PANEL_VALUE), (char *)xv_get(server_id, PANEL_VALUE));
	ttysw_input(term, str, strlen(str));

    return XV_OK;
}

int
disconnect_proc(item,event)
Panel_item      item;
Event   *event;
{
    char        str[81];
    
	sprintf(str, "logout\n");
	ttysw_input(term, str, strlen(str));

	sprintf(str, "xhost - %s \n", (char *)xv_get(server_id, PANEL_VALUE));
	ttysw_input(term, str, strlen(str));

/*	xv_set(username_id, PANEL_VALUE, master_username, NULL); */
	xv_set(server_id, PANEL_VALUE, master_hostname, NULL);

    return XV_OK;
}


int
manage_proc(item,event)
Panel_item      item;
Event   *event;
{
    char        str[81];
    
/*    sprintf(str, "vem -display %s\n", (char *)getenv("HOSTDISPLAY")); */
    sprintf(str, "vem -display %s:0 &\n", (char *)getenv("HOSTNAME"));

    ttysw_input(term, str, strlen(str));

    return XV_OK;
}


/**************************************************************************
* Text selection routines.
**************************************************************************/

/*
 * return the text selected in the current selection rank.  Use
 * selection_query() to guarantee that the entire selection is
 * retrieved.  selection_query() calls our installed routine,
 * read_proc() (see below).
 */
char *
get_selection()
{
    Seln_holder   holder;
    Seln_result   result;
    Seln_request  *response;
    char          context = FIRST_BUFFER;

    holder = selection_inquire(server, SELN_PRIMARY);
   
    /* result is based on the return value of read_proc() */
    result = selection_query(server, &holder, read_proc, &context,
        SELN_REQ_BYTESIZE,              NULL,
        SELN_REQ_CONTENTS_ASCII,        NULL,
        NULL);
    if (result == SELN_FAILED) {
        puts("couldn't get selection");
        return NULL;
    }

    return seln_bufs[seln_type];
}

/*
 * Called by selection_query for every buffer of information received.
 * Short messages (under about 2000 bytes) will fit into one buffer.
 * For larger messages, read_proc is called for each buffer in the
 * selection.  The context pointer passed to selection_query is
 * modified by read_proc so that we know if this is the first buffer
 * or not.
 */
Seln_result
read_proc(response)
Seln_request *response;
{
    char *reply;  /* pointer to the data in the response received */
    long seln_len; /* total number of bytes in the selection */
    static long seln_have_bytes;
        /* number of bytes of the selection
         * which have been read; cumulative over all calls for
         * the same selection (it is reset when the first
         * response of a selection is read)
         */

    printf("read_proc status: %s (%d)\n",
        response->status == SELN_FAILED? "failed" :
        response->status == SELN_SUCCESS? "succeeded" :
        response->status == SELN_CONTINUED? "continued" : "???",
        response->status);
    if (*response->requester.context == FIRST_BUFFER) {
        reply = response->data;

        /* read in the length of the selection -- first attribute.
         * advance "reply" passed attribute to point to actual data.
         */
        reply += sizeof(SELN_REQ_BYTESIZE);
        /* set seln_len to actual data now. (bytes selected) */
        seln_len = *(int *)reply;
        printf("selection size is %ld bytes\n", seln_len);
        /* advance "reply" to next attribute in list */
        reply += sizeof(long);

        /* create a buffer large enough to store entire selection */
        if (seln_bufs[seln_type] != NULL)
            free(seln_bufs[seln_type]);
        if (!(seln_bufs[seln_type] = malloc(seln_len + 1))) {
            puts("out of memory");
            return(SELN_FAILED);
        }
        seln_have_bytes = 0;

        /* move "reply" passed attribute so it points to contents */
        reply += sizeof(SELN_REQ_CONTENTS_ASCII);
       *response->requester.context = NOT_FIRST_BUFFER;
    } else {
        /* this is not the first buffer, so the contents of the
	 * response is just more of the selection
         */
        reply = response->data;
    }

    /* copy data from received to the seln buffer allocated above */
    (void) strcpy(&seln_bufs[seln_type][seln_have_bytes], reply);
    seln_have_bytes += strlen(reply);

    return SELN_SUCCESS;
}
