static char *SccsId = "@(#)dmstring.c 3.4 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 04-Dec-1986
Modified by       : Paul Stravers
Modification date : november 1993


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1987 , All rights reserved
**********************************************************/
#include "dmstd.h"

/* these things are #define'd in dmmem.h but here we need the real thing! */
#undef malloc
#undef calloc
#undef free

#include <malloc.h>

extern int dm_mem_options;	  /* defined in dmmem.c */

/* store string in permanent memory */

char   *_dmOriginalStrSave (string)
char   *string;
{
    char   *p = NULL;

    if (string) {
	if (p = malloc ((unsigned) (strlen (string) + 1)))
	    strcpy (p, string);
    }
    return (p);
}

/* delete string from permanent memory */

_dmOriginalStrFree (string)
char   *string;
{
    if (string)
	free (string);
}


/* depending on the dm_mem_options, use either the nelsis or the seadif
 * string manager. In both cases STRING is stored and a pointer to it
 * is returned.
 */
char *_dmStrSave(string)
   char *string;
{
   if (dm_mem_options & DM_NEW_STRINGSAVE)
      return cs(string);
   else
      return _dmOriginalStrSave(string);
}


/* depending on the dm_mem_options, use either the nelsis or the seadif
 * string manager. In both cases the storage of STRING is released.
 */
_dmStrFree(string)
   char *string;
{
   if (dm_mem_options & DM_NEW_STRINGSAVE)
      fs(string);
   else
      _dmOriginalStrFree(string);
}
