/* SccsId = "@(#)gdef.h 4.4 (TU-Delft) 01/18/91" */
/**********************************************************

Name/Version      : cldm/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 17-Dec-1987
Modification date : 20-May-1988
Modification date : 14-May-1990
Modification date : 18-Jan-1991


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987-1988, All rights reserved
**********************************************************/
#include "incl.h"

/*
**  Global declarations of CLDM
*/

/* Flags for various purposes */

struct stat stat_buf;	/* file status info */
#ifdef hpux
extern unsigned char yytext[];	/* lex string buffer (see: LEX) */
#else
extern char yytext[];	/* lex string buffer (see: LEX) */
#endif
extern int  yyleng;	/* lex string buffer length */
extern int  yylineno;	/* lex current line number */

char    name_len[4];

DM_PROCDATA *process;   /* ptr to process info */

int	sfx, sfy;	/* model call scaling factors */
int	lay_code;	/* layer code (of process table) */
int     err_cnt  = 0;	/* error counter */
int     err_flag = 0;	/* set when an error, either a syntax or a
			   semantic error, is detected, reset when
			   a me statement is encountered */
int     v_mode = 0;  	/* verbose, if -v option is specified */
int     s_mode = 0;  	/* syntax check only (-s option) */
int     o_mode = 0;
int     f_mode = 0;	/* force cell overwrite (if on) */
int     b_mode = 0;
int     mode45 = 0;	/* test input on 45 degree */

int     ini_bbbox = 0;	/* bounding box flags, set when a ms
				   statement */
int     ini_mcbbox = 0;	/* is encountered, reset when the
			   corresponding bounding box gets a value */

int     n_tok  = 0;	/* if(true) name token expected */
int     t_tok  = 0;	/* if(true) term stat processing */
int     w_tok  = 0;	/* if(true) wire stat processing */
int     ms_tok = 0;	/* if(true) ms stat seen */

char    ms_name[DM_MAXNAME+1] = "??";/* name of current modeldef. */
char    mc_name[DM_MAXNAME+1];	/* name of model called */
char    instance[DM_MAXNAME+1];	/* name of model inst. */
char    terminal[DM_MAXNAME+1];	/* name of terminal */

/* Binary sorted name trees */

struct name_tree   *tree_ptr = NULL;
struct name_tree   *mod_tree = NULL;
	/* tree containing names of models defined
	   in the database */
struct name_tree   *tnam_tree = NULL;
	/* tree containing names of terminals
	   defined in current model */
struct name_tree   *inst_tree = NULL;
	/* tree containing names of instances
	   defined in current model */

DM_PROJECT *dmproject = NULL;
DM_CELL *mod_key = NULL;

/* FILE descriptors */

DM_STREAM *fp_box;
DM_STREAM *fp_info;
DM_STREAM *fp_mc;
DM_STREAM *fp_nor;
DM_STREAM *fp_term;

/* Element Parameters: */

char    layer[DM_MAXLAY+1];	/* layer code string */
int     w_dir;			/* current wire direction */
int     w_width, w_x, w_y;	/* width and position */
int	tmp_i;			/* temporary usable integer */
double	tmp_d, d_f;		/* temporary usable double */

int     int_val[NOINTS];	/* int  number buffer */
int     int_ind = 0;		/* int  number buffer index */
int     dx, nx, dy, ny;         /* repetition  */
long    tx, ty;		        /* translation */
long    bbnd_xl, bbnd_xr;       /* box bounding box */
long    bbnd_yb, bbnd_yt;
long    mcbb_xl, mcbb_xr;       /* model reference bbox */
long    mcbb_yb, mcbb_yt;
/* sea-of-gates bounding box WITHOUT image: */
long    mcNoImage_xl, mcNoImage_xr;
long    mcNoImage_yb, mcNoImage_yt;

long    cifunit = 100;		/* default cif unit */
