/* SccsId = "@(#)sys_incl.h 4.3 (TU-Delft) 07/27/92" */
/**********************************************************

Name/Version      : sls_mkdb/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#ifndef NOSYSINCL
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#ifdef SYSV
#include <fcntl.h>
#else
#include <sys/file.h>
#endif
#include "dmincl.h"
#ifndef NCF_RELEASE
#define NCF_RELEASE 300
#endif
#endif

#line 1 "parse.cls"
/* <<cpre-2/8/82>> */ 
static char yysccsid [ ] = "@(#)yaccpar	1.8 (Berkeley) 01/20/90" ; 
#line 2 "parse.y"

#line 1 "./sys_incl.h"

#line 41 "./sys_incl.h"

#line 33 "parse.cls"

#line 1 "./class.h"

#line 1 "./odb.h"

#line 31 "./class.h"
typedef struct datum 
{ 
char * dptr ; 
int dsize ; 
} datum ; 

typedef struct db_files { 
char * dbname ; 
int DbRdOnly ; 
int DirF , dir_b , dir_t ; 
int PagF , pag_b , pag_t ; 

long bitno ; 
long maxbno ; 
long blkno ; 
long hmask ; 

char pagbuf [ 1024 ] ; 
char dirbuf [ 1024 ] ; 
} DbAcces ; 

DbAcces * dbOpen ( ) ; 
datum dbfetch ( ) ; 
datum makdatum ( ) ; 
datum firstkey ( ) ; 
datum nextkey ( ) ; 
datum firsthash ( ) ; 
long calchash ( ) ; 
long hashinc ( ) ; 
#line 28 "./class.h"

#line 1 "./stack.h"

#line 27 "./stack.h"
struct stack { char * * min ;
char * * top ;
char * * max ;
} ;
extern int _1stack_new ( /* short */ ) ;
extern int _2stack_delete ( ) ;
extern int _13stack_empty ( /* ? */ ) ;
extern int _14stack_push ( /* char * */ ) ;
extern char * _15stack_pop ( ) ;
extern char * _16stack_access ( /* int */ ) ;
extern int _17stack_print ( ) ;
extern int _18stack_reset ( ) ;
extern struct stack * _19stack_copy ( ) ;
extern char * * _20stack_base ( ) ;
extern char * * _21stack_limit ( ) ;
extern int _22stack_length ( ) ;

#line 44 "./stack.h"
; 
#line 29 "./class.h"

#line 1 "./queue.h"

#line 27 "./queue.h"
struct link { struct link * next ;
char type ;
} ;

#line 31 "./queue.h"
;

#line 33 "./queue.h"
struct queue { struct link _Bqueue ;
struct link * tail ;
short n ;
} ;
extern int _1queue_new ( /* char */ ) ;
extern int _2queue_delete ( ) ;
extern int _12queue_reset ( ) ;
extern struct link * _13queue_get ( ) ;
extern int _14queue_put ( /* struct link * */ ) ;
extern short _15queue_length ( ) ;
extern int _16queue_print ( ) ;
extern int _17queue_empty ( ) ;
extern struct link * _18queue_access ( /* int */ ) ;
extern struct link * _19queue_first_elem ( ) ;
extern struct link * _20queue_next_elem ( /* struct link * */ ) ;
extern struct link * _21queue_last_elem ( ) ;
extern int _22queue_append ( /* struct queue * */ ) ;

#line 51 "./queue.h"
; 
#line 30 "./class.h"

#line 1 "./dict.h"

#line 27 "./dict.h"
struct dictionary { struct db_files * db ;
struct datum key ;
struct datum data ;
} ;
extern int _1dictionary_new ( ) ;
extern int _2dictionary_delete ( ) ;
extern int _13dictionary_store ( /* char * , char * */ ) ;
extern char * _14dictionary_fetch ( /* char * */ ) ;
extern int _15dictionary_print ( /* ? */ ) ;

#line 37 "./dict.h"
; 
#line 31 "./class.h"

typedef struct dictionary Dictionary ; 
typedef struct stack Stack ; 
typedef struct queue Queue ; 
typedef struct link Link ; 
#line 1 "./ntwdefs.h"

#line 27 "./ntwdefs.h"
struct ntwdef { int inst_gen_cnt ;
int net_gen_cnt ;
char * ntw_name ;
int local ;
struct queue * termq ;
struct queue * orig_termq ;
struct queue * mcq ;
struct queue * netq ;
} ;
extern int _1ntwdef_new ( /* char * */ ) ;
extern int _2ntwdef_delete ( ) ;
extern char * _12ntwdef_genname ( /* char */ ) ;

#line 40 "./ntwdefs.h"
;

#line 42 "./ntwdefs.h"
struct instancestruct { char * inst_name ;
struct stack * inst_construct ;
int termCnt ;
struct netMember * nmem ;
} ;
extern int _1instancestruct_new ( /* char * , struct stack * */ ) ;
extern int _2instancestruct_delete ( ) ;

#line 50 "./ntwdefs.h"
;

#line 52 "./ntwdefs.h"
struct ntwinst { struct link _Bntwinst ;
struct ntwdef * ntw ;
struct stack * ntw_attr ;
struct instancestruct * inst_struct ;
} ;
extern int _1ntwinst_new ( /* struct ntwdef * , struct stack * */ ) ;
extern int _2ntwinst_delete ( ) ;
extern int _13ntwinst_to_db ( ) ;

#line 60 "./ntwdefs.h"
; 


typedef struct ntwdef Network ; 
typedef struct ntwinst NetworkInstance ; 
typedef struct instancestruct InstanceStruct ; 
#line 38 "./class.h"

#line 1 "./xelem.h"

#line 27 "./xelem.h"
struct xelem { short left_bound ;
short right_bound ;
} ;
extern int _1xelem_new ( /* short , short */ ) ;
extern int _2xelem_delete ( ) ;
extern int _12xelem_print ( /* ? */ ) ;

#line 34 "./xelem.h"
; 
#line 39 "./class.h"

#line 1 "./netelem.h"

#line 31 "./netelem.h"
struct simpleNet { struct netMember * nmem ;
struct simpleNet * next ;
struct simpleNet * prev ;
} ;

#line 36 "./netelem.h"
;

#line 49 "./ntwdefs.h"
struct netMember { struct ntwinst * inst ;
struct netelem * net ;
struct netMember * next ;
struct simpleNet * snet ;
} ;

#line 44 "./netelem.h"
;

#line 41 "./netelem.h"
struct netelem { struct link _Bnetelem ;
char * name ;
int type ;
struct stack * xs ;
struct queue * eqv ;
struct netMember * nmem ;
} ;
extern int _1netelem_new ( /* char * , struct stack * , char */ ) ;
extern int _2netelem_delete ( ) ;
extern int _15netelem_print ( /* ? */ ) ;
extern int _16netelem_to_db ( /* ? */ ) ;

#line 57 "./netelem.h"
;

#line 59 "./netelem.h"
struct net_ref { struct link _Bnet_ref ;
struct netelem * net ;
struct stack * net_xs ;
struct ntwinst * inst ;
struct stack * inst_xs ;
struct stack * ref_xs ;
} ;
extern int _1net_ref_new ( /* struct netelem * , struct stack * */ ) ;
extern int _2net_ref_delete ( ) ;

#line 68 "./netelem.h"
; 

typedef struct netMember Nmem ; 
#line 40 "./class.h"

typedef struct xelem Xelem ; 
typedef struct netelem Netelem ; 
typedef struct net_ref NetReference ; 
#line 35 "parse.cls"

#line 1 "./mkdbdefs.h"

#line 1 "./slserr.h"

#line 30 "./mkdbdefs.h"

#line 36 "parse.cls"

#line 1 "./mkdbincl.h"

#line 27 "parse.cls"
extern int doSimpleNet ; 
extern int genIntNet ; 
extern int externRequired ; 
extern int forbidFirstCapital ; 
extern int noWarnings ; 
extern int sls_errcnt ; 
extern int sls_errno ; 
extern int sls_nerr ; 
extern char * sls_errlist [ ] ; 

extern int yylineno ; 
extern char fn_incl [ ] ; 

extern int int_nbyte , int_maxnbyte ; 
extern int char_nbyte , char_maxnbyte ; 
extern int ntwdef_nbyte , ntwdef_maxnbyte ; 
extern int ntwinst_nbyte , ntwinst_maxnbyte ; 
extern int inst_struct_nbyte , inst_struct_maxnbyte ; 
extern int netelem_nbyte , netelem_maxnbyte ; 
extern int dict_nbyte , dict_maxnbyte ; 
extern int net_ref_nbyte , net_ref_maxnbyte ; 
extern int xelem_nbyte , xelem_maxnbyte ; 
extern int queue_nbyte , queue_maxnbyte ; 
extern int stack_nbyte , stack_maxnbyte ; 
#line 37 "parse.cls"

extern char * yytext ; 
extern Netelem * notconnected ; 

int resynch ( ) ; 
char * strsav ( ) ; 
double cvt_atof ( ) ; 
Stack * stackcpy ( ) ; 
Stack * xstackcpy ( ) ; 
Network * init_ntw ( ) ; 
Network * read_ntw ( ) ; 
Network * dev_tab [ ] ; 

int n_net_cnt ; 
int n_inst_cnt = 0 ; 
int n_term_cnt ; 

Stack * xs , * pxs ; 
Stack * attr_s ; 
Queue * pq ; 
Queue * netq ; 
Queue * pnetq ; 
extern Dictionary * ntw_dict ; 
extern Dictionary * sym_dict ; 
extern Dictionary * dff_dict ; 

extern char * * globNets ; 
extern int globNets_cnt ; 

Xelem * pxelem ; 
Netelem * pnet ; 
Network * ntw ; 
Network * pntw ; 
NetReference * pnref ; 
NetworkInstance * inst ; 

char name_buf [ BUFSIZ ] ; 
char ntw_name [ BUFSIZ ] ; 
char attr_buf [ BUFSIZ ] ; 

int fflag = 0 ; 
int bifflag = 0 ; 
int invertbifflag ; 
int trunc_warn = 0 ; 
int externspec = 0 ; 
char mc_type = 'i' ; 

int almost_eos = 0 ; 

Network * curr_ntw ; 
#line 86 "parse.y"
typedef union { 
int ival ; 
char * sval ; 
char cval ; 
int * pival ; 
float fval ; 
double dval ; 
} YYSTYPE ; 
#line 98 "y.tab.c"

#line 128 "y.tab.c"
short yylhs [ ] = { - 1 , 
0 , 0 , 47 , 49 , 47 , 23 , 5 , 5 , 48 , 6 , 
6 , 7 , 19 , 19 , 20 , 8 , 8 , 50 , 50 , 51 , 
51 , 51 , 51 , 24 , 26 , 26 , 27 , 28 , 29 , 29 , 
29 , 29 , 29 , 30 , 31 , 32 , 33 , 25 , 53 , 34 , 
22 , 22 , 22 , 35 , 35 , 39 , 40 , 40 , 40 , 40 , 
37 , 38 , 38 , 36 , 14 , 14 , 15 , 15 , 16 , 16 , 
16 , 54 , 17 , 18 , 52 , 9 , 9 , 10 , 10 , 11 , 
12 , 12 , 13 , 13 , 1 , 1 , 2 , 2 , 3 , 3 , 
4 , 21 , 43 , 43 , 41 , 41 , 41 , 41 , 42 , 42 , 
42 , 44 , 45 , 46 , 55 , 55 , 55 , 55 , 55 , 55 , 
55 , 55 , 55 , 56 , 56 , 56 , 56 , 
} ; 
short yylen [ ] = { 2 , 
1 , 2 , 3 , 0 , 4 , 2 , 3 , 2 , 3 , 1 , 
3 , 2 , 1 , 3 , 2 , 1 , 1 , 0 , 2 , 2 , 
2 , 1 , 1 , 2 , 1 , 1 , 4 , 1 , 1 , 1 , 
1 , 1 , 1 , 2 , 2 , 2 , 2 , 2 , 0 , 3 , 
1 , 1 , 1 , 0 , 2 , 3 , 1 , 1 , 1 , 1 , 
1 , 1 , 1 , 1 , 3 , 3 , 1 , 3 , 1 , 1 , 
0 , 0 , 4 , 2 , 4 , 1 , 1 , 1 , 3 , 3 , 
1 , 3 , 2 , 1 , 0 , 3 , 1 , 3 , 1 , 1 , 
3 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 
1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 
1 , 1 , 1 , 1 , 1 , 1 , 1 , 
} ; 
short yydefred [ ] = { 0 , 
0 , 4 , 0 , 0 , 1 , 92 , 97 , 95 , 96 , 98 , 
99 , 100 , 101 , 102 , 103 , 6 , 83 , 84 , 93 , 0 , 
2 , 0 , 0 , 0 , 17 , 16 , 8 , 0 , 10 , 0 , 
18 , 3 , 5 , 0 , 7 , 107 , 104 , 105 , 106 , 0 , 
13 , 0 , 89 , 90 , 91 , 94 , 0 , 11 , 0 , 0 , 
15 , 23 , 0 , 41 , 42 , 43 , 0 , 0 , 22 , 0 , 
9 , 39 , 44 , 0 , 0 , 25 , 26 , 28 , 29 , 30 , 
31 , 32 , 33 , 44 , 19 , 0 , 14 , 82 , 0 , 77 , 
80 , 0 , 0 , 54 , 52 , 53 , 35 , 36 , 88 , 0 , 
0 , 85 , 86 , 87 , 0 , 0 , 21 , 0 , 0 , 24 , 
0 , 20 , 0 , 76 , 0 , 74 , 0 , 0 , 0 , 68 , 
0 , 71 , 0 , 0 , 38 , 40 , 47 , 48 , 49 , 50 , 
45 , 0 , 62 , 60 , 0 , 57 , 59 , 0 , 78 , 81 , 
0 , 65 , 0 , 0 , 73 , 27 , 0 , 0 , 0 , 56 , 
55 , 70 , 69 , 72 , 46 , 51 , 0 , 58 , 63 , 0 , 
64 , 
} ; 
short yydgoto [ ] = { 3 , 
123 , 79 , 80 , 81 , 23 , 28 , 29 , 30 , 108 , 109 , 
110 , 111 , 124 , 100 , 125 , 126 , 127 , 149 , 40 , 41 , 
85 , 63 , 4 , 64 , 90 , 65 , 66 , 67 , 68 , 69 , 
70 , 71 , 72 , 73 , 96 , 86 , 145 , 87 , 121 , 122 , 
91 , 113 , 74 , 43 , 44 , 45 , 5 , 32 , 20 , 47 , 
75 , 76 , 95 , 138 , 19 , 46 , 
} ; 
short yysindex [ ] = { - 160 , 
- 21 , 0 , - 160 , - 241 , 0 , 0 , 0 , 0 , 0 , 0 , 
0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , - 195 , 
0 , - 243 , - 229 , - 241 , 0 , 0 , 0 , - 171 , 0 , - 37 , 
0 , 0 , 0 , - 248 , 0 , 0 , 0 , 0 , 0 , - 216 , 
0 , - 157 , 0 , 0 , 0 , 0 , - 240 , 0 , - 37 , - 151 , 
0 , 0 , - 144 , 0 , 0 , 0 , - 125 , - 125 , 0 , - 62 , 
0 , 0 , 0 , - 133 , - 188 , 0 , 0 , 0 , 0 , 0 , 
0 , 0 , 0 , 0 , 0 , - 130 , 0 , 0 , - 264 , 0 , 
0 , - 128 , - 187 , 0 , 0 , 0 , 0 , 0 , 0 , - 116 , 
- 157 , 0 , 0 , 0 , - 21 , - 168 , 0 , - 139 , - 139 , 0 , 
- 168 , 0 , - 151 , 0 , - 151 , 0 , - 113 , - 115 , - 112 , 0 , 
- 109 , 0 , - 157 , - 88 , 0 , 0 , 0 , 0 , 0 , 0 , 
0 , - 121 , 0 , 0 , - 215 , 0 , 0 , - 172 , 0 , 0 , 
- 141 , 0 , - 127 , - 113 , 0 , 0 , - 125 , - 108 , - 139 , 0 , 
0 , 0 , 0 , 0 , 0 , 0 , - 37 , 0 , 0 , - 157 , 
0 , 
} ; 
short yyrindex [ ] = { 0 , 
0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 
0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 
0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 
0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , - 169 , 
0 , - 206 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 
0 , 0 , 0 , 0 , 0 , 0 , - 228 , - 191 , 0 , 0 , 
0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 
0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 
0 , - 234 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 
- 111 , 0 , 0 , 0 , 0 , - 138 , 0 , - 164 , - 238 , 0 , 
- 117 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , - 105 , 0 , 
- 101 , 0 , - 207 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 
0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 
0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , - 263 , 0 , 
0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 , - 207 , 
0 , 
} ; 
short yygindex [ ] = { 0 , 
- 41 , 0 , 78 , 0 , 158 , 0 , 149 , 0 , 0 , 0 , 
51 , 79 , - 77 , 0 , 86 , 48 , 0 , 0 , 0 , 139 , 
- 45 , 0 , 169 , 0 , 0 , 0 , 0 , 0 , 76 , 0 , 
0 , 0 , 102 , 0 , 133 , 0 , 0 , - 54 , 0 , 0 , 
0 , - 30 , 207 , 1 , 2 , 151 , 206 , 0 , 0 , 0 , 
0 , 0 , 0 , 0 , 0 , 0 , 
} ; 

short yytable [ ] = { 42 , 
51 , 17 , 18 , 88 , 82 , 112 , 103 , 61 , 75 , 25 , 
61 , 26 , 61 , 104 , 25 , 52 , 26 , 6 , 42 , 7 , 
8 , 9 , 53 , 54 , 55 , 56 , 57 , 58 , 59 , 112 , 
27 , 22 , 61 , 75 , 60 , 61 , 79 , 61 , 12 , 13 , 
14 , 15 , 62 , 79 , 98 , 31 , 98 , 17 , 18 , 115 , 
98 , 98 , 98 , 98 , 49 , 139 , 144 , 82 , 140 , 130 , 
92 , 93 , 75 , 75 , 75 , 1 , 75 , 75 , 75 , 106 , 
6 , 135 , 7 , 8 , 9 , 36 , 37 , 38 , 39 , 10 , 
11 , 99 , 146 , 99 , 98 , 107 , 99 , 99 , 99 , 99 , 
99 , 12 , 13 , 14 , 15 , 17 , 18 , 34 , 139 , 12 , 
1 , 2 , 35 , 141 , 12 , 78 , 61 , 75 , 151 , 61 , 
117 , 118 , 119 , 120 , 17 , 18 , 150 , 106 , 6 , 50 , 
7 , 8 , 9 , 36 , 37 , 38 , 39 , 10 , 11 , 134 , 
83 , 78 , 142 , 84 , 34 , 97 , 34 , 50 , 102 , 12 , 
13 , 14 , 15 , 106 , 6 , 107 , 7 , 8 , 9 , 36 , 
37 , 38 , 39 , 10 , 11 , 37 , 105 , 37 , 133 , 114 , 
132 , 134 , 137 , 147 , 75 , 12 , 13 , 14 , 15 , 6 , 
66 , 7 , 8 , 9 , 67 , 54 , 55 , 56 , 57 , 58 , 
129 , 33 , 48 , 143 , 128 , 131 , 148 , 77 , 24 , 136 , 
12 , 13 , 14 , 15 , 62 , 6 , 116 , 7 , 8 , 9 , 
36 , 37 , 38 , 39 , 10 , 11 , 101 , 16 , 21 , 89 , 
94 , 0 , 0 , 0 , 0 , 0 , 12 , 13 , 14 , 15 , 
6 , 0 , 7 , 8 , 9 , 36 , 37 , 38 , 39 , 10 , 
11 , 0 , 0 , 0 , 0 , 0 , 6 , 0 , 7 , 8 , 
9 , 12 , 13 , 14 , 15 , 10 , 11 , 0 , 0 , 0 , 
0 , 0 , 0 , 0 , 0 , 0 , 0 , 12 , 13 , 14 , 
15 , 
} ; 
short yycheck [ ] = { 30 , 
42 , 1 , 1 , 58 , 50 , 83 , 271 , 271 , 272 , 258 , 
274 , 260 , 276 , 278 , 258 , 256 , 260 , 258 , 49 , 260 , 
261 , 262 , 263 , 264 , 265 , 266 , 267 , 268 , 269 , 107 , 
274 , 273 , 271 , 272 , 275 , 276 , 271 , 276 , 279 , 280 , 
281 , 282 , 283 , 278 , 273 , 275 , 275 , 47 , 47 , 91 , 
279 , 280 , 281 , 282 , 271 , 271 , 134 , 103 , 274 , 105 , 
60 , 60 , 269 , 271 , 271 , 261 , 274 , 274 , 276 , 257 , 
258 , 113 , 260 , 261 , 262 , 263 , 264 , 265 , 266 , 267 , 
268 , 273 , 137 , 275 , 273 , 273 , 275 , 279 , 280 , 281 , 
282 , 279 , 280 , 281 , 282 , 95 , 95 , 269 , 271 , 269 , 
261 , 262 , 274 , 276 , 274 , 257 , 271 , 272 , 150 , 274 , 
279 , 280 , 281 , 282 , 114 , 114 , 147 , 257 , 258 , 277 , 
260 , 261 , 262 , 263 , 264 , 265 , 266 , 267 , 268 , 271 , 
275 , 257 , 274 , 259 , 273 , 269 , 275 , 277 , 269 , 279 , 
280 , 281 , 282 , 257 , 258 , 273 , 260 , 261 , 262 , 263 , 
264 , 265 , 266 , 267 , 268 , 273 , 285 , 275 , 271 , 276 , 
276 , 271 , 284 , 272 , 276 , 279 , 280 , 281 , 282 , 258 , 
276 , 260 , 261 , 262 , 276 , 264 , 265 , 266 , 267 , 268 , 
103 , 24 , 34 , 133 , 99 , 107 , 139 , 49 , 20 , 114 , 
279 , 280 , 281 , 282 , 283 , 258 , 95 , 260 , 261 , 262 , 
263 , 264 , 265 , 266 , 267 , 268 , 74 , 1 , 3 , 272 , 
60 , - 1 , - 1 , - 1 , - 1 , - 1 , 279 , 280 , 281 , 282 , 
258 , - 1 , 260 , 261 , 262 , 263 , 264 , 265 , 266 , 267 , 
268 , - 1 , - 1 , - 1 , - 1 , - 1 , 258 , - 1 , 260 , 261 , 
262 , 279 , 280 , 281 , 282 , 267 , 268 , - 1 , - 1 , - 1 , 
- 1 , - 1 , - 1 , - 1 , - 1 , - 1 , - 1 , 279 , 280 , 281 , 
282 , 
} ; 
#line 411 "parse.cls"

#line 418 "parse.cls"

#line 421 "parse.cls"

#line 426 "parse.y"
int yydebug ; 
int yynerrs ; 
int yyerrflag ; 
int yychar ; 
short * yyssp ; 
YYSTYPE * yyvsp ; 
YYSTYPE yyval ; 
YYSTYPE yylval ; 
short yyss [ 500 ] ; 
YYSTYPE yyvs [ 500 ] ; 
#line 1159 "parse.y"

int yyerror ( s ) char * s ; 

{ int * _that ; 
sls_error ( yylineno , 6 , 0 ) ; } /* yyerror */ 


int resynch ( c ) char c ; 

{ int * _that ; int _result ; 
int c1 , 
newline = 0 ; 

if ( almost_eos ) { 
fprintf ( stderr , "   \";\" expected" ) ; 
if ( yytext ) fprintf ( stderr , ", found \"%s\"\n" , yytext ) ; 
else fprintf ( stderr , "\n" ) ; 
while ( ( c1 = Input ( ) ) != c && c1 != 0 ) ; } 

else { 
fprintf ( stderr , " \"" ) ; 
if ( yytext ) 
fprintf ( stderr , "%s" , yytext ) ; 
while ( ( c1 = Input ( ) ) != c && c1 != 0 ) 
{ 
if ( ! ( newline = ( newline || ( ( c1 == '\n' ) ? 1 : 0 ) ) ) ) 
fprintf ( stderr , "%c" , c1 ) ; } 


fprintf ( stderr , "\"\n" ) ; } { _result = 


 ( c1 ) ; goto _return ; } _return : return _result ; } /* resynch */ 


int stackfree ( xs , type ) struct stack * xs ; int type ; 


{ int * _that ; 
char * p ; 

if ( xs ) 
{ 
while ( ! _13stack_empty ( ( struct stack * ) xs ) ) 
{ 
 p = _15stack_pop ( ( struct stack * ) xs ) ; 
switch ( type ) { 
case 0 : 
if ( p ) { _that = ( int * ) 
 ( struct xelem * ) p ; _2xelem_delete ( ( struct xelem * ) _that ) ; free ( _that ) ; } 
break ; 
case 1 : 
if ( p ) 
{ 
#line 494 "parse.cls"
{ _that = ( int * ) 
 p ; free ( _that ) ; } } 

break ; } } } } /* stackfree */ 
#line 503 "parse.cls"
Netelem * findterm ( inst , term_name ) struct ntwinst * inst ; char * term_name ; 


{ int * _that ; struct netelem * _result ; 
Queue * termq ; 
int termq_len ; 
Netelem * pterm ; 
int i ; 

if ( inst ) 
 termq = ( struct queue * ) ( inst -> ntw -> termq ) ; 
else 
 termq = ( struct queue * ) ( ntw -> termq ) ; 

 termq_len = _15queue_length ( ( struct queue * ) termq ) ; 

for ( i = 0 , pterm = ( struct netelem * ) _19queue_first_elem ( ( struct queue * ) termq ) ; 
i < termq_len ; 
 i ++ , pterm = ( struct netelem * ) _20queue_next_elem ( ( struct queue * ) termq , ( struct link * ) ( ( struct link * ) pterm ) ) ) 
{ 
if ( strcmp ( pterm -> name , term_name ) == 0 ) { _result = 
 ( pterm ) ; goto _return ; } } { _result = 


 ( 0 ) ; goto _return ; } _return : return _result ; } /* findterm */ 


int gettermcnt ( netw ) struct ntwdef * netw ; 

{ int * _that ; int _result ; 
Queue * termq ; 
int termq_len ; 
Netelem * pterm ; 
int i ; 
int term_cnt ; 

 termq = ( struct queue * ) ( netw -> termq ) ; 
 termq_len = _15queue_length ( ( struct queue * ) termq ) ; 
term_cnt = 0 ; 

for ( i = 0 , pterm = ( struct netelem * ) _19queue_first_elem ( ( struct queue * ) termq ) ; 
i < termq_len ; 
 i ++ , pterm = ( struct netelem * ) _20queue_next_elem ( ( struct queue * ) termq , ( struct link * ) ( ( struct link * ) pterm ) ) ) 
{ 
 term_cnt += getxslength ( pterm -> xs ) ; } { _result = 


 ( term_cnt ) ; goto _return ; } _return : return _result ; } /* gettermcnt */ 


int prxs ( xs ) struct stack * xs ; 

{ int * _that ; 

int i ; 
int xs_len = _22stack_length ( ( struct stack * ) xs ) ; 

fprintf ( stderr , "stack: %x, length: %d\n" , xs , xs_len ) ; 
if ( xs ) 
{ 
for ( i = 0 ; i < xs_len ; i ++ ) 
{ 
 pxelem = ( struct xelem * ) _16stack_access ( ( struct stack * ) xs , ( int ) ( i ) ) ; 
fprintf ( stderr , "lb: %d, rb: %d\n" , pxelem -> left_bound , 
 pxelem -> right_bound ) ; } } 
#line 572 "y.tab.c"
} /* prxs */ 


int yyparse 
( ) 
{ int * _that ; int _result ; 
register int yym , yyn , yystate ; 
#line 589 "parse.cls"


yynerrs = 0 ; 
yyerrflag = 0 ; 
yychar = ( - 1 ) ; 

yyssp = yyss ; 
yyvsp = yyvs ; 
* yyssp = yystate = 0 ; 

yyloop : 
if ( yyn = yydefred [ yystate ] ) goto yyreduce ; 
if ( yychar < 0 ) 
{ 
if ( ( yychar = yylex ( ) ) < 0 ) yychar = 0 ; 
#line 613 "parse.cls"
} 

if ( ( yyn = yysindex [ yystate ] ) && ( yyn += yychar ) >= 0 && 
yyn <= 261 && yycheck [ yyn ] == yychar ) 
{ 
#line 622 "parse.cls"

if ( yyssp >= yyss + 500 - 1 ) 
{ 
goto yyoverflow ; } 

* ++ yyssp = yystate = yytable [ yyn ] ; 
* ++ yyvsp = yylval ; 
yychar = ( - 1 ) ; 
if ( yyerrflag > 0 ) -- yyerrflag ; 
goto yyloop ; } 

if ( ( yyn = yyrindex [ yystate ] ) && ( yyn += yychar ) >= 0 && 
yyn <= 261 && yycheck [ yyn ] == yychar ) 
{ 
yyn = yytable [ yyn ] ; 
goto yyreduce ; } 

if ( yyerrflag ) goto yyinrecovery ; 
#line 642 "parse.cls"

yynewerror : 
 yyerror ( "syntax error" ) ; 
#line 647 "parse.cls"

yyerrlab : 
++ yynerrs ; 
yyinrecovery : 
if ( yyerrflag < 3 ) 
{ 
yyerrflag = 3 ; 
for ( ; ; ) 
{ 
if ( ( yyn = yysindex [ * yyssp ] ) && ( yyn += 256 ) >= 0 && 
yyn <= 261 && yycheck [ yyn ] == 256 ) 
{ 
#line 663 "parse.cls"

if ( yyssp >= yyss + 500 - 1 ) 
{ 
goto yyoverflow ; } 

* ++ yyssp = yystate = yytable [ yyn ] ; 
* ++ yyvsp = yylval ; 
goto yyloop ; } 

else 
{ 
#line 678 "parse.cls"

if ( yyssp <= yyss ) goto yyabort ; 
-- yyssp ; 
-- yyvsp ; } } } 



else 
{ 
if ( yychar == 0 ) goto yyabort ; 
#line 697 "parse.cls"

yychar = ( - 1 ) ; 
goto yyloop ; } 

yyreduce : 
#line 706 "parse.cls"

yym = yylen [ yyn ] ; 
yyval = yyvsp [ 1 - yym ] ; 
switch ( yyn ) 
{ 
case 3 : 
#line 129 "parse.y"
{ 
if ( end_ntw ( yyvsp [ - 2 ] . ival , externspec , COMPLETE ) ) 
{ 
sls_error ( yylineno , sls_errno , 0 ) ; 
die ( ) ; } } 


break ; 
case 4 : 
#line 137 "parse.y"
{ 
externspec = 1 ; } 

break ; 
case 5 : 
#line 141 "parse.y"
{ 
int finalCheckDbTerm ( ) ; 

finalCheckDbTerm ( ) ; 

if ( end_ntw ( yyvsp [ - 1 ] . ival , externspec , COMPLETE ) ) 
{ 
sls_error ( yylineno , sls_errno , 0 ) ; 
die ( ) ; } 


externspec = 0 ; } 

break ; 
case 6 : 
#line 157 "parse.y"
{ 
if ( ! externspec && forbidFirstCapital && yyvsp [ 0 ] . sval 
&& yyvsp [ 0 ] . sval [ 0 ] >= 'A' && yyvsp [ 0 ] . sval [ 0 ] <= 'Z' ) { 
sls_errno = 21 ; 
sls_error ( yylineno , sls_errno , yyvsp [ 0 ] . sval ) ; 
die ( ) ; } 
#line 169 "parse.y"
if ( ntw = ( struct ntwdef * ) init_ntw ( yyvsp [ 0 ] . sval , externspec ) ) { 
 curr_ntw = ( struct ntwdef * ) ( ntw ) ; 
 yyval . ival = ( int ) ntw ; } 

else 
{ 

sls_errno = 14 ; 
sls_error ( yylineno , sls_errno , yyvsp [ 0 ] . sval ) ; 
die ( ) ; } } 


break ; 
case 7 : 
#line 184 "parse.y"
{ 
int i ; 

yyval . ival = 1 ; 

if ( yyvsp [ - 1 ] . ival && globNets_cnt > 0 ) { 
 pnetq = ( struct queue * ) ( 0 ) ; 
for ( i = 0 ; i < globNets_cnt ; i ++ ) { 

if ( externspec && ! isDefGlobalNet ( globNets [ i ] ) ) 
continue ; 

if ( ! ( pnet = ( struct netelem * ) ( _14dictionary_fetch ( ( struct dictionary * ) sym_dict , ( char * ) ( globNets [ i ] ) ) ) ) ) { 
#line 201 "parse.y"
if ( ! pnetq ) { 
 pnetq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; } 


 _18stack_reset ( ( struct stack * ) xs ) ; 


 pnet = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( globNets [ i ] ) , ( struct stack * ) ( stackcpy ( ( struct stack * ) xs ) ) , ( char ) ( 0x04 ) ) , ( struct netelem * ) _that ) ; 
 pnet -> type = pnet -> type | 2 ; 
 _14queue_put ( ( struct queue * ) pnetq , ( struct link * ) ( ( struct link * ) pnet ) ) ; 


 pnet = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( globNets [ i ] ) , ( struct stack * ) ( stackcpy ( ( struct stack * ) xs ) ) , ( char ) ( 0x04 ) ) , ( struct netelem * ) _that ) ; 
 pnet -> type = pnet -> type | 2 ; 
 _13dictionary_store ( ( struct dictionary * ) sym_dict , ( char * ) ( pnet -> name ) , ( char * ) ( ( char * ) pnet ) ) ; 
 _14queue_put ( ( struct queue * ) ntw -> netq , ( struct link * ) ( ( struct link * ) pnet ) ) ; } 

else if ( pnet -> xs ) { 
sls_errno = 7 ; 
sls_error ( yylineno , sls_errno , 
globNets [ i ] ) ; 
yyval . ival = 0 ; 
break ; } } 



if ( pnetq ) { 
if ( ntw -> termq ) 
 _22queue_append ( ( struct queue * ) ntw -> termq , ( struct queue * ) ( ( struct queue * ) pnetq ) ) ; 
else 
 ntw -> termq = ( struct queue * ) pnetq ; } } 



if ( yyval . ival ) { 
if ( yyvsp [ - 1 ] . ival && ! externspec ) 
 term_to_db ( ( struct queue * ) yyvsp [ - 1 ] . ival ) ; 
yyval . ival = yyvsp [ - 1 ] . ival ; } } 


break ; 
case 8 : 
#line 242 "parse.y"
{ 
int i ; 

yyval . ival = 0 ; 
 pnetq = ( struct queue * ) ( 0 ) ; 
for ( i = 0 ; i < globNets_cnt ; i ++ ) { 

if ( externspec && ! isDefGlobalNet ( globNets [ i ] ) ) 
continue ; 
#line 255 "parse.y"
if ( ! pnetq ) { 
 pnetq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; } 


 _18stack_reset ( ( struct stack * ) xs ) ; 


 pnet = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( globNets [ i ] ) , ( struct stack * ) ( stackcpy ( ( struct stack * ) xs ) ) , ( char ) ( 0x04 ) ) , ( struct netelem * ) _that ) ; 
 pnet -> type = pnet -> type | 2 ; 
 _14queue_put ( ( struct queue * ) pnetq , ( struct link * ) ( ( struct link * ) pnet ) ) ; 


 pnet = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( globNets [ i ] ) , ( struct stack * ) ( stackcpy ( ( struct stack * ) xs ) ) , ( char ) ( 0x04 ) ) , ( struct netelem * ) _that ) ; 
 pnet -> type = pnet -> type | 2 ; 
 _13dictionary_store ( ( struct dictionary * ) sym_dict , ( char * ) ( pnet -> name ) , ( char * ) ( ( char * ) pnet ) ) ; 
 _14queue_put ( ( struct queue * ) ntw -> netq , ( struct link * ) ( ( struct link * ) pnet ) ) ; 
yyval . ival = 1 ; } 


if ( pnetq ) { 
if ( ntw -> termq ) 
 _22queue_append ( ( struct queue * ) ntw -> termq , ( struct queue * ) ( ( struct queue * ) pnetq ) ) ; 
else 
 ntw -> termq = ( struct queue * ) pnetq ; } 


if ( yyval . ival ) { 
if ( ! externspec ) 
 term_to_db ( ( struct queue * ) ( ntw -> termq ) ) ; 
 yyval . ival = ( int ) ( ntw -> termq ) ; } } 


break ; 
case 10 : 
#line 293 "parse.y"
{ 
yyval . ival = yyvsp [ 0 ] . ival ; } 

break ; 
case 11 : 
#line 297 "parse.y"
{ 
yyval . ival = yyvsp [ - 2 ] . ival ; } 

break ; 
case 12 : 
#line 303 "parse.y"
{ 
if ( yyvsp [ - 1 ] . ival == 0x04 && yyvsp [ 0 ] . ival ) 
{ 
if ( ntw -> termq ) 
 _22queue_append ( ( struct queue * ) ntw -> termq , ( struct queue * ) ( ( struct queue * ) yyvsp [ 0 ] . ival ) ) ; 
else 
 ntw -> termq = ( struct queue * ) yyvsp [ 0 ] . ival ; 
yyval . ival = ( int ) yyvsp [ 0 ] . ival ; } 

else if ( yyvsp [ - 1 ] . ival == 0 || yyvsp [ 0 ] . ival == 0 ) { 
yyval . ival = 0 ; } 

else { 
yyval . ival = ( int ) yyvsp [ 0 ] . ival ; } } 


break ; 
case 13 : 
#line 322 "parse.y"
{ 
if ( yyvsp [ 0 ] . ival ) { 
 pnetq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 
 _14queue_put ( ( struct queue * ) pnetq , ( struct link * ) ( ( struct link * ) yyvsp [ 0 ] . ival ) ) ; 
 yyval . ival = ( int ) pnetq ; } 

else 
yyval . ival = 0 ; } 

break ; 
case 14 : 
#line 332 "parse.y"
{ 
if ( yyvsp [ - 2 ] . ival && yyvsp [ 0 ] . ival ) 
 _14queue_put ( ( struct queue * ) ( ( struct queue * ) yyvsp [ - 2 ] . ival ) , ( struct link * ) ( ( struct link * ) yyvsp [ 0 ] . ival ) ) ; 
yyval . ival = yyvsp [ - 2 ] . ival ; } 

break ; 
case 15 : 
#line 340 "parse.y"
{ 
if ( _14dictionary_fetch ( ( struct dictionary * ) sym_dict , ( char * ) ( yyvsp [ - 1 ] . sval ) ) ) 
{ 

sls_errno = 8 ; 
sls_error ( yylineno , sls_errno , yyvsp [ - 1 ] . sval ) ; 
yyval . ival = 0 ; } 

else 
{ 

 pnet = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( yyvsp [ - 1 ] . sval ) , ( struct stack * ) ( stackcpy ( ( struct stack * ) yyvsp [ 0 ] . ival ) ) , ( char ) ( 0x04 ) ) , ( struct netelem * ) _that ) ; 
if ( externspec && checkDbTerm ( pnet ) != 0 ) 
yyval . ival = 0 ; 
else { 
 yyval . ival = ( int ) pnet ; 

 pnet = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( yyvsp [ - 1 ] . sval ) , ( struct stack * ) ( stackcpy ( ( struct stack * ) yyvsp [ 0 ] . ival ) ) , ( char ) ( 0x04 ) ) , ( struct netelem * ) _that ) ; 
 _13dictionary_store ( ( struct dictionary * ) sym_dict , ( char * ) ( pnet -> name ) , ( char * ) ( ( char * ) pnet ) ) ; 
 _14queue_put ( ( struct queue * ) ntw -> netq , ( struct link * ) ( ( struct link * ) pnet ) ) ; } } } 



break ; 
case 16 : 
#line 366 "parse.y"
{ 
yyval . ival = 0x04 ; } 

break ; 
case 17 : 
#line 370 "parse.y"
{ 

sls_errno = 9 ; 
sls_error ( yylineno , sls_errno , yyvsp [ 0 ] . sval ) ; 
yyval . ival = 0 ; } 

break ; 
case 20 : 
#line 383 "parse.y"
{ 
almost_eos = 0 ; } 

break ; 
case 21 : 
#line 387 "parse.y"
{ 
if ( inst ) 
{ 
if ( ntw -> mcq == 0 ) 
 ntw -> mcq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 

 _14queue_put ( ( struct queue * ) ntw -> mcq , ( struct link * ) ( ( struct link * ) inst ) ) ; 
 inst_to_db ( ( struct ntwinst * ) inst ) ; } 


almost_eos = 0 ; } 

break ; 
case 23 : 
#line 401 "parse.y"
{ 
if ( resynch ( ( char ) ( ';' ) ) ) 
{ 
( yyerrflag = 0 ) ; 
( yychar = ( - 1 ) ) ; } 

else 
die ( ) ; } 

break ; 
case 24 : 
#line 413 "parse.y"
{ 
int net_cnt ; 
int inst_cnt ; 
Stack * inst_xs ; 
 inst = ( struct ntwinst * ) yyvsp [ - 1 ] . ival ; 

if ( yyvsp [ - 1 ] . ival && yyvsp [ 0 ] . ival ) { 
if ( ( ( struct link * ) yyvsp [ - 1 ] . ival ) -> type == 0x14 ) { 
mc_type = 'f' ; 
sprintf ( attr_buf , "f" ) ; 
 _14stack_push ( ( struct stack * ) attr_s , ( char * ) ( strsav ( attr_buf ) ) ) ; } 


if ( bifflag ) 
{ 
mc_type = 'b' ; 
 inst_xs = ( struct stack * ) ( inst -> inst_struct -> inst_construct ) ; 
 net_cnt = getnetcnt ( ( struct queue * ) yyvsp [ 0 ] . ival ) ; 
if ( inst_xs ) 
{ 
 inst_cnt = getxslength ( inst_xs ) ; 
net_cnt = net_cnt / inst_cnt ; } 



 pnet = ( struct netelem * ) _19queue_first_elem ( ( struct queue * ) inst -> ntw -> termq ) ; 
 pxs = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct stack ) ) , _1stack_new ( ( struct stack * ) _that , ( short ) ( 1 ) ) , ( struct stack * ) _that ) ; 
 pxelem = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct xelem ) ) , _1xelem_new ( ( struct xelem * ) _that , ( short ) 0 , ( short ) ( net_cnt - 2 ) ) , ( struct xelem * ) _that ) ; 
 _14stack_push ( ( struct stack * ) pxs , ( char * ) ( ( char * ) pxelem ) ) ; 
 pnet -> xs = ( struct stack * ) ( pxs ) ; 
#line 449 "parse.y"
sprintf ( attr_buf , "n=%d" , net_cnt - 1 ) ; 
 _14stack_push ( ( struct stack * ) attr_s , ( char * ) ( strsav ( attr_buf ) ) ) ; 
bifflag = 0 ; 

if ( invertbifflag ) { 
if ( net_cnt < 2 ) 
sls_error ( yylineno , 2 , 
0 ) ; 
else if ( net_cnt > 2 ) 
sls_error ( yylineno , 3 , 
0 ) ; } } 
#line 466 "parse.y"
if ( ( ( struct link * ) yyvsp [ - 1 ] . ival ) -> type == 0x13 ) { 
 inst_xs = ( struct stack * ) ( inst -> inst_struct -> inst_construct ) ; 
if ( inst_xs ) 
 n_inst_cnt = getxslength ( inst_xs ) ; 
else 
n_inst_cnt = 1 ; 
 n_net_cnt = getnetcnt ( ( struct queue * ) yyvsp [ 0 ] . ival ) ; 
 n_term_cnt = gettermcnt ( inst -> ntw ) ; 
if ( n_net_cnt % n_inst_cnt != 0 ) 
n_inst_cnt = 0 ; } 

else 
n_inst_cnt = 0 ; 

 inst -> ntw_attr = ( struct stack * ) ( stackcpy ( attr_s ) ) ; 
if ( inst_net_eqv ( inst , ( struct queue * ) yyvsp [ 0 ] . ival ) ) 
{ 
sls_error ( yylineno , sls_errno , 0 ) ; } 

n_inst_cnt = 0 ; } 


almost_eos = 1 ; } 

break ; 
case 25 : 
#line 493 "parse.y"
{ 
yyval . ival = yyvsp [ 0 ] . ival ; } 

break ; 
case 26 : 
#line 497 "parse.y"
{ 
yyval . ival = yyvsp [ 0 ] . ival ; } 

break ; 
case 27 : 
#line 503 "parse.y"
{ 
if ( yyvsp [ - 2 ] . ival && yyvsp [ 0 ] . ival ) { 
 inst = ( struct ntwinst * ) yyvsp [ 0 ] . ival ; 

 inst -> inst_struct = ( struct instancestruct * ) yyvsp [ - 2 ] . ival ; 

 _13dictionary_store ( ( struct dictionary * ) sym_dict , ( char * ) ( inst -> inst_struct -> inst_name ) , ( char * ) ( ( char * ) inst ) ) ; 
yyval . ival = yyvsp [ 0 ] . ival ; } 

else 
yyval . ival = 0 ; } 

break ; 
case 28 : 
#line 518 "parse.y"
{ 
 inst = ( struct ntwinst * ) yyvsp [ 0 ] . ival ; 


 inst -> inst_struct = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct instancestruct ) ) , _1instancestruct_new ( ( struct instancestruct * ) _that , ( char * ) ( ( char * ) _12ntwdef_genname ( ( struct ntwdef * ) ntw , ( char ) ( 0x07 ) ) ) , ( struct stack * ) 0 ) , ( struct instancestruct * ) _that ) ; 

 _13dictionary_store ( ( struct dictionary * ) sym_dict , ( char * ) ( inst -> inst_struct -> inst_name ) , ( char * ) ( ( char * ) inst ) ) ; 
yyval . ival = yyvsp [ 0 ] . ival ; } 

break ; 
case 29 : 
#line 530 "parse.y"
{ 
 ( ( struct link * ) yyvsp [ 0 ] . ival ) -> type = 0x10 ; 
yyval . ival = yyvsp [ 0 ] . ival ; } 

break ; 
case 30 : 
#line 535 "parse.y"
{ 
 ( ( struct link * ) yyvsp [ 0 ] . ival ) -> type = 0x11 ; 
yyval . ival = yyvsp [ 0 ] . ival ; } 

break ; 
case 31 : 
#line 540 "parse.y"
{ 
 ( ( struct link * ) yyvsp [ 0 ] . ival ) -> type = 0x12 ; 
yyval . ival = yyvsp [ 0 ] . ival ; } 

break ; 
case 32 : 
#line 545 "parse.y"
{ 
mc_type = 'c' ; 
 ( ( struct link * ) yyvsp [ 0 ] . ival ) -> type = 0x13 ; 
yyval . ival = yyvsp [ 0 ] . ival ; } 

break ; 
case 33 : 
#line 551 "parse.y"
{ 
 ( ( struct link * ) yyvsp [ 0 ] . ival ) -> type = 0x14 ; 
yyval . ival = yyvsp [ 0 ] . ival ; } 

break ; 
case 34 : 
#line 558 "parse.y"
{ 
yyval . ival = ( int ) ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct ntwinst ) ) , _1ntwinst_new ( ( struct ntwinst * ) _that , ( struct ntwdef * ) ( ( struct ntwdef * ) yyvsp [ - 1 ] . ival ) , ( struct stack * ) 0 ) , ( struct ntwinst * ) _that ) ; } 

break ; 
case 35 : 
#line 564 "parse.y"
{ 
 _18stack_reset ( ( struct stack * ) attr_s ) ; 
sprintf ( attr_buf , "v=%g" , yyvsp [ 0 ] . dval ) ; 
 _14stack_push ( ( struct stack * ) attr_s , ( char * ) ( strsav ( attr_buf ) ) ) ; 

yyval . ival = ( int ) ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct ntwinst ) ) , _1ntwinst_new ( ( struct ntwinst * ) _that , ( struct ntwdef * ) ( dev_tab [ 3 ] ) , ( struct stack * ) 0 ) , ( struct ntwinst * ) _that ) ; } 

break ; 
case 36 : 
#line 574 "parse.y"
{ 
 _18stack_reset ( ( struct stack * ) attr_s ) ; 
sprintf ( attr_buf , "v=%g" , yyvsp [ 0 ] . dval ) ; 
 _14stack_push ( ( struct stack * ) attr_s , ( char * ) ( strsav ( attr_buf ) ) ) ; 

yyval . ival = ( int ) ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct ntwinst ) ) , _1ntwinst_new ( ( struct ntwinst * ) _that , ( struct ntwdef * ) ( dev_tab [ 4 ] ) , ( struct stack * ) 0 ) , ( struct ntwinst * ) _that ) ; } 

break ; 
case 37 : 
#line 584 "parse.y"
{ 
if ( fflag ) 
{ 
if ( ! ( pntw = ( struct ntwdef * ) ( is_bifunc ( yyvsp [ - 1 ] . sval ) ) ) ) 
{ 
if ( 
 ( pntw = ( struct ntwdef * ) _14dictionary_fetch ( ( struct dictionary * ) dff_dict , ( char * ) ( yyvsp [ - 1 ] . sval ) ) ) == 0 ) 
{ 
if ( ( pntw = ( struct ntwdef * ) ( read_dff ( yyvsp [ - 1 ] . sval ) ) ) == 0 ) 
{ 
sls_errno = 13 ; 
sls_error ( yylineno , sls_errno , yyvsp [ - 1 ] . sval ) ; 
die ( ) ; } } } 



else { 
bifflag = 1 ; 

if ( yyvsp [ - 1 ] . sval [ 0 ] == 'i' 
&& strcmp ( yyvsp [ - 1 ] . sval , "invert" ) == 0 ) 
invertbifflag = 1 ; 
else 
invertbifflag = 0 ; } } 


else 
{ 
if ( ( pntw = ( struct ntwdef * ) _14dictionary_fetch ( ( struct dictionary * ) ntw_dict , ( char * ) ( yyvsp [ - 1 ] . sval ) ) ) == 0 ) 
{ 
if ( externRequired ) { 
sls_errno = 20 ; 
sls_error ( yylineno , sls_errno , yyvsp [ - 1 ] . sval ) ; 
die ( ) ; } 


if ( ( pntw = ( struct ntwdef * ) ( read_ntw ( yyvsp [ - 1 ] . sval ) ) ) == 0 ) 
{ 
sls_errno = 12 ; 
sls_error ( yylineno , sls_errno , yyvsp [ - 1 ] . sval ) ; 
die ( ) ; } } } 
#line 629 "parse.y"
yyval . ival = ( int ) ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct ntwinst ) ) , _1ntwinst_new ( ( struct ntwinst * ) _that , ( struct ntwdef * ) ( pntw ) , ( struct stack * ) 0 ) , ( struct ntwinst * ) _that ) ; } 

break ; 
case 38 : 
#line 634 "parse.y"
{ 
if ( _14dictionary_fetch ( ( struct dictionary * ) sym_dict , ( char * ) ( yyvsp [ - 1 ] . sval ) ) ) 
{ 
sls_errno = 11 ; 
sls_error ( yylineno , sls_errno , yyvsp [ - 1 ] . sval ) ; 
yyval . ival = 0 ; } 

else 
{ 
yyval . ival = ( int ) 
 ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct instancestruct ) ) , _1instancestruct_new ( ( struct instancestruct * ) _that , ( char * ) ( strsav ( yyvsp [ - 1 ] . sval ) ) , ( struct stack * ) ( stackcpy ( ( struct stack * ) yyvsp [ 0 ] . ival ) ) ) , ( struct instancestruct * ) _that ) ; } } 


break ; 
case 39 : 
#line 650 "parse.y"
{ 
fflag ++ ; } 

break ; 
case 40 : 
#line 654 "parse.y"
{ 
fflag = 0 ; 
yyval . ival = yyvsp [ 0 ] . ival ; } 

break ; 
case 41 : 
#line 661 "parse.y"
{ 
 yyval . ival = ( int ) dev_tab [ 0 ] ; } 

break ; 
case 42 : 
#line 665 "parse.y"
{ 
 yyval . ival = ( int ) dev_tab [ 1 ] ; } 

break ; 
case 43 : 
#line 669 "parse.y"
{ 
 yyval . ival = ( int ) dev_tab [ 2 ] ; } 

break ; 
case 44 : 
#line 675 "parse.y"
{ 
 _18stack_reset ( ( struct stack * ) attr_s ) ; 
 yyval . ival = ( int ) attr_s ; } 

break ; 
case 45 : 
#line 680 "parse.y"
{ 
 _14stack_push ( ( struct stack * ) ( ( struct stack * ) yyvsp [ - 1 ] . ival ) , ( char * ) ( ( char * ) strsav ( yyvsp [ 0 ] . sval ) ) ) ; 
yyval . ival = yyvsp [ - 1 ] . ival ; } 

break ; 
case 46 : 
#line 687 "parse.y"
{ 
sprintf ( attr_buf , "%s=%g" , yyvsp [ - 2 ] . sval , yyvsp [ 0 ] . dval ) ; 
yyval . sval = attr_buf ; } 

break ; 
case 47 : 
#line 694 "parse.y"
{ 
yyval . sval = "w" ; } 

break ; 
case 48 : 
#line 698 "parse.y"
{ 
yyval . sval = "l" ; } 

break ; 
case 49 : 
#line 702 "parse.y"
{ 
yyval . sval = "tr" ; } 

break ; 
case 50 : 
#line 706 "parse.y"
{ 
yyval . sval = "tf" ; } 

break ; 
case 51 : 
#line 712 "parse.y"
{ 
yyval . dval = yyvsp [ 0 ] . dval ; } 

break ; 
case 52 : 
#line 718 "parse.y"
{ 
yyval . dval = ( double ) yyvsp [ 0 ] . ival ; } 

break ; 
case 53 : 
#line 722 "parse.y"
{ 
yyval . dval = yyvsp [ 0 ] . dval ; } 

break ; 
case 54 : 
#line 728 "parse.y"
{ 
 yyval . dval = cvt_atof ( yyvsp [ 0 ] . sval ) ; } 

break ; 
case 55 : 
#line 734 "parse.y"
{ 
 ( ( struct link * ) ( ( struct queue * ) yyvsp [ - 1 ] . ival ) ) -> type = 0x08 ; 
yyval . ival = yyvsp [ - 1 ] . ival ; } 

break ; 
case 56 : 
#line 739 "parse.y"
{ 
 ( ( struct link * ) ( ( struct queue * ) yyvsp [ - 1 ] . ival ) ) -> type = 0x09 ; 
yyval . ival = yyvsp [ - 1 ] . ival ; } 

break ; 
case 57 : 
#line 746 "parse.y"
{ 
 pnetq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 

if ( yyvsp [ 0 ] . ival ) 
{ 
 _14queue_put ( ( struct queue * ) pnetq , ( struct link * ) ( ( struct link * ) yyvsp [ 0 ] . ival ) ) ; } 


 yyval . ival = ( int ) pnetq ; } 

break ; 
case 58 : 
#line 757 "parse.y"
{ 
if ( yyvsp [ 0 ] . ival ) 
{ 
 _14queue_put ( ( struct queue * ) ( ( struct queue * ) yyvsp [ - 2 ] . ival ) , ( struct link * ) ( ( struct link * ) yyvsp [ 0 ] . ival ) ) ; } 


yyval . ival = yyvsp [ - 2 ] . ival ; } 

break ; 
case 59 : 
#line 768 "parse.y"
{ 
yyval . ival = yyvsp [ 0 ] . ival ; } 

break ; 
case 60 : 
#line 772 "parse.y"
{ 
yyval . ival = yyvsp [ 0 ] . ival ; } 

break ; 
case 61 : 
#line 776 "parse.y"
{ 
yyval . ival = ( int ) ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct net_ref ) ) , _1net_ref_new ( ( struct net_ref * ) _that , ( struct netelem * ) ( notconnected ) , ( struct stack * ) 0 ) , ( struct net_ref * ) _that ) ; } 

break ; 
case 62 : 
#line 782 "parse.y"
{ 
 pxs = ( struct stack * ) ( stackcpy ( ( struct stack * ) yyvsp [ 0 ] . ival ) ) ; } 

break ; 
case 63 : 
#line 786 "parse.y"
{ 
int inst_xs_len = 0 ; 
int net_xs_len = 0 ; 
int net_len = 0 ; 

 pnref = ( struct net_ref * ) yyvsp [ 0 ] . ival ; 

if ( pnref ) 
{ 
 pnref -> inst = ( struct ntwinst * ) ( inst ) ; 
if ( chk_bounds ( pnref -> inst -> inst_struct -> inst_construct , pxs ) ) 
{ 
sls_errno = 7 ; 
sls_error ( yylineno , sls_errno , 
"range not within declared bounds" ) ; 
yyval . ival = 0 ; } 

else 
{ 
 pnref -> inst_xs = ( struct stack * ) ( pxs ) ; 

 inst_xs_len = getxslength ( pxs ) ; 
 net_xs_len = getxslength ( pnref -> net_xs ) ; 
net_len = ( inst_xs_len ? inst_xs_len : 1 ) * 
( net_xs_len ? net_xs_len : 1 ) ; 
 _18stack_reset ( ( struct stack * ) xs ) ; 
if ( net_len ) 
{ 
 pxelem = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct xelem ) ) , _1xelem_new ( ( struct xelem * ) _that , ( short ) 0 , ( short ) ( net_len - 1 ) ) , ( struct xelem * ) _that ) ; 
 _14stack_push ( ( struct stack * ) xs , ( char * ) ( ( char * ) pxelem ) ) ; } 


 pxs = ( struct stack * ) ( stackcpy ( xs ) ) ; 
 pnref -> ref_xs = ( struct stack * ) ( stackcpy ( xs ) ) ; 


 pnet = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( ( char * ) _12ntwdef_genname ( ( struct ntwdef * ) ntw , ( char ) ( 0x05 ) ) ) , ( struct stack * ) ( pxs ) , ( char ) ( 0x05 ) ) , ( struct netelem * ) _that ) ; 

 _13dictionary_store ( ( struct dictionary * ) sym_dict , ( char * ) ( pnet -> name ) , ( char * ) ( ( char * ) pnet ) ) ; 
 _14queue_put ( ( struct queue * ) ntw -> netq , ( struct link * ) ( ( struct link * ) pnet ) ) ; 

yyval . ival = ( int ) 
 ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct net_ref ) ) , _1net_ref_new ( ( struct net_ref * ) _that , ( struct netelem * ) ( pnet ) , ( struct stack * ) ( stackcpy ( pnet -> xs ) ) ) , ( struct net_ref * ) _that ) ; 
if ( doSimpleNet ) { 


 joinSimple ( pnet , pnref -> ref_xs , pnref -> inst , pnref -> inst_xs , pnref -> net , pnref -> net_xs ) ; { _that = ( int * ) 
 pnref ; _2net_ref_delete ( ( struct net_ref * ) _that ) ; free ( _that ) ; } } 

else { 
if ( ! pnet -> eqv ) 
 pnet -> eqv = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 

 _14queue_put ( ( struct queue * ) pnet -> eqv , ( struct link * ) ( ( struct link * ) pnref ) ) ; } } } 



else 
yyval . ival = 0 ; } 

break ; 
case 64 : 
#line 849 "parse.y"
{ 
Netelem * pterm ; 
Stack * pxs1 ; 

 pxs1 = ( struct stack * ) ( stackcpy ( ( struct stack * ) yyvsp [ 0 ] . ival ) ) ; 

if ( pterm = ( struct netelem * ) ( findterm ( inst , yyvsp [ - 1 ] . sval ) ) ) 
{ 
if ( chk_bounds ( pterm -> xs , pxs1 ) ) 
{ 
sls_errno = 7 ; 
sls_error ( yylineno , sls_errno , 
"range not within declared bounds" ) ; 
yyval . ival = 0 ; } 

else 
yyval . ival = ( int ) ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct net_ref ) ) , _1net_ref_new ( ( struct net_ref * ) _that , ( struct netelem * ) ( pterm ) , ( struct stack * ) ( pxs1 ) ) , ( struct net_ref * ) _that ) ; } 

else 
{ 
sls_errno = 15 ; 
sls_error ( yylineno , sls_errno , yyvsp [ - 1 ] . sval ) ; 
yyval . ival = 0 ; } } 


break ; 
case 65 : 
#line 877 "parse.y"
{ 
if ( yyvsp [ - 1 ] . ival ) 
{ 
if ( neteqv ( ( struct queue * ) yyvsp [ - 1 ] . ival ) ) 
{ 
sls_error ( yylineno , sls_errno , 0 ) ; } } 



almost_eos = 1 ; } 

break ; 
case 66 : 
#line 891 "parse.y"
{ 
yyval . ival = yyvsp [ 0 ] . ival ; } 

break ; 
case 67 : 
#line 895 "parse.y"
{ 
yyval . ival = yyvsp [ 0 ] . ival ; } 

break ; 
case 68 : 
#line 901 "parse.y"
{ 
if ( yyvsp [ 0 ] . ival ) 
{ 
 pnetq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 
 _14queue_put ( ( struct queue * ) pnetq , ( struct link * ) ( ( struct link * ) yyvsp [ 0 ] . ival ) ) ; 
 yyval . ival = ( int ) pnetq ; } 

else 
yyval . ival = yyvsp [ 0 ] . ival ; } 

break ; 
case 69 : 
#line 912 "parse.y"
{ 
if ( yyvsp [ - 2 ] . ival && yyvsp [ 0 ] . ival ) 
{ 
 _14queue_put ( ( struct queue * ) ( ( struct queue * ) yyvsp [ - 2 ] . ival ) , ( struct link * ) ( ( struct link * ) yyvsp [ 0 ] . ival ) ) ; 
yyval . ival = yyvsp [ - 2 ] . ival ; } 

else 
yyval . ival = 0 ; } 

break ; 
case 70 : 
#line 924 "parse.y"
{ 
yyval . ival = yyvsp [ - 1 ] . ival ; } 

break ; 
case 71 : 
#line 930 "parse.y"
{ 
if ( yyvsp [ 0 ] . ival ) 
{ 
 pnetq = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct queue ) ) , _1queue_new ( ( struct queue * ) _that , ( char ) ( 0x01 ) ) , ( struct queue * ) _that ) ; 
 _14queue_put ( ( struct queue * ) pnetq , ( struct link * ) ( ( struct link * ) yyvsp [ 0 ] . ival ) ) ; 
 yyval . ival = ( int ) pnetq ; } 

else 
yyval . ival = yyvsp [ 0 ] . ival ; } 

break ; 
case 72 : 
#line 941 "parse.y"
{ 
if ( yyvsp [ - 2 ] . ival && yyvsp [ 0 ] . ival ) 
{ 
 _14queue_put ( ( struct queue * ) ( ( struct queue * ) yyvsp [ - 2 ] . ival ) , ( struct link * ) ( ( struct link * ) yyvsp [ 0 ] . ival ) ) ; 
yyval . ival = yyvsp [ - 2 ] . ival ; } 

else 
yyval . ival = 0 ; } 

break ; 
case 73 : 
#line 953 "parse.y"
{ 

 pxs = ( struct stack * ) ( stackcpy ( ( struct stack * ) yyvsp [ 0 ] . ival ) ) ; 

if ( ( pnet = ( struct netelem * ) ( _14dictionary_fetch ( ( struct dictionary * ) sym_dict , ( char * ) ( yyvsp [ - 1 ] . sval ) ) ) ) == 0 ) 
{ 
 pnet = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( yyvsp [ - 1 ] . sval ) , ( struct stack * ) ( pxs ) , ( char ) ( 0x05 ) ) , ( struct netelem * ) _that ) ; 
 _13dictionary_store ( ( struct dictionary * ) sym_dict , ( char * ) ( pnet -> name ) , ( char * ) ( ( char * ) pnet ) ) ; 
 _14queue_put ( ( struct queue * ) ntw -> netq , ( struct link * ) ( ( struct link * ) pnet ) ) ; 
yyval . ival = ( int ) ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct net_ref ) ) , _1net_ref_new ( ( struct net_ref * ) _that , ( struct netelem * ) ( pnet ) , ( struct stack * ) ( pxs ) ) , ( struct net_ref * ) _that ) ; } 

else 
{ 
if ( chk_bounds ( pnet -> xs , pxs ) ) 
{ 
sls_errno = 7 ; 
sls_error ( yylineno , sls_errno , 
"range not within declared bounds" ) ; 
yyval . ival = 0 ; } 

else 
yyval . ival = ( int ) ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct net_ref ) ) , _1net_ref_new ( ( struct net_ref * ) _that , ( struct netelem * ) ( pnet ) , ( struct stack * ) ( pxs ) ) , ( struct net_ref * ) _that ) ; } } 


break ; 
case 74 : 
#line 978 "parse.y"
{ 
#line 984 "parse.y"
if ( ( pnet = ( struct netelem * ) ( _14dictionary_fetch ( ( struct dictionary * ) sym_dict , ( char * ) ( yyvsp [ 0 ] . sval ) ) ) ) == 0 ) 
{ 
 pnet = ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct netelem ) ) , _1netelem_new ( ( struct netelem * ) _that , ( char * ) ( yyvsp [ 0 ] . sval ) , ( struct stack * ) 0 , ( char ) ( 0x05 ) ) , ( struct netelem * ) _that ) ; 
 _13dictionary_store ( ( struct dictionary * ) sym_dict , ( char * ) ( pnet -> name ) , ( char * ) ( ( char * ) pnet ) ) ; 
 _14queue_put ( ( struct queue * ) ntw -> netq , ( struct link * ) ( ( struct link * ) pnet ) ) ; } 

yyval . ival = ( int ) ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct net_ref ) ) , _1net_ref_new ( ( struct net_ref * ) _that , ( struct netelem * ) ( pnet ) , ( struct stack * ) 0 ) , ( struct net_ref * ) _that ) ; } 

break ; 
case 75 : 
#line 996 "parse.y"
{ 
 _18stack_reset ( ( struct stack * ) xs ) ; 
 yyval . ival = ( int ) xs ; } 

break ; 
case 76 : 
#line 1001 "parse.y"
{ 
yyval . ival = yyvsp [ - 1 ] . ival ; } 

break ; 
case 77 : 
#line 1007 "parse.y"
{ 
 _18stack_reset ( ( struct stack * ) xs ) ; 
if ( _14stack_push ( ( struct stack * ) xs , ( char * ) ( ( char * ) yyvsp [ 0 ] . ival ) ) == 0x1 ) { 
fprintf ( stderr , "xstack overflow\n" ) ; 
die ( ) ; } 

 yyval . ival = ( int ) xs ; } 


break ; 
case 78 : 
#line 1017 "parse.y"
{ 
if ( _14stack_push ( ( struct stack * ) ( ( struct stack * ) yyvsp [ - 2 ] . ival ) , ( char * ) ( ( char * ) yyvsp [ 0 ] . ival ) ) == 0x1 ) { 
fprintf ( stderr , "xstack overflow\n" ) ; 
die ( ) ; } 

yyval . ival = yyvsp [ - 2 ] . ival ; } 

break ; 
case 79 : 
#line 1027 "parse.y"
{ 
yyval . ival = ( int ) ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct xelem ) ) , _1xelem_new ( ( struct xelem * ) _that , ( short ) ( yyvsp [ 0 ] . ival ) , ( short ) ( yyvsp [ 0 ] . ival ) ) , ( struct xelem * ) _that ) ; } 

break ; 
case 80 : 
#line 1031 "parse.y"
{ 
yyval . ival = yyvsp [ 0 ] . ival ; } 

break ; 
case 81 : 
#line 1037 "parse.y"
{ 
if ( yyvsp [ - 2 ] . ival > yyvsp [ 0 ] . ival ) 
{ 
sls_errno = 7 ; 
sls_error ( yylineno , sls_errno , 
"left bound > right bound" ) ; 
yyval . ival = ( int ) ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct xelem ) ) , _1xelem_new ( ( struct xelem * ) _that , ( short ) ( yyvsp [ 0 ] . ival ) , ( short ) ( yyvsp [ - 2 ] . ival ) ) , ( struct xelem * ) _that ) ; } 

else 
yyval . ival = ( int ) ( _that = ( int * ) calloc ( ( unsigned ) 1 , sizeof ( struct xelem ) ) , _1xelem_new ( ( struct xelem * ) _that , ( short ) ( yyvsp [ - 2 ] . ival ) , ( short ) ( yyvsp [ 0 ] . ival ) ) , ( struct xelem * ) _that ) ; } 

break ; 
case 82 : 
#line 1051 "parse.y"
{ 
yyval . ival = atoi ( yyvsp [ 0 ] . sval ) ; } 

break ; 
case 83 : 
#line 1057 "parse.y"
{ 
strcpy ( ntw_name , yyvsp [ 0 ] . sval ) ; 
yyval . sval = ntw_name ; } 

break ; 
case 84 : 
#line 1062 "parse.y"
{ 
strcpy ( ntw_name , yyvsp [ 0 ] . sval ) ; 
yyval . sval = ntw_name ; } 

break ; 
case 88 : 
#line 1072 "parse.y"
{ 
 yyval . sval = _12ntwdef_genname ( ( struct ntwdef * ) ntw , ( char ) ( 0x07 ) ) ; } 

break ; 
case 89 : 
#line 1078 "parse.y"
{ 
strcpy ( ntw_name , yyvsp [ 0 ] . sval ) ; 
yyval . sval = ntw_name ; } 

break ; 
case 90 : 
#line 1083 "parse.y"
{ 
strcpy ( ntw_name , yyvsp [ 0 ] . sval ) ; 
yyval . sval = ntw_name ; } 

break ; 
case 91 : 
#line 1088 "parse.y"
{ 
strcpy ( ntw_name , yyvsp [ 0 ] . sval ) ; 
yyval . sval = ntw_name ; } 

break ; 
case 92 : 
#line 1095 "parse.y"
{ 
strcpy ( name_buf , yyvsp [ 0 ] . sval ) ; 

if ( dmTestname ( name_buf ) == 1 ) { 
if ( ! trunc_warn && ! noWarnings ) { 
fprintf ( stderr , 
"Warning: name(s) truncated to %d characters\n" , 
DM_MAXNAME ) ; 
trunc_warn = 1 ; } } 


yyval . sval = name_buf ; } 

break ; 
case 93 : 
#line 1111 "parse.y"
{ 
strcpy ( name_buf , yytext ) ; 

if ( dmTestname ( name_buf ) == 1 ) { 
if ( ! trunc_warn && ! noWarnings ) { 
fprintf ( stderr , 
"Warning: name(s) truncated to %d characters\n" , 
DM_MAXNAME ) ; 
trunc_warn = 1 ; } } 


yyval . sval = name_buf ; } 

break ; 
case 94 : 
#line 1127 "parse.y"
{ 
strcpy ( name_buf , yytext ) ; 

if ( dmTestname ( name_buf ) == 1 ) { 
if ( ! trunc_warn && ! noWarnings ) { 
fprintf ( stderr , 
"Warning: name(s) truncated to %d characters\n" , 
DM_MAXNAME ) ; 
trunc_warn = 1 ; } } 


yyval . sval = name_buf ; } 

break ; 
#line 1786 "y.tab.c"
} 
yyssp -= yym ; 
yystate = * yyssp ; 
yyvsp -= yym ; 
yym = yylhs [ yyn ] ; 
if ( yystate == 0 && yym == 0 ) 
{ 
#line 1797 "parse.cls"

yystate = 3 ; 
* ++ yyssp = 3 ; 
* ++ yyvsp = yyval ; 
if ( yychar < 0 ) 
{ 
if ( ( yychar = yylex ( ) ) < 0 ) yychar = 0 ; 
#line 1813 "parse.cls"
} 

if ( yychar == 0 ) goto yyaccept ; 
goto yyloop ; } 

if ( ( yyn = yygindex [ yym ] ) && ( yyn += yystate ) >= 0 && 
yyn <= 261 && yycheck [ yyn ] == yystate ) 
yystate = yytable [ yyn ] ; 
else 
yystate = yydgoto [ yym ] ; 
#line 1827 "parse.cls"

if ( yyssp >= yyss + 500 - 1 ) 
{ 
goto yyoverflow ; } 

* ++ yyssp = yystate ; 
* ++ yyvsp = yyval ; 
goto yyloop ; 
yyoverflow : 
 yyerror ( "yacc stack overflow" ) ; 
yyabort : { _result = 
 ( 1 ) ; goto _return ; } 
yyaccept : { _result = 
 ( 0 ) ; goto _return ; } _return : return _result ; } /* yyparse */ 
